/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * Root config message for HL7v2 schema. This contains a schema structure of groups and segments,
 * and filters that determine which messages to apply the schema structure to.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Hl7SchemaConfig extends com.google.api.client.json.GenericJson {

  /**
   * Map from each HL7v2 message type and trigger event pair, such as ADT_A04, to its schema
   * configuration root group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, SchemaGroup> messageSchemaConfigs;

  /**
   * Each VersionSource is tested and only if they all match is the schema used for the message.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<VersionSource> version;

  /**
   * Map from each HL7v2 message type and trigger event pair, such as ADT_A04, to its schema
   * configuration root group.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, SchemaGroup> getMessageSchemaConfigs() {
    return messageSchemaConfigs;
  }

  /**
   * Map from each HL7v2 message type and trigger event pair, such as ADT_A04, to its schema
   * configuration root group.
   * @param messageSchemaConfigs messageSchemaConfigs or {@code null} for none
   */
  public Hl7SchemaConfig setMessageSchemaConfigs(java.util.Map<String, SchemaGroup> messageSchemaConfigs) {
    this.messageSchemaConfigs = messageSchemaConfigs;
    return this;
  }

  /**
   * Each VersionSource is tested and only if they all match is the schema used for the message.
   * @return value or {@code null} for none
   */
  public java.util.List<VersionSource> getVersion() {
    return version;
  }

  /**
   * Each VersionSource is tested and only if they all match is the schema used for the message.
   * @param version version or {@code null} for none
   */
  public Hl7SchemaConfig setVersion(java.util.List<VersionSource> version) {
    this.version = version;
    return this;
  }

  @Override
  public Hl7SchemaConfig set(String fieldName, Object value) {
    return (Hl7SchemaConfig) super.set(fieldName, value);
  }

  @Override
  public Hl7SchemaConfig clone() {
    return (Hl7SchemaConfig) super.clone();
  }

}
