/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * An attribute value for a Consent or User data mapping. Each Attribute must have a corresponding
 * AttributeDefinition in the consent store that defines the default and allowed values.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Attribute extends com.google.api.client.json.GenericJson {

  /**
   * Indicates the name of an attribute defined in the consent store.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String attributeDefinitionId;

  /**
   * Required. The value of the attribute. Must be an acceptable value as defined in the consent
   * store. For example, if the consent store defines "data type" with acceptable values
   * "questionnaire" and "step-count", when the attribute name is data type, this field must contain
   * one of those values.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> values;

  /**
   * Indicates the name of an attribute defined in the consent store.
   * @return value or {@code null} for none
   */
  public java.lang.String getAttributeDefinitionId() {
    return attributeDefinitionId;
  }

  /**
   * Indicates the name of an attribute defined in the consent store.
   * @param attributeDefinitionId attributeDefinitionId or {@code null} for none
   */
  public Attribute setAttributeDefinitionId(java.lang.String attributeDefinitionId) {
    this.attributeDefinitionId = attributeDefinitionId;
    return this;
  }

  /**
   * Required. The value of the attribute. Must be an acceptable value as defined in the consent
   * store. For example, if the consent store defines "data type" with acceptable values
   * "questionnaire" and "step-count", when the attribute name is data type, this field must contain
   * one of those values.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getValues() {
    return values;
  }

  /**
   * Required. The value of the attribute. Must be an acceptable value as defined in the consent
   * store. For example, if the consent store defines "data type" with acceptable values
   * "questionnaire" and "step-count", when the attribute name is data type, this field must contain
   * one of those values.
   * @param values values or {@code null} for none
   */
  public Attribute setValues(java.util.List<java.lang.String> values) {
    this.values = values;
    return this;
  }

  @Override
  public Attribute set(String fieldName, Object value) {
    return (Attribute) super.set(fieldName, value);
  }

  @Override
  public Attribute clone() {
    return (Attribute) super.clone();
  }

}
