/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.displayvideo.v2;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.displayvideo.v2.DisplayVideoRequest;
import com.google.api.services.displayvideo.v2.DisplayVideoRequestInitializer;
import com.google.api.services.displayvideo.v2.model.ActivateManualTriggerRequest;
import com.google.api.services.displayvideo.v2.model.Advertiser;
import com.google.api.services.displayvideo.v2.model.AssignedInventorySource;
import com.google.api.services.displayvideo.v2.model.AssignedLocation;
import com.google.api.services.displayvideo.v2.model.AssignedTargetingOption;
import com.google.api.services.displayvideo.v2.model.AuditAdvertiserResponse;
import com.google.api.services.displayvideo.v2.model.BulkEditAdvertiserAssignedTargetingOptionsRequest;
import com.google.api.services.displayvideo.v2.model.BulkEditAdvertiserAssignedTargetingOptionsResponse;
import com.google.api.services.displayvideo.v2.model.BulkEditAssignedInventorySourcesRequest;
import com.google.api.services.displayvideo.v2.model.BulkEditAssignedInventorySourcesResponse;
import com.google.api.services.displayvideo.v2.model.BulkEditAssignedLocationsRequest;
import com.google.api.services.displayvideo.v2.model.BulkEditAssignedLocationsResponse;
import com.google.api.services.displayvideo.v2.model.BulkEditAssignedTargetingOptionsRequest;
import com.google.api.services.displayvideo.v2.model.BulkEditAssignedTargetingOptionsResponse;
import com.google.api.services.displayvideo.v2.model.BulkEditAssignedUserRolesRequest;
import com.google.api.services.displayvideo.v2.model.BulkEditAssignedUserRolesResponse;
import com.google.api.services.displayvideo.v2.model.BulkEditNegativeKeywordsRequest;
import com.google.api.services.displayvideo.v2.model.BulkEditNegativeKeywordsResponse;
import com.google.api.services.displayvideo.v2.model.BulkEditPartnerAssignedTargetingOptionsRequest;
import com.google.api.services.displayvideo.v2.model.BulkEditPartnerAssignedTargetingOptionsResponse;
import com.google.api.services.displayvideo.v2.model.BulkEditSitesRequest;
import com.google.api.services.displayvideo.v2.model.BulkEditSitesResponse;
import com.google.api.services.displayvideo.v2.model.BulkListAdvertiserAssignedTargetingOptionsResponse;
import com.google.api.services.displayvideo.v2.model.BulkListAssignedTargetingOptionsResponse;
import com.google.api.services.displayvideo.v2.model.BulkListCampaignAssignedTargetingOptionsResponse;
import com.google.api.services.displayvideo.v2.model.BulkListInsertionOrderAssignedTargetingOptionsResponse;
import com.google.api.services.displayvideo.v2.model.BulkUpdateLineItemsRequest;
import com.google.api.services.displayvideo.v2.model.BulkUpdateLineItemsResponse;
import com.google.api.services.displayvideo.v2.model.Campaign;
import com.google.api.services.displayvideo.v2.model.Channel;
import com.google.api.services.displayvideo.v2.model.CombinedAudience;
import com.google.api.services.displayvideo.v2.model.CreateAssetRequest;
import com.google.api.services.displayvideo.v2.model.CreateAssetResponse;
import com.google.api.services.displayvideo.v2.model.CreateSdfDownloadTaskRequest;
import com.google.api.services.displayvideo.v2.model.Creative;
import com.google.api.services.displayvideo.v2.model.CustomBiddingAlgorithm;
import com.google.api.services.displayvideo.v2.model.CustomBiddingScript;
import com.google.api.services.displayvideo.v2.model.CustomBiddingScriptRef;
import com.google.api.services.displayvideo.v2.model.CustomList;
import com.google.api.services.displayvideo.v2.model.DeactivateManualTriggerRequest;
import com.google.api.services.displayvideo.v2.model.DuplicateLineItemRequest;
import com.google.api.services.displayvideo.v2.model.DuplicateLineItemResponse;
import com.google.api.services.displayvideo.v2.model.EditCustomerMatchMembersRequest;
import com.google.api.services.displayvideo.v2.model.EditCustomerMatchMembersResponse;
import com.google.api.services.displayvideo.v2.model.EditGuaranteedOrderReadAccessorsRequest;
import com.google.api.services.displayvideo.v2.model.EditGuaranteedOrderReadAccessorsResponse;
import com.google.api.services.displayvideo.v2.model.EditInventorySourceReadWriteAccessorsRequest;
import com.google.api.services.displayvideo.v2.model.Empty;
import com.google.api.services.displayvideo.v2.model.FirstAndThirdPartyAudience;
import com.google.api.services.displayvideo.v2.model.FloodlightGroup;
import com.google.api.services.displayvideo.v2.model.GenerateDefaultLineItemRequest;
import com.google.api.services.displayvideo.v2.model.GoogleAudience;
import com.google.api.services.displayvideo.v2.model.GoogleBytestreamMedia;
import com.google.api.services.displayvideo.v2.model.GuaranteedOrder;
import com.google.api.services.displayvideo.v2.model.InsertionOrder;
import com.google.api.services.displayvideo.v2.model.InventorySource;
import com.google.api.services.displayvideo.v2.model.InventorySourceAccessors;
import com.google.api.services.displayvideo.v2.model.InventorySourceGroup;
import com.google.api.services.displayvideo.v2.model.LineItem;
import com.google.api.services.displayvideo.v2.model.ListAdvertiserAssignedTargetingOptionsResponse;
import com.google.api.services.displayvideo.v2.model.ListAdvertisersResponse;
import com.google.api.services.displayvideo.v2.model.ListAssignedInventorySourcesResponse;
import com.google.api.services.displayvideo.v2.model.ListAssignedLocationsResponse;
import com.google.api.services.displayvideo.v2.model.ListCampaignAssignedTargetingOptionsResponse;
import com.google.api.services.displayvideo.v2.model.ListCampaignsResponse;
import com.google.api.services.displayvideo.v2.model.ListChannelsResponse;
import com.google.api.services.displayvideo.v2.model.ListCombinedAudiencesResponse;
import com.google.api.services.displayvideo.v2.model.ListCreativesResponse;
import com.google.api.services.displayvideo.v2.model.ListCustomBiddingAlgorithmsResponse;
import com.google.api.services.displayvideo.v2.model.ListCustomBiddingScriptsResponse;
import com.google.api.services.displayvideo.v2.model.ListCustomListsResponse;
import com.google.api.services.displayvideo.v2.model.ListFirstAndThirdPartyAudiencesResponse;
import com.google.api.services.displayvideo.v2.model.ListGoogleAudiencesResponse;
import com.google.api.services.displayvideo.v2.model.ListGuaranteedOrdersResponse;
import com.google.api.services.displayvideo.v2.model.ListInsertionOrderAssignedTargetingOptionsResponse;
import com.google.api.services.displayvideo.v2.model.ListInsertionOrdersResponse;
import com.google.api.services.displayvideo.v2.model.ListInventorySourceGroupsResponse;
import com.google.api.services.displayvideo.v2.model.ListInventorySourcesResponse;
import com.google.api.services.displayvideo.v2.model.ListInvoicesResponse;
import com.google.api.services.displayvideo.v2.model.ListLineItemAssignedTargetingOptionsResponse;
import com.google.api.services.displayvideo.v2.model.ListLineItemsResponse;
import com.google.api.services.displayvideo.v2.model.ListLocationListsResponse;
import com.google.api.services.displayvideo.v2.model.ListManualTriggersResponse;
import com.google.api.services.displayvideo.v2.model.ListNegativeKeywordListsResponse;
import com.google.api.services.displayvideo.v2.model.ListNegativeKeywordsResponse;
import com.google.api.services.displayvideo.v2.model.ListPartnerAssignedTargetingOptionsResponse;
import com.google.api.services.displayvideo.v2.model.ListPartnersResponse;
import com.google.api.services.displayvideo.v2.model.ListSitesResponse;
import com.google.api.services.displayvideo.v2.model.ListTargetingOptionsResponse;
import com.google.api.services.displayvideo.v2.model.ListUsersResponse;
import com.google.api.services.displayvideo.v2.model.LocationList;
import com.google.api.services.displayvideo.v2.model.LookupInvoiceCurrencyResponse;
import com.google.api.services.displayvideo.v2.model.ManualTrigger;
import com.google.api.services.displayvideo.v2.model.NegativeKeyword;
import com.google.api.services.displayvideo.v2.model.NegativeKeywordList;
import com.google.api.services.displayvideo.v2.model.Operation;
import com.google.api.services.displayvideo.v2.model.Partner;
import com.google.api.services.displayvideo.v2.model.ReplaceNegativeKeywordsRequest;
import com.google.api.services.displayvideo.v2.model.ReplaceNegativeKeywordsResponse;
import com.google.api.services.displayvideo.v2.model.ReplaceSitesRequest;
import com.google.api.services.displayvideo.v2.model.ReplaceSitesResponse;
import com.google.api.services.displayvideo.v2.model.SearchTargetingOptionsRequest;
import com.google.api.services.displayvideo.v2.model.SearchTargetingOptionsResponse;
import com.google.api.services.displayvideo.v2.model.Site;
import com.google.api.services.displayvideo.v2.model.TargetingOption;
import com.google.api.services.displayvideo.v2.model.User;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.regex.Pattern;

public class DisplayVideo
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://displayvideo.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://displayvideo.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://displayvideo.googleapis.com/";

    public DisplayVideo(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    DisplayVideo(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Advertisers advertisers() {
        return new Advertisers();
    }

    public CombinedAudiences combinedAudiences() {
        return new CombinedAudiences();
    }

    public CustomBiddingAlgorithms customBiddingAlgorithms() {
        return new CustomBiddingAlgorithms();
    }

    public CustomLists customLists() {
        return new CustomLists();
    }

    public FirstAndThirdPartyAudiences firstAndThirdPartyAudiences() {
        return new FirstAndThirdPartyAudiences();
    }

    public FloodlightGroups floodlightGroups() {
        return new FloodlightGroups();
    }

    public GoogleAudiences googleAudiences() {
        return new GoogleAudiences();
    }

    public GuaranteedOrders guaranteedOrders() {
        return new GuaranteedOrders();
    }

    public InventorySourceGroups inventorySourceGroups() {
        return new InventorySourceGroups();
    }

    public InventorySources inventorySources() {
        return new InventorySources();
    }

    public Media media() {
        return new Media();
    }

    public Partners partners() {
        return new Partners();
    }

    public Sdfdownloadtasks sdfdownloadtasks() {
        return new Sdfdownloadtasks();
    }

    public TargetingTypes targetingTypes() {
        return new TargetingTypes();
    }

    public Users users() {
        return new Users();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the Display & Video 360 API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return DisplayVideo.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://displayvideo.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), DisplayVideo.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(DisplayVideo.DEFAULT_BATCH_PATH);
        }

        public DisplayVideo build() {
            return new DisplayVideo(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setDisplayVideoRequestInitializer(DisplayVideoRequestInitializer displayvideoRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)displayvideoRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Users {
        public BulkEditAssignedUserRoles bulkEditAssignedUserRoles(Long userId, BulkEditAssignedUserRolesRequest content) throws IOException {
            BulkEditAssignedUserRoles result = new BulkEditAssignedUserRoles(userId, content);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Create create(User content) throws IOException {
            Create result = new Create(content);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(Long userId) throws IOException {
            Delete result = new Delete(userId);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(Long userId) throws IOException {
            Get result = new Get(userId);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(Long userId, User content) throws IOException {
            Patch result = new Patch(userId, content);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Patch
        extends DisplayVideoRequest<User> {
            private static final String REST_PATH = "v2/users/{+userId}";
            private final Pattern USER_ID_PATTERN;
            @Key
            private Long userId;
            @Key
            private String updateMask;

            protected Patch(Long userId, User content) {
                super(DisplayVideo.this, "PATCH", REST_PATH, (Object)content, User.class);
                this.USER_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.userId = (Long)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public Long getUserId() {
                return this.userId;
            }

            public Patch setUserId(Long userId) {
                this.userId = userId;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public Patch setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends DisplayVideoRequest<ListUsersResponse> {
            private static final String REST_PATH = "v2/users";
            @Key
            private String filter;
            @Key
            private String orderBy;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List() {
                super(DisplayVideo.this, "GET", REST_PATH, null, ListUsersResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends DisplayVideoRequest<User> {
            private static final String REST_PATH = "v2/users/{+userId}";
            private final Pattern USER_ID_PATTERN;
            @Key
            private Long userId;

            protected Get(Long userId) {
                super(DisplayVideo.this, "GET", REST_PATH, null, User.class);
                this.USER_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.userId = (Long)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getUserId() {
                return this.userId;
            }

            public Get setUserId(Long userId) {
                this.userId = userId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends DisplayVideoRequest<Empty> {
            private static final String REST_PATH = "v2/users/{+userId}";
            private final Pattern USER_ID_PATTERN;
            @Key
            private Long userId;

            protected Delete(Long userId) {
                super(DisplayVideo.this, "DELETE", REST_PATH, null, Empty.class);
                this.USER_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.userId = (Long)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public Long getUserId() {
                return this.userId;
            }

            public Delete setUserId(Long userId) {
                this.userId = userId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends DisplayVideoRequest<User> {
            private static final String REST_PATH = "v2/users";

            protected Create(User content) {
                super(DisplayVideo.this, "POST", REST_PATH, (Object)content, User.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }

        public class BulkEditAssignedUserRoles
        extends DisplayVideoRequest<BulkEditAssignedUserRolesResponse> {
            private static final String REST_PATH = "v2/users/{+userId}:bulkEditAssignedUserRoles";
            private final Pattern USER_ID_PATTERN;
            @Key
            private Long userId;

            protected BulkEditAssignedUserRoles(Long userId, BulkEditAssignedUserRolesRequest content) {
                super(DisplayVideo.this, "POST", REST_PATH, (Object)content, BulkEditAssignedUserRolesResponse.class);
                this.USER_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.userId = (Long)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
            }

            public BulkEditAssignedUserRoles set$Xgafv(String $Xgafv) {
                return (BulkEditAssignedUserRoles)super.set$Xgafv($Xgafv);
            }

            public BulkEditAssignedUserRoles setAccessToken(String accessToken) {
                return (BulkEditAssignedUserRoles)super.setAccessToken(accessToken);
            }

            public BulkEditAssignedUserRoles setAlt(String alt) {
                return (BulkEditAssignedUserRoles)super.setAlt(alt);
            }

            public BulkEditAssignedUserRoles setCallback(String callback) {
                return (BulkEditAssignedUserRoles)super.setCallback(callback);
            }

            public BulkEditAssignedUserRoles setFields(String fields) {
                return (BulkEditAssignedUserRoles)super.setFields(fields);
            }

            public BulkEditAssignedUserRoles setKey(String key) {
                return (BulkEditAssignedUserRoles)super.setKey(key);
            }

            public BulkEditAssignedUserRoles setOauthToken(String oauthToken) {
                return (BulkEditAssignedUserRoles)super.setOauthToken(oauthToken);
            }

            public BulkEditAssignedUserRoles setPrettyPrint(Boolean prettyPrint) {
                return (BulkEditAssignedUserRoles)super.setPrettyPrint(prettyPrint);
            }

            public BulkEditAssignedUserRoles setQuotaUser(String quotaUser) {
                return (BulkEditAssignedUserRoles)super.setQuotaUser(quotaUser);
            }

            public BulkEditAssignedUserRoles setUploadType(String uploadType) {
                return (BulkEditAssignedUserRoles)super.setUploadType(uploadType);
            }

            public BulkEditAssignedUserRoles setUploadProtocol(String uploadProtocol) {
                return (BulkEditAssignedUserRoles)super.setUploadProtocol(uploadProtocol);
            }

            public Long getUserId() {
                return this.userId;
            }

            public BulkEditAssignedUserRoles setUserId(Long userId) {
                this.userId = userId;
                return this;
            }

            @Override
            public BulkEditAssignedUserRoles set(String parameterName, Object value) {
                return (BulkEditAssignedUserRoles)super.set(parameterName, value);
            }
        }
    }

    public class TargetingTypes {
        public TargetingOptions targetingOptions() {
            return new TargetingOptions();
        }

        public class TargetingOptions {
            public Get get(String targetingType, String targetingOptionId) throws IOException {
                Get result = new Get(targetingType, targetingOptionId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String targetingType) throws IOException {
                List result = new List(targetingType);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Search search(String targetingType, SearchTargetingOptionsRequest content) throws IOException {
                Search result = new Search(targetingType, content);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Search
            extends DisplayVideoRequest<SearchTargetingOptionsResponse> {
                private static final String REST_PATH = "v2/targetingTypes/{+targetingType}/targetingOptions:search";
                private final Pattern TARGETING_TYPE_PATTERN;
                @Key
                private String targetingType;

                protected Search(String targetingType, SearchTargetingOptionsRequest content) {
                    super(DisplayVideo.this, "POST", REST_PATH, (Object)content, SearchTargetingOptionsResponse.class);
                    this.TARGETING_TYPE_PATTERN = Pattern.compile("^[^/]+$");
                    this.targetingType = (String)Preconditions.checkNotNull((Object)targetingType, (Object)"Required parameter targetingType must be specified.");
                    if (!DisplayVideo.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                    }
                }

                public Search set$Xgafv(String $Xgafv) {
                    return (Search)super.set$Xgafv($Xgafv);
                }

                public Search setAccessToken(String accessToken) {
                    return (Search)super.setAccessToken(accessToken);
                }

                public Search setAlt(String alt) {
                    return (Search)super.setAlt(alt);
                }

                public Search setCallback(String callback) {
                    return (Search)super.setCallback(callback);
                }

                public Search setFields(String fields) {
                    return (Search)super.setFields(fields);
                }

                public Search setKey(String key) {
                    return (Search)super.setKey(key);
                }

                public Search setOauthToken(String oauthToken) {
                    return (Search)super.setOauthToken(oauthToken);
                }

                public Search setPrettyPrint(Boolean prettyPrint) {
                    return (Search)super.setPrettyPrint(prettyPrint);
                }

                public Search setQuotaUser(String quotaUser) {
                    return (Search)super.setQuotaUser(quotaUser);
                }

                public Search setUploadType(String uploadType) {
                    return (Search)super.setUploadType(uploadType);
                }

                public Search setUploadProtocol(String uploadProtocol) {
                    return (Search)super.setUploadProtocol(uploadProtocol);
                }

                public String getTargetingType() {
                    return this.targetingType;
                }

                public Search setTargetingType(String targetingType) {
                    if (!DisplayVideo.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                    }
                    this.targetingType = targetingType;
                    return this;
                }

                @Override
                public Search set(String parameterName, Object value) {
                    return (Search)super.set(parameterName, value);
                }
            }

            public class List
            extends DisplayVideoRequest<ListTargetingOptionsResponse> {
                private static final String REST_PATH = "v2/targetingTypes/{+targetingType}/targetingOptions";
                private final Pattern TARGETING_TYPE_PATTERN;
                @Key
                private String targetingType;
                @Key
                private Long advertiserId;
                @Key
                private String filter;
                @Key
                private String orderBy;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String targetingType) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, ListTargetingOptionsResponse.class);
                    this.TARGETING_TYPE_PATTERN = Pattern.compile("^[^/]+$");
                    this.targetingType = (String)Preconditions.checkNotNull((Object)targetingType, (Object)"Required parameter targetingType must be specified.");
                    if (!DisplayVideo.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getTargetingType() {
                    return this.targetingType;
                }

                public List setTargetingType(String targetingType) {
                    if (!DisplayVideo.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                    }
                    this.targetingType = targetingType;
                    return this;
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public List setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public List setOrderBy(String orderBy) {
                    this.orderBy = orderBy;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends DisplayVideoRequest<TargetingOption> {
                private static final String REST_PATH = "v2/targetingTypes/{+targetingType}/targetingOptions/{+targetingOptionId}";
                private final Pattern TARGETING_TYPE_PATTERN;
                private final Pattern TARGETING_OPTION_ID_PATTERN;
                @Key
                private String targetingType;
                @Key
                private String targetingOptionId;
                @Key
                private Long advertiserId;

                protected Get(String targetingType, String targetingOptionId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, TargetingOption.class);
                    this.TARGETING_TYPE_PATTERN = Pattern.compile("^[^/]+$");
                    this.TARGETING_OPTION_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.targetingType = (String)Preconditions.checkNotNull((Object)targetingType, (Object)"Required parameter targetingType must be specified.");
                    if (!DisplayVideo.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                    }
                    this.targetingOptionId = (String)Preconditions.checkNotNull((Object)targetingOptionId, (Object)"Required parameter targetingOptionId must be specified.");
                    if (!DisplayVideo.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.TARGETING_OPTION_ID_PATTERN.matcher(targetingOptionId).matches(), (Object)"Parameter targetingOptionId must conform to the pattern ^[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getTargetingType() {
                    return this.targetingType;
                }

                public Get setTargetingType(String targetingType) {
                    if (!DisplayVideo.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                    }
                    this.targetingType = targetingType;
                    return this;
                }

                public String getTargetingOptionId() {
                    return this.targetingOptionId;
                }

                public Get setTargetingOptionId(String targetingOptionId) {
                    if (!DisplayVideo.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.TARGETING_OPTION_ID_PATTERN.matcher(targetingOptionId).matches(), (Object)"Parameter targetingOptionId must conform to the pattern ^[^/]+$");
                    }
                    this.targetingOptionId = targetingOptionId;
                    return this;
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Get setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }
    }

    public class Sdfdownloadtasks {
        public Create create(CreateSdfDownloadTaskRequest content) throws IOException {
            Create result = new Create(content);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Operations operations() {
            return new Operations();
        }

        public class Operations {
            public Get get(String name) throws IOException {
                Get result = new Get(name);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Get
            extends DisplayVideoRequest<Operation> {
                private static final String REST_PATH = "v2/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, Operation.class);
                    this.NAME_PATTERN = Pattern.compile("^sdfdownloadtasks/operations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!DisplayVideo.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^sdfdownloadtasks/operations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!DisplayVideo.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^sdfdownloadtasks/operations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class Create
        extends DisplayVideoRequest<Operation> {
            private static final String REST_PATH = "v2/sdfdownloadtasks";

            protected Create(CreateSdfDownloadTaskRequest content) {
                super(DisplayVideo.this, "POST", REST_PATH, (Object)content, Operation.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class Partners {
        public EditAssignedTargetingOptions editAssignedTargetingOptions(Long partnerId, BulkEditPartnerAssignedTargetingOptionsRequest content) throws IOException {
            EditAssignedTargetingOptions result = new EditAssignedTargetingOptions(partnerId, content);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(Long partnerId) throws IOException {
            Get result = new Get(partnerId);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Channels channels() {
            return new Channels();
        }

        public TargetingTypes targetingTypes() {
            return new TargetingTypes();
        }

        public class TargetingTypes {
            public AssignedTargetingOptions assignedTargetingOptions() {
                return new AssignedTargetingOptions();
            }

            public class AssignedTargetingOptions {
                public Create create(Long partnerId, String targetingType, AssignedTargetingOption content) throws IOException {
                    Create result = new Create(partnerId, targetingType, content);
                    DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(Long partnerId, String targetingType, String assignedTargetingOptionId) throws IOException {
                    Delete result = new Delete(partnerId, targetingType, assignedTargetingOptionId);
                    DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(Long partnerId, String targetingType, String assignedTargetingOptionId) throws IOException {
                    Get result = new Get(partnerId, targetingType, assignedTargetingOptionId);
                    DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(Long partnerId, String targetingType) throws IOException {
                    List result = new List(partnerId, targetingType);
                    DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends DisplayVideoRequest<ListPartnerAssignedTargetingOptionsResponse> {
                    private static final String REST_PATH = "v2/partners/{+partnerId}/targetingTypes/{+targetingType}/assignedTargetingOptions";
                    private final Pattern PARTNER_ID_PATTERN;
                    private final Pattern TARGETING_TYPE_PATTERN;
                    @Key
                    private Long partnerId;
                    @Key
                    private String targetingType;
                    @Key
                    private String filter;
                    @Key
                    private String orderBy;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(Long partnerId, String targetingType) {
                        super(DisplayVideo.this, "GET", REST_PATH, null, ListPartnerAssignedTargetingOptionsResponse.class);
                        this.PARTNER_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.TARGETING_TYPE_PATTERN = Pattern.compile("^[^/]+$");
                        this.partnerId = (Long)Preconditions.checkNotNull((Object)partnerId, (Object)"Required parameter partnerId must be specified.");
                        this.targetingType = (String)Preconditions.checkNotNull((Object)targetingType, (Object)"Required parameter targetingType must be specified.");
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public Long getPartnerId() {
                        return this.partnerId;
                    }

                    public List setPartnerId(Long partnerId) {
                        this.partnerId = partnerId;
                        return this;
                    }

                    public String getTargetingType() {
                        return this.targetingType;
                    }

                    public List setTargetingType(String targetingType) {
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                        }
                        this.targetingType = targetingType;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public String getOrderBy() {
                        return this.orderBy;
                    }

                    public List setOrderBy(String orderBy) {
                        this.orderBy = orderBy;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends DisplayVideoRequest<AssignedTargetingOption> {
                    private static final String REST_PATH = "v2/partners/{+partnerId}/targetingTypes/{+targetingType}/assignedTargetingOptions/{+assignedTargetingOptionId}";
                    private final Pattern PARTNER_ID_PATTERN;
                    private final Pattern TARGETING_TYPE_PATTERN;
                    private final Pattern ASSIGNED_TARGETING_OPTION_ID_PATTERN;
                    @Key
                    private Long partnerId;
                    @Key
                    private String targetingType;
                    @Key
                    private String assignedTargetingOptionId;

                    protected Get(Long partnerId, String targetingType, String assignedTargetingOptionId) {
                        super(DisplayVideo.this, "GET", REST_PATH, null, AssignedTargetingOption.class);
                        this.PARTNER_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.TARGETING_TYPE_PATTERN = Pattern.compile("^[^/]+$");
                        this.ASSIGNED_TARGETING_OPTION_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.partnerId = (Long)Preconditions.checkNotNull((Object)partnerId, (Object)"Required parameter partnerId must be specified.");
                        this.targetingType = (String)Preconditions.checkNotNull((Object)targetingType, (Object)"Required parameter targetingType must be specified.");
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                        }
                        this.assignedTargetingOptionId = (String)Preconditions.checkNotNull((Object)assignedTargetingOptionId, (Object)"Required parameter assignedTargetingOptionId must be specified.");
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.ASSIGNED_TARGETING_OPTION_ID_PATTERN.matcher(assignedTargetingOptionId).matches(), (Object)"Parameter assignedTargetingOptionId must conform to the pattern ^[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public Long getPartnerId() {
                        return this.partnerId;
                    }

                    public Get setPartnerId(Long partnerId) {
                        this.partnerId = partnerId;
                        return this;
                    }

                    public String getTargetingType() {
                        return this.targetingType;
                    }

                    public Get setTargetingType(String targetingType) {
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                        }
                        this.targetingType = targetingType;
                        return this;
                    }

                    public String getAssignedTargetingOptionId() {
                        return this.assignedTargetingOptionId;
                    }

                    public Get setAssignedTargetingOptionId(String assignedTargetingOptionId) {
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.ASSIGNED_TARGETING_OPTION_ID_PATTERN.matcher(assignedTargetingOptionId).matches(), (Object)"Parameter assignedTargetingOptionId must conform to the pattern ^[^/]+$");
                        }
                        this.assignedTargetingOptionId = assignedTargetingOptionId;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends DisplayVideoRequest<Empty> {
                    private static final String REST_PATH = "v2/partners/{+partnerId}/targetingTypes/{+targetingType}/assignedTargetingOptions/{+assignedTargetingOptionId}";
                    private final Pattern PARTNER_ID_PATTERN;
                    private final Pattern TARGETING_TYPE_PATTERN;
                    private final Pattern ASSIGNED_TARGETING_OPTION_ID_PATTERN;
                    @Key
                    private Long partnerId;
                    @Key
                    private String targetingType;
                    @Key
                    private String assignedTargetingOptionId;

                    protected Delete(Long partnerId, String targetingType, String assignedTargetingOptionId) {
                        super(DisplayVideo.this, "DELETE", REST_PATH, null, Empty.class);
                        this.PARTNER_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.TARGETING_TYPE_PATTERN = Pattern.compile("^[^/]+$");
                        this.ASSIGNED_TARGETING_OPTION_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.partnerId = (Long)Preconditions.checkNotNull((Object)partnerId, (Object)"Required parameter partnerId must be specified.");
                        this.targetingType = (String)Preconditions.checkNotNull((Object)targetingType, (Object)"Required parameter targetingType must be specified.");
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                        }
                        this.assignedTargetingOptionId = (String)Preconditions.checkNotNull((Object)assignedTargetingOptionId, (Object)"Required parameter assignedTargetingOptionId must be specified.");
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.ASSIGNED_TARGETING_OPTION_ID_PATTERN.matcher(assignedTargetingOptionId).matches(), (Object)"Parameter assignedTargetingOptionId must conform to the pattern ^[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public Long getPartnerId() {
                        return this.partnerId;
                    }

                    public Delete setPartnerId(Long partnerId) {
                        this.partnerId = partnerId;
                        return this;
                    }

                    public String getTargetingType() {
                        return this.targetingType;
                    }

                    public Delete setTargetingType(String targetingType) {
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                        }
                        this.targetingType = targetingType;
                        return this;
                    }

                    public String getAssignedTargetingOptionId() {
                        return this.assignedTargetingOptionId;
                    }

                    public Delete setAssignedTargetingOptionId(String assignedTargetingOptionId) {
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.ASSIGNED_TARGETING_OPTION_ID_PATTERN.matcher(assignedTargetingOptionId).matches(), (Object)"Parameter assignedTargetingOptionId must conform to the pattern ^[^/]+$");
                        }
                        this.assignedTargetingOptionId = assignedTargetingOptionId;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends DisplayVideoRequest<AssignedTargetingOption> {
                    private static final String REST_PATH = "v2/partners/{+partnerId}/targetingTypes/{+targetingType}/assignedTargetingOptions";
                    private final Pattern PARTNER_ID_PATTERN;
                    private final Pattern TARGETING_TYPE_PATTERN;
                    @Key
                    private Long partnerId;
                    @Key
                    private String targetingType;

                    protected Create(Long partnerId, String targetingType, AssignedTargetingOption content) {
                        super(DisplayVideo.this, "POST", REST_PATH, (Object)content, AssignedTargetingOption.class);
                        this.PARTNER_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.TARGETING_TYPE_PATTERN = Pattern.compile("^[^/]+$");
                        this.partnerId = (Long)Preconditions.checkNotNull((Object)partnerId, (Object)"Required parameter partnerId must be specified.");
                        this.targetingType = (String)Preconditions.checkNotNull((Object)targetingType, (Object)"Required parameter targetingType must be specified.");
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public Long getPartnerId() {
                        return this.partnerId;
                    }

                    public Create setPartnerId(Long partnerId) {
                        this.partnerId = partnerId;
                        return this;
                    }

                    public String getTargetingType() {
                        return this.targetingType;
                    }

                    public Create setTargetingType(String targetingType) {
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                        }
                        this.targetingType = targetingType;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }
        }

        public class Channels {
            public Create create(Long partnerId, Channel content) throws IOException {
                Create result = new Create(partnerId, content);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(Long partnerId, Long channelId) throws IOException {
                Get result = new Get(partnerId, channelId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(Long partnerId) throws IOException {
                List result = new List(partnerId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(Long partnerId, Long channelId, Channel content) throws IOException {
                Patch result = new Patch(partnerId, channelId, content);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Sites sites() {
                return new Sites();
            }

            public class Sites {
                public BulkEdit bulkEdit(Long partnerId, Long channelId, BulkEditSitesRequest content) throws IOException {
                    BulkEdit result = new BulkEdit(partnerId, channelId, content);
                    DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Create create(Long partnerId, Long channelId, Site content) throws IOException {
                    Create result = new Create(partnerId, channelId, content);
                    DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(Long partnerId, Long channelId, String urlOrAppId) throws IOException {
                    Delete result = new Delete(partnerId, channelId, urlOrAppId);
                    DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(Long partnerId, Long channelId) throws IOException {
                    List result = new List(partnerId, channelId);
                    DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Replace replace(Long partnerId, Long channelId, ReplaceSitesRequest content) throws IOException {
                    Replace result = new Replace(partnerId, channelId, content);
                    DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class Replace
                extends DisplayVideoRequest<ReplaceSitesResponse> {
                    private static final String REST_PATH = "v2/partners/{partnerId}/channels/{+channelId}/sites:replace";
                    private final Pattern CHANNEL_ID_PATTERN;
                    @Key
                    private Long partnerId;
                    @Key
                    private Long channelId;

                    protected Replace(Long partnerId, Long channelId, ReplaceSitesRequest content) {
                        super(DisplayVideo.this, "POST", REST_PATH, (Object)content, ReplaceSitesResponse.class);
                        this.CHANNEL_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.partnerId = (Long)Preconditions.checkNotNull((Object)partnerId, (Object)"Required parameter partnerId must be specified.");
                        this.channelId = (Long)Preconditions.checkNotNull((Object)channelId, (Object)"Required parameter channelId must be specified.");
                    }

                    public Replace set$Xgafv(String $Xgafv) {
                        return (Replace)super.set$Xgafv($Xgafv);
                    }

                    public Replace setAccessToken(String accessToken) {
                        return (Replace)super.setAccessToken(accessToken);
                    }

                    public Replace setAlt(String alt) {
                        return (Replace)super.setAlt(alt);
                    }

                    public Replace setCallback(String callback) {
                        return (Replace)super.setCallback(callback);
                    }

                    public Replace setFields(String fields) {
                        return (Replace)super.setFields(fields);
                    }

                    public Replace setKey(String key) {
                        return (Replace)super.setKey(key);
                    }

                    public Replace setOauthToken(String oauthToken) {
                        return (Replace)super.setOauthToken(oauthToken);
                    }

                    public Replace setPrettyPrint(Boolean prettyPrint) {
                        return (Replace)super.setPrettyPrint(prettyPrint);
                    }

                    public Replace setQuotaUser(String quotaUser) {
                        return (Replace)super.setQuotaUser(quotaUser);
                    }

                    public Replace setUploadType(String uploadType) {
                        return (Replace)super.setUploadType(uploadType);
                    }

                    public Replace setUploadProtocol(String uploadProtocol) {
                        return (Replace)super.setUploadProtocol(uploadProtocol);
                    }

                    public Long getPartnerId() {
                        return this.partnerId;
                    }

                    public Replace setPartnerId(Long partnerId) {
                        this.partnerId = partnerId;
                        return this;
                    }

                    public Long getChannelId() {
                        return this.channelId;
                    }

                    public Replace setChannelId(Long channelId) {
                        this.channelId = channelId;
                        return this;
                    }

                    @Override
                    public Replace set(String parameterName, Object value) {
                        return (Replace)super.set(parameterName, value);
                    }
                }

                public class List
                extends DisplayVideoRequest<ListSitesResponse> {
                    private static final String REST_PATH = "v2/partners/{+partnerId}/channels/{+channelId}/sites";
                    private final Pattern PARTNER_ID_PATTERN;
                    private final Pattern CHANNEL_ID_PATTERN;
                    @Key
                    private Long partnerId;
                    @Key
                    private Long channelId;
                    @Key
                    private Long advertiserId;
                    @Key
                    private String filter;
                    @Key
                    private String orderBy;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(Long partnerId, Long channelId) {
                        super(DisplayVideo.this, "GET", REST_PATH, null, ListSitesResponse.class);
                        this.PARTNER_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.CHANNEL_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.partnerId = (Long)Preconditions.checkNotNull((Object)partnerId, (Object)"Required parameter partnerId must be specified.");
                        this.channelId = (Long)Preconditions.checkNotNull((Object)channelId, (Object)"Required parameter channelId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public Long getPartnerId() {
                        return this.partnerId;
                    }

                    public List setPartnerId(Long partnerId) {
                        this.partnerId = partnerId;
                        return this;
                    }

                    public Long getChannelId() {
                        return this.channelId;
                    }

                    public List setChannelId(Long channelId) {
                        this.channelId = channelId;
                        return this;
                    }

                    public Long getAdvertiserId() {
                        return this.advertiserId;
                    }

                    public List setAdvertiserId(Long advertiserId) {
                        this.advertiserId = advertiserId;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public String getOrderBy() {
                        return this.orderBy;
                    }

                    public List setOrderBy(String orderBy) {
                        this.orderBy = orderBy;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends DisplayVideoRequest<Empty> {
                    private static final String REST_PATH = "v2/partners/{partnerId}/channels/{+channelId}/sites/{+urlOrAppId}";
                    private final Pattern CHANNEL_ID_PATTERN;
                    private final Pattern URL_OR_APP_ID_PATTERN;
                    @Key
                    private Long partnerId;
                    @Key
                    private Long channelId;
                    @Key
                    private String urlOrAppId;
                    @Key
                    private Long advertiserId;

                    protected Delete(Long partnerId, Long channelId, String urlOrAppId) {
                        super(DisplayVideo.this, "DELETE", REST_PATH, null, Empty.class);
                        this.CHANNEL_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.URL_OR_APP_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.partnerId = (Long)Preconditions.checkNotNull((Object)partnerId, (Object)"Required parameter partnerId must be specified.");
                        this.channelId = (Long)Preconditions.checkNotNull((Object)channelId, (Object)"Required parameter channelId must be specified.");
                        this.urlOrAppId = (String)Preconditions.checkNotNull((Object)urlOrAppId, (Object)"Required parameter urlOrAppId must be specified.");
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.URL_OR_APP_ID_PATTERN.matcher(urlOrAppId).matches(), (Object)"Parameter urlOrAppId must conform to the pattern ^[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public Long getPartnerId() {
                        return this.partnerId;
                    }

                    public Delete setPartnerId(Long partnerId) {
                        this.partnerId = partnerId;
                        return this;
                    }

                    public Long getChannelId() {
                        return this.channelId;
                    }

                    public Delete setChannelId(Long channelId) {
                        this.channelId = channelId;
                        return this;
                    }

                    public String getUrlOrAppId() {
                        return this.urlOrAppId;
                    }

                    public Delete setUrlOrAppId(String urlOrAppId) {
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.URL_OR_APP_ID_PATTERN.matcher(urlOrAppId).matches(), (Object)"Parameter urlOrAppId must conform to the pattern ^[^/]+$");
                        }
                        this.urlOrAppId = urlOrAppId;
                        return this;
                    }

                    public Long getAdvertiserId() {
                        return this.advertiserId;
                    }

                    public Delete setAdvertiserId(Long advertiserId) {
                        this.advertiserId = advertiserId;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends DisplayVideoRequest<Site> {
                    private static final String REST_PATH = "v2/partners/{partnerId}/channels/{+channelId}/sites";
                    private final Pattern CHANNEL_ID_PATTERN;
                    @Key
                    private Long partnerId;
                    @Key
                    private Long channelId;
                    @Key
                    private Long advertiserId;

                    protected Create(Long partnerId, Long channelId, Site content) {
                        super(DisplayVideo.this, "POST", REST_PATH, (Object)content, Site.class);
                        this.CHANNEL_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.partnerId = (Long)Preconditions.checkNotNull((Object)partnerId, (Object)"Required parameter partnerId must be specified.");
                        this.channelId = (Long)Preconditions.checkNotNull((Object)channelId, (Object)"Required parameter channelId must be specified.");
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public Long getPartnerId() {
                        return this.partnerId;
                    }

                    public Create setPartnerId(Long partnerId) {
                        this.partnerId = partnerId;
                        return this;
                    }

                    public Long getChannelId() {
                        return this.channelId;
                    }

                    public Create setChannelId(Long channelId) {
                        this.channelId = channelId;
                        return this;
                    }

                    public Long getAdvertiserId() {
                        return this.advertiserId;
                    }

                    public Create setAdvertiserId(Long advertiserId) {
                        this.advertiserId = advertiserId;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }

                public class BulkEdit
                extends DisplayVideoRequest<BulkEditSitesResponse> {
                    private static final String REST_PATH = "v2/partners/{partnerId}/channels/{+channelId}/sites:bulkEdit";
                    private final Pattern CHANNEL_ID_PATTERN;
                    @Key
                    private Long partnerId;
                    @Key
                    private Long channelId;

                    protected BulkEdit(Long partnerId, Long channelId, BulkEditSitesRequest content) {
                        super(DisplayVideo.this, "POST", REST_PATH, (Object)content, BulkEditSitesResponse.class);
                        this.CHANNEL_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.partnerId = (Long)Preconditions.checkNotNull((Object)partnerId, (Object)"Required parameter partnerId must be specified.");
                        this.channelId = (Long)Preconditions.checkNotNull((Object)channelId, (Object)"Required parameter channelId must be specified.");
                    }

                    public BulkEdit set$Xgafv(String $Xgafv) {
                        return (BulkEdit)super.set$Xgafv($Xgafv);
                    }

                    public BulkEdit setAccessToken(String accessToken) {
                        return (BulkEdit)super.setAccessToken(accessToken);
                    }

                    public BulkEdit setAlt(String alt) {
                        return (BulkEdit)super.setAlt(alt);
                    }

                    public BulkEdit setCallback(String callback) {
                        return (BulkEdit)super.setCallback(callback);
                    }

                    public BulkEdit setFields(String fields) {
                        return (BulkEdit)super.setFields(fields);
                    }

                    public BulkEdit setKey(String key) {
                        return (BulkEdit)super.setKey(key);
                    }

                    public BulkEdit setOauthToken(String oauthToken) {
                        return (BulkEdit)super.setOauthToken(oauthToken);
                    }

                    public BulkEdit setPrettyPrint(Boolean prettyPrint) {
                        return (BulkEdit)super.setPrettyPrint(prettyPrint);
                    }

                    public BulkEdit setQuotaUser(String quotaUser) {
                        return (BulkEdit)super.setQuotaUser(quotaUser);
                    }

                    public BulkEdit setUploadType(String uploadType) {
                        return (BulkEdit)super.setUploadType(uploadType);
                    }

                    public BulkEdit setUploadProtocol(String uploadProtocol) {
                        return (BulkEdit)super.setUploadProtocol(uploadProtocol);
                    }

                    public Long getPartnerId() {
                        return this.partnerId;
                    }

                    public BulkEdit setPartnerId(Long partnerId) {
                        this.partnerId = partnerId;
                        return this;
                    }

                    public Long getChannelId() {
                        return this.channelId;
                    }

                    public BulkEdit setChannelId(Long channelId) {
                        this.channelId = channelId;
                        return this;
                    }

                    @Override
                    public BulkEdit set(String parameterName, Object value) {
                        return (BulkEdit)super.set(parameterName, value);
                    }
                }
            }

            public class Patch
            extends DisplayVideoRequest<Channel> {
                private static final String REST_PATH = "v2/partners/{+partnerId}/channels/{channelId}";
                private final Pattern PARTNER_ID_PATTERN;
                @Key
                private Long partnerId;
                @Key
                private Long channelId;
                @Key
                private Long advertiserId;
                @Key
                private String updateMask;

                protected Patch(Long partnerId, Long channelId, Channel content) {
                    super(DisplayVideo.this, "PATCH", REST_PATH, (Object)content, Channel.class);
                    this.PARTNER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.partnerId = (Long)Preconditions.checkNotNull((Object)partnerId, (Object)"Required parameter partnerId must be specified.");
                    this.channelId = (Long)Preconditions.checkNotNull((Object)channelId, (Object)"Required parameter channelId must be specified.");
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public Long getPartnerId() {
                    return this.partnerId;
                }

                public Patch setPartnerId(Long partnerId) {
                    this.partnerId = partnerId;
                    return this;
                }

                public Long getChannelId() {
                    return this.channelId;
                }

                public Patch setChannelId(Long channelId) {
                    this.channelId = channelId;
                    return this;
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Patch setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends DisplayVideoRequest<ListChannelsResponse> {
                private static final String REST_PATH = "v2/partners/{+partnerId}/channels";
                private final Pattern PARTNER_ID_PATTERN;
                @Key
                private Long partnerId;
                @Key
                private Long advertiserId;
                @Key
                private String filter;
                @Key
                private String orderBy;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(Long partnerId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, ListChannelsResponse.class);
                    this.PARTNER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.partnerId = (Long)Preconditions.checkNotNull((Object)partnerId, (Object)"Required parameter partnerId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public Long getPartnerId() {
                    return this.partnerId;
                }

                public List setPartnerId(Long partnerId) {
                    this.partnerId = partnerId;
                    return this;
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public List setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public List setOrderBy(String orderBy) {
                    this.orderBy = orderBy;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends DisplayVideoRequest<Channel> {
                private static final String REST_PATH = "v2/partners/{+partnerId}/channels/{+channelId}";
                private final Pattern PARTNER_ID_PATTERN;
                private final Pattern CHANNEL_ID_PATTERN;
                @Key
                private Long partnerId;
                @Key
                private Long channelId;
                @Key
                private Long advertiserId;

                protected Get(Long partnerId, Long channelId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, Channel.class);
                    this.PARTNER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.CHANNEL_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.partnerId = (Long)Preconditions.checkNotNull((Object)partnerId, (Object)"Required parameter partnerId must be specified.");
                    this.channelId = (Long)Preconditions.checkNotNull((Object)channelId, (Object)"Required parameter channelId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public Long getPartnerId() {
                    return this.partnerId;
                }

                public Get setPartnerId(Long partnerId) {
                    this.partnerId = partnerId;
                    return this;
                }

                public Long getChannelId() {
                    return this.channelId;
                }

                public Get setChannelId(Long channelId) {
                    this.channelId = channelId;
                    return this;
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Get setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Create
            extends DisplayVideoRequest<Channel> {
                private static final String REST_PATH = "v2/partners/{+partnerId}/channels";
                private final Pattern PARTNER_ID_PATTERN;
                @Key
                private Long partnerId;
                @Key
                private Long advertiserId;

                protected Create(Long partnerId, Channel content) {
                    super(DisplayVideo.this, "POST", REST_PATH, (Object)content, Channel.class);
                    this.PARTNER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.partnerId = (Long)Preconditions.checkNotNull((Object)partnerId, (Object)"Required parameter partnerId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public Long getPartnerId() {
                    return this.partnerId;
                }

                public Create setPartnerId(Long partnerId) {
                    this.partnerId = partnerId;
                    return this;
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Create setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class List
        extends DisplayVideoRequest<ListPartnersResponse> {
            private static final String REST_PATH = "v2/partners";
            @Key
            private String filter;
            @Key
            private String orderBy;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List() {
                super(DisplayVideo.this, "GET", REST_PATH, null, ListPartnersResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends DisplayVideoRequest<Partner> {
            private static final String REST_PATH = "v2/partners/{+partnerId}";
            private final Pattern PARTNER_ID_PATTERN;
            @Key
            private Long partnerId;

            protected Get(Long partnerId) {
                super(DisplayVideo.this, "GET", REST_PATH, null, Partner.class);
                this.PARTNER_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.partnerId = (Long)Preconditions.checkNotNull((Object)partnerId, (Object)"Required parameter partnerId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public Get setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class EditAssignedTargetingOptions
        extends DisplayVideoRequest<BulkEditPartnerAssignedTargetingOptionsResponse> {
            private static final String REST_PATH = "v2/partners/{+partnerId}:editAssignedTargetingOptions";
            private final Pattern PARTNER_ID_PATTERN;
            @Key
            private Long partnerId;

            protected EditAssignedTargetingOptions(Long partnerId, BulkEditPartnerAssignedTargetingOptionsRequest content) {
                super(DisplayVideo.this, "POST", REST_PATH, (Object)content, BulkEditPartnerAssignedTargetingOptionsResponse.class);
                this.PARTNER_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.partnerId = (Long)Preconditions.checkNotNull((Object)partnerId, (Object)"Required parameter partnerId must be specified.");
            }

            public EditAssignedTargetingOptions set$Xgafv(String $Xgafv) {
                return (EditAssignedTargetingOptions)super.set$Xgafv($Xgafv);
            }

            public EditAssignedTargetingOptions setAccessToken(String accessToken) {
                return (EditAssignedTargetingOptions)super.setAccessToken(accessToken);
            }

            public EditAssignedTargetingOptions setAlt(String alt) {
                return (EditAssignedTargetingOptions)super.setAlt(alt);
            }

            public EditAssignedTargetingOptions setCallback(String callback) {
                return (EditAssignedTargetingOptions)super.setCallback(callback);
            }

            public EditAssignedTargetingOptions setFields(String fields) {
                return (EditAssignedTargetingOptions)super.setFields(fields);
            }

            public EditAssignedTargetingOptions setKey(String key) {
                return (EditAssignedTargetingOptions)super.setKey(key);
            }

            public EditAssignedTargetingOptions setOauthToken(String oauthToken) {
                return (EditAssignedTargetingOptions)super.setOauthToken(oauthToken);
            }

            public EditAssignedTargetingOptions setPrettyPrint(Boolean prettyPrint) {
                return (EditAssignedTargetingOptions)super.setPrettyPrint(prettyPrint);
            }

            public EditAssignedTargetingOptions setQuotaUser(String quotaUser) {
                return (EditAssignedTargetingOptions)super.setQuotaUser(quotaUser);
            }

            public EditAssignedTargetingOptions setUploadType(String uploadType) {
                return (EditAssignedTargetingOptions)super.setUploadType(uploadType);
            }

            public EditAssignedTargetingOptions setUploadProtocol(String uploadProtocol) {
                return (EditAssignedTargetingOptions)super.setUploadProtocol(uploadProtocol);
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public EditAssignedTargetingOptions setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            @Override
            public EditAssignedTargetingOptions set(String parameterName, Object value) {
                return (EditAssignedTargetingOptions)super.set(parameterName, value);
            }
        }
    }

    public class Media {
        public Download download(String resourceName) throws IOException {
            Download result = new Download(resourceName);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Upload upload(String resourceName, GoogleBytestreamMedia content) throws IOException {
            Upload result = new Upload(resourceName, content);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Upload upload(String resourceName, GoogleBytestreamMedia content, AbstractInputStreamContent mediaContent) throws IOException {
            Upload result = new Upload(resourceName, content, mediaContent);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Upload
        extends DisplayVideoRequest<GoogleBytestreamMedia> {
            private static final String REST_PATH = "media/{+resourceName}";
            private final Pattern RESOURCE_NAME_PATTERN;
            @Key
            private String resourceName;

            protected Upload(String resourceName, GoogleBytestreamMedia content) {
                super(DisplayVideo.this, "POST", REST_PATH, (Object)content, GoogleBytestreamMedia.class);
                this.RESOURCE_NAME_PATTERN = Pattern.compile("^.*$");
                this.resourceName = (String)Preconditions.checkNotNull((Object)resourceName, (Object)"Required parameter resourceName must be specified.");
                if (!DisplayVideo.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(resourceName).matches(), (Object)"Parameter resourceName must conform to the pattern ^.*$");
                }
            }

            protected Upload(String resourceName, GoogleBytestreamMedia content, AbstractInputStreamContent mediaContent) {
                super(DisplayVideo.this, "POST", "/upload/" + DisplayVideo.this.getServicePath() + REST_PATH, (Object)content, GoogleBytestreamMedia.class);
                this.RESOURCE_NAME_PATTERN = Pattern.compile("^.*$");
                this.resourceName = (String)Preconditions.checkNotNull((Object)resourceName, (Object)"Required parameter resourceName must be specified.");
                this.initializeMediaUpload(mediaContent);
            }

            public Upload set$Xgafv(String $Xgafv) {
                return (Upload)super.set$Xgafv($Xgafv);
            }

            public Upload setAccessToken(String accessToken) {
                return (Upload)super.setAccessToken(accessToken);
            }

            public Upload setAlt(String alt) {
                return (Upload)super.setAlt(alt);
            }

            public Upload setCallback(String callback) {
                return (Upload)super.setCallback(callback);
            }

            public Upload setFields(String fields) {
                return (Upload)super.setFields(fields);
            }

            public Upload setKey(String key) {
                return (Upload)super.setKey(key);
            }

            public Upload setOauthToken(String oauthToken) {
                return (Upload)super.setOauthToken(oauthToken);
            }

            public Upload setPrettyPrint(Boolean prettyPrint) {
                return (Upload)super.setPrettyPrint(prettyPrint);
            }

            public Upload setQuotaUser(String quotaUser) {
                return (Upload)super.setQuotaUser(quotaUser);
            }

            public Upload setUploadType(String uploadType) {
                return (Upload)super.setUploadType(uploadType);
            }

            public Upload setUploadProtocol(String uploadProtocol) {
                return (Upload)super.setUploadProtocol(uploadProtocol);
            }

            public String getResourceName() {
                return this.resourceName;
            }

            public Upload setResourceName(String resourceName) {
                if (!DisplayVideo.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(resourceName).matches(), (Object)"Parameter resourceName must conform to the pattern ^.*$");
                }
                this.resourceName = resourceName;
                return this;
            }

            @Override
            public Upload set(String parameterName, Object value) {
                return (Upload)super.set(parameterName, value);
            }
        }

        public class Download
        extends DisplayVideoRequest<GoogleBytestreamMedia> {
            private static final String REST_PATH = "download/{+resourceName}";
            private final Pattern RESOURCE_NAME_PATTERN;
            @Key
            private String resourceName;

            protected Download(String resourceName) {
                super(DisplayVideo.this, "GET", REST_PATH, null, GoogleBytestreamMedia.class);
                this.RESOURCE_NAME_PATTERN = Pattern.compile("^.*$");
                this.resourceName = (String)Preconditions.checkNotNull((Object)resourceName, (Object)"Required parameter resourceName must be specified.");
                if (!DisplayVideo.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(resourceName).matches(), (Object)"Parameter resourceName must conform to the pattern ^.*$");
                }
                this.initializeMediaDownload();
            }

            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Download set$Xgafv(String $Xgafv) {
                return (Download)super.set$Xgafv($Xgafv);
            }

            public Download setAccessToken(String accessToken) {
                return (Download)super.setAccessToken(accessToken);
            }

            public Download setAlt(String alt) {
                return (Download)super.setAlt(alt);
            }

            public Download setCallback(String callback) {
                return (Download)super.setCallback(callback);
            }

            public Download setFields(String fields) {
                return (Download)super.setFields(fields);
            }

            public Download setKey(String key) {
                return (Download)super.setKey(key);
            }

            public Download setOauthToken(String oauthToken) {
                return (Download)super.setOauthToken(oauthToken);
            }

            public Download setPrettyPrint(Boolean prettyPrint) {
                return (Download)super.setPrettyPrint(prettyPrint);
            }

            public Download setQuotaUser(String quotaUser) {
                return (Download)super.setQuotaUser(quotaUser);
            }

            public Download setUploadType(String uploadType) {
                return (Download)super.setUploadType(uploadType);
            }

            public Download setUploadProtocol(String uploadProtocol) {
                return (Download)super.setUploadProtocol(uploadProtocol);
            }

            public String getResourceName() {
                return this.resourceName;
            }

            public Download setResourceName(String resourceName) {
                if (!DisplayVideo.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(resourceName).matches(), (Object)"Parameter resourceName must conform to the pattern ^.*$");
                }
                this.resourceName = resourceName;
                return this;
            }

            @Override
            public Download set(String parameterName, Object value) {
                return (Download)super.set(parameterName, value);
            }
        }
    }

    public class InventorySources {
        public Create create(InventorySource content) throws IOException {
            Create result = new Create(content);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public EditInventorySourceReadWriteAccessors editInventorySourceReadWriteAccessors(Long inventorySourceId, EditInventorySourceReadWriteAccessorsRequest content) throws IOException {
            EditInventorySourceReadWriteAccessors result = new EditInventorySourceReadWriteAccessors(inventorySourceId, content);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(Long inventorySourceId) throws IOException {
            Get result = new Get(inventorySourceId);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(Long inventorySourceId, InventorySource content) throws IOException {
            Patch result = new Patch(inventorySourceId, content);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Patch
        extends DisplayVideoRequest<InventorySource> {
            private static final String REST_PATH = "v2/inventorySources/{+inventorySourceId}";
            private final Pattern INVENTORY_SOURCE_ID_PATTERN;
            @Key
            private Long inventorySourceId;
            @Key
            private Long advertiserId;
            @Key
            private Long partnerId;
            @Key
            private String updateMask;

            protected Patch(Long inventorySourceId, InventorySource content) {
                super(DisplayVideo.this, "PATCH", REST_PATH, (Object)content, InventorySource.class);
                this.INVENTORY_SOURCE_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.inventorySourceId = (Long)Preconditions.checkNotNull((Object)inventorySourceId, (Object)"Required parameter inventorySourceId must be specified.");
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public Long getInventorySourceId() {
                return this.inventorySourceId;
            }

            public Patch setInventorySourceId(Long inventorySourceId) {
                this.inventorySourceId = inventorySourceId;
                return this;
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public Patch setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public Patch setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public Patch setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends DisplayVideoRequest<ListInventorySourcesResponse> {
            private static final String REST_PATH = "v2/inventorySources";
            @Key
            private Long advertiserId;
            @Key
            private String filter;
            @Key
            private String orderBy;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private Long partnerId;

            protected List() {
                super(DisplayVideo.this, "GET", REST_PATH, null, ListInventorySourcesResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public List setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public List setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends DisplayVideoRequest<InventorySource> {
            private static final String REST_PATH = "v2/inventorySources/{+inventorySourceId}";
            private final Pattern INVENTORY_SOURCE_ID_PATTERN;
            @Key
            private Long inventorySourceId;
            @Key
            private Long partnerId;

            protected Get(Long inventorySourceId) {
                super(DisplayVideo.this, "GET", REST_PATH, null, InventorySource.class);
                this.INVENTORY_SOURCE_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.inventorySourceId = (Long)Preconditions.checkNotNull((Object)inventorySourceId, (Object)"Required parameter inventorySourceId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getInventorySourceId() {
                return this.inventorySourceId;
            }

            public Get setInventorySourceId(Long inventorySourceId) {
                this.inventorySourceId = inventorySourceId;
                return this;
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public Get setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class EditInventorySourceReadWriteAccessors
        extends DisplayVideoRequest<InventorySourceAccessors> {
            private static final String REST_PATH = "v2/inventorySources/{+inventorySourceId}:editInventorySourceReadWriteAccessors";
            private final Pattern INVENTORY_SOURCE_ID_PATTERN;
            @Key
            private Long inventorySourceId;

            protected EditInventorySourceReadWriteAccessors(Long inventorySourceId, EditInventorySourceReadWriteAccessorsRequest content) {
                super(DisplayVideo.this, "POST", REST_PATH, (Object)content, InventorySourceAccessors.class);
                this.INVENTORY_SOURCE_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.inventorySourceId = (Long)Preconditions.checkNotNull((Object)inventorySourceId, (Object)"Required parameter inventorySourceId must be specified.");
            }

            public EditInventorySourceReadWriteAccessors set$Xgafv(String $Xgafv) {
                return (EditInventorySourceReadWriteAccessors)super.set$Xgafv($Xgafv);
            }

            public EditInventorySourceReadWriteAccessors setAccessToken(String accessToken) {
                return (EditInventorySourceReadWriteAccessors)super.setAccessToken(accessToken);
            }

            public EditInventorySourceReadWriteAccessors setAlt(String alt) {
                return (EditInventorySourceReadWriteAccessors)super.setAlt(alt);
            }

            public EditInventorySourceReadWriteAccessors setCallback(String callback) {
                return (EditInventorySourceReadWriteAccessors)super.setCallback(callback);
            }

            public EditInventorySourceReadWriteAccessors setFields(String fields) {
                return (EditInventorySourceReadWriteAccessors)super.setFields(fields);
            }

            public EditInventorySourceReadWriteAccessors setKey(String key) {
                return (EditInventorySourceReadWriteAccessors)super.setKey(key);
            }

            public EditInventorySourceReadWriteAccessors setOauthToken(String oauthToken) {
                return (EditInventorySourceReadWriteAccessors)super.setOauthToken(oauthToken);
            }

            public EditInventorySourceReadWriteAccessors setPrettyPrint(Boolean prettyPrint) {
                return (EditInventorySourceReadWriteAccessors)super.setPrettyPrint(prettyPrint);
            }

            public EditInventorySourceReadWriteAccessors setQuotaUser(String quotaUser) {
                return (EditInventorySourceReadWriteAccessors)super.setQuotaUser(quotaUser);
            }

            public EditInventorySourceReadWriteAccessors setUploadType(String uploadType) {
                return (EditInventorySourceReadWriteAccessors)super.setUploadType(uploadType);
            }

            public EditInventorySourceReadWriteAccessors setUploadProtocol(String uploadProtocol) {
                return (EditInventorySourceReadWriteAccessors)super.setUploadProtocol(uploadProtocol);
            }

            public Long getInventorySourceId() {
                return this.inventorySourceId;
            }

            public EditInventorySourceReadWriteAccessors setInventorySourceId(Long inventorySourceId) {
                this.inventorySourceId = inventorySourceId;
                return this;
            }

            @Override
            public EditInventorySourceReadWriteAccessors set(String parameterName, Object value) {
                return (EditInventorySourceReadWriteAccessors)super.set(parameterName, value);
            }
        }

        public class Create
        extends DisplayVideoRequest<InventorySource> {
            private static final String REST_PATH = "v2/inventorySources";
            @Key
            private Long advertiserId;
            @Key
            private Long partnerId;

            protected Create(InventorySource content) {
                super(DisplayVideo.this, "POST", REST_PATH, (Object)content, InventorySource.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public Create setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public Create setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class InventorySourceGroups {
        public Create create(InventorySourceGroup content) throws IOException {
            Create result = new Create(content);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(Long inventorySourceGroupId) throws IOException {
            Delete result = new Delete(inventorySourceGroupId);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(Long inventorySourceGroupId) throws IOException {
            Get result = new Get(inventorySourceGroupId);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(Long inventorySourceGroupId, InventorySourceGroup content) throws IOException {
            Patch result = new Patch(inventorySourceGroupId, content);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public AssignedInventorySources assignedInventorySources() {
            return new AssignedInventorySources();
        }

        public class AssignedInventorySources {
            public BulkEdit bulkEdit(Long inventorySourceGroupId, BulkEditAssignedInventorySourcesRequest content) throws IOException {
                BulkEdit result = new BulkEdit(inventorySourceGroupId, content);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Create create(Long inventorySourceGroupId, AssignedInventorySource content) throws IOException {
                Create result = new Create(inventorySourceGroupId, content);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(Long inventorySourceGroupId, Long assignedInventorySourceId) throws IOException {
                Delete result = new Delete(inventorySourceGroupId, assignedInventorySourceId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(Long inventorySourceGroupId) throws IOException {
                List result = new List(inventorySourceGroupId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends DisplayVideoRequest<ListAssignedInventorySourcesResponse> {
                private static final String REST_PATH = "v2/inventorySourceGroups/{+inventorySourceGroupId}/assignedInventorySources";
                private final Pattern INVENTORY_SOURCE_GROUP_ID_PATTERN;
                @Key
                private Long inventorySourceGroupId;
                @Key
                private Long advertiserId;
                @Key
                private String filter;
                @Key
                private String orderBy;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;
                @Key
                private Long partnerId;

                protected List(Long inventorySourceGroupId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, ListAssignedInventorySourcesResponse.class);
                    this.INVENTORY_SOURCE_GROUP_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.inventorySourceGroupId = (Long)Preconditions.checkNotNull((Object)inventorySourceGroupId, (Object)"Required parameter inventorySourceGroupId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public Long getInventorySourceGroupId() {
                    return this.inventorySourceGroupId;
                }

                public List setInventorySourceGroupId(Long inventorySourceGroupId) {
                    this.inventorySourceGroupId = inventorySourceGroupId;
                    return this;
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public List setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public List setOrderBy(String orderBy) {
                    this.orderBy = orderBy;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public Long getPartnerId() {
                    return this.partnerId;
                }

                public List setPartnerId(Long partnerId) {
                    this.partnerId = partnerId;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Delete
            extends DisplayVideoRequest<Empty> {
                private static final String REST_PATH = "v2/inventorySourceGroups/{+inventorySourceGroupId}/assignedInventorySources/{+assignedInventorySourceId}";
                private final Pattern INVENTORY_SOURCE_GROUP_ID_PATTERN;
                private final Pattern ASSIGNED_INVENTORY_SOURCE_ID_PATTERN;
                @Key
                private Long inventorySourceGroupId;
                @Key
                private Long assignedInventorySourceId;
                @Key
                private Long advertiserId;
                @Key
                private Long partnerId;

                protected Delete(Long inventorySourceGroupId, Long assignedInventorySourceId) {
                    super(DisplayVideo.this, "DELETE", REST_PATH, null, Empty.class);
                    this.INVENTORY_SOURCE_GROUP_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.ASSIGNED_INVENTORY_SOURCE_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.inventorySourceGroupId = (Long)Preconditions.checkNotNull((Object)inventorySourceGroupId, (Object)"Required parameter inventorySourceGroupId must be specified.");
                    this.assignedInventorySourceId = (Long)Preconditions.checkNotNull((Object)assignedInventorySourceId, (Object)"Required parameter assignedInventorySourceId must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public Long getInventorySourceGroupId() {
                    return this.inventorySourceGroupId;
                }

                public Delete setInventorySourceGroupId(Long inventorySourceGroupId) {
                    this.inventorySourceGroupId = inventorySourceGroupId;
                    return this;
                }

                public Long getAssignedInventorySourceId() {
                    return this.assignedInventorySourceId;
                }

                public Delete setAssignedInventorySourceId(Long assignedInventorySourceId) {
                    this.assignedInventorySourceId = assignedInventorySourceId;
                    return this;
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Delete setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getPartnerId() {
                    return this.partnerId;
                }

                public Delete setPartnerId(Long partnerId) {
                    this.partnerId = partnerId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends DisplayVideoRequest<AssignedInventorySource> {
                private static final String REST_PATH = "v2/inventorySourceGroups/{+inventorySourceGroupId}/assignedInventorySources";
                private final Pattern INVENTORY_SOURCE_GROUP_ID_PATTERN;
                @Key
                private Long inventorySourceGroupId;
                @Key
                private Long advertiserId;
                @Key
                private Long partnerId;

                protected Create(Long inventorySourceGroupId, AssignedInventorySource content) {
                    super(DisplayVideo.this, "POST", REST_PATH, (Object)content, AssignedInventorySource.class);
                    this.INVENTORY_SOURCE_GROUP_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.inventorySourceGroupId = (Long)Preconditions.checkNotNull((Object)inventorySourceGroupId, (Object)"Required parameter inventorySourceGroupId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public Long getInventorySourceGroupId() {
                    return this.inventorySourceGroupId;
                }

                public Create setInventorySourceGroupId(Long inventorySourceGroupId) {
                    this.inventorySourceGroupId = inventorySourceGroupId;
                    return this;
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Create setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getPartnerId() {
                    return this.partnerId;
                }

                public Create setPartnerId(Long partnerId) {
                    this.partnerId = partnerId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }

            public class BulkEdit
            extends DisplayVideoRequest<BulkEditAssignedInventorySourcesResponse> {
                private static final String REST_PATH = "v2/inventorySourceGroups/{+inventorySourceGroupId}/assignedInventorySources:bulkEdit";
                private final Pattern INVENTORY_SOURCE_GROUP_ID_PATTERN;
                @Key
                private Long inventorySourceGroupId;

                protected BulkEdit(Long inventorySourceGroupId, BulkEditAssignedInventorySourcesRequest content) {
                    super(DisplayVideo.this, "POST", REST_PATH, (Object)content, BulkEditAssignedInventorySourcesResponse.class);
                    this.INVENTORY_SOURCE_GROUP_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.inventorySourceGroupId = (Long)Preconditions.checkNotNull((Object)inventorySourceGroupId, (Object)"Required parameter inventorySourceGroupId must be specified.");
                }

                public BulkEdit set$Xgafv(String $Xgafv) {
                    return (BulkEdit)super.set$Xgafv($Xgafv);
                }

                public BulkEdit setAccessToken(String accessToken) {
                    return (BulkEdit)super.setAccessToken(accessToken);
                }

                public BulkEdit setAlt(String alt) {
                    return (BulkEdit)super.setAlt(alt);
                }

                public BulkEdit setCallback(String callback) {
                    return (BulkEdit)super.setCallback(callback);
                }

                public BulkEdit setFields(String fields) {
                    return (BulkEdit)super.setFields(fields);
                }

                public BulkEdit setKey(String key) {
                    return (BulkEdit)super.setKey(key);
                }

                public BulkEdit setOauthToken(String oauthToken) {
                    return (BulkEdit)super.setOauthToken(oauthToken);
                }

                public BulkEdit setPrettyPrint(Boolean prettyPrint) {
                    return (BulkEdit)super.setPrettyPrint(prettyPrint);
                }

                public BulkEdit setQuotaUser(String quotaUser) {
                    return (BulkEdit)super.setQuotaUser(quotaUser);
                }

                public BulkEdit setUploadType(String uploadType) {
                    return (BulkEdit)super.setUploadType(uploadType);
                }

                public BulkEdit setUploadProtocol(String uploadProtocol) {
                    return (BulkEdit)super.setUploadProtocol(uploadProtocol);
                }

                public Long getInventorySourceGroupId() {
                    return this.inventorySourceGroupId;
                }

                public BulkEdit setInventorySourceGroupId(Long inventorySourceGroupId) {
                    this.inventorySourceGroupId = inventorySourceGroupId;
                    return this;
                }

                @Override
                public BulkEdit set(String parameterName, Object value) {
                    return (BulkEdit)super.set(parameterName, value);
                }
            }
        }

        public class Patch
        extends DisplayVideoRequest<InventorySourceGroup> {
            private static final String REST_PATH = "v2/inventorySourceGroups/{inventorySourceGroupId}";
            @Key
            private Long inventorySourceGroupId;
            @Key
            private Long advertiserId;
            @Key
            private Long partnerId;
            @Key
            private String updateMask;

            protected Patch(Long inventorySourceGroupId, InventorySourceGroup content) {
                super(DisplayVideo.this, "PATCH", REST_PATH, (Object)content, InventorySourceGroup.class);
                this.inventorySourceGroupId = (Long)Preconditions.checkNotNull((Object)inventorySourceGroupId, (Object)"Required parameter inventorySourceGroupId must be specified.");
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public Long getInventorySourceGroupId() {
                return this.inventorySourceGroupId;
            }

            public Patch setInventorySourceGroupId(Long inventorySourceGroupId) {
                this.inventorySourceGroupId = inventorySourceGroupId;
                return this;
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public Patch setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public Patch setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public Patch setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends DisplayVideoRequest<ListInventorySourceGroupsResponse> {
            private static final String REST_PATH = "v2/inventorySourceGroups";
            @Key
            private Long advertiserId;
            @Key
            private String filter;
            @Key
            private String orderBy;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private Long partnerId;

            protected List() {
                super(DisplayVideo.this, "GET", REST_PATH, null, ListInventorySourceGroupsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public List setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public List setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends DisplayVideoRequest<InventorySourceGroup> {
            private static final String REST_PATH = "v2/inventorySourceGroups/{+inventorySourceGroupId}";
            private final Pattern INVENTORY_SOURCE_GROUP_ID_PATTERN;
            @Key
            private Long inventorySourceGroupId;
            @Key
            private Long advertiserId;
            @Key
            private Long partnerId;

            protected Get(Long inventorySourceGroupId) {
                super(DisplayVideo.this, "GET", REST_PATH, null, InventorySourceGroup.class);
                this.INVENTORY_SOURCE_GROUP_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.inventorySourceGroupId = (Long)Preconditions.checkNotNull((Object)inventorySourceGroupId, (Object)"Required parameter inventorySourceGroupId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getInventorySourceGroupId() {
                return this.inventorySourceGroupId;
            }

            public Get setInventorySourceGroupId(Long inventorySourceGroupId) {
                this.inventorySourceGroupId = inventorySourceGroupId;
                return this;
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public Get setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public Get setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends DisplayVideoRequest<Empty> {
            private static final String REST_PATH = "v2/inventorySourceGroups/{+inventorySourceGroupId}";
            private final Pattern INVENTORY_SOURCE_GROUP_ID_PATTERN;
            @Key
            private Long inventorySourceGroupId;
            @Key
            private Long advertiserId;
            @Key
            private Long partnerId;

            protected Delete(Long inventorySourceGroupId) {
                super(DisplayVideo.this, "DELETE", REST_PATH, null, Empty.class);
                this.INVENTORY_SOURCE_GROUP_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.inventorySourceGroupId = (Long)Preconditions.checkNotNull((Object)inventorySourceGroupId, (Object)"Required parameter inventorySourceGroupId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public Long getInventorySourceGroupId() {
                return this.inventorySourceGroupId;
            }

            public Delete setInventorySourceGroupId(Long inventorySourceGroupId) {
                this.inventorySourceGroupId = inventorySourceGroupId;
                return this;
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public Delete setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public Delete setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends DisplayVideoRequest<InventorySourceGroup> {
            private static final String REST_PATH = "v2/inventorySourceGroups";
            @Key
            private Long advertiserId;
            @Key
            private Long partnerId;

            protected Create(InventorySourceGroup content) {
                super(DisplayVideo.this, "POST", REST_PATH, (Object)content, InventorySourceGroup.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public Create setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public Create setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class GuaranteedOrders {
        public Create create(GuaranteedOrder content) throws IOException {
            Create result = new Create(content);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public EditGuaranteedOrderReadAccessors editGuaranteedOrderReadAccessors(String guaranteedOrderId, EditGuaranteedOrderReadAccessorsRequest content) throws IOException {
            EditGuaranteedOrderReadAccessors result = new EditGuaranteedOrderReadAccessors(guaranteedOrderId, content);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String guaranteedOrderId) throws IOException {
            Get result = new Get(guaranteedOrderId);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String guaranteedOrderId, GuaranteedOrder content) throws IOException {
            Patch result = new Patch(guaranteedOrderId, content);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Patch
        extends DisplayVideoRequest<GuaranteedOrder> {
            private static final String REST_PATH = "v2/guaranteedOrders/{+guaranteedOrderId}";
            private final Pattern GUARANTEED_ORDER_ID_PATTERN;
            @Key
            private String guaranteedOrderId;
            @Key
            private Long advertiserId;
            @Key
            private Long partnerId;
            @Key
            private String updateMask;

            protected Patch(String guaranteedOrderId, GuaranteedOrder content) {
                super(DisplayVideo.this, "PATCH", REST_PATH, (Object)content, GuaranteedOrder.class);
                this.GUARANTEED_ORDER_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.guaranteedOrderId = (String)Preconditions.checkNotNull((Object)guaranteedOrderId, (Object)"Required parameter guaranteedOrderId must be specified.");
                if (!DisplayVideo.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.GUARANTEED_ORDER_ID_PATTERN.matcher(guaranteedOrderId).matches(), (Object)"Parameter guaranteedOrderId must conform to the pattern ^[^/]+$");
                }
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public String getGuaranteedOrderId() {
                return this.guaranteedOrderId;
            }

            public Patch setGuaranteedOrderId(String guaranteedOrderId) {
                if (!DisplayVideo.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.GUARANTEED_ORDER_ID_PATTERN.matcher(guaranteedOrderId).matches(), (Object)"Parameter guaranteedOrderId must conform to the pattern ^[^/]+$");
                }
                this.guaranteedOrderId = guaranteedOrderId;
                return this;
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public Patch setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public Patch setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public Patch setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends DisplayVideoRequest<ListGuaranteedOrdersResponse> {
            private static final String REST_PATH = "v2/guaranteedOrders";
            @Key
            private Long advertiserId;
            @Key
            private String filter;
            @Key
            private String orderBy;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private Long partnerId;

            protected List() {
                super(DisplayVideo.this, "GET", REST_PATH, null, ListGuaranteedOrdersResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public List setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public List setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends DisplayVideoRequest<GuaranteedOrder> {
            private static final String REST_PATH = "v2/guaranteedOrders/{+guaranteedOrderId}";
            private final Pattern GUARANTEED_ORDER_ID_PATTERN;
            @Key
            private String guaranteedOrderId;
            @Key
            private Long advertiserId;
            @Key
            private Long partnerId;

            protected Get(String guaranteedOrderId) {
                super(DisplayVideo.this, "GET", REST_PATH, null, GuaranteedOrder.class);
                this.GUARANTEED_ORDER_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.guaranteedOrderId = (String)Preconditions.checkNotNull((Object)guaranteedOrderId, (Object)"Required parameter guaranteedOrderId must be specified.");
                if (!DisplayVideo.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.GUARANTEED_ORDER_ID_PATTERN.matcher(guaranteedOrderId).matches(), (Object)"Parameter guaranteedOrderId must conform to the pattern ^[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getGuaranteedOrderId() {
                return this.guaranteedOrderId;
            }

            public Get setGuaranteedOrderId(String guaranteedOrderId) {
                if (!DisplayVideo.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.GUARANTEED_ORDER_ID_PATTERN.matcher(guaranteedOrderId).matches(), (Object)"Parameter guaranteedOrderId must conform to the pattern ^[^/]+$");
                }
                this.guaranteedOrderId = guaranteedOrderId;
                return this;
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public Get setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public Get setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class EditGuaranteedOrderReadAccessors
        extends DisplayVideoRequest<EditGuaranteedOrderReadAccessorsResponse> {
            private static final String REST_PATH = "v2/guaranteedOrders/{+guaranteedOrderId}:editGuaranteedOrderReadAccessors";
            private final Pattern GUARANTEED_ORDER_ID_PATTERN;
            @Key
            private String guaranteedOrderId;

            protected EditGuaranteedOrderReadAccessors(String guaranteedOrderId, EditGuaranteedOrderReadAccessorsRequest content) {
                super(DisplayVideo.this, "POST", REST_PATH, (Object)content, EditGuaranteedOrderReadAccessorsResponse.class);
                this.GUARANTEED_ORDER_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.guaranteedOrderId = (String)Preconditions.checkNotNull((Object)guaranteedOrderId, (Object)"Required parameter guaranteedOrderId must be specified.");
                if (!DisplayVideo.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.GUARANTEED_ORDER_ID_PATTERN.matcher(guaranteedOrderId).matches(), (Object)"Parameter guaranteedOrderId must conform to the pattern ^[^/]+$");
                }
            }

            public EditGuaranteedOrderReadAccessors set$Xgafv(String $Xgafv) {
                return (EditGuaranteedOrderReadAccessors)super.set$Xgafv($Xgafv);
            }

            public EditGuaranteedOrderReadAccessors setAccessToken(String accessToken) {
                return (EditGuaranteedOrderReadAccessors)super.setAccessToken(accessToken);
            }

            public EditGuaranteedOrderReadAccessors setAlt(String alt) {
                return (EditGuaranteedOrderReadAccessors)super.setAlt(alt);
            }

            public EditGuaranteedOrderReadAccessors setCallback(String callback) {
                return (EditGuaranteedOrderReadAccessors)super.setCallback(callback);
            }

            public EditGuaranteedOrderReadAccessors setFields(String fields) {
                return (EditGuaranteedOrderReadAccessors)super.setFields(fields);
            }

            public EditGuaranteedOrderReadAccessors setKey(String key) {
                return (EditGuaranteedOrderReadAccessors)super.setKey(key);
            }

            public EditGuaranteedOrderReadAccessors setOauthToken(String oauthToken) {
                return (EditGuaranteedOrderReadAccessors)super.setOauthToken(oauthToken);
            }

            public EditGuaranteedOrderReadAccessors setPrettyPrint(Boolean prettyPrint) {
                return (EditGuaranteedOrderReadAccessors)super.setPrettyPrint(prettyPrint);
            }

            public EditGuaranteedOrderReadAccessors setQuotaUser(String quotaUser) {
                return (EditGuaranteedOrderReadAccessors)super.setQuotaUser(quotaUser);
            }

            public EditGuaranteedOrderReadAccessors setUploadType(String uploadType) {
                return (EditGuaranteedOrderReadAccessors)super.setUploadType(uploadType);
            }

            public EditGuaranteedOrderReadAccessors setUploadProtocol(String uploadProtocol) {
                return (EditGuaranteedOrderReadAccessors)super.setUploadProtocol(uploadProtocol);
            }

            public String getGuaranteedOrderId() {
                return this.guaranteedOrderId;
            }

            public EditGuaranteedOrderReadAccessors setGuaranteedOrderId(String guaranteedOrderId) {
                if (!DisplayVideo.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.GUARANTEED_ORDER_ID_PATTERN.matcher(guaranteedOrderId).matches(), (Object)"Parameter guaranteedOrderId must conform to the pattern ^[^/]+$");
                }
                this.guaranteedOrderId = guaranteedOrderId;
                return this;
            }

            @Override
            public EditGuaranteedOrderReadAccessors set(String parameterName, Object value) {
                return (EditGuaranteedOrderReadAccessors)super.set(parameterName, value);
            }
        }

        public class Create
        extends DisplayVideoRequest<GuaranteedOrder> {
            private static final String REST_PATH = "v2/guaranteedOrders";
            @Key
            private Long advertiserId;
            @Key
            private Long partnerId;

            protected Create(GuaranteedOrder content) {
                super(DisplayVideo.this, "POST", REST_PATH, (Object)content, GuaranteedOrder.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public Create setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public Create setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class GoogleAudiences {
        public Get get(Long googleAudienceId) throws IOException {
            Get result = new Get(googleAudienceId);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends DisplayVideoRequest<ListGoogleAudiencesResponse> {
            private static final String REST_PATH = "v2/googleAudiences";
            @Key
            private Long advertiserId;
            @Key
            private String filter;
            @Key
            private String orderBy;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private Long partnerId;

            protected List() {
                super(DisplayVideo.this, "GET", REST_PATH, null, ListGoogleAudiencesResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public List setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public List setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends DisplayVideoRequest<GoogleAudience> {
            private static final String REST_PATH = "v2/googleAudiences/{+googleAudienceId}";
            private final Pattern GOOGLE_AUDIENCE_ID_PATTERN;
            @Key
            private Long googleAudienceId;
            @Key
            private Long advertiserId;
            @Key
            private Long partnerId;

            protected Get(Long googleAudienceId) {
                super(DisplayVideo.this, "GET", REST_PATH, null, GoogleAudience.class);
                this.GOOGLE_AUDIENCE_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.googleAudienceId = (Long)Preconditions.checkNotNull((Object)googleAudienceId, (Object)"Required parameter googleAudienceId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getGoogleAudienceId() {
                return this.googleAudienceId;
            }

            public Get setGoogleAudienceId(Long googleAudienceId) {
                this.googleAudienceId = googleAudienceId;
                return this;
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public Get setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public Get setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class FloodlightGroups {
        public Get get(Long floodlightGroupId) throws IOException {
            Get result = new Get(floodlightGroupId);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(Long floodlightGroupId, FloodlightGroup content) throws IOException {
            Patch result = new Patch(floodlightGroupId, content);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Patch
        extends DisplayVideoRequest<FloodlightGroup> {
            private static final String REST_PATH = "v2/floodlightGroups/{floodlightGroupId}";
            @Key
            private Long floodlightGroupId;
            @Key
            private Long partnerId;
            @Key
            private String updateMask;

            protected Patch(Long floodlightGroupId, FloodlightGroup content) {
                super(DisplayVideo.this, "PATCH", REST_PATH, (Object)content, FloodlightGroup.class);
                this.floodlightGroupId = (Long)Preconditions.checkNotNull((Object)floodlightGroupId, (Object)"Required parameter floodlightGroupId must be specified.");
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public Long getFloodlightGroupId() {
                return this.floodlightGroupId;
            }

            public Patch setFloodlightGroupId(Long floodlightGroupId) {
                this.floodlightGroupId = floodlightGroupId;
                return this;
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public Patch setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public Patch setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class Get
        extends DisplayVideoRequest<FloodlightGroup> {
            private static final String REST_PATH = "v2/floodlightGroups/{+floodlightGroupId}";
            private final Pattern FLOODLIGHT_GROUP_ID_PATTERN;
            @Key
            private Long floodlightGroupId;
            @Key
            private Long partnerId;

            protected Get(Long floodlightGroupId) {
                super(DisplayVideo.this, "GET", REST_PATH, null, FloodlightGroup.class);
                this.FLOODLIGHT_GROUP_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.floodlightGroupId = (Long)Preconditions.checkNotNull((Object)floodlightGroupId, (Object)"Required parameter floodlightGroupId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getFloodlightGroupId() {
                return this.floodlightGroupId;
            }

            public Get setFloodlightGroupId(Long floodlightGroupId) {
                this.floodlightGroupId = floodlightGroupId;
                return this;
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public Get setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class FirstAndThirdPartyAudiences {
        public Create create(FirstAndThirdPartyAudience content) throws IOException {
            Create result = new Create(content);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public EditCustomerMatchMembers editCustomerMatchMembers(Long firstAndThirdPartyAudienceId, EditCustomerMatchMembersRequest content) throws IOException {
            EditCustomerMatchMembers result = new EditCustomerMatchMembers(firstAndThirdPartyAudienceId, content);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(Long firstAndThirdPartyAudienceId) throws IOException {
            Get result = new Get(firstAndThirdPartyAudienceId);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(Long firstAndThirdPartyAudienceId, FirstAndThirdPartyAudience content) throws IOException {
            Patch result = new Patch(firstAndThirdPartyAudienceId, content);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Patch
        extends DisplayVideoRequest<FirstAndThirdPartyAudience> {
            private static final String REST_PATH = "v2/firstAndThirdPartyAudiences/{+firstAndThirdPartyAudienceId}";
            private final Pattern FIRST_AND_THIRD_PARTY_AUDIENCE_ID_PATTERN;
            @Key
            private Long firstAndThirdPartyAudienceId;
            @Key
            private Long advertiserId;
            @Key
            private String updateMask;

            protected Patch(Long firstAndThirdPartyAudienceId, FirstAndThirdPartyAudience content) {
                super(DisplayVideo.this, "PATCH", REST_PATH, (Object)content, FirstAndThirdPartyAudience.class);
                this.FIRST_AND_THIRD_PARTY_AUDIENCE_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.firstAndThirdPartyAudienceId = (Long)Preconditions.checkNotNull((Object)firstAndThirdPartyAudienceId, (Object)"Required parameter firstAndThirdPartyAudienceId must be specified.");
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public Long getFirstAndThirdPartyAudienceId() {
                return this.firstAndThirdPartyAudienceId;
            }

            public Patch setFirstAndThirdPartyAudienceId(Long firstAndThirdPartyAudienceId) {
                this.firstAndThirdPartyAudienceId = firstAndThirdPartyAudienceId;
                return this;
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public Patch setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public Patch setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends DisplayVideoRequest<ListFirstAndThirdPartyAudiencesResponse> {
            private static final String REST_PATH = "v2/firstAndThirdPartyAudiences";
            @Key
            private Long advertiserId;
            @Key
            private String filter;
            @Key
            private String orderBy;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private Long partnerId;

            protected List() {
                super(DisplayVideo.this, "GET", REST_PATH, null, ListFirstAndThirdPartyAudiencesResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public List setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public List setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends DisplayVideoRequest<FirstAndThirdPartyAudience> {
            private static final String REST_PATH = "v2/firstAndThirdPartyAudiences/{+firstAndThirdPartyAudienceId}";
            private final Pattern FIRST_AND_THIRD_PARTY_AUDIENCE_ID_PATTERN;
            @Key
            private Long firstAndThirdPartyAudienceId;
            @Key
            private Long advertiserId;
            @Key
            private Long partnerId;

            protected Get(Long firstAndThirdPartyAudienceId) {
                super(DisplayVideo.this, "GET", REST_PATH, null, FirstAndThirdPartyAudience.class);
                this.FIRST_AND_THIRD_PARTY_AUDIENCE_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.firstAndThirdPartyAudienceId = (Long)Preconditions.checkNotNull((Object)firstAndThirdPartyAudienceId, (Object)"Required parameter firstAndThirdPartyAudienceId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getFirstAndThirdPartyAudienceId() {
                return this.firstAndThirdPartyAudienceId;
            }

            public Get setFirstAndThirdPartyAudienceId(Long firstAndThirdPartyAudienceId) {
                this.firstAndThirdPartyAudienceId = firstAndThirdPartyAudienceId;
                return this;
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public Get setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public Get setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class EditCustomerMatchMembers
        extends DisplayVideoRequest<EditCustomerMatchMembersResponse> {
            private static final String REST_PATH = "v2/firstAndThirdPartyAudiences/{+firstAndThirdPartyAudienceId}:editCustomerMatchMembers";
            private final Pattern FIRST_AND_THIRD_PARTY_AUDIENCE_ID_PATTERN;
            @Key
            private Long firstAndThirdPartyAudienceId;

            protected EditCustomerMatchMembers(Long firstAndThirdPartyAudienceId, EditCustomerMatchMembersRequest content) {
                super(DisplayVideo.this, "POST", REST_PATH, (Object)content, EditCustomerMatchMembersResponse.class);
                this.FIRST_AND_THIRD_PARTY_AUDIENCE_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.firstAndThirdPartyAudienceId = (Long)Preconditions.checkNotNull((Object)firstAndThirdPartyAudienceId, (Object)"Required parameter firstAndThirdPartyAudienceId must be specified.");
            }

            public EditCustomerMatchMembers set$Xgafv(String $Xgafv) {
                return (EditCustomerMatchMembers)super.set$Xgafv($Xgafv);
            }

            public EditCustomerMatchMembers setAccessToken(String accessToken) {
                return (EditCustomerMatchMembers)super.setAccessToken(accessToken);
            }

            public EditCustomerMatchMembers setAlt(String alt) {
                return (EditCustomerMatchMembers)super.setAlt(alt);
            }

            public EditCustomerMatchMembers setCallback(String callback) {
                return (EditCustomerMatchMembers)super.setCallback(callback);
            }

            public EditCustomerMatchMembers setFields(String fields) {
                return (EditCustomerMatchMembers)super.setFields(fields);
            }

            public EditCustomerMatchMembers setKey(String key) {
                return (EditCustomerMatchMembers)super.setKey(key);
            }

            public EditCustomerMatchMembers setOauthToken(String oauthToken) {
                return (EditCustomerMatchMembers)super.setOauthToken(oauthToken);
            }

            public EditCustomerMatchMembers setPrettyPrint(Boolean prettyPrint) {
                return (EditCustomerMatchMembers)super.setPrettyPrint(prettyPrint);
            }

            public EditCustomerMatchMembers setQuotaUser(String quotaUser) {
                return (EditCustomerMatchMembers)super.setQuotaUser(quotaUser);
            }

            public EditCustomerMatchMembers setUploadType(String uploadType) {
                return (EditCustomerMatchMembers)super.setUploadType(uploadType);
            }

            public EditCustomerMatchMembers setUploadProtocol(String uploadProtocol) {
                return (EditCustomerMatchMembers)super.setUploadProtocol(uploadProtocol);
            }

            public Long getFirstAndThirdPartyAudienceId() {
                return this.firstAndThirdPartyAudienceId;
            }

            public EditCustomerMatchMembers setFirstAndThirdPartyAudienceId(Long firstAndThirdPartyAudienceId) {
                this.firstAndThirdPartyAudienceId = firstAndThirdPartyAudienceId;
                return this;
            }

            @Override
            public EditCustomerMatchMembers set(String parameterName, Object value) {
                return (EditCustomerMatchMembers)super.set(parameterName, value);
            }
        }

        public class Create
        extends DisplayVideoRequest<FirstAndThirdPartyAudience> {
            private static final String REST_PATH = "v2/firstAndThirdPartyAudiences";
            @Key
            private Long advertiserId;

            protected Create(FirstAndThirdPartyAudience content) {
                super(DisplayVideo.this, "POST", REST_PATH, (Object)content, FirstAndThirdPartyAudience.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public Create setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class CustomLists {
        public Get get(Long customListId) throws IOException {
            Get result = new Get(customListId);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends DisplayVideoRequest<ListCustomListsResponse> {
            private static final String REST_PATH = "v2/customLists";
            @Key
            private Long advertiserId;
            @Key
            private String filter;
            @Key
            private String orderBy;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List() {
                super(DisplayVideo.this, "GET", REST_PATH, null, ListCustomListsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public List setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends DisplayVideoRequest<CustomList> {
            private static final String REST_PATH = "v2/customLists/{+customListId}";
            private final Pattern CUSTOM_LIST_ID_PATTERN;
            @Key
            private Long customListId;
            @Key
            private Long advertiserId;

            protected Get(Long customListId) {
                super(DisplayVideo.this, "GET", REST_PATH, null, CustomList.class);
                this.CUSTOM_LIST_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.customListId = (Long)Preconditions.checkNotNull((Object)customListId, (Object)"Required parameter customListId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getCustomListId() {
                return this.customListId;
            }

            public Get setCustomListId(Long customListId) {
                this.customListId = customListId;
                return this;
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public Get setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class CustomBiddingAlgorithms {
        public Create create(CustomBiddingAlgorithm content) throws IOException {
            Create result = new Create(content);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(Long customBiddingAlgorithmId) throws IOException {
            Get result = new Get(customBiddingAlgorithmId);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(Long customBiddingAlgorithmId, CustomBiddingAlgorithm content) throws IOException {
            Patch result = new Patch(customBiddingAlgorithmId, content);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public UploadScript uploadScript(Long customBiddingAlgorithmId) throws IOException {
            UploadScript result = new UploadScript(customBiddingAlgorithmId);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Scripts scripts() {
            return new Scripts();
        }

        public class Scripts {
            public Create create(Long customBiddingAlgorithmId, CustomBiddingScript content) throws IOException {
                Create result = new Create(customBiddingAlgorithmId, content);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(Long customBiddingAlgorithmId, Long customBiddingScriptId) throws IOException {
                Get result = new Get(customBiddingAlgorithmId, customBiddingScriptId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(Long customBiddingAlgorithmId) throws IOException {
                List result = new List(customBiddingAlgorithmId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends DisplayVideoRequest<ListCustomBiddingScriptsResponse> {
                private static final String REST_PATH = "v2/customBiddingAlgorithms/{+customBiddingAlgorithmId}/scripts";
                private final Pattern CUSTOM_BIDDING_ALGORITHM_ID_PATTERN;
                @Key
                private Long customBiddingAlgorithmId;
                @Key
                private Long advertiserId;
                @Key
                private String orderBy;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;
                @Key
                private Long partnerId;

                protected List(Long customBiddingAlgorithmId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, ListCustomBiddingScriptsResponse.class);
                    this.CUSTOM_BIDDING_ALGORITHM_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.customBiddingAlgorithmId = (Long)Preconditions.checkNotNull((Object)customBiddingAlgorithmId, (Object)"Required parameter customBiddingAlgorithmId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public Long getCustomBiddingAlgorithmId() {
                    return this.customBiddingAlgorithmId;
                }

                public List setCustomBiddingAlgorithmId(Long customBiddingAlgorithmId) {
                    this.customBiddingAlgorithmId = customBiddingAlgorithmId;
                    return this;
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public List setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public List setOrderBy(String orderBy) {
                    this.orderBy = orderBy;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public Long getPartnerId() {
                    return this.partnerId;
                }

                public List setPartnerId(Long partnerId) {
                    this.partnerId = partnerId;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends DisplayVideoRequest<CustomBiddingScript> {
                private static final String REST_PATH = "v2/customBiddingAlgorithms/{+customBiddingAlgorithmId}/scripts/{+customBiddingScriptId}";
                private final Pattern CUSTOM_BIDDING_ALGORITHM_ID_PATTERN;
                private final Pattern CUSTOM_BIDDING_SCRIPT_ID_PATTERN;
                @Key
                private Long customBiddingAlgorithmId;
                @Key
                private Long customBiddingScriptId;
                @Key
                private Long advertiserId;
                @Key
                private Long partnerId;

                protected Get(Long customBiddingAlgorithmId, Long customBiddingScriptId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, CustomBiddingScript.class);
                    this.CUSTOM_BIDDING_ALGORITHM_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.CUSTOM_BIDDING_SCRIPT_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.customBiddingAlgorithmId = (Long)Preconditions.checkNotNull((Object)customBiddingAlgorithmId, (Object)"Required parameter customBiddingAlgorithmId must be specified.");
                    this.customBiddingScriptId = (Long)Preconditions.checkNotNull((Object)customBiddingScriptId, (Object)"Required parameter customBiddingScriptId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public Long getCustomBiddingAlgorithmId() {
                    return this.customBiddingAlgorithmId;
                }

                public Get setCustomBiddingAlgorithmId(Long customBiddingAlgorithmId) {
                    this.customBiddingAlgorithmId = customBiddingAlgorithmId;
                    return this;
                }

                public Long getCustomBiddingScriptId() {
                    return this.customBiddingScriptId;
                }

                public Get setCustomBiddingScriptId(Long customBiddingScriptId) {
                    this.customBiddingScriptId = customBiddingScriptId;
                    return this;
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Get setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getPartnerId() {
                    return this.partnerId;
                }

                public Get setPartnerId(Long partnerId) {
                    this.partnerId = partnerId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Create
            extends DisplayVideoRequest<CustomBiddingScript> {
                private static final String REST_PATH = "v2/customBiddingAlgorithms/{+customBiddingAlgorithmId}/scripts";
                private final Pattern CUSTOM_BIDDING_ALGORITHM_ID_PATTERN;
                @Key
                private Long customBiddingAlgorithmId;
                @Key
                private Long advertiserId;
                @Key
                private Long partnerId;

                protected Create(Long customBiddingAlgorithmId, CustomBiddingScript content) {
                    super(DisplayVideo.this, "POST", REST_PATH, (Object)content, CustomBiddingScript.class);
                    this.CUSTOM_BIDDING_ALGORITHM_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.customBiddingAlgorithmId = (Long)Preconditions.checkNotNull((Object)customBiddingAlgorithmId, (Object)"Required parameter customBiddingAlgorithmId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public Long getCustomBiddingAlgorithmId() {
                    return this.customBiddingAlgorithmId;
                }

                public Create setCustomBiddingAlgorithmId(Long customBiddingAlgorithmId) {
                    this.customBiddingAlgorithmId = customBiddingAlgorithmId;
                    return this;
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Create setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getPartnerId() {
                    return this.partnerId;
                }

                public Create setPartnerId(Long partnerId) {
                    this.partnerId = partnerId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class UploadScript
        extends DisplayVideoRequest<CustomBiddingScriptRef> {
            private static final String REST_PATH = "v2/customBiddingAlgorithms/{+customBiddingAlgorithmId}:uploadScript";
            private final Pattern CUSTOM_BIDDING_ALGORITHM_ID_PATTERN;
            @Key
            private Long customBiddingAlgorithmId;
            @Key
            private Long advertiserId;
            @Key
            private Long partnerId;

            protected UploadScript(Long customBiddingAlgorithmId) {
                super(DisplayVideo.this, "GET", REST_PATH, null, CustomBiddingScriptRef.class);
                this.CUSTOM_BIDDING_ALGORITHM_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.customBiddingAlgorithmId = (Long)Preconditions.checkNotNull((Object)customBiddingAlgorithmId, (Object)"Required parameter customBiddingAlgorithmId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public UploadScript set$Xgafv(String $Xgafv) {
                return (UploadScript)super.set$Xgafv($Xgafv);
            }

            public UploadScript setAccessToken(String accessToken) {
                return (UploadScript)super.setAccessToken(accessToken);
            }

            public UploadScript setAlt(String alt) {
                return (UploadScript)super.setAlt(alt);
            }

            public UploadScript setCallback(String callback) {
                return (UploadScript)super.setCallback(callback);
            }

            public UploadScript setFields(String fields) {
                return (UploadScript)super.setFields(fields);
            }

            public UploadScript setKey(String key) {
                return (UploadScript)super.setKey(key);
            }

            public UploadScript setOauthToken(String oauthToken) {
                return (UploadScript)super.setOauthToken(oauthToken);
            }

            public UploadScript setPrettyPrint(Boolean prettyPrint) {
                return (UploadScript)super.setPrettyPrint(prettyPrint);
            }

            public UploadScript setQuotaUser(String quotaUser) {
                return (UploadScript)super.setQuotaUser(quotaUser);
            }

            public UploadScript setUploadType(String uploadType) {
                return (UploadScript)super.setUploadType(uploadType);
            }

            public UploadScript setUploadProtocol(String uploadProtocol) {
                return (UploadScript)super.setUploadProtocol(uploadProtocol);
            }

            public Long getCustomBiddingAlgorithmId() {
                return this.customBiddingAlgorithmId;
            }

            public UploadScript setCustomBiddingAlgorithmId(Long customBiddingAlgorithmId) {
                this.customBiddingAlgorithmId = customBiddingAlgorithmId;
                return this;
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public UploadScript setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public UploadScript setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            @Override
            public UploadScript set(String parameterName, Object value) {
                return (UploadScript)super.set(parameterName, value);
            }
        }

        public class Patch
        extends DisplayVideoRequest<CustomBiddingAlgorithm> {
            private static final String REST_PATH = "v2/customBiddingAlgorithms/{+customBiddingAlgorithmId}";
            private final Pattern CUSTOM_BIDDING_ALGORITHM_ID_PATTERN;
            @Key
            private Long customBiddingAlgorithmId;
            @Key
            private String updateMask;

            protected Patch(Long customBiddingAlgorithmId, CustomBiddingAlgorithm content) {
                super(DisplayVideo.this, "PATCH", REST_PATH, (Object)content, CustomBiddingAlgorithm.class);
                this.CUSTOM_BIDDING_ALGORITHM_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.customBiddingAlgorithmId = (Long)Preconditions.checkNotNull((Object)customBiddingAlgorithmId, (Object)"Required parameter customBiddingAlgorithmId must be specified.");
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public Long getCustomBiddingAlgorithmId() {
                return this.customBiddingAlgorithmId;
            }

            public Patch setCustomBiddingAlgorithmId(Long customBiddingAlgorithmId) {
                this.customBiddingAlgorithmId = customBiddingAlgorithmId;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public Patch setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends DisplayVideoRequest<ListCustomBiddingAlgorithmsResponse> {
            private static final String REST_PATH = "v2/customBiddingAlgorithms";
            @Key
            private Long advertiserId;
            @Key
            private String filter;
            @Key
            private String orderBy;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private Long partnerId;

            protected List() {
                super(DisplayVideo.this, "GET", REST_PATH, null, ListCustomBiddingAlgorithmsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public List setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public List setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends DisplayVideoRequest<CustomBiddingAlgorithm> {
            private static final String REST_PATH = "v2/customBiddingAlgorithms/{+customBiddingAlgorithmId}";
            private final Pattern CUSTOM_BIDDING_ALGORITHM_ID_PATTERN;
            @Key
            private Long customBiddingAlgorithmId;
            @Key
            private Long advertiserId;
            @Key
            private Long partnerId;

            protected Get(Long customBiddingAlgorithmId) {
                super(DisplayVideo.this, "GET", REST_PATH, null, CustomBiddingAlgorithm.class);
                this.CUSTOM_BIDDING_ALGORITHM_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.customBiddingAlgorithmId = (Long)Preconditions.checkNotNull((Object)customBiddingAlgorithmId, (Object)"Required parameter customBiddingAlgorithmId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getCustomBiddingAlgorithmId() {
                return this.customBiddingAlgorithmId;
            }

            public Get setCustomBiddingAlgorithmId(Long customBiddingAlgorithmId) {
                this.customBiddingAlgorithmId = customBiddingAlgorithmId;
                return this;
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public Get setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public Get setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Create
        extends DisplayVideoRequest<CustomBiddingAlgorithm> {
            private static final String REST_PATH = "v2/customBiddingAlgorithms";

            protected Create(CustomBiddingAlgorithm content) {
                super(DisplayVideo.this, "POST", REST_PATH, (Object)content, CustomBiddingAlgorithm.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class CombinedAudiences {
        public Get get(Long combinedAudienceId) throws IOException {
            Get result = new Get(combinedAudienceId);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends DisplayVideoRequest<ListCombinedAudiencesResponse> {
            private static final String REST_PATH = "v2/combinedAudiences";
            @Key
            private Long advertiserId;
            @Key
            private String filter;
            @Key
            private String orderBy;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private Long partnerId;

            protected List() {
                super(DisplayVideo.this, "GET", REST_PATH, null, ListCombinedAudiencesResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public List setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public List setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends DisplayVideoRequest<CombinedAudience> {
            private static final String REST_PATH = "v2/combinedAudiences/{+combinedAudienceId}";
            private final Pattern COMBINED_AUDIENCE_ID_PATTERN;
            @Key
            private Long combinedAudienceId;
            @Key
            private Long advertiserId;
            @Key
            private Long partnerId;

            protected Get(Long combinedAudienceId) {
                super(DisplayVideo.this, "GET", REST_PATH, null, CombinedAudience.class);
                this.COMBINED_AUDIENCE_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.combinedAudienceId = (Long)Preconditions.checkNotNull((Object)combinedAudienceId, (Object)"Required parameter combinedAudienceId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getCombinedAudienceId() {
                return this.combinedAudienceId;
            }

            public Get setCombinedAudienceId(Long combinedAudienceId) {
                this.combinedAudienceId = combinedAudienceId;
                return this;
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public Get setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public Get setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Advertisers {
        public Audit audit(Long advertiserId) throws IOException {
            Audit result = new Audit(advertiserId);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Create create(Advertiser content) throws IOException {
            Create result = new Create(content);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(Long advertiserId) throws IOException {
            Delete result = new Delete(advertiserId);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public EditAssignedTargetingOptions editAssignedTargetingOptions(Long advertiserId, BulkEditAdvertiserAssignedTargetingOptionsRequest content) throws IOException {
            EditAssignedTargetingOptions result = new EditAssignedTargetingOptions(advertiserId, content);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(Long advertiserId) throws IOException {
            Get result = new Get(advertiserId);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public ListAssignedTargetingOptions listAssignedTargetingOptions(Long advertiserId) throws IOException {
            ListAssignedTargetingOptions result = new ListAssignedTargetingOptions(advertiserId);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(Long advertiserId, Advertiser content) throws IOException {
            Patch result = new Patch(advertiserId, content);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Assets assets() {
            return new Assets();
        }

        public Campaigns campaigns() {
            return new Campaigns();
        }

        public Channels channels() {
            return new Channels();
        }

        public Creatives creatives() {
            return new Creatives();
        }

        public InsertionOrders insertionOrders() {
            return new InsertionOrders();
        }

        public Invoices invoices() {
            return new Invoices();
        }

        public LineItems lineItems() {
            return new LineItems();
        }

        public LocationLists locationLists() {
            return new LocationLists();
        }

        public ManualTriggers manualTriggers() {
            return new ManualTriggers();
        }

        public NegativeKeywordLists negativeKeywordLists() {
            return new NegativeKeywordLists();
        }

        public TargetingTypes targetingTypes() {
            return new TargetingTypes();
        }

        public class TargetingTypes {
            public AssignedTargetingOptions assignedTargetingOptions() {
                return new AssignedTargetingOptions();
            }

            public class AssignedTargetingOptions {
                public Create create(Long advertiserId, String targetingType, AssignedTargetingOption content) throws IOException {
                    Create result = new Create(advertiserId, targetingType, content);
                    DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(Long advertiserId, String targetingType, String assignedTargetingOptionId) throws IOException {
                    Delete result = new Delete(advertiserId, targetingType, assignedTargetingOptionId);
                    DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(Long advertiserId, String targetingType, String assignedTargetingOptionId) throws IOException {
                    Get result = new Get(advertiserId, targetingType, assignedTargetingOptionId);
                    DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(Long advertiserId, String targetingType) throws IOException {
                    List result = new List(advertiserId, targetingType);
                    DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends DisplayVideoRequest<ListAdvertiserAssignedTargetingOptionsResponse> {
                    private static final String REST_PATH = "v2/advertisers/{+advertiserId}/targetingTypes/{+targetingType}/assignedTargetingOptions";
                    private final Pattern ADVERTISER_ID_PATTERN;
                    private final Pattern TARGETING_TYPE_PATTERN;
                    @Key
                    private Long advertiserId;
                    @Key
                    private String targetingType;
                    @Key
                    private String filter;
                    @Key
                    private String orderBy;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(Long advertiserId, String targetingType) {
                        super(DisplayVideo.this, "GET", REST_PATH, null, ListAdvertiserAssignedTargetingOptionsResponse.class);
                        this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.TARGETING_TYPE_PATTERN = Pattern.compile("^[^/]+$");
                        this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                        this.targetingType = (String)Preconditions.checkNotNull((Object)targetingType, (Object)"Required parameter targetingType must be specified.");
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public Long getAdvertiserId() {
                        return this.advertiserId;
                    }

                    public List setAdvertiserId(Long advertiserId) {
                        this.advertiserId = advertiserId;
                        return this;
                    }

                    public String getTargetingType() {
                        return this.targetingType;
                    }

                    public List setTargetingType(String targetingType) {
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                        }
                        this.targetingType = targetingType;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public String getOrderBy() {
                        return this.orderBy;
                    }

                    public List setOrderBy(String orderBy) {
                        this.orderBy = orderBy;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends DisplayVideoRequest<AssignedTargetingOption> {
                    private static final String REST_PATH = "v2/advertisers/{+advertiserId}/targetingTypes/{+targetingType}/assignedTargetingOptions/{+assignedTargetingOptionId}";
                    private final Pattern ADVERTISER_ID_PATTERN;
                    private final Pattern TARGETING_TYPE_PATTERN;
                    private final Pattern ASSIGNED_TARGETING_OPTION_ID_PATTERN;
                    @Key
                    private Long advertiserId;
                    @Key
                    private String targetingType;
                    @Key
                    private String assignedTargetingOptionId;

                    protected Get(Long advertiserId, String targetingType, String assignedTargetingOptionId) {
                        super(DisplayVideo.this, "GET", REST_PATH, null, AssignedTargetingOption.class);
                        this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.TARGETING_TYPE_PATTERN = Pattern.compile("^[^/]+$");
                        this.ASSIGNED_TARGETING_OPTION_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                        this.targetingType = (String)Preconditions.checkNotNull((Object)targetingType, (Object)"Required parameter targetingType must be specified.");
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                        }
                        this.assignedTargetingOptionId = (String)Preconditions.checkNotNull((Object)assignedTargetingOptionId, (Object)"Required parameter assignedTargetingOptionId must be specified.");
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.ASSIGNED_TARGETING_OPTION_ID_PATTERN.matcher(assignedTargetingOptionId).matches(), (Object)"Parameter assignedTargetingOptionId must conform to the pattern ^[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public Long getAdvertiserId() {
                        return this.advertiserId;
                    }

                    public Get setAdvertiserId(Long advertiserId) {
                        this.advertiserId = advertiserId;
                        return this;
                    }

                    public String getTargetingType() {
                        return this.targetingType;
                    }

                    public Get setTargetingType(String targetingType) {
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                        }
                        this.targetingType = targetingType;
                        return this;
                    }

                    public String getAssignedTargetingOptionId() {
                        return this.assignedTargetingOptionId;
                    }

                    public Get setAssignedTargetingOptionId(String assignedTargetingOptionId) {
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.ASSIGNED_TARGETING_OPTION_ID_PATTERN.matcher(assignedTargetingOptionId).matches(), (Object)"Parameter assignedTargetingOptionId must conform to the pattern ^[^/]+$");
                        }
                        this.assignedTargetingOptionId = assignedTargetingOptionId;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends DisplayVideoRequest<Empty> {
                    private static final String REST_PATH = "v2/advertisers/{+advertiserId}/targetingTypes/{+targetingType}/assignedTargetingOptions/{+assignedTargetingOptionId}";
                    private final Pattern ADVERTISER_ID_PATTERN;
                    private final Pattern TARGETING_TYPE_PATTERN;
                    private final Pattern ASSIGNED_TARGETING_OPTION_ID_PATTERN;
                    @Key
                    private Long advertiserId;
                    @Key
                    private String targetingType;
                    @Key
                    private String assignedTargetingOptionId;

                    protected Delete(Long advertiserId, String targetingType, String assignedTargetingOptionId) {
                        super(DisplayVideo.this, "DELETE", REST_PATH, null, Empty.class);
                        this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.TARGETING_TYPE_PATTERN = Pattern.compile("^[^/]+$");
                        this.ASSIGNED_TARGETING_OPTION_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                        this.targetingType = (String)Preconditions.checkNotNull((Object)targetingType, (Object)"Required parameter targetingType must be specified.");
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                        }
                        this.assignedTargetingOptionId = (String)Preconditions.checkNotNull((Object)assignedTargetingOptionId, (Object)"Required parameter assignedTargetingOptionId must be specified.");
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.ASSIGNED_TARGETING_OPTION_ID_PATTERN.matcher(assignedTargetingOptionId).matches(), (Object)"Parameter assignedTargetingOptionId must conform to the pattern ^[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public Long getAdvertiserId() {
                        return this.advertiserId;
                    }

                    public Delete setAdvertiserId(Long advertiserId) {
                        this.advertiserId = advertiserId;
                        return this;
                    }

                    public String getTargetingType() {
                        return this.targetingType;
                    }

                    public Delete setTargetingType(String targetingType) {
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                        }
                        this.targetingType = targetingType;
                        return this;
                    }

                    public String getAssignedTargetingOptionId() {
                        return this.assignedTargetingOptionId;
                    }

                    public Delete setAssignedTargetingOptionId(String assignedTargetingOptionId) {
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.ASSIGNED_TARGETING_OPTION_ID_PATTERN.matcher(assignedTargetingOptionId).matches(), (Object)"Parameter assignedTargetingOptionId must conform to the pattern ^[^/]+$");
                        }
                        this.assignedTargetingOptionId = assignedTargetingOptionId;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends DisplayVideoRequest<AssignedTargetingOption> {
                    private static final String REST_PATH = "v2/advertisers/{+advertiserId}/targetingTypes/{+targetingType}/assignedTargetingOptions";
                    private final Pattern ADVERTISER_ID_PATTERN;
                    private final Pattern TARGETING_TYPE_PATTERN;
                    @Key
                    private Long advertiserId;
                    @Key
                    private String targetingType;

                    protected Create(Long advertiserId, String targetingType, AssignedTargetingOption content) {
                        super(DisplayVideo.this, "POST", REST_PATH, (Object)content, AssignedTargetingOption.class);
                        this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.TARGETING_TYPE_PATTERN = Pattern.compile("^[^/]+$");
                        this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                        this.targetingType = (String)Preconditions.checkNotNull((Object)targetingType, (Object)"Required parameter targetingType must be specified.");
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public Long getAdvertiserId() {
                        return this.advertiserId;
                    }

                    public Create setAdvertiserId(Long advertiserId) {
                        this.advertiserId = advertiserId;
                        return this;
                    }

                    public String getTargetingType() {
                        return this.targetingType;
                    }

                    public Create setTargetingType(String targetingType) {
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                        }
                        this.targetingType = targetingType;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }
        }

        public class NegativeKeywordLists {
            public Create create(Long advertiserId, NegativeKeywordList content) throws IOException {
                Create result = new Create(advertiserId, content);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(Long advertiserId, Long negativeKeywordListId) throws IOException {
                Delete result = new Delete(advertiserId, negativeKeywordListId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(Long advertiserId, Long negativeKeywordListId) throws IOException {
                Get result = new Get(advertiserId, negativeKeywordListId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(Long advertiserId) throws IOException {
                List result = new List(advertiserId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(Long advertiserId, Long negativeKeywordListId, NegativeKeywordList content) throws IOException {
                Patch result = new Patch(advertiserId, negativeKeywordListId, content);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public NegativeKeywords negativeKeywords() {
                return new NegativeKeywords();
            }

            public class NegativeKeywords {
                public BulkEdit bulkEdit(Long advertiserId, Long negativeKeywordListId, BulkEditNegativeKeywordsRequest content) throws IOException {
                    BulkEdit result = new BulkEdit(advertiserId, negativeKeywordListId, content);
                    DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Create create(Long advertiserId, Long negativeKeywordListId, NegativeKeyword content) throws IOException {
                    Create result = new Create(advertiserId, negativeKeywordListId, content);
                    DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(Long advertiserId, Long negativeKeywordListId, String keywordValue) throws IOException {
                    Delete result = new Delete(advertiserId, negativeKeywordListId, keywordValue);
                    DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(Long advertiserId, Long negativeKeywordListId) throws IOException {
                    List result = new List(advertiserId, negativeKeywordListId);
                    DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Replace replace(Long advertiserId, Long negativeKeywordListId, ReplaceNegativeKeywordsRequest content) throws IOException {
                    Replace result = new Replace(advertiserId, negativeKeywordListId, content);
                    DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class Replace
                extends DisplayVideoRequest<ReplaceNegativeKeywordsResponse> {
                    private static final String REST_PATH = "v2/advertisers/{advertiserId}/negativeKeywordLists/{+negativeKeywordListId}/negativeKeywords:replace";
                    private final Pattern NEGATIVE_KEYWORD_LIST_ID_PATTERN;
                    @Key
                    private Long advertiserId;
                    @Key
                    private Long negativeKeywordListId;

                    protected Replace(Long advertiserId, Long negativeKeywordListId, ReplaceNegativeKeywordsRequest content) {
                        super(DisplayVideo.this, "POST", REST_PATH, (Object)content, ReplaceNegativeKeywordsResponse.class);
                        this.NEGATIVE_KEYWORD_LIST_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                        this.negativeKeywordListId = (Long)Preconditions.checkNotNull((Object)negativeKeywordListId, (Object)"Required parameter negativeKeywordListId must be specified.");
                    }

                    public Replace set$Xgafv(String $Xgafv) {
                        return (Replace)super.set$Xgafv($Xgafv);
                    }

                    public Replace setAccessToken(String accessToken) {
                        return (Replace)super.setAccessToken(accessToken);
                    }

                    public Replace setAlt(String alt) {
                        return (Replace)super.setAlt(alt);
                    }

                    public Replace setCallback(String callback) {
                        return (Replace)super.setCallback(callback);
                    }

                    public Replace setFields(String fields) {
                        return (Replace)super.setFields(fields);
                    }

                    public Replace setKey(String key) {
                        return (Replace)super.setKey(key);
                    }

                    public Replace setOauthToken(String oauthToken) {
                        return (Replace)super.setOauthToken(oauthToken);
                    }

                    public Replace setPrettyPrint(Boolean prettyPrint) {
                        return (Replace)super.setPrettyPrint(prettyPrint);
                    }

                    public Replace setQuotaUser(String quotaUser) {
                        return (Replace)super.setQuotaUser(quotaUser);
                    }

                    public Replace setUploadType(String uploadType) {
                        return (Replace)super.setUploadType(uploadType);
                    }

                    public Replace setUploadProtocol(String uploadProtocol) {
                        return (Replace)super.setUploadProtocol(uploadProtocol);
                    }

                    public Long getAdvertiserId() {
                        return this.advertiserId;
                    }

                    public Replace setAdvertiserId(Long advertiserId) {
                        this.advertiserId = advertiserId;
                        return this;
                    }

                    public Long getNegativeKeywordListId() {
                        return this.negativeKeywordListId;
                    }

                    public Replace setNegativeKeywordListId(Long negativeKeywordListId) {
                        this.negativeKeywordListId = negativeKeywordListId;
                        return this;
                    }

                    @Override
                    public Replace set(String parameterName, Object value) {
                        return (Replace)super.set(parameterName, value);
                    }
                }

                public class List
                extends DisplayVideoRequest<ListNegativeKeywordsResponse> {
                    private static final String REST_PATH = "v2/advertisers/{+advertiserId}/negativeKeywordLists/{+negativeKeywordListId}/negativeKeywords";
                    private final Pattern ADVERTISER_ID_PATTERN;
                    private final Pattern NEGATIVE_KEYWORD_LIST_ID_PATTERN;
                    @Key
                    private Long advertiserId;
                    @Key
                    private Long negativeKeywordListId;
                    @Key
                    private String filter;
                    @Key
                    private String orderBy;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(Long advertiserId, Long negativeKeywordListId) {
                        super(DisplayVideo.this, "GET", REST_PATH, null, ListNegativeKeywordsResponse.class);
                        this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.NEGATIVE_KEYWORD_LIST_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                        this.negativeKeywordListId = (Long)Preconditions.checkNotNull((Object)negativeKeywordListId, (Object)"Required parameter negativeKeywordListId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public Long getAdvertiserId() {
                        return this.advertiserId;
                    }

                    public List setAdvertiserId(Long advertiserId) {
                        this.advertiserId = advertiserId;
                        return this;
                    }

                    public Long getNegativeKeywordListId() {
                        return this.negativeKeywordListId;
                    }

                    public List setNegativeKeywordListId(Long negativeKeywordListId) {
                        this.negativeKeywordListId = negativeKeywordListId;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public String getOrderBy() {
                        return this.orderBy;
                    }

                    public List setOrderBy(String orderBy) {
                        this.orderBy = orderBy;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends DisplayVideoRequest<Empty> {
                    private static final String REST_PATH = "v2/advertisers/{advertiserId}/negativeKeywordLists/{+negativeKeywordListId}/negativeKeywords/{+keywordValue}";
                    private final Pattern NEGATIVE_KEYWORD_LIST_ID_PATTERN;
                    private final Pattern KEYWORD_VALUE_PATTERN;
                    @Key
                    private Long advertiserId;
                    @Key
                    private Long negativeKeywordListId;
                    @Key
                    private String keywordValue;

                    protected Delete(Long advertiserId, Long negativeKeywordListId, String keywordValue) {
                        super(DisplayVideo.this, "DELETE", REST_PATH, null, Empty.class);
                        this.NEGATIVE_KEYWORD_LIST_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.KEYWORD_VALUE_PATTERN = Pattern.compile("^[^/]+$");
                        this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                        this.negativeKeywordListId = (Long)Preconditions.checkNotNull((Object)negativeKeywordListId, (Object)"Required parameter negativeKeywordListId must be specified.");
                        this.keywordValue = (String)Preconditions.checkNotNull((Object)keywordValue, (Object)"Required parameter keywordValue must be specified.");
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.KEYWORD_VALUE_PATTERN.matcher(keywordValue).matches(), (Object)"Parameter keywordValue must conform to the pattern ^[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public Long getAdvertiserId() {
                        return this.advertiserId;
                    }

                    public Delete setAdvertiserId(Long advertiserId) {
                        this.advertiserId = advertiserId;
                        return this;
                    }

                    public Long getNegativeKeywordListId() {
                        return this.negativeKeywordListId;
                    }

                    public Delete setNegativeKeywordListId(Long negativeKeywordListId) {
                        this.negativeKeywordListId = negativeKeywordListId;
                        return this;
                    }

                    public String getKeywordValue() {
                        return this.keywordValue;
                    }

                    public Delete setKeywordValue(String keywordValue) {
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.KEYWORD_VALUE_PATTERN.matcher(keywordValue).matches(), (Object)"Parameter keywordValue must conform to the pattern ^[^/]+$");
                        }
                        this.keywordValue = keywordValue;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends DisplayVideoRequest<NegativeKeyword> {
                    private static final String REST_PATH = "v2/advertisers/{advertiserId}/negativeKeywordLists/{+negativeKeywordListId}/negativeKeywords";
                    private final Pattern NEGATIVE_KEYWORD_LIST_ID_PATTERN;
                    @Key
                    private Long advertiserId;
                    @Key
                    private Long negativeKeywordListId;

                    protected Create(Long advertiserId, Long negativeKeywordListId, NegativeKeyword content) {
                        super(DisplayVideo.this, "POST", REST_PATH, (Object)content, NegativeKeyword.class);
                        this.NEGATIVE_KEYWORD_LIST_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                        this.negativeKeywordListId = (Long)Preconditions.checkNotNull((Object)negativeKeywordListId, (Object)"Required parameter negativeKeywordListId must be specified.");
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public Long getAdvertiserId() {
                        return this.advertiserId;
                    }

                    public Create setAdvertiserId(Long advertiserId) {
                        this.advertiserId = advertiserId;
                        return this;
                    }

                    public Long getNegativeKeywordListId() {
                        return this.negativeKeywordListId;
                    }

                    public Create setNegativeKeywordListId(Long negativeKeywordListId) {
                        this.negativeKeywordListId = negativeKeywordListId;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }

                public class BulkEdit
                extends DisplayVideoRequest<BulkEditNegativeKeywordsResponse> {
                    private static final String REST_PATH = "v2/advertisers/{advertiserId}/negativeKeywordLists/{+negativeKeywordListId}/negativeKeywords:bulkEdit";
                    private final Pattern NEGATIVE_KEYWORD_LIST_ID_PATTERN;
                    @Key
                    private Long advertiserId;
                    @Key
                    private Long negativeKeywordListId;

                    protected BulkEdit(Long advertiserId, Long negativeKeywordListId, BulkEditNegativeKeywordsRequest content) {
                        super(DisplayVideo.this, "POST", REST_PATH, (Object)content, BulkEditNegativeKeywordsResponse.class);
                        this.NEGATIVE_KEYWORD_LIST_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                        this.negativeKeywordListId = (Long)Preconditions.checkNotNull((Object)negativeKeywordListId, (Object)"Required parameter negativeKeywordListId must be specified.");
                    }

                    public BulkEdit set$Xgafv(String $Xgafv) {
                        return (BulkEdit)super.set$Xgafv($Xgafv);
                    }

                    public BulkEdit setAccessToken(String accessToken) {
                        return (BulkEdit)super.setAccessToken(accessToken);
                    }

                    public BulkEdit setAlt(String alt) {
                        return (BulkEdit)super.setAlt(alt);
                    }

                    public BulkEdit setCallback(String callback) {
                        return (BulkEdit)super.setCallback(callback);
                    }

                    public BulkEdit setFields(String fields) {
                        return (BulkEdit)super.setFields(fields);
                    }

                    public BulkEdit setKey(String key) {
                        return (BulkEdit)super.setKey(key);
                    }

                    public BulkEdit setOauthToken(String oauthToken) {
                        return (BulkEdit)super.setOauthToken(oauthToken);
                    }

                    public BulkEdit setPrettyPrint(Boolean prettyPrint) {
                        return (BulkEdit)super.setPrettyPrint(prettyPrint);
                    }

                    public BulkEdit setQuotaUser(String quotaUser) {
                        return (BulkEdit)super.setQuotaUser(quotaUser);
                    }

                    public BulkEdit setUploadType(String uploadType) {
                        return (BulkEdit)super.setUploadType(uploadType);
                    }

                    public BulkEdit setUploadProtocol(String uploadProtocol) {
                        return (BulkEdit)super.setUploadProtocol(uploadProtocol);
                    }

                    public Long getAdvertiserId() {
                        return this.advertiserId;
                    }

                    public BulkEdit setAdvertiserId(Long advertiserId) {
                        this.advertiserId = advertiserId;
                        return this;
                    }

                    public Long getNegativeKeywordListId() {
                        return this.negativeKeywordListId;
                    }

                    public BulkEdit setNegativeKeywordListId(Long negativeKeywordListId) {
                        this.negativeKeywordListId = negativeKeywordListId;
                        return this;
                    }

                    @Override
                    public BulkEdit set(String parameterName, Object value) {
                        return (BulkEdit)super.set(parameterName, value);
                    }
                }
            }

            public class Patch
            extends DisplayVideoRequest<NegativeKeywordList> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/negativeKeywordLists/{negativeKeywordListId}";
                private final Pattern ADVERTISER_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long negativeKeywordListId;
                @Key
                private String updateMask;

                protected Patch(Long advertiserId, Long negativeKeywordListId, NegativeKeywordList content) {
                    super(DisplayVideo.this, "PATCH", REST_PATH, (Object)content, NegativeKeywordList.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.negativeKeywordListId = (Long)Preconditions.checkNotNull((Object)negativeKeywordListId, (Object)"Required parameter negativeKeywordListId must be specified.");
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Patch setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getNegativeKeywordListId() {
                    return this.negativeKeywordListId;
                }

                public Patch setNegativeKeywordListId(Long negativeKeywordListId) {
                    this.negativeKeywordListId = negativeKeywordListId;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends DisplayVideoRequest<ListNegativeKeywordListsResponse> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/negativeKeywordLists";
                private final Pattern ADVERTISER_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(Long advertiserId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, ListNegativeKeywordListsResponse.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public List setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends DisplayVideoRequest<NegativeKeywordList> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/negativeKeywordLists/{+negativeKeywordListId}";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern NEGATIVE_KEYWORD_LIST_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long negativeKeywordListId;

                protected Get(Long advertiserId, Long negativeKeywordListId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, NegativeKeywordList.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.NEGATIVE_KEYWORD_LIST_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.negativeKeywordListId = (Long)Preconditions.checkNotNull((Object)negativeKeywordListId, (Object)"Required parameter negativeKeywordListId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Get setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getNegativeKeywordListId() {
                    return this.negativeKeywordListId;
                }

                public Get setNegativeKeywordListId(Long negativeKeywordListId) {
                    this.negativeKeywordListId = negativeKeywordListId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends DisplayVideoRequest<Empty> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/negativeKeywordLists/{+negativeKeywordListId}";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern NEGATIVE_KEYWORD_LIST_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long negativeKeywordListId;

                protected Delete(Long advertiserId, Long negativeKeywordListId) {
                    super(DisplayVideo.this, "DELETE", REST_PATH, null, Empty.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.NEGATIVE_KEYWORD_LIST_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.negativeKeywordListId = (Long)Preconditions.checkNotNull((Object)negativeKeywordListId, (Object)"Required parameter negativeKeywordListId must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Delete setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getNegativeKeywordListId() {
                    return this.negativeKeywordListId;
                }

                public Delete setNegativeKeywordListId(Long negativeKeywordListId) {
                    this.negativeKeywordListId = negativeKeywordListId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends DisplayVideoRequest<NegativeKeywordList> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/negativeKeywordLists";
                private final Pattern ADVERTISER_ID_PATTERN;
                @Key
                private Long advertiserId;

                protected Create(Long advertiserId, NegativeKeywordList content) {
                    super(DisplayVideo.this, "POST", REST_PATH, (Object)content, NegativeKeywordList.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Create setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class ManualTriggers {
            public Activate activate(Long advertiserId, Long triggerId, ActivateManualTriggerRequest content) throws IOException {
                Activate result = new Activate(advertiserId, triggerId, content);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Create create(Long advertiserId, ManualTrigger content) throws IOException {
                Create result = new Create(advertiserId, content);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Deactivate deactivate(Long advertiserId, Long triggerId, DeactivateManualTriggerRequest content) throws IOException {
                Deactivate result = new Deactivate(advertiserId, triggerId, content);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(Long advertiserId, Long triggerId) throws IOException {
                Get result = new Get(advertiserId, triggerId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(Long advertiserId) throws IOException {
                List result = new List(advertiserId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(Long advertiserId, Long triggerId, ManualTrigger content) throws IOException {
                Patch result = new Patch(advertiserId, triggerId, content);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Patch
            extends DisplayVideoRequest<ManualTrigger> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/manualTriggers/{+triggerId}";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern TRIGGER_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long triggerId;
                @Key
                private String updateMask;

                protected Patch(Long advertiserId, Long triggerId, ManualTrigger content) {
                    super(DisplayVideo.this, "PATCH", REST_PATH, (Object)content, ManualTrigger.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.TRIGGER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.triggerId = (Long)Preconditions.checkNotNull((Object)triggerId, (Object)"Required parameter triggerId must be specified.");
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Patch setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getTriggerId() {
                    return this.triggerId;
                }

                public Patch setTriggerId(Long triggerId) {
                    this.triggerId = triggerId;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends DisplayVideoRequest<ListManualTriggersResponse> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/manualTriggers";
                private final Pattern ADVERTISER_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private String filter;
                @Key
                private String orderBy;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(Long advertiserId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, ListManualTriggersResponse.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public List setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public List setOrderBy(String orderBy) {
                    this.orderBy = orderBy;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends DisplayVideoRequest<ManualTrigger> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/manualTriggers/{+triggerId}";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern TRIGGER_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long triggerId;

                protected Get(Long advertiserId, Long triggerId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, ManualTrigger.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.TRIGGER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.triggerId = (Long)Preconditions.checkNotNull((Object)triggerId, (Object)"Required parameter triggerId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Get setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getTriggerId() {
                    return this.triggerId;
                }

                public Get setTriggerId(Long triggerId) {
                    this.triggerId = triggerId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Deactivate
            extends DisplayVideoRequest<ManualTrigger> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/manualTriggers/{+triggerId}:deactivate";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern TRIGGER_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long triggerId;

                protected Deactivate(Long advertiserId, Long triggerId, DeactivateManualTriggerRequest content) {
                    super(DisplayVideo.this, "POST", REST_PATH, (Object)content, ManualTrigger.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.TRIGGER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.triggerId = (Long)Preconditions.checkNotNull((Object)triggerId, (Object)"Required parameter triggerId must be specified.");
                }

                public Deactivate set$Xgafv(String $Xgafv) {
                    return (Deactivate)super.set$Xgafv($Xgafv);
                }

                public Deactivate setAccessToken(String accessToken) {
                    return (Deactivate)super.setAccessToken(accessToken);
                }

                public Deactivate setAlt(String alt) {
                    return (Deactivate)super.setAlt(alt);
                }

                public Deactivate setCallback(String callback) {
                    return (Deactivate)super.setCallback(callback);
                }

                public Deactivate setFields(String fields) {
                    return (Deactivate)super.setFields(fields);
                }

                public Deactivate setKey(String key) {
                    return (Deactivate)super.setKey(key);
                }

                public Deactivate setOauthToken(String oauthToken) {
                    return (Deactivate)super.setOauthToken(oauthToken);
                }

                public Deactivate setPrettyPrint(Boolean prettyPrint) {
                    return (Deactivate)super.setPrettyPrint(prettyPrint);
                }

                public Deactivate setQuotaUser(String quotaUser) {
                    return (Deactivate)super.setQuotaUser(quotaUser);
                }

                public Deactivate setUploadType(String uploadType) {
                    return (Deactivate)super.setUploadType(uploadType);
                }

                public Deactivate setUploadProtocol(String uploadProtocol) {
                    return (Deactivate)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Deactivate setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getTriggerId() {
                    return this.triggerId;
                }

                public Deactivate setTriggerId(Long triggerId) {
                    this.triggerId = triggerId;
                    return this;
                }

                @Override
                public Deactivate set(String parameterName, Object value) {
                    return (Deactivate)super.set(parameterName, value);
                }
            }

            public class Create
            extends DisplayVideoRequest<ManualTrigger> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/manualTriggers";
                private final Pattern ADVERTISER_ID_PATTERN;
                @Key
                private Long advertiserId;

                protected Create(Long advertiserId, ManualTrigger content) {
                    super(DisplayVideo.this, "POST", REST_PATH, (Object)content, ManualTrigger.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Create setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }

            public class Activate
            extends DisplayVideoRequest<ManualTrigger> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/manualTriggers/{+triggerId}:activate";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern TRIGGER_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long triggerId;

                protected Activate(Long advertiserId, Long triggerId, ActivateManualTriggerRequest content) {
                    super(DisplayVideo.this, "POST", REST_PATH, (Object)content, ManualTrigger.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.TRIGGER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.triggerId = (Long)Preconditions.checkNotNull((Object)triggerId, (Object)"Required parameter triggerId must be specified.");
                }

                public Activate set$Xgafv(String $Xgafv) {
                    return (Activate)super.set$Xgafv($Xgafv);
                }

                public Activate setAccessToken(String accessToken) {
                    return (Activate)super.setAccessToken(accessToken);
                }

                public Activate setAlt(String alt) {
                    return (Activate)super.setAlt(alt);
                }

                public Activate setCallback(String callback) {
                    return (Activate)super.setCallback(callback);
                }

                public Activate setFields(String fields) {
                    return (Activate)super.setFields(fields);
                }

                public Activate setKey(String key) {
                    return (Activate)super.setKey(key);
                }

                public Activate setOauthToken(String oauthToken) {
                    return (Activate)super.setOauthToken(oauthToken);
                }

                public Activate setPrettyPrint(Boolean prettyPrint) {
                    return (Activate)super.setPrettyPrint(prettyPrint);
                }

                public Activate setQuotaUser(String quotaUser) {
                    return (Activate)super.setQuotaUser(quotaUser);
                }

                public Activate setUploadType(String uploadType) {
                    return (Activate)super.setUploadType(uploadType);
                }

                public Activate setUploadProtocol(String uploadProtocol) {
                    return (Activate)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Activate setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getTriggerId() {
                    return this.triggerId;
                }

                public Activate setTriggerId(Long triggerId) {
                    this.triggerId = triggerId;
                    return this;
                }

                @Override
                public Activate set(String parameterName, Object value) {
                    return (Activate)super.set(parameterName, value);
                }
            }
        }

        public class LocationLists {
            public Create create(Long advertiserId, LocationList content) throws IOException {
                Create result = new Create(advertiserId, content);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(Long advertiserId, Long locationListId) throws IOException {
                Get result = new Get(advertiserId, locationListId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(Long advertiserId) throws IOException {
                List result = new List(advertiserId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(Long advertiserId, Long locationListId, LocationList content) throws IOException {
                Patch result = new Patch(advertiserId, locationListId, content);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public AssignedLocations assignedLocations() {
                return new AssignedLocations();
            }

            public class AssignedLocations {
                public BulkEdit bulkEdit(Long advertiserId, Long locationListId, BulkEditAssignedLocationsRequest content) throws IOException {
                    BulkEdit result = new BulkEdit(advertiserId, locationListId, content);
                    DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Create create(Long advertiserId, Long locationListId, AssignedLocation content) throws IOException {
                    Create result = new Create(advertiserId, locationListId, content);
                    DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(Long advertiserId, Long locationListId, Long assignedLocationId) throws IOException {
                    Delete result = new Delete(advertiserId, locationListId, assignedLocationId);
                    DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(Long advertiserId, Long locationListId) throws IOException {
                    List result = new List(advertiserId, locationListId);
                    DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends DisplayVideoRequest<ListAssignedLocationsResponse> {
                    private static final String REST_PATH = "v2/advertisers/{advertiserId}/locationLists/{locationListId}/assignedLocations";
                    @Key
                    private Long advertiserId;
                    @Key
                    private Long locationListId;
                    @Key
                    private String filter;
                    @Key
                    private String orderBy;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(Long advertiserId, Long locationListId) {
                        super(DisplayVideo.this, "GET", REST_PATH, null, ListAssignedLocationsResponse.class);
                        this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                        this.locationListId = (Long)Preconditions.checkNotNull((Object)locationListId, (Object)"Required parameter locationListId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public Long getAdvertiserId() {
                        return this.advertiserId;
                    }

                    public List setAdvertiserId(Long advertiserId) {
                        this.advertiserId = advertiserId;
                        return this;
                    }

                    public Long getLocationListId() {
                        return this.locationListId;
                    }

                    public List setLocationListId(Long locationListId) {
                        this.locationListId = locationListId;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public String getOrderBy() {
                        return this.orderBy;
                    }

                    public List setOrderBy(String orderBy) {
                        this.orderBy = orderBy;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends DisplayVideoRequest<Empty> {
                    private static final String REST_PATH = "v2/advertisers/{advertiserId}/locationLists/{locationListId}/assignedLocations/{+assignedLocationId}";
                    private final Pattern ASSIGNED_LOCATION_ID_PATTERN;
                    @Key
                    private Long advertiserId;
                    @Key
                    private Long locationListId;
                    @Key
                    private Long assignedLocationId;

                    protected Delete(Long advertiserId, Long locationListId, Long assignedLocationId) {
                        super(DisplayVideo.this, "DELETE", REST_PATH, null, Empty.class);
                        this.ASSIGNED_LOCATION_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                        this.locationListId = (Long)Preconditions.checkNotNull((Object)locationListId, (Object)"Required parameter locationListId must be specified.");
                        this.assignedLocationId = (Long)Preconditions.checkNotNull((Object)assignedLocationId, (Object)"Required parameter assignedLocationId must be specified.");
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public Long getAdvertiserId() {
                        return this.advertiserId;
                    }

                    public Delete setAdvertiserId(Long advertiserId) {
                        this.advertiserId = advertiserId;
                        return this;
                    }

                    public Long getLocationListId() {
                        return this.locationListId;
                    }

                    public Delete setLocationListId(Long locationListId) {
                        this.locationListId = locationListId;
                        return this;
                    }

                    public Long getAssignedLocationId() {
                        return this.assignedLocationId;
                    }

                    public Delete setAssignedLocationId(Long assignedLocationId) {
                        this.assignedLocationId = assignedLocationId;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends DisplayVideoRequest<AssignedLocation> {
                    private static final String REST_PATH = "v2/advertisers/{advertiserId}/locationLists/{locationListId}/assignedLocations";
                    @Key
                    private Long advertiserId;
                    @Key
                    private Long locationListId;

                    protected Create(Long advertiserId, Long locationListId, AssignedLocation content) {
                        super(DisplayVideo.this, "POST", REST_PATH, (Object)content, AssignedLocation.class);
                        this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                        this.locationListId = (Long)Preconditions.checkNotNull((Object)locationListId, (Object)"Required parameter locationListId must be specified.");
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public Long getAdvertiserId() {
                        return this.advertiserId;
                    }

                    public Create setAdvertiserId(Long advertiserId) {
                        this.advertiserId = advertiserId;
                        return this;
                    }

                    public Long getLocationListId() {
                        return this.locationListId;
                    }

                    public Create setLocationListId(Long locationListId) {
                        this.locationListId = locationListId;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }

                public class BulkEdit
                extends DisplayVideoRequest<BulkEditAssignedLocationsResponse> {
                    private static final String REST_PATH = "v2/advertisers/{advertiserId}/locationLists/{+locationListId}/assignedLocations:bulkEdit";
                    private final Pattern LOCATION_LIST_ID_PATTERN;
                    @Key
                    private Long advertiserId;
                    @Key
                    private Long locationListId;

                    protected BulkEdit(Long advertiserId, Long locationListId, BulkEditAssignedLocationsRequest content) {
                        super(DisplayVideo.this, "POST", REST_PATH, (Object)content, BulkEditAssignedLocationsResponse.class);
                        this.LOCATION_LIST_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                        this.locationListId = (Long)Preconditions.checkNotNull((Object)locationListId, (Object)"Required parameter locationListId must be specified.");
                    }

                    public BulkEdit set$Xgafv(String $Xgafv) {
                        return (BulkEdit)super.set$Xgafv($Xgafv);
                    }

                    public BulkEdit setAccessToken(String accessToken) {
                        return (BulkEdit)super.setAccessToken(accessToken);
                    }

                    public BulkEdit setAlt(String alt) {
                        return (BulkEdit)super.setAlt(alt);
                    }

                    public BulkEdit setCallback(String callback) {
                        return (BulkEdit)super.setCallback(callback);
                    }

                    public BulkEdit setFields(String fields) {
                        return (BulkEdit)super.setFields(fields);
                    }

                    public BulkEdit setKey(String key) {
                        return (BulkEdit)super.setKey(key);
                    }

                    public BulkEdit setOauthToken(String oauthToken) {
                        return (BulkEdit)super.setOauthToken(oauthToken);
                    }

                    public BulkEdit setPrettyPrint(Boolean prettyPrint) {
                        return (BulkEdit)super.setPrettyPrint(prettyPrint);
                    }

                    public BulkEdit setQuotaUser(String quotaUser) {
                        return (BulkEdit)super.setQuotaUser(quotaUser);
                    }

                    public BulkEdit setUploadType(String uploadType) {
                        return (BulkEdit)super.setUploadType(uploadType);
                    }

                    public BulkEdit setUploadProtocol(String uploadProtocol) {
                        return (BulkEdit)super.setUploadProtocol(uploadProtocol);
                    }

                    public Long getAdvertiserId() {
                        return this.advertiserId;
                    }

                    public BulkEdit setAdvertiserId(Long advertiserId) {
                        this.advertiserId = advertiserId;
                        return this;
                    }

                    public Long getLocationListId() {
                        return this.locationListId;
                    }

                    public BulkEdit setLocationListId(Long locationListId) {
                        this.locationListId = locationListId;
                        return this;
                    }

                    @Override
                    public BulkEdit set(String parameterName, Object value) {
                        return (BulkEdit)super.set(parameterName, value);
                    }
                }
            }

            public class Patch
            extends DisplayVideoRequest<LocationList> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/locationLists/{locationListId}";
                private final Pattern ADVERTISER_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long locationListId;
                @Key
                private String updateMask;

                protected Patch(Long advertiserId, Long locationListId, LocationList content) {
                    super(DisplayVideo.this, "PATCH", REST_PATH, (Object)content, LocationList.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.locationListId = (Long)Preconditions.checkNotNull((Object)locationListId, (Object)"Required parameter locationListId must be specified.");
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Patch setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getLocationListId() {
                    return this.locationListId;
                }

                public Patch setLocationListId(Long locationListId) {
                    this.locationListId = locationListId;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends DisplayVideoRequest<ListLocationListsResponse> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/locationLists";
                private final Pattern ADVERTISER_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private String filter;
                @Key
                private String orderBy;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(Long advertiserId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, ListLocationListsResponse.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public List setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public List setOrderBy(String orderBy) {
                    this.orderBy = orderBy;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends DisplayVideoRequest<LocationList> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/locationLists/{+locationListId}";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern LOCATION_LIST_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long locationListId;

                protected Get(Long advertiserId, Long locationListId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, LocationList.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.LOCATION_LIST_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.locationListId = (Long)Preconditions.checkNotNull((Object)locationListId, (Object)"Required parameter locationListId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Get setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getLocationListId() {
                    return this.locationListId;
                }

                public Get setLocationListId(Long locationListId) {
                    this.locationListId = locationListId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Create
            extends DisplayVideoRequest<LocationList> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/locationLists";
                private final Pattern ADVERTISER_ID_PATTERN;
                @Key
                private Long advertiserId;

                protected Create(Long advertiserId, LocationList content) {
                    super(DisplayVideo.this, "POST", REST_PATH, (Object)content, LocationList.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Create setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class LineItems {
            public BulkEditAssignedTargetingOptions bulkEditAssignedTargetingOptions(Long advertiserId, BulkEditAssignedTargetingOptionsRequest content) throws IOException {
                BulkEditAssignedTargetingOptions result = new BulkEditAssignedTargetingOptions(advertiserId, content);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public BulkListAssignedTargetingOptions bulkListAssignedTargetingOptions(Long advertiserId) throws IOException {
                BulkListAssignedTargetingOptions result = new BulkListAssignedTargetingOptions(advertiserId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public BulkUpdate bulkUpdate(Long advertiserId, BulkUpdateLineItemsRequest content) throws IOException {
                BulkUpdate result = new BulkUpdate(advertiserId, content);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Create create(Long advertiserId, LineItem content) throws IOException {
                Create result = new Create(advertiserId, content);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(Long advertiserId, Long lineItemId) throws IOException {
                Delete result = new Delete(advertiserId, lineItemId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Duplicate duplicate(Long advertiserId, Long lineItemId, DuplicateLineItemRequest content) throws IOException {
                Duplicate result = new Duplicate(advertiserId, lineItemId, content);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public GenerateDefault generateDefault(Long advertiserId, GenerateDefaultLineItemRequest content) throws IOException {
                GenerateDefault result = new GenerateDefault(advertiserId, content);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(Long advertiserId, Long lineItemId) throws IOException {
                Get result = new Get(advertiserId, lineItemId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(Long advertiserId) throws IOException {
                List result = new List(advertiserId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(Long advertiserId, Long lineItemId, LineItem content) throws IOException {
                Patch result = new Patch(advertiserId, lineItemId, content);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public TargetingTypes targetingTypes() {
                return new TargetingTypes();
            }

            public class TargetingTypes {
                public AssignedTargetingOptions assignedTargetingOptions() {
                    return new AssignedTargetingOptions();
                }

                public class AssignedTargetingOptions {
                    public Create create(Long advertiserId, Long lineItemId, String targetingType, AssignedTargetingOption content) throws IOException {
                        Create result = new Create(advertiserId, lineItemId, targetingType, content);
                        DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Delete delete(Long advertiserId, Long lineItemId, String targetingType, String assignedTargetingOptionId) throws IOException {
                        Delete result = new Delete(advertiserId, lineItemId, targetingType, assignedTargetingOptionId);
                        DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Get get(Long advertiserId, Long lineItemId, String targetingType, String assignedTargetingOptionId) throws IOException {
                        Get result = new Get(advertiserId, lineItemId, targetingType, assignedTargetingOptionId);
                        DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public List list(Long advertiserId, Long lineItemId, String targetingType) throws IOException {
                        List result = new List(advertiserId, lineItemId, targetingType);
                        DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class List
                    extends DisplayVideoRequest<ListLineItemAssignedTargetingOptionsResponse> {
                        private static final String REST_PATH = "v2/advertisers/{+advertiserId}/lineItems/{+lineItemId}/targetingTypes/{+targetingType}/assignedTargetingOptions";
                        private final Pattern ADVERTISER_ID_PATTERN;
                        private final Pattern LINE_ITEM_ID_PATTERN;
                        private final Pattern TARGETING_TYPE_PATTERN;
                        @Key
                        private Long advertiserId;
                        @Key
                        private Long lineItemId;
                        @Key
                        private String targetingType;
                        @Key
                        private String filter;
                        @Key
                        private String orderBy;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(Long advertiserId, Long lineItemId, String targetingType) {
                            super(DisplayVideo.this, "GET", REST_PATH, null, ListLineItemAssignedTargetingOptionsResponse.class);
                            this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                            this.LINE_ITEM_ID_PATTERN = Pattern.compile("^[^/]+$");
                            this.TARGETING_TYPE_PATTERN = Pattern.compile("^[^/]+$");
                            this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                            this.lineItemId = (Long)Preconditions.checkNotNull((Object)lineItemId, (Object)"Required parameter lineItemId must be specified.");
                            this.targetingType = (String)Preconditions.checkNotNull((Object)targetingType, (Object)"Required parameter targetingType must be specified.");
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public Long getAdvertiserId() {
                            return this.advertiserId;
                        }

                        public List setAdvertiserId(Long advertiserId) {
                            this.advertiserId = advertiserId;
                            return this;
                        }

                        public Long getLineItemId() {
                            return this.lineItemId;
                        }

                        public List setLineItemId(Long lineItemId) {
                            this.lineItemId = lineItemId;
                            return this;
                        }

                        public String getTargetingType() {
                            return this.targetingType;
                        }

                        public List setTargetingType(String targetingType) {
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                            }
                            this.targetingType = targetingType;
                            return this;
                        }

                        public String getFilter() {
                            return this.filter;
                        }

                        public List setFilter(String filter) {
                            this.filter = filter;
                            return this;
                        }

                        public String getOrderBy() {
                            return this.orderBy;
                        }

                        public List setOrderBy(String orderBy) {
                            this.orderBy = orderBy;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }

                    public class Get
                    extends DisplayVideoRequest<AssignedTargetingOption> {
                        private static final String REST_PATH = "v2/advertisers/{+advertiserId}/lineItems/{+lineItemId}/targetingTypes/{+targetingType}/assignedTargetingOptions/{+assignedTargetingOptionId}";
                        private final Pattern ADVERTISER_ID_PATTERN;
                        private final Pattern LINE_ITEM_ID_PATTERN;
                        private final Pattern TARGETING_TYPE_PATTERN;
                        private final Pattern ASSIGNED_TARGETING_OPTION_ID_PATTERN;
                        @Key
                        private Long advertiserId;
                        @Key
                        private Long lineItemId;
                        @Key
                        private String targetingType;
                        @Key
                        private String assignedTargetingOptionId;

                        protected Get(Long advertiserId, Long lineItemId, String targetingType, String assignedTargetingOptionId) {
                            super(DisplayVideo.this, "GET", REST_PATH, null, AssignedTargetingOption.class);
                            this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                            this.LINE_ITEM_ID_PATTERN = Pattern.compile("^[^/]+$");
                            this.TARGETING_TYPE_PATTERN = Pattern.compile("^[^/]+$");
                            this.ASSIGNED_TARGETING_OPTION_ID_PATTERN = Pattern.compile("^[^/]+$");
                            this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                            this.lineItemId = (Long)Preconditions.checkNotNull((Object)lineItemId, (Object)"Required parameter lineItemId must be specified.");
                            this.targetingType = (String)Preconditions.checkNotNull((Object)targetingType, (Object)"Required parameter targetingType must be specified.");
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                            }
                            this.assignedTargetingOptionId = (String)Preconditions.checkNotNull((Object)assignedTargetingOptionId, (Object)"Required parameter assignedTargetingOptionId must be specified.");
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.ASSIGNED_TARGETING_OPTION_ID_PATTERN.matcher(assignedTargetingOptionId).matches(), (Object)"Parameter assignedTargetingOptionId must conform to the pattern ^[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String $Xgafv) {
                            return (Get)super.set$Xgafv($Xgafv);
                        }

                        public Get setAccessToken(String accessToken) {
                            return (Get)super.setAccessToken(accessToken);
                        }

                        public Get setAlt(String alt) {
                            return (Get)super.setAlt(alt);
                        }

                        public Get setCallback(String callback) {
                            return (Get)super.setCallback(callback);
                        }

                        public Get setFields(String fields) {
                            return (Get)super.setFields(fields);
                        }

                        public Get setKey(String key) {
                            return (Get)super.setKey(key);
                        }

                        public Get setOauthToken(String oauthToken) {
                            return (Get)super.setOauthToken(oauthToken);
                        }

                        public Get setPrettyPrint(Boolean prettyPrint) {
                            return (Get)super.setPrettyPrint(prettyPrint);
                        }

                        public Get setQuotaUser(String quotaUser) {
                            return (Get)super.setQuotaUser(quotaUser);
                        }

                        public Get setUploadType(String uploadType) {
                            return (Get)super.setUploadType(uploadType);
                        }

                        public Get setUploadProtocol(String uploadProtocol) {
                            return (Get)super.setUploadProtocol(uploadProtocol);
                        }

                        public Long getAdvertiserId() {
                            return this.advertiserId;
                        }

                        public Get setAdvertiserId(Long advertiserId) {
                            this.advertiserId = advertiserId;
                            return this;
                        }

                        public Long getLineItemId() {
                            return this.lineItemId;
                        }

                        public Get setLineItemId(Long lineItemId) {
                            this.lineItemId = lineItemId;
                            return this;
                        }

                        public String getTargetingType() {
                            return this.targetingType;
                        }

                        public Get setTargetingType(String targetingType) {
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                            }
                            this.targetingType = targetingType;
                            return this;
                        }

                        public String getAssignedTargetingOptionId() {
                            return this.assignedTargetingOptionId;
                        }

                        public Get setAssignedTargetingOptionId(String assignedTargetingOptionId) {
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.ASSIGNED_TARGETING_OPTION_ID_PATTERN.matcher(assignedTargetingOptionId).matches(), (Object)"Parameter assignedTargetingOptionId must conform to the pattern ^[^/]+$");
                            }
                            this.assignedTargetingOptionId = assignedTargetingOptionId;
                            return this;
                        }

                        @Override
                        public Get set(String parameterName, Object value) {
                            return (Get)super.set(parameterName, value);
                        }
                    }

                    public class Delete
                    extends DisplayVideoRequest<Empty> {
                        private static final String REST_PATH = "v2/advertisers/{+advertiserId}/lineItems/{+lineItemId}/targetingTypes/{+targetingType}/assignedTargetingOptions/{+assignedTargetingOptionId}";
                        private final Pattern ADVERTISER_ID_PATTERN;
                        private final Pattern LINE_ITEM_ID_PATTERN;
                        private final Pattern TARGETING_TYPE_PATTERN;
                        private final Pattern ASSIGNED_TARGETING_OPTION_ID_PATTERN;
                        @Key
                        private Long advertiserId;
                        @Key
                        private Long lineItemId;
                        @Key
                        private String targetingType;
                        @Key
                        private String assignedTargetingOptionId;

                        protected Delete(Long advertiserId, Long lineItemId, String targetingType, String assignedTargetingOptionId) {
                            super(DisplayVideo.this, "DELETE", REST_PATH, null, Empty.class);
                            this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                            this.LINE_ITEM_ID_PATTERN = Pattern.compile("^[^/]+$");
                            this.TARGETING_TYPE_PATTERN = Pattern.compile("^[^/]+$");
                            this.ASSIGNED_TARGETING_OPTION_ID_PATTERN = Pattern.compile("^[^/]+$");
                            this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                            this.lineItemId = (Long)Preconditions.checkNotNull((Object)lineItemId, (Object)"Required parameter lineItemId must be specified.");
                            this.targetingType = (String)Preconditions.checkNotNull((Object)targetingType, (Object)"Required parameter targetingType must be specified.");
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                            }
                            this.assignedTargetingOptionId = (String)Preconditions.checkNotNull((Object)assignedTargetingOptionId, (Object)"Required parameter assignedTargetingOptionId must be specified.");
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.ASSIGNED_TARGETING_OPTION_ID_PATTERN.matcher(assignedTargetingOptionId).matches(), (Object)"Parameter assignedTargetingOptionId must conform to the pattern ^[^/]+$");
                            }
                        }

                        public Delete set$Xgafv(String $Xgafv) {
                            return (Delete)super.set$Xgafv($Xgafv);
                        }

                        public Delete setAccessToken(String accessToken) {
                            return (Delete)super.setAccessToken(accessToken);
                        }

                        public Delete setAlt(String alt) {
                            return (Delete)super.setAlt(alt);
                        }

                        public Delete setCallback(String callback) {
                            return (Delete)super.setCallback(callback);
                        }

                        public Delete setFields(String fields) {
                            return (Delete)super.setFields(fields);
                        }

                        public Delete setKey(String key) {
                            return (Delete)super.setKey(key);
                        }

                        public Delete setOauthToken(String oauthToken) {
                            return (Delete)super.setOauthToken(oauthToken);
                        }

                        public Delete setPrettyPrint(Boolean prettyPrint) {
                            return (Delete)super.setPrettyPrint(prettyPrint);
                        }

                        public Delete setQuotaUser(String quotaUser) {
                            return (Delete)super.setQuotaUser(quotaUser);
                        }

                        public Delete setUploadType(String uploadType) {
                            return (Delete)super.setUploadType(uploadType);
                        }

                        public Delete setUploadProtocol(String uploadProtocol) {
                            return (Delete)super.setUploadProtocol(uploadProtocol);
                        }

                        public Long getAdvertiserId() {
                            return this.advertiserId;
                        }

                        public Delete setAdvertiserId(Long advertiserId) {
                            this.advertiserId = advertiserId;
                            return this;
                        }

                        public Long getLineItemId() {
                            return this.lineItemId;
                        }

                        public Delete setLineItemId(Long lineItemId) {
                            this.lineItemId = lineItemId;
                            return this;
                        }

                        public String getTargetingType() {
                            return this.targetingType;
                        }

                        public Delete setTargetingType(String targetingType) {
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                            }
                            this.targetingType = targetingType;
                            return this;
                        }

                        public String getAssignedTargetingOptionId() {
                            return this.assignedTargetingOptionId;
                        }

                        public Delete setAssignedTargetingOptionId(String assignedTargetingOptionId) {
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.ASSIGNED_TARGETING_OPTION_ID_PATTERN.matcher(assignedTargetingOptionId).matches(), (Object)"Parameter assignedTargetingOptionId must conform to the pattern ^[^/]+$");
                            }
                            this.assignedTargetingOptionId = assignedTargetingOptionId;
                            return this;
                        }

                        @Override
                        public Delete set(String parameterName, Object value) {
                            return (Delete)super.set(parameterName, value);
                        }
                    }

                    public class Create
                    extends DisplayVideoRequest<AssignedTargetingOption> {
                        private static final String REST_PATH = "v2/advertisers/{+advertiserId}/lineItems/{+lineItemId}/targetingTypes/{+targetingType}/assignedTargetingOptions";
                        private final Pattern ADVERTISER_ID_PATTERN;
                        private final Pattern LINE_ITEM_ID_PATTERN;
                        private final Pattern TARGETING_TYPE_PATTERN;
                        @Key
                        private Long advertiserId;
                        @Key
                        private Long lineItemId;
                        @Key
                        private String targetingType;

                        protected Create(Long advertiserId, Long lineItemId, String targetingType, AssignedTargetingOption content) {
                            super(DisplayVideo.this, "POST", REST_PATH, (Object)content, AssignedTargetingOption.class);
                            this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                            this.LINE_ITEM_ID_PATTERN = Pattern.compile("^[^/]+$");
                            this.TARGETING_TYPE_PATTERN = Pattern.compile("^[^/]+$");
                            this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                            this.lineItemId = (Long)Preconditions.checkNotNull((Object)lineItemId, (Object)"Required parameter lineItemId must be specified.");
                            this.targetingType = (String)Preconditions.checkNotNull((Object)targetingType, (Object)"Required parameter targetingType must be specified.");
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                            }
                        }

                        public Create set$Xgafv(String $Xgafv) {
                            return (Create)super.set$Xgafv($Xgafv);
                        }

                        public Create setAccessToken(String accessToken) {
                            return (Create)super.setAccessToken(accessToken);
                        }

                        public Create setAlt(String alt) {
                            return (Create)super.setAlt(alt);
                        }

                        public Create setCallback(String callback) {
                            return (Create)super.setCallback(callback);
                        }

                        public Create setFields(String fields) {
                            return (Create)super.setFields(fields);
                        }

                        public Create setKey(String key) {
                            return (Create)super.setKey(key);
                        }

                        public Create setOauthToken(String oauthToken) {
                            return (Create)super.setOauthToken(oauthToken);
                        }

                        public Create setPrettyPrint(Boolean prettyPrint) {
                            return (Create)super.setPrettyPrint(prettyPrint);
                        }

                        public Create setQuotaUser(String quotaUser) {
                            return (Create)super.setQuotaUser(quotaUser);
                        }

                        public Create setUploadType(String uploadType) {
                            return (Create)super.setUploadType(uploadType);
                        }

                        public Create setUploadProtocol(String uploadProtocol) {
                            return (Create)super.setUploadProtocol(uploadProtocol);
                        }

                        public Long getAdvertiserId() {
                            return this.advertiserId;
                        }

                        public Create setAdvertiserId(Long advertiserId) {
                            this.advertiserId = advertiserId;
                            return this;
                        }

                        public Long getLineItemId() {
                            return this.lineItemId;
                        }

                        public Create setLineItemId(Long lineItemId) {
                            this.lineItemId = lineItemId;
                            return this;
                        }

                        public String getTargetingType() {
                            return this.targetingType;
                        }

                        public Create setTargetingType(String targetingType) {
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                            }
                            this.targetingType = targetingType;
                            return this;
                        }

                        @Override
                        public Create set(String parameterName, Object value) {
                            return (Create)super.set(parameterName, value);
                        }
                    }
                }
            }

            public class Patch
            extends DisplayVideoRequest<LineItem> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/lineItems/{+lineItemId}";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern LINE_ITEM_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long lineItemId;
                @Key
                private String updateMask;

                protected Patch(Long advertiserId, Long lineItemId, LineItem content) {
                    super(DisplayVideo.this, "PATCH", REST_PATH, (Object)content, LineItem.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.LINE_ITEM_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.lineItemId = (Long)Preconditions.checkNotNull((Object)lineItemId, (Object)"Required parameter lineItemId must be specified.");
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Patch setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getLineItemId() {
                    return this.lineItemId;
                }

                public Patch setLineItemId(Long lineItemId) {
                    this.lineItemId = lineItemId;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends DisplayVideoRequest<ListLineItemsResponse> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/lineItems";
                private final Pattern ADVERTISER_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private String filter;
                @Key
                private String orderBy;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(Long advertiserId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, ListLineItemsResponse.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public List setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public List setOrderBy(String orderBy) {
                    this.orderBy = orderBy;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends DisplayVideoRequest<LineItem> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/lineItems/{+lineItemId}";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern LINE_ITEM_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long lineItemId;

                protected Get(Long advertiserId, Long lineItemId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, LineItem.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.LINE_ITEM_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.lineItemId = (Long)Preconditions.checkNotNull((Object)lineItemId, (Object)"Required parameter lineItemId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Get setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getLineItemId() {
                    return this.lineItemId;
                }

                public Get setLineItemId(Long lineItemId) {
                    this.lineItemId = lineItemId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class GenerateDefault
            extends DisplayVideoRequest<LineItem> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/lineItems:generateDefault";
                private final Pattern ADVERTISER_ID_PATTERN;
                @Key
                private Long advertiserId;

                protected GenerateDefault(Long advertiserId, GenerateDefaultLineItemRequest content) {
                    super(DisplayVideo.this, "POST", REST_PATH, (Object)content, LineItem.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                }

                public GenerateDefault set$Xgafv(String $Xgafv) {
                    return (GenerateDefault)super.set$Xgafv($Xgafv);
                }

                public GenerateDefault setAccessToken(String accessToken) {
                    return (GenerateDefault)super.setAccessToken(accessToken);
                }

                public GenerateDefault setAlt(String alt) {
                    return (GenerateDefault)super.setAlt(alt);
                }

                public GenerateDefault setCallback(String callback) {
                    return (GenerateDefault)super.setCallback(callback);
                }

                public GenerateDefault setFields(String fields) {
                    return (GenerateDefault)super.setFields(fields);
                }

                public GenerateDefault setKey(String key) {
                    return (GenerateDefault)super.setKey(key);
                }

                public GenerateDefault setOauthToken(String oauthToken) {
                    return (GenerateDefault)super.setOauthToken(oauthToken);
                }

                public GenerateDefault setPrettyPrint(Boolean prettyPrint) {
                    return (GenerateDefault)super.setPrettyPrint(prettyPrint);
                }

                public GenerateDefault setQuotaUser(String quotaUser) {
                    return (GenerateDefault)super.setQuotaUser(quotaUser);
                }

                public GenerateDefault setUploadType(String uploadType) {
                    return (GenerateDefault)super.setUploadType(uploadType);
                }

                public GenerateDefault setUploadProtocol(String uploadProtocol) {
                    return (GenerateDefault)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public GenerateDefault setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                @Override
                public GenerateDefault set(String parameterName, Object value) {
                    return (GenerateDefault)super.set(parameterName, value);
                }
            }

            public class Duplicate
            extends DisplayVideoRequest<DuplicateLineItemResponse> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/lineItems/{+lineItemId}:duplicate";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern LINE_ITEM_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long lineItemId;

                protected Duplicate(Long advertiserId, Long lineItemId, DuplicateLineItemRequest content) {
                    super(DisplayVideo.this, "POST", REST_PATH, (Object)content, DuplicateLineItemResponse.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.LINE_ITEM_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.lineItemId = (Long)Preconditions.checkNotNull((Object)lineItemId, (Object)"Required parameter lineItemId must be specified.");
                }

                public Duplicate set$Xgafv(String $Xgafv) {
                    return (Duplicate)super.set$Xgafv($Xgafv);
                }

                public Duplicate setAccessToken(String accessToken) {
                    return (Duplicate)super.setAccessToken(accessToken);
                }

                public Duplicate setAlt(String alt) {
                    return (Duplicate)super.setAlt(alt);
                }

                public Duplicate setCallback(String callback) {
                    return (Duplicate)super.setCallback(callback);
                }

                public Duplicate setFields(String fields) {
                    return (Duplicate)super.setFields(fields);
                }

                public Duplicate setKey(String key) {
                    return (Duplicate)super.setKey(key);
                }

                public Duplicate setOauthToken(String oauthToken) {
                    return (Duplicate)super.setOauthToken(oauthToken);
                }

                public Duplicate setPrettyPrint(Boolean prettyPrint) {
                    return (Duplicate)super.setPrettyPrint(prettyPrint);
                }

                public Duplicate setQuotaUser(String quotaUser) {
                    return (Duplicate)super.setQuotaUser(quotaUser);
                }

                public Duplicate setUploadType(String uploadType) {
                    return (Duplicate)super.setUploadType(uploadType);
                }

                public Duplicate setUploadProtocol(String uploadProtocol) {
                    return (Duplicate)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Duplicate setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getLineItemId() {
                    return this.lineItemId;
                }

                public Duplicate setLineItemId(Long lineItemId) {
                    this.lineItemId = lineItemId;
                    return this;
                }

                @Override
                public Duplicate set(String parameterName, Object value) {
                    return (Duplicate)super.set(parameterName, value);
                }
            }

            public class Delete
            extends DisplayVideoRequest<Empty> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/lineItems/{+lineItemId}";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern LINE_ITEM_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long lineItemId;

                protected Delete(Long advertiserId, Long lineItemId) {
                    super(DisplayVideo.this, "DELETE", REST_PATH, null, Empty.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.LINE_ITEM_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.lineItemId = (Long)Preconditions.checkNotNull((Object)lineItemId, (Object)"Required parameter lineItemId must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Delete setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getLineItemId() {
                    return this.lineItemId;
                }

                public Delete setLineItemId(Long lineItemId) {
                    this.lineItemId = lineItemId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends DisplayVideoRequest<LineItem> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/lineItems";
                private final Pattern ADVERTISER_ID_PATTERN;
                @Key
                private Long advertiserId;

                protected Create(Long advertiserId, LineItem content) {
                    super(DisplayVideo.this, "POST", REST_PATH, (Object)content, LineItem.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Create setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }

            public class BulkUpdate
            extends DisplayVideoRequest<BulkUpdateLineItemsResponse> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/lineItems:bulkUpdate";
                private final Pattern ADVERTISER_ID_PATTERN;
                @Key
                private Long advertiserId;

                protected BulkUpdate(Long advertiserId, BulkUpdateLineItemsRequest content) {
                    super(DisplayVideo.this, "POST", REST_PATH, (Object)content, BulkUpdateLineItemsResponse.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                }

                public BulkUpdate set$Xgafv(String $Xgafv) {
                    return (BulkUpdate)super.set$Xgafv($Xgafv);
                }

                public BulkUpdate setAccessToken(String accessToken) {
                    return (BulkUpdate)super.setAccessToken(accessToken);
                }

                public BulkUpdate setAlt(String alt) {
                    return (BulkUpdate)super.setAlt(alt);
                }

                public BulkUpdate setCallback(String callback) {
                    return (BulkUpdate)super.setCallback(callback);
                }

                public BulkUpdate setFields(String fields) {
                    return (BulkUpdate)super.setFields(fields);
                }

                public BulkUpdate setKey(String key) {
                    return (BulkUpdate)super.setKey(key);
                }

                public BulkUpdate setOauthToken(String oauthToken) {
                    return (BulkUpdate)super.setOauthToken(oauthToken);
                }

                public BulkUpdate setPrettyPrint(Boolean prettyPrint) {
                    return (BulkUpdate)super.setPrettyPrint(prettyPrint);
                }

                public BulkUpdate setQuotaUser(String quotaUser) {
                    return (BulkUpdate)super.setQuotaUser(quotaUser);
                }

                public BulkUpdate setUploadType(String uploadType) {
                    return (BulkUpdate)super.setUploadType(uploadType);
                }

                public BulkUpdate setUploadProtocol(String uploadProtocol) {
                    return (BulkUpdate)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public BulkUpdate setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                @Override
                public BulkUpdate set(String parameterName, Object value) {
                    return (BulkUpdate)super.set(parameterName, value);
                }
            }

            public class BulkListAssignedTargetingOptions
            extends DisplayVideoRequest<BulkListAssignedTargetingOptionsResponse> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/lineItems:bulkListAssignedTargetingOptions";
                private final Pattern ADVERTISER_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private String filter;
                @Key
                private java.util.List<Long> lineItemIds;
                @Key
                private String orderBy;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected BulkListAssignedTargetingOptions(Long advertiserId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, BulkListAssignedTargetingOptionsResponse.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public BulkListAssignedTargetingOptions set$Xgafv(String $Xgafv) {
                    return (BulkListAssignedTargetingOptions)super.set$Xgafv($Xgafv);
                }

                public BulkListAssignedTargetingOptions setAccessToken(String accessToken) {
                    return (BulkListAssignedTargetingOptions)super.setAccessToken(accessToken);
                }

                public BulkListAssignedTargetingOptions setAlt(String alt) {
                    return (BulkListAssignedTargetingOptions)super.setAlt(alt);
                }

                public BulkListAssignedTargetingOptions setCallback(String callback) {
                    return (BulkListAssignedTargetingOptions)super.setCallback(callback);
                }

                public BulkListAssignedTargetingOptions setFields(String fields) {
                    return (BulkListAssignedTargetingOptions)super.setFields(fields);
                }

                public BulkListAssignedTargetingOptions setKey(String key) {
                    return (BulkListAssignedTargetingOptions)super.setKey(key);
                }

                public BulkListAssignedTargetingOptions setOauthToken(String oauthToken) {
                    return (BulkListAssignedTargetingOptions)super.setOauthToken(oauthToken);
                }

                public BulkListAssignedTargetingOptions setPrettyPrint(Boolean prettyPrint) {
                    return (BulkListAssignedTargetingOptions)super.setPrettyPrint(prettyPrint);
                }

                public BulkListAssignedTargetingOptions setQuotaUser(String quotaUser) {
                    return (BulkListAssignedTargetingOptions)super.setQuotaUser(quotaUser);
                }

                public BulkListAssignedTargetingOptions setUploadType(String uploadType) {
                    return (BulkListAssignedTargetingOptions)super.setUploadType(uploadType);
                }

                public BulkListAssignedTargetingOptions setUploadProtocol(String uploadProtocol) {
                    return (BulkListAssignedTargetingOptions)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public BulkListAssignedTargetingOptions setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public BulkListAssignedTargetingOptions setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public java.util.List<Long> getLineItemIds() {
                    return this.lineItemIds;
                }

                public BulkListAssignedTargetingOptions setLineItemIds(java.util.List<Long> lineItemIds) {
                    this.lineItemIds = lineItemIds;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public BulkListAssignedTargetingOptions setOrderBy(String orderBy) {
                    this.orderBy = orderBy;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public BulkListAssignedTargetingOptions setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public BulkListAssignedTargetingOptions setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public BulkListAssignedTargetingOptions set(String parameterName, Object value) {
                    return (BulkListAssignedTargetingOptions)super.set(parameterName, value);
                }
            }

            public class BulkEditAssignedTargetingOptions
            extends DisplayVideoRequest<BulkEditAssignedTargetingOptionsResponse> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/lineItems:bulkEditAssignedTargetingOptions";
                private final Pattern ADVERTISER_ID_PATTERN;
                @Key
                private Long advertiserId;

                protected BulkEditAssignedTargetingOptions(Long advertiserId, BulkEditAssignedTargetingOptionsRequest content) {
                    super(DisplayVideo.this, "POST", REST_PATH, (Object)content, BulkEditAssignedTargetingOptionsResponse.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                }

                public BulkEditAssignedTargetingOptions set$Xgafv(String $Xgafv) {
                    return (BulkEditAssignedTargetingOptions)super.set$Xgafv($Xgafv);
                }

                public BulkEditAssignedTargetingOptions setAccessToken(String accessToken) {
                    return (BulkEditAssignedTargetingOptions)super.setAccessToken(accessToken);
                }

                public BulkEditAssignedTargetingOptions setAlt(String alt) {
                    return (BulkEditAssignedTargetingOptions)super.setAlt(alt);
                }

                public BulkEditAssignedTargetingOptions setCallback(String callback) {
                    return (BulkEditAssignedTargetingOptions)super.setCallback(callback);
                }

                public BulkEditAssignedTargetingOptions setFields(String fields) {
                    return (BulkEditAssignedTargetingOptions)super.setFields(fields);
                }

                public BulkEditAssignedTargetingOptions setKey(String key) {
                    return (BulkEditAssignedTargetingOptions)super.setKey(key);
                }

                public BulkEditAssignedTargetingOptions setOauthToken(String oauthToken) {
                    return (BulkEditAssignedTargetingOptions)super.setOauthToken(oauthToken);
                }

                public BulkEditAssignedTargetingOptions setPrettyPrint(Boolean prettyPrint) {
                    return (BulkEditAssignedTargetingOptions)super.setPrettyPrint(prettyPrint);
                }

                public BulkEditAssignedTargetingOptions setQuotaUser(String quotaUser) {
                    return (BulkEditAssignedTargetingOptions)super.setQuotaUser(quotaUser);
                }

                public BulkEditAssignedTargetingOptions setUploadType(String uploadType) {
                    return (BulkEditAssignedTargetingOptions)super.setUploadType(uploadType);
                }

                public BulkEditAssignedTargetingOptions setUploadProtocol(String uploadProtocol) {
                    return (BulkEditAssignedTargetingOptions)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public BulkEditAssignedTargetingOptions setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                @Override
                public BulkEditAssignedTargetingOptions set(String parameterName, Object value) {
                    return (BulkEditAssignedTargetingOptions)super.set(parameterName, value);
                }
            }
        }

        public class Invoices {
            public List list(Long advertiserId) throws IOException {
                List result = new List(advertiserId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public LookupInvoiceCurrency lookupInvoiceCurrency(Long advertiserId) throws IOException {
                LookupInvoiceCurrency result = new LookupInvoiceCurrency(advertiserId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class LookupInvoiceCurrency
            extends DisplayVideoRequest<LookupInvoiceCurrencyResponse> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/invoices:lookupInvoiceCurrency";
                private final Pattern ADVERTISER_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private String invoiceMonth;

                protected LookupInvoiceCurrency(Long advertiserId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, LookupInvoiceCurrencyResponse.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public LookupInvoiceCurrency set$Xgafv(String $Xgafv) {
                    return (LookupInvoiceCurrency)super.set$Xgafv($Xgafv);
                }

                public LookupInvoiceCurrency setAccessToken(String accessToken) {
                    return (LookupInvoiceCurrency)super.setAccessToken(accessToken);
                }

                public LookupInvoiceCurrency setAlt(String alt) {
                    return (LookupInvoiceCurrency)super.setAlt(alt);
                }

                public LookupInvoiceCurrency setCallback(String callback) {
                    return (LookupInvoiceCurrency)super.setCallback(callback);
                }

                public LookupInvoiceCurrency setFields(String fields) {
                    return (LookupInvoiceCurrency)super.setFields(fields);
                }

                public LookupInvoiceCurrency setKey(String key) {
                    return (LookupInvoiceCurrency)super.setKey(key);
                }

                public LookupInvoiceCurrency setOauthToken(String oauthToken) {
                    return (LookupInvoiceCurrency)super.setOauthToken(oauthToken);
                }

                public LookupInvoiceCurrency setPrettyPrint(Boolean prettyPrint) {
                    return (LookupInvoiceCurrency)super.setPrettyPrint(prettyPrint);
                }

                public LookupInvoiceCurrency setQuotaUser(String quotaUser) {
                    return (LookupInvoiceCurrency)super.setQuotaUser(quotaUser);
                }

                public LookupInvoiceCurrency setUploadType(String uploadType) {
                    return (LookupInvoiceCurrency)super.setUploadType(uploadType);
                }

                public LookupInvoiceCurrency setUploadProtocol(String uploadProtocol) {
                    return (LookupInvoiceCurrency)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public LookupInvoiceCurrency setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public String getInvoiceMonth() {
                    return this.invoiceMonth;
                }

                public LookupInvoiceCurrency setInvoiceMonth(String invoiceMonth) {
                    this.invoiceMonth = invoiceMonth;
                    return this;
                }

                @Override
                public LookupInvoiceCurrency set(String parameterName, Object value) {
                    return (LookupInvoiceCurrency)super.set(parameterName, value);
                }
            }

            public class List
            extends DisplayVideoRequest<ListInvoicesResponse> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/invoices";
                private final Pattern ADVERTISER_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private String issueMonth;
                @Key
                private String loiSapinInvoiceType;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(Long advertiserId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, ListInvoicesResponse.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public List setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public String getIssueMonth() {
                    return this.issueMonth;
                }

                public List setIssueMonth(String issueMonth) {
                    this.issueMonth = issueMonth;
                    return this;
                }

                public String getLoiSapinInvoiceType() {
                    return this.loiSapinInvoiceType;
                }

                public List setLoiSapinInvoiceType(String loiSapinInvoiceType) {
                    this.loiSapinInvoiceType = loiSapinInvoiceType;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }
        }

        public class InsertionOrders {
            public Create create(Long advertiserId, InsertionOrder content) throws IOException {
                Create result = new Create(advertiserId, content);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(Long advertiserId, Long insertionOrderId) throws IOException {
                Delete result = new Delete(advertiserId, insertionOrderId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(Long advertiserId, Long insertionOrderId) throws IOException {
                Get result = new Get(advertiserId, insertionOrderId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(Long advertiserId) throws IOException {
                List result = new List(advertiserId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public ListAssignedTargetingOptions listAssignedTargetingOptions(Long advertiserId, Long insertionOrderId) throws IOException {
                ListAssignedTargetingOptions result = new ListAssignedTargetingOptions(advertiserId, insertionOrderId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(Long advertiserId, Long insertionOrderId, InsertionOrder content) throws IOException {
                Patch result = new Patch(advertiserId, insertionOrderId, content);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public TargetingTypes targetingTypes() {
                return new TargetingTypes();
            }

            public class TargetingTypes {
                public AssignedTargetingOptions assignedTargetingOptions() {
                    return new AssignedTargetingOptions();
                }

                public class AssignedTargetingOptions {
                    public Create create(Long advertiserId, Long insertionOrderId, String targetingType, AssignedTargetingOption content) throws IOException {
                        Create result = new Create(advertiserId, insertionOrderId, targetingType, content);
                        DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Delete delete(Long advertiserId, Long insertionOrderId, String targetingType, String assignedTargetingOptionId) throws IOException {
                        Delete result = new Delete(advertiserId, insertionOrderId, targetingType, assignedTargetingOptionId);
                        DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Get get(Long advertiserId, Long insertionOrderId, String targetingType, String assignedTargetingOptionId) throws IOException {
                        Get result = new Get(advertiserId, insertionOrderId, targetingType, assignedTargetingOptionId);
                        DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public List list(Long advertiserId, Long insertionOrderId, String targetingType) throws IOException {
                        List result = new List(advertiserId, insertionOrderId, targetingType);
                        DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class List
                    extends DisplayVideoRequest<ListInsertionOrderAssignedTargetingOptionsResponse> {
                        private static final String REST_PATH = "v2/advertisers/{+advertiserId}/insertionOrders/{+insertionOrderId}/targetingTypes/{+targetingType}/assignedTargetingOptions";
                        private final Pattern ADVERTISER_ID_PATTERN;
                        private final Pattern INSERTION_ORDER_ID_PATTERN;
                        private final Pattern TARGETING_TYPE_PATTERN;
                        @Key
                        private Long advertiserId;
                        @Key
                        private Long insertionOrderId;
                        @Key
                        private String targetingType;
                        @Key
                        private String filter;
                        @Key
                        private String orderBy;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(Long advertiserId, Long insertionOrderId, String targetingType) {
                            super(DisplayVideo.this, "GET", REST_PATH, null, ListInsertionOrderAssignedTargetingOptionsResponse.class);
                            this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                            this.INSERTION_ORDER_ID_PATTERN = Pattern.compile("^[^/]+$");
                            this.TARGETING_TYPE_PATTERN = Pattern.compile("^[^/]+$");
                            this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                            this.insertionOrderId = (Long)Preconditions.checkNotNull((Object)insertionOrderId, (Object)"Required parameter insertionOrderId must be specified.");
                            this.targetingType = (String)Preconditions.checkNotNull((Object)targetingType, (Object)"Required parameter targetingType must be specified.");
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public Long getAdvertiserId() {
                            return this.advertiserId;
                        }

                        public List setAdvertiserId(Long advertiserId) {
                            this.advertiserId = advertiserId;
                            return this;
                        }

                        public Long getInsertionOrderId() {
                            return this.insertionOrderId;
                        }

                        public List setInsertionOrderId(Long insertionOrderId) {
                            this.insertionOrderId = insertionOrderId;
                            return this;
                        }

                        public String getTargetingType() {
                            return this.targetingType;
                        }

                        public List setTargetingType(String targetingType) {
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                            }
                            this.targetingType = targetingType;
                            return this;
                        }

                        public String getFilter() {
                            return this.filter;
                        }

                        public List setFilter(String filter) {
                            this.filter = filter;
                            return this;
                        }

                        public String getOrderBy() {
                            return this.orderBy;
                        }

                        public List setOrderBy(String orderBy) {
                            this.orderBy = orderBy;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }

                    public class Get
                    extends DisplayVideoRequest<AssignedTargetingOption> {
                        private static final String REST_PATH = "v2/advertisers/{+advertiserId}/insertionOrders/{+insertionOrderId}/targetingTypes/{+targetingType}/assignedTargetingOptions/{+assignedTargetingOptionId}";
                        private final Pattern ADVERTISER_ID_PATTERN;
                        private final Pattern INSERTION_ORDER_ID_PATTERN;
                        private final Pattern TARGETING_TYPE_PATTERN;
                        private final Pattern ASSIGNED_TARGETING_OPTION_ID_PATTERN;
                        @Key
                        private Long advertiserId;
                        @Key
                        private Long insertionOrderId;
                        @Key
                        private String targetingType;
                        @Key
                        private String assignedTargetingOptionId;

                        protected Get(Long advertiserId, Long insertionOrderId, String targetingType, String assignedTargetingOptionId) {
                            super(DisplayVideo.this, "GET", REST_PATH, null, AssignedTargetingOption.class);
                            this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                            this.INSERTION_ORDER_ID_PATTERN = Pattern.compile("^[^/]+$");
                            this.TARGETING_TYPE_PATTERN = Pattern.compile("^[^/]+$");
                            this.ASSIGNED_TARGETING_OPTION_ID_PATTERN = Pattern.compile("^[^/]+$");
                            this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                            this.insertionOrderId = (Long)Preconditions.checkNotNull((Object)insertionOrderId, (Object)"Required parameter insertionOrderId must be specified.");
                            this.targetingType = (String)Preconditions.checkNotNull((Object)targetingType, (Object)"Required parameter targetingType must be specified.");
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                            }
                            this.assignedTargetingOptionId = (String)Preconditions.checkNotNull((Object)assignedTargetingOptionId, (Object)"Required parameter assignedTargetingOptionId must be specified.");
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.ASSIGNED_TARGETING_OPTION_ID_PATTERN.matcher(assignedTargetingOptionId).matches(), (Object)"Parameter assignedTargetingOptionId must conform to the pattern ^[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String $Xgafv) {
                            return (Get)super.set$Xgafv($Xgafv);
                        }

                        public Get setAccessToken(String accessToken) {
                            return (Get)super.setAccessToken(accessToken);
                        }

                        public Get setAlt(String alt) {
                            return (Get)super.setAlt(alt);
                        }

                        public Get setCallback(String callback) {
                            return (Get)super.setCallback(callback);
                        }

                        public Get setFields(String fields) {
                            return (Get)super.setFields(fields);
                        }

                        public Get setKey(String key) {
                            return (Get)super.setKey(key);
                        }

                        public Get setOauthToken(String oauthToken) {
                            return (Get)super.setOauthToken(oauthToken);
                        }

                        public Get setPrettyPrint(Boolean prettyPrint) {
                            return (Get)super.setPrettyPrint(prettyPrint);
                        }

                        public Get setQuotaUser(String quotaUser) {
                            return (Get)super.setQuotaUser(quotaUser);
                        }

                        public Get setUploadType(String uploadType) {
                            return (Get)super.setUploadType(uploadType);
                        }

                        public Get setUploadProtocol(String uploadProtocol) {
                            return (Get)super.setUploadProtocol(uploadProtocol);
                        }

                        public Long getAdvertiserId() {
                            return this.advertiserId;
                        }

                        public Get setAdvertiserId(Long advertiserId) {
                            this.advertiserId = advertiserId;
                            return this;
                        }

                        public Long getInsertionOrderId() {
                            return this.insertionOrderId;
                        }

                        public Get setInsertionOrderId(Long insertionOrderId) {
                            this.insertionOrderId = insertionOrderId;
                            return this;
                        }

                        public String getTargetingType() {
                            return this.targetingType;
                        }

                        public Get setTargetingType(String targetingType) {
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                            }
                            this.targetingType = targetingType;
                            return this;
                        }

                        public String getAssignedTargetingOptionId() {
                            return this.assignedTargetingOptionId;
                        }

                        public Get setAssignedTargetingOptionId(String assignedTargetingOptionId) {
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.ASSIGNED_TARGETING_OPTION_ID_PATTERN.matcher(assignedTargetingOptionId).matches(), (Object)"Parameter assignedTargetingOptionId must conform to the pattern ^[^/]+$");
                            }
                            this.assignedTargetingOptionId = assignedTargetingOptionId;
                            return this;
                        }

                        @Override
                        public Get set(String parameterName, Object value) {
                            return (Get)super.set(parameterName, value);
                        }
                    }

                    public class Delete
                    extends DisplayVideoRequest<Empty> {
                        private static final String REST_PATH = "v2/advertisers/{+advertiserId}/insertionOrders/{+insertionOrderId}/targetingTypes/{+targetingType}/assignedTargetingOptions/{+assignedTargetingOptionId}";
                        private final Pattern ADVERTISER_ID_PATTERN;
                        private final Pattern INSERTION_ORDER_ID_PATTERN;
                        private final Pattern TARGETING_TYPE_PATTERN;
                        private final Pattern ASSIGNED_TARGETING_OPTION_ID_PATTERN;
                        @Key
                        private Long advertiserId;
                        @Key
                        private Long insertionOrderId;
                        @Key
                        private String targetingType;
                        @Key
                        private String assignedTargetingOptionId;

                        protected Delete(Long advertiserId, Long insertionOrderId, String targetingType, String assignedTargetingOptionId) {
                            super(DisplayVideo.this, "DELETE", REST_PATH, null, Empty.class);
                            this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                            this.INSERTION_ORDER_ID_PATTERN = Pattern.compile("^[^/]+$");
                            this.TARGETING_TYPE_PATTERN = Pattern.compile("^[^/]+$");
                            this.ASSIGNED_TARGETING_OPTION_ID_PATTERN = Pattern.compile("^[^/]+$");
                            this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                            this.insertionOrderId = (Long)Preconditions.checkNotNull((Object)insertionOrderId, (Object)"Required parameter insertionOrderId must be specified.");
                            this.targetingType = (String)Preconditions.checkNotNull((Object)targetingType, (Object)"Required parameter targetingType must be specified.");
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                            }
                            this.assignedTargetingOptionId = (String)Preconditions.checkNotNull((Object)assignedTargetingOptionId, (Object)"Required parameter assignedTargetingOptionId must be specified.");
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.ASSIGNED_TARGETING_OPTION_ID_PATTERN.matcher(assignedTargetingOptionId).matches(), (Object)"Parameter assignedTargetingOptionId must conform to the pattern ^[^/]+$");
                            }
                        }

                        public Delete set$Xgafv(String $Xgafv) {
                            return (Delete)super.set$Xgafv($Xgafv);
                        }

                        public Delete setAccessToken(String accessToken) {
                            return (Delete)super.setAccessToken(accessToken);
                        }

                        public Delete setAlt(String alt) {
                            return (Delete)super.setAlt(alt);
                        }

                        public Delete setCallback(String callback) {
                            return (Delete)super.setCallback(callback);
                        }

                        public Delete setFields(String fields) {
                            return (Delete)super.setFields(fields);
                        }

                        public Delete setKey(String key) {
                            return (Delete)super.setKey(key);
                        }

                        public Delete setOauthToken(String oauthToken) {
                            return (Delete)super.setOauthToken(oauthToken);
                        }

                        public Delete setPrettyPrint(Boolean prettyPrint) {
                            return (Delete)super.setPrettyPrint(prettyPrint);
                        }

                        public Delete setQuotaUser(String quotaUser) {
                            return (Delete)super.setQuotaUser(quotaUser);
                        }

                        public Delete setUploadType(String uploadType) {
                            return (Delete)super.setUploadType(uploadType);
                        }

                        public Delete setUploadProtocol(String uploadProtocol) {
                            return (Delete)super.setUploadProtocol(uploadProtocol);
                        }

                        public Long getAdvertiserId() {
                            return this.advertiserId;
                        }

                        public Delete setAdvertiserId(Long advertiserId) {
                            this.advertiserId = advertiserId;
                            return this;
                        }

                        public Long getInsertionOrderId() {
                            return this.insertionOrderId;
                        }

                        public Delete setInsertionOrderId(Long insertionOrderId) {
                            this.insertionOrderId = insertionOrderId;
                            return this;
                        }

                        public String getTargetingType() {
                            return this.targetingType;
                        }

                        public Delete setTargetingType(String targetingType) {
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                            }
                            this.targetingType = targetingType;
                            return this;
                        }

                        public String getAssignedTargetingOptionId() {
                            return this.assignedTargetingOptionId;
                        }

                        public Delete setAssignedTargetingOptionId(String assignedTargetingOptionId) {
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.ASSIGNED_TARGETING_OPTION_ID_PATTERN.matcher(assignedTargetingOptionId).matches(), (Object)"Parameter assignedTargetingOptionId must conform to the pattern ^[^/]+$");
                            }
                            this.assignedTargetingOptionId = assignedTargetingOptionId;
                            return this;
                        }

                        @Override
                        public Delete set(String parameterName, Object value) {
                            return (Delete)super.set(parameterName, value);
                        }
                    }

                    public class Create
                    extends DisplayVideoRequest<AssignedTargetingOption> {
                        private static final String REST_PATH = "v2/advertisers/{+advertiserId}/insertionOrders/{+insertionOrderId}/targetingTypes/{+targetingType}/assignedTargetingOptions";
                        private final Pattern ADVERTISER_ID_PATTERN;
                        private final Pattern INSERTION_ORDER_ID_PATTERN;
                        private final Pattern TARGETING_TYPE_PATTERN;
                        @Key
                        private Long advertiserId;
                        @Key
                        private Long insertionOrderId;
                        @Key
                        private String targetingType;

                        protected Create(Long advertiserId, Long insertionOrderId, String targetingType, AssignedTargetingOption content) {
                            super(DisplayVideo.this, "POST", REST_PATH, (Object)content, AssignedTargetingOption.class);
                            this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                            this.INSERTION_ORDER_ID_PATTERN = Pattern.compile("^[^/]+$");
                            this.TARGETING_TYPE_PATTERN = Pattern.compile("^[^/]+$");
                            this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                            this.insertionOrderId = (Long)Preconditions.checkNotNull((Object)insertionOrderId, (Object)"Required parameter insertionOrderId must be specified.");
                            this.targetingType = (String)Preconditions.checkNotNull((Object)targetingType, (Object)"Required parameter targetingType must be specified.");
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                            }
                        }

                        public Create set$Xgafv(String $Xgafv) {
                            return (Create)super.set$Xgafv($Xgafv);
                        }

                        public Create setAccessToken(String accessToken) {
                            return (Create)super.setAccessToken(accessToken);
                        }

                        public Create setAlt(String alt) {
                            return (Create)super.setAlt(alt);
                        }

                        public Create setCallback(String callback) {
                            return (Create)super.setCallback(callback);
                        }

                        public Create setFields(String fields) {
                            return (Create)super.setFields(fields);
                        }

                        public Create setKey(String key) {
                            return (Create)super.setKey(key);
                        }

                        public Create setOauthToken(String oauthToken) {
                            return (Create)super.setOauthToken(oauthToken);
                        }

                        public Create setPrettyPrint(Boolean prettyPrint) {
                            return (Create)super.setPrettyPrint(prettyPrint);
                        }

                        public Create setQuotaUser(String quotaUser) {
                            return (Create)super.setQuotaUser(quotaUser);
                        }

                        public Create setUploadType(String uploadType) {
                            return (Create)super.setUploadType(uploadType);
                        }

                        public Create setUploadProtocol(String uploadProtocol) {
                            return (Create)super.setUploadProtocol(uploadProtocol);
                        }

                        public Long getAdvertiserId() {
                            return this.advertiserId;
                        }

                        public Create setAdvertiserId(Long advertiserId) {
                            this.advertiserId = advertiserId;
                            return this;
                        }

                        public Long getInsertionOrderId() {
                            return this.insertionOrderId;
                        }

                        public Create setInsertionOrderId(Long insertionOrderId) {
                            this.insertionOrderId = insertionOrderId;
                            return this;
                        }

                        public String getTargetingType() {
                            return this.targetingType;
                        }

                        public Create setTargetingType(String targetingType) {
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                            }
                            this.targetingType = targetingType;
                            return this;
                        }

                        @Override
                        public Create set(String parameterName, Object value) {
                            return (Create)super.set(parameterName, value);
                        }
                    }
                }
            }

            public class Patch
            extends DisplayVideoRequest<InsertionOrder> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/insertionOrders/{+insertionOrderId}";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern INSERTION_ORDER_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long insertionOrderId;
                @Key
                private String updateMask;

                protected Patch(Long advertiserId, Long insertionOrderId, InsertionOrder content) {
                    super(DisplayVideo.this, "PATCH", REST_PATH, (Object)content, InsertionOrder.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.INSERTION_ORDER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.insertionOrderId = (Long)Preconditions.checkNotNull((Object)insertionOrderId, (Object)"Required parameter insertionOrderId must be specified.");
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Patch setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getInsertionOrderId() {
                    return this.insertionOrderId;
                }

                public Patch setInsertionOrderId(Long insertionOrderId) {
                    this.insertionOrderId = insertionOrderId;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class ListAssignedTargetingOptions
            extends DisplayVideoRequest<BulkListInsertionOrderAssignedTargetingOptionsResponse> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/insertionOrders/{+insertionOrderId}:listAssignedTargetingOptions";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern INSERTION_ORDER_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long insertionOrderId;
                @Key
                private String filter;
                @Key
                private String orderBy;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected ListAssignedTargetingOptions(Long advertiserId, Long insertionOrderId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, BulkListInsertionOrderAssignedTargetingOptionsResponse.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.INSERTION_ORDER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.insertionOrderId = (Long)Preconditions.checkNotNull((Object)insertionOrderId, (Object)"Required parameter insertionOrderId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public ListAssignedTargetingOptions set$Xgafv(String $Xgafv) {
                    return (ListAssignedTargetingOptions)super.set$Xgafv($Xgafv);
                }

                public ListAssignedTargetingOptions setAccessToken(String accessToken) {
                    return (ListAssignedTargetingOptions)super.setAccessToken(accessToken);
                }

                public ListAssignedTargetingOptions setAlt(String alt) {
                    return (ListAssignedTargetingOptions)super.setAlt(alt);
                }

                public ListAssignedTargetingOptions setCallback(String callback) {
                    return (ListAssignedTargetingOptions)super.setCallback(callback);
                }

                public ListAssignedTargetingOptions setFields(String fields) {
                    return (ListAssignedTargetingOptions)super.setFields(fields);
                }

                public ListAssignedTargetingOptions setKey(String key) {
                    return (ListAssignedTargetingOptions)super.setKey(key);
                }

                public ListAssignedTargetingOptions setOauthToken(String oauthToken) {
                    return (ListAssignedTargetingOptions)super.setOauthToken(oauthToken);
                }

                public ListAssignedTargetingOptions setPrettyPrint(Boolean prettyPrint) {
                    return (ListAssignedTargetingOptions)super.setPrettyPrint(prettyPrint);
                }

                public ListAssignedTargetingOptions setQuotaUser(String quotaUser) {
                    return (ListAssignedTargetingOptions)super.setQuotaUser(quotaUser);
                }

                public ListAssignedTargetingOptions setUploadType(String uploadType) {
                    return (ListAssignedTargetingOptions)super.setUploadType(uploadType);
                }

                public ListAssignedTargetingOptions setUploadProtocol(String uploadProtocol) {
                    return (ListAssignedTargetingOptions)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public ListAssignedTargetingOptions setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getInsertionOrderId() {
                    return this.insertionOrderId;
                }

                public ListAssignedTargetingOptions setInsertionOrderId(Long insertionOrderId) {
                    this.insertionOrderId = insertionOrderId;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public ListAssignedTargetingOptions setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public ListAssignedTargetingOptions setOrderBy(String orderBy) {
                    this.orderBy = orderBy;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public ListAssignedTargetingOptions setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public ListAssignedTargetingOptions setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public ListAssignedTargetingOptions set(String parameterName, Object value) {
                    return (ListAssignedTargetingOptions)super.set(parameterName, value);
                }
            }

            public class List
            extends DisplayVideoRequest<ListInsertionOrdersResponse> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/insertionOrders";
                private final Pattern ADVERTISER_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private String filter;
                @Key
                private String orderBy;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(Long advertiserId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, ListInsertionOrdersResponse.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public List setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public List setOrderBy(String orderBy) {
                    this.orderBy = orderBy;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends DisplayVideoRequest<InsertionOrder> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/insertionOrders/{+insertionOrderId}";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern INSERTION_ORDER_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long insertionOrderId;

                protected Get(Long advertiserId, Long insertionOrderId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, InsertionOrder.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.INSERTION_ORDER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.insertionOrderId = (Long)Preconditions.checkNotNull((Object)insertionOrderId, (Object)"Required parameter insertionOrderId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Get setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getInsertionOrderId() {
                    return this.insertionOrderId;
                }

                public Get setInsertionOrderId(Long insertionOrderId) {
                    this.insertionOrderId = insertionOrderId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends DisplayVideoRequest<Empty> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/insertionOrders/{+insertionOrderId}";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern INSERTION_ORDER_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long insertionOrderId;

                protected Delete(Long advertiserId, Long insertionOrderId) {
                    super(DisplayVideo.this, "DELETE", REST_PATH, null, Empty.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.INSERTION_ORDER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.insertionOrderId = (Long)Preconditions.checkNotNull((Object)insertionOrderId, (Object)"Required parameter insertionOrderId must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Delete setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getInsertionOrderId() {
                    return this.insertionOrderId;
                }

                public Delete setInsertionOrderId(Long insertionOrderId) {
                    this.insertionOrderId = insertionOrderId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends DisplayVideoRequest<InsertionOrder> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/insertionOrders";
                private final Pattern ADVERTISER_ID_PATTERN;
                @Key
                private Long advertiserId;

                protected Create(Long advertiserId, InsertionOrder content) {
                    super(DisplayVideo.this, "POST", REST_PATH, (Object)content, InsertionOrder.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Create setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Creatives {
            public Create create(Long advertiserId, Creative content) throws IOException {
                Create result = new Create(advertiserId, content);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(Long advertiserId, Long creativeId) throws IOException {
                Delete result = new Delete(advertiserId, creativeId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(Long advertiserId, Long creativeId) throws IOException {
                Get result = new Get(advertiserId, creativeId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(Long advertiserId) throws IOException {
                List result = new List(advertiserId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(Long advertiserId, Long creativeId, Creative content) throws IOException {
                Patch result = new Patch(advertiserId, creativeId, content);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Patch
            extends DisplayVideoRequest<Creative> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/creatives/{+creativeId}";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern CREATIVE_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long creativeId;
                @Key
                private String updateMask;

                protected Patch(Long advertiserId, Long creativeId, Creative content) {
                    super(DisplayVideo.this, "PATCH", REST_PATH, (Object)content, Creative.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.CREATIVE_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.creativeId = (Long)Preconditions.checkNotNull((Object)creativeId, (Object)"Required parameter creativeId must be specified.");
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Patch setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getCreativeId() {
                    return this.creativeId;
                }

                public Patch setCreativeId(Long creativeId) {
                    this.creativeId = creativeId;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends DisplayVideoRequest<ListCreativesResponse> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/creatives";
                private final Pattern ADVERTISER_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private String filter;
                @Key
                private String orderBy;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(Long advertiserId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, ListCreativesResponse.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public List setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public List setOrderBy(String orderBy) {
                    this.orderBy = orderBy;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends DisplayVideoRequest<Creative> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/creatives/{+creativeId}";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern CREATIVE_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long creativeId;

                protected Get(Long advertiserId, Long creativeId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, Creative.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.CREATIVE_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.creativeId = (Long)Preconditions.checkNotNull((Object)creativeId, (Object)"Required parameter creativeId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Get setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getCreativeId() {
                    return this.creativeId;
                }

                public Get setCreativeId(Long creativeId) {
                    this.creativeId = creativeId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends DisplayVideoRequest<Empty> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/creatives/{+creativeId}";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern CREATIVE_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long creativeId;

                protected Delete(Long advertiserId, Long creativeId) {
                    super(DisplayVideo.this, "DELETE", REST_PATH, null, Empty.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.CREATIVE_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.creativeId = (Long)Preconditions.checkNotNull((Object)creativeId, (Object)"Required parameter creativeId must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Delete setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getCreativeId() {
                    return this.creativeId;
                }

                public Delete setCreativeId(Long creativeId) {
                    this.creativeId = creativeId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends DisplayVideoRequest<Creative> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/creatives";
                private final Pattern ADVERTISER_ID_PATTERN;
                @Key
                private Long advertiserId;

                protected Create(Long advertiserId, Creative content) {
                    super(DisplayVideo.this, "POST", REST_PATH, (Object)content, Creative.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Create setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Channels {
            public Create create(Long advertiserId, Channel content) throws IOException {
                Create result = new Create(advertiserId, content);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(Long advertiserId, Long channelId) throws IOException {
                Get result = new Get(advertiserId, channelId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(Long advertiserId) throws IOException {
                List result = new List(advertiserId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(Long advertiserId, Long channelId, Channel content) throws IOException {
                Patch result = new Patch(advertiserId, channelId, content);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Sites sites() {
                return new Sites();
            }

            public class Sites {
                public BulkEdit bulkEdit(Long advertiserId, Long channelId, BulkEditSitesRequest content) throws IOException {
                    BulkEdit result = new BulkEdit(advertiserId, channelId, content);
                    DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Create create(Long advertiserId, Long channelId, Site content) throws IOException {
                    Create result = new Create(advertiserId, channelId, content);
                    DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(Long advertiserId, Long channelId, String urlOrAppId) throws IOException {
                    Delete result = new Delete(advertiserId, channelId, urlOrAppId);
                    DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(Long advertiserId, Long channelId) throws IOException {
                    List result = new List(advertiserId, channelId);
                    DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Replace replace(Long advertiserId, Long channelId, ReplaceSitesRequest content) throws IOException {
                    Replace result = new Replace(advertiserId, channelId, content);
                    DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class Replace
                extends DisplayVideoRequest<ReplaceSitesResponse> {
                    private static final String REST_PATH = "v2/advertisers/{advertiserId}/channels/{+channelId}/sites:replace";
                    private final Pattern CHANNEL_ID_PATTERN;
                    @Key
                    private Long advertiserId;
                    @Key
                    private Long channelId;

                    protected Replace(Long advertiserId, Long channelId, ReplaceSitesRequest content) {
                        super(DisplayVideo.this, "POST", REST_PATH, (Object)content, ReplaceSitesResponse.class);
                        this.CHANNEL_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                        this.channelId = (Long)Preconditions.checkNotNull((Object)channelId, (Object)"Required parameter channelId must be specified.");
                    }

                    public Replace set$Xgafv(String $Xgafv) {
                        return (Replace)super.set$Xgafv($Xgafv);
                    }

                    public Replace setAccessToken(String accessToken) {
                        return (Replace)super.setAccessToken(accessToken);
                    }

                    public Replace setAlt(String alt) {
                        return (Replace)super.setAlt(alt);
                    }

                    public Replace setCallback(String callback) {
                        return (Replace)super.setCallback(callback);
                    }

                    public Replace setFields(String fields) {
                        return (Replace)super.setFields(fields);
                    }

                    public Replace setKey(String key) {
                        return (Replace)super.setKey(key);
                    }

                    public Replace setOauthToken(String oauthToken) {
                        return (Replace)super.setOauthToken(oauthToken);
                    }

                    public Replace setPrettyPrint(Boolean prettyPrint) {
                        return (Replace)super.setPrettyPrint(prettyPrint);
                    }

                    public Replace setQuotaUser(String quotaUser) {
                        return (Replace)super.setQuotaUser(quotaUser);
                    }

                    public Replace setUploadType(String uploadType) {
                        return (Replace)super.setUploadType(uploadType);
                    }

                    public Replace setUploadProtocol(String uploadProtocol) {
                        return (Replace)super.setUploadProtocol(uploadProtocol);
                    }

                    public Long getAdvertiserId() {
                        return this.advertiserId;
                    }

                    public Replace setAdvertiserId(Long advertiserId) {
                        this.advertiserId = advertiserId;
                        return this;
                    }

                    public Long getChannelId() {
                        return this.channelId;
                    }

                    public Replace setChannelId(Long channelId) {
                        this.channelId = channelId;
                        return this;
                    }

                    @Override
                    public Replace set(String parameterName, Object value) {
                        return (Replace)super.set(parameterName, value);
                    }
                }

                public class List
                extends DisplayVideoRequest<ListSitesResponse> {
                    private static final String REST_PATH = "v2/advertisers/{+advertiserId}/channels/{+channelId}/sites";
                    private final Pattern ADVERTISER_ID_PATTERN;
                    private final Pattern CHANNEL_ID_PATTERN;
                    @Key
                    private Long advertiserId;
                    @Key
                    private Long channelId;
                    @Key
                    private String filter;
                    @Key
                    private String orderBy;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;
                    @Key
                    private Long partnerId;

                    protected List(Long advertiserId, Long channelId) {
                        super(DisplayVideo.this, "GET", REST_PATH, null, ListSitesResponse.class);
                        this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.CHANNEL_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                        this.channelId = (Long)Preconditions.checkNotNull((Object)channelId, (Object)"Required parameter channelId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public Long getAdvertiserId() {
                        return this.advertiserId;
                    }

                    public List setAdvertiserId(Long advertiserId) {
                        this.advertiserId = advertiserId;
                        return this;
                    }

                    public Long getChannelId() {
                        return this.channelId;
                    }

                    public List setChannelId(Long channelId) {
                        this.channelId = channelId;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public String getOrderBy() {
                        return this.orderBy;
                    }

                    public List setOrderBy(String orderBy) {
                        this.orderBy = orderBy;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    public Long getPartnerId() {
                        return this.partnerId;
                    }

                    public List setPartnerId(Long partnerId) {
                        this.partnerId = partnerId;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends DisplayVideoRequest<Empty> {
                    private static final String REST_PATH = "v2/advertisers/{advertiserId}/channels/{+channelId}/sites/{+urlOrAppId}";
                    private final Pattern CHANNEL_ID_PATTERN;
                    private final Pattern URL_OR_APP_ID_PATTERN;
                    @Key
                    private Long advertiserId;
                    @Key
                    private Long channelId;
                    @Key
                    private String urlOrAppId;
                    @Key
                    private Long partnerId;

                    protected Delete(Long advertiserId, Long channelId, String urlOrAppId) {
                        super(DisplayVideo.this, "DELETE", REST_PATH, null, Empty.class);
                        this.CHANNEL_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.URL_OR_APP_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                        this.channelId = (Long)Preconditions.checkNotNull((Object)channelId, (Object)"Required parameter channelId must be specified.");
                        this.urlOrAppId = (String)Preconditions.checkNotNull((Object)urlOrAppId, (Object)"Required parameter urlOrAppId must be specified.");
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.URL_OR_APP_ID_PATTERN.matcher(urlOrAppId).matches(), (Object)"Parameter urlOrAppId must conform to the pattern ^[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public Long getAdvertiserId() {
                        return this.advertiserId;
                    }

                    public Delete setAdvertiserId(Long advertiserId) {
                        this.advertiserId = advertiserId;
                        return this;
                    }

                    public Long getChannelId() {
                        return this.channelId;
                    }

                    public Delete setChannelId(Long channelId) {
                        this.channelId = channelId;
                        return this;
                    }

                    public String getUrlOrAppId() {
                        return this.urlOrAppId;
                    }

                    public Delete setUrlOrAppId(String urlOrAppId) {
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.URL_OR_APP_ID_PATTERN.matcher(urlOrAppId).matches(), (Object)"Parameter urlOrAppId must conform to the pattern ^[^/]+$");
                        }
                        this.urlOrAppId = urlOrAppId;
                        return this;
                    }

                    public Long getPartnerId() {
                        return this.partnerId;
                    }

                    public Delete setPartnerId(Long partnerId) {
                        this.partnerId = partnerId;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends DisplayVideoRequest<Site> {
                    private static final String REST_PATH = "v2/advertisers/{advertiserId}/channels/{+channelId}/sites";
                    private final Pattern CHANNEL_ID_PATTERN;
                    @Key
                    private Long advertiserId;
                    @Key
                    private Long channelId;
                    @Key
                    private Long partnerId;

                    protected Create(Long advertiserId, Long channelId, Site content) {
                        super(DisplayVideo.this, "POST", REST_PATH, (Object)content, Site.class);
                        this.CHANNEL_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                        this.channelId = (Long)Preconditions.checkNotNull((Object)channelId, (Object)"Required parameter channelId must be specified.");
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public Long getAdvertiserId() {
                        return this.advertiserId;
                    }

                    public Create setAdvertiserId(Long advertiserId) {
                        this.advertiserId = advertiserId;
                        return this;
                    }

                    public Long getChannelId() {
                        return this.channelId;
                    }

                    public Create setChannelId(Long channelId) {
                        this.channelId = channelId;
                        return this;
                    }

                    public Long getPartnerId() {
                        return this.partnerId;
                    }

                    public Create setPartnerId(Long partnerId) {
                        this.partnerId = partnerId;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }

                public class BulkEdit
                extends DisplayVideoRequest<BulkEditSitesResponse> {
                    private static final String REST_PATH = "v2/advertisers/{advertiserId}/channels/{+channelId}/sites:bulkEdit";
                    private final Pattern CHANNEL_ID_PATTERN;
                    @Key
                    private Long advertiserId;
                    @Key
                    private Long channelId;

                    protected BulkEdit(Long advertiserId, Long channelId, BulkEditSitesRequest content) {
                        super(DisplayVideo.this, "POST", REST_PATH, (Object)content, BulkEditSitesResponse.class);
                        this.CHANNEL_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                        this.channelId = (Long)Preconditions.checkNotNull((Object)channelId, (Object)"Required parameter channelId must be specified.");
                    }

                    public BulkEdit set$Xgafv(String $Xgafv) {
                        return (BulkEdit)super.set$Xgafv($Xgafv);
                    }

                    public BulkEdit setAccessToken(String accessToken) {
                        return (BulkEdit)super.setAccessToken(accessToken);
                    }

                    public BulkEdit setAlt(String alt) {
                        return (BulkEdit)super.setAlt(alt);
                    }

                    public BulkEdit setCallback(String callback) {
                        return (BulkEdit)super.setCallback(callback);
                    }

                    public BulkEdit setFields(String fields) {
                        return (BulkEdit)super.setFields(fields);
                    }

                    public BulkEdit setKey(String key) {
                        return (BulkEdit)super.setKey(key);
                    }

                    public BulkEdit setOauthToken(String oauthToken) {
                        return (BulkEdit)super.setOauthToken(oauthToken);
                    }

                    public BulkEdit setPrettyPrint(Boolean prettyPrint) {
                        return (BulkEdit)super.setPrettyPrint(prettyPrint);
                    }

                    public BulkEdit setQuotaUser(String quotaUser) {
                        return (BulkEdit)super.setQuotaUser(quotaUser);
                    }

                    public BulkEdit setUploadType(String uploadType) {
                        return (BulkEdit)super.setUploadType(uploadType);
                    }

                    public BulkEdit setUploadProtocol(String uploadProtocol) {
                        return (BulkEdit)super.setUploadProtocol(uploadProtocol);
                    }

                    public Long getAdvertiserId() {
                        return this.advertiserId;
                    }

                    public BulkEdit setAdvertiserId(Long advertiserId) {
                        this.advertiserId = advertiserId;
                        return this;
                    }

                    public Long getChannelId() {
                        return this.channelId;
                    }

                    public BulkEdit setChannelId(Long channelId) {
                        this.channelId = channelId;
                        return this;
                    }

                    @Override
                    public BulkEdit set(String parameterName, Object value) {
                        return (BulkEdit)super.set(parameterName, value);
                    }
                }
            }

            public class Patch
            extends DisplayVideoRequest<Channel> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/channels/{channelId}";
                private final Pattern ADVERTISER_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long channelId;
                @Key
                private Long partnerId;
                @Key
                private String updateMask;

                protected Patch(Long advertiserId, Long channelId, Channel content) {
                    super(DisplayVideo.this, "PATCH", REST_PATH, (Object)content, Channel.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.channelId = (Long)Preconditions.checkNotNull((Object)channelId, (Object)"Required parameter channelId must be specified.");
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Patch setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getChannelId() {
                    return this.channelId;
                }

                public Patch setChannelId(Long channelId) {
                    this.channelId = channelId;
                    return this;
                }

                public Long getPartnerId() {
                    return this.partnerId;
                }

                public Patch setPartnerId(Long partnerId) {
                    this.partnerId = partnerId;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends DisplayVideoRequest<ListChannelsResponse> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/channels";
                private final Pattern ADVERTISER_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private String filter;
                @Key
                private String orderBy;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;
                @Key
                private Long partnerId;

                protected List(Long advertiserId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, ListChannelsResponse.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public List setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public List setOrderBy(String orderBy) {
                    this.orderBy = orderBy;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public Long getPartnerId() {
                    return this.partnerId;
                }

                public List setPartnerId(Long partnerId) {
                    this.partnerId = partnerId;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends DisplayVideoRequest<Channel> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/channels/{+channelId}";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern CHANNEL_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long channelId;
                @Key
                private Long partnerId;

                protected Get(Long advertiserId, Long channelId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, Channel.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.CHANNEL_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.channelId = (Long)Preconditions.checkNotNull((Object)channelId, (Object)"Required parameter channelId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Get setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getChannelId() {
                    return this.channelId;
                }

                public Get setChannelId(Long channelId) {
                    this.channelId = channelId;
                    return this;
                }

                public Long getPartnerId() {
                    return this.partnerId;
                }

                public Get setPartnerId(Long partnerId) {
                    this.partnerId = partnerId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Create
            extends DisplayVideoRequest<Channel> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/channels";
                private final Pattern ADVERTISER_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long partnerId;

                protected Create(Long advertiserId, Channel content) {
                    super(DisplayVideo.this, "POST", REST_PATH, (Object)content, Channel.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Create setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getPartnerId() {
                    return this.partnerId;
                }

                public Create setPartnerId(Long partnerId) {
                    this.partnerId = partnerId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Campaigns {
            public Create create(Long advertiserId, Campaign content) throws IOException {
                Create result = new Create(advertiserId, content);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(Long advertiserId, Long campaignId) throws IOException {
                Delete result = new Delete(advertiserId, campaignId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(Long advertiserId, Long campaignId) throws IOException {
                Get result = new Get(advertiserId, campaignId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(Long advertiserId) throws IOException {
                List result = new List(advertiserId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public ListAssignedTargetingOptions listAssignedTargetingOptions(Long advertiserId, Long campaignId) throws IOException {
                ListAssignedTargetingOptions result = new ListAssignedTargetingOptions(advertiserId, campaignId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(Long advertiserId, Long campaignId, Campaign content) throws IOException {
                Patch result = new Patch(advertiserId, campaignId, content);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public TargetingTypes targetingTypes() {
                return new TargetingTypes();
            }

            public class TargetingTypes {
                public AssignedTargetingOptions assignedTargetingOptions() {
                    return new AssignedTargetingOptions();
                }

                public class AssignedTargetingOptions {
                    public Get get(Long advertiserId, Long campaignId, String targetingType, String assignedTargetingOptionId) throws IOException {
                        Get result = new Get(advertiserId, campaignId, targetingType, assignedTargetingOptionId);
                        DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public List list(Long advertiserId, Long campaignId, String targetingType) throws IOException {
                        List result = new List(advertiserId, campaignId, targetingType);
                        DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class List
                    extends DisplayVideoRequest<ListCampaignAssignedTargetingOptionsResponse> {
                        private static final String REST_PATH = "v2/advertisers/{+advertiserId}/campaigns/{+campaignId}/targetingTypes/{+targetingType}/assignedTargetingOptions";
                        private final Pattern ADVERTISER_ID_PATTERN;
                        private final Pattern CAMPAIGN_ID_PATTERN;
                        private final Pattern TARGETING_TYPE_PATTERN;
                        @Key
                        private Long advertiserId;
                        @Key
                        private Long campaignId;
                        @Key
                        private String targetingType;
                        @Key
                        private String filter;
                        @Key
                        private String orderBy;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(Long advertiserId, Long campaignId, String targetingType) {
                            super(DisplayVideo.this, "GET", REST_PATH, null, ListCampaignAssignedTargetingOptionsResponse.class);
                            this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                            this.CAMPAIGN_ID_PATTERN = Pattern.compile("^[^/]+$");
                            this.TARGETING_TYPE_PATTERN = Pattern.compile("^[^/]+$");
                            this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                            this.campaignId = (Long)Preconditions.checkNotNull((Object)campaignId, (Object)"Required parameter campaignId must be specified.");
                            this.targetingType = (String)Preconditions.checkNotNull((Object)targetingType, (Object)"Required parameter targetingType must be specified.");
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public Long getAdvertiserId() {
                            return this.advertiserId;
                        }

                        public List setAdvertiserId(Long advertiserId) {
                            this.advertiserId = advertiserId;
                            return this;
                        }

                        public Long getCampaignId() {
                            return this.campaignId;
                        }

                        public List setCampaignId(Long campaignId) {
                            this.campaignId = campaignId;
                            return this;
                        }

                        public String getTargetingType() {
                            return this.targetingType;
                        }

                        public List setTargetingType(String targetingType) {
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                            }
                            this.targetingType = targetingType;
                            return this;
                        }

                        public String getFilter() {
                            return this.filter;
                        }

                        public List setFilter(String filter) {
                            this.filter = filter;
                            return this;
                        }

                        public String getOrderBy() {
                            return this.orderBy;
                        }

                        public List setOrderBy(String orderBy) {
                            this.orderBy = orderBy;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }

                    public class Get
                    extends DisplayVideoRequest<AssignedTargetingOption> {
                        private static final String REST_PATH = "v2/advertisers/{+advertiserId}/campaigns/{+campaignId}/targetingTypes/{+targetingType}/assignedTargetingOptions/{+assignedTargetingOptionId}";
                        private final Pattern ADVERTISER_ID_PATTERN;
                        private final Pattern CAMPAIGN_ID_PATTERN;
                        private final Pattern TARGETING_TYPE_PATTERN;
                        private final Pattern ASSIGNED_TARGETING_OPTION_ID_PATTERN;
                        @Key
                        private Long advertiserId;
                        @Key
                        private Long campaignId;
                        @Key
                        private String targetingType;
                        @Key
                        private String assignedTargetingOptionId;

                        protected Get(Long advertiserId, Long campaignId, String targetingType, String assignedTargetingOptionId) {
                            super(DisplayVideo.this, "GET", REST_PATH, null, AssignedTargetingOption.class);
                            this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                            this.CAMPAIGN_ID_PATTERN = Pattern.compile("^[^/]+$");
                            this.TARGETING_TYPE_PATTERN = Pattern.compile("^[^/]+$");
                            this.ASSIGNED_TARGETING_OPTION_ID_PATTERN = Pattern.compile("^[^/]+$");
                            this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                            this.campaignId = (Long)Preconditions.checkNotNull((Object)campaignId, (Object)"Required parameter campaignId must be specified.");
                            this.targetingType = (String)Preconditions.checkNotNull((Object)targetingType, (Object)"Required parameter targetingType must be specified.");
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                            }
                            this.assignedTargetingOptionId = (String)Preconditions.checkNotNull((Object)assignedTargetingOptionId, (Object)"Required parameter assignedTargetingOptionId must be specified.");
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.ASSIGNED_TARGETING_OPTION_ID_PATTERN.matcher(assignedTargetingOptionId).matches(), (Object)"Parameter assignedTargetingOptionId must conform to the pattern ^[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String $Xgafv) {
                            return (Get)super.set$Xgafv($Xgafv);
                        }

                        public Get setAccessToken(String accessToken) {
                            return (Get)super.setAccessToken(accessToken);
                        }

                        public Get setAlt(String alt) {
                            return (Get)super.setAlt(alt);
                        }

                        public Get setCallback(String callback) {
                            return (Get)super.setCallback(callback);
                        }

                        public Get setFields(String fields) {
                            return (Get)super.setFields(fields);
                        }

                        public Get setKey(String key) {
                            return (Get)super.setKey(key);
                        }

                        public Get setOauthToken(String oauthToken) {
                            return (Get)super.setOauthToken(oauthToken);
                        }

                        public Get setPrettyPrint(Boolean prettyPrint) {
                            return (Get)super.setPrettyPrint(prettyPrint);
                        }

                        public Get setQuotaUser(String quotaUser) {
                            return (Get)super.setQuotaUser(quotaUser);
                        }

                        public Get setUploadType(String uploadType) {
                            return (Get)super.setUploadType(uploadType);
                        }

                        public Get setUploadProtocol(String uploadProtocol) {
                            return (Get)super.setUploadProtocol(uploadProtocol);
                        }

                        public Long getAdvertiserId() {
                            return this.advertiserId;
                        }

                        public Get setAdvertiserId(Long advertiserId) {
                            this.advertiserId = advertiserId;
                            return this;
                        }

                        public Long getCampaignId() {
                            return this.campaignId;
                        }

                        public Get setCampaignId(Long campaignId) {
                            this.campaignId = campaignId;
                            return this;
                        }

                        public String getTargetingType() {
                            return this.targetingType;
                        }

                        public Get setTargetingType(String targetingType) {
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                            }
                            this.targetingType = targetingType;
                            return this;
                        }

                        public String getAssignedTargetingOptionId() {
                            return this.assignedTargetingOptionId;
                        }

                        public Get setAssignedTargetingOptionId(String assignedTargetingOptionId) {
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.ASSIGNED_TARGETING_OPTION_ID_PATTERN.matcher(assignedTargetingOptionId).matches(), (Object)"Parameter assignedTargetingOptionId must conform to the pattern ^[^/]+$");
                            }
                            this.assignedTargetingOptionId = assignedTargetingOptionId;
                            return this;
                        }

                        @Override
                        public Get set(String parameterName, Object value) {
                            return (Get)super.set(parameterName, value);
                        }
                    }
                }
            }

            public class Patch
            extends DisplayVideoRequest<Campaign> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/campaigns/{+campaignId}";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern CAMPAIGN_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long campaignId;
                @Key
                private String updateMask;

                protected Patch(Long advertiserId, Long campaignId, Campaign content) {
                    super(DisplayVideo.this, "PATCH", REST_PATH, (Object)content, Campaign.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.CAMPAIGN_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.campaignId = (Long)Preconditions.checkNotNull((Object)campaignId, (Object)"Required parameter campaignId must be specified.");
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Patch setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getCampaignId() {
                    return this.campaignId;
                }

                public Patch setCampaignId(Long campaignId) {
                    this.campaignId = campaignId;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class ListAssignedTargetingOptions
            extends DisplayVideoRequest<BulkListCampaignAssignedTargetingOptionsResponse> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/campaigns/{+campaignId}:listAssignedTargetingOptions";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern CAMPAIGN_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long campaignId;
                @Key
                private String filter;
                @Key
                private String orderBy;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected ListAssignedTargetingOptions(Long advertiserId, Long campaignId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, BulkListCampaignAssignedTargetingOptionsResponse.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.CAMPAIGN_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.campaignId = (Long)Preconditions.checkNotNull((Object)campaignId, (Object)"Required parameter campaignId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public ListAssignedTargetingOptions set$Xgafv(String $Xgafv) {
                    return (ListAssignedTargetingOptions)super.set$Xgafv($Xgafv);
                }

                public ListAssignedTargetingOptions setAccessToken(String accessToken) {
                    return (ListAssignedTargetingOptions)super.setAccessToken(accessToken);
                }

                public ListAssignedTargetingOptions setAlt(String alt) {
                    return (ListAssignedTargetingOptions)super.setAlt(alt);
                }

                public ListAssignedTargetingOptions setCallback(String callback) {
                    return (ListAssignedTargetingOptions)super.setCallback(callback);
                }

                public ListAssignedTargetingOptions setFields(String fields) {
                    return (ListAssignedTargetingOptions)super.setFields(fields);
                }

                public ListAssignedTargetingOptions setKey(String key) {
                    return (ListAssignedTargetingOptions)super.setKey(key);
                }

                public ListAssignedTargetingOptions setOauthToken(String oauthToken) {
                    return (ListAssignedTargetingOptions)super.setOauthToken(oauthToken);
                }

                public ListAssignedTargetingOptions setPrettyPrint(Boolean prettyPrint) {
                    return (ListAssignedTargetingOptions)super.setPrettyPrint(prettyPrint);
                }

                public ListAssignedTargetingOptions setQuotaUser(String quotaUser) {
                    return (ListAssignedTargetingOptions)super.setQuotaUser(quotaUser);
                }

                public ListAssignedTargetingOptions setUploadType(String uploadType) {
                    return (ListAssignedTargetingOptions)super.setUploadType(uploadType);
                }

                public ListAssignedTargetingOptions setUploadProtocol(String uploadProtocol) {
                    return (ListAssignedTargetingOptions)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public ListAssignedTargetingOptions setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getCampaignId() {
                    return this.campaignId;
                }

                public ListAssignedTargetingOptions setCampaignId(Long campaignId) {
                    this.campaignId = campaignId;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public ListAssignedTargetingOptions setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public ListAssignedTargetingOptions setOrderBy(String orderBy) {
                    this.orderBy = orderBy;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public ListAssignedTargetingOptions setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public ListAssignedTargetingOptions setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public ListAssignedTargetingOptions set(String parameterName, Object value) {
                    return (ListAssignedTargetingOptions)super.set(parameterName, value);
                }
            }

            public class List
            extends DisplayVideoRequest<ListCampaignsResponse> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/campaigns";
                private final Pattern ADVERTISER_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private String filter;
                @Key
                private String orderBy;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(Long advertiserId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, ListCampaignsResponse.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public List setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public List setOrderBy(String orderBy) {
                    this.orderBy = orderBy;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends DisplayVideoRequest<Campaign> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/campaigns/{+campaignId}";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern CAMPAIGN_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long campaignId;

                protected Get(Long advertiserId, Long campaignId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, Campaign.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.CAMPAIGN_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.campaignId = (Long)Preconditions.checkNotNull((Object)campaignId, (Object)"Required parameter campaignId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Get setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getCampaignId() {
                    return this.campaignId;
                }

                public Get setCampaignId(Long campaignId) {
                    this.campaignId = campaignId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends DisplayVideoRequest<Empty> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/campaigns/{+campaignId}";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern CAMPAIGN_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long campaignId;

                protected Delete(Long advertiserId, Long campaignId) {
                    super(DisplayVideo.this, "DELETE", REST_PATH, null, Empty.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.CAMPAIGN_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.campaignId = (Long)Preconditions.checkNotNull((Object)campaignId, (Object)"Required parameter campaignId must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Delete setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getCampaignId() {
                    return this.campaignId;
                }

                public Delete setCampaignId(Long campaignId) {
                    this.campaignId = campaignId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends DisplayVideoRequest<Campaign> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/campaigns";
                private final Pattern ADVERTISER_ID_PATTERN;
                @Key
                private Long advertiserId;

                protected Create(Long advertiserId, Campaign content) {
                    super(DisplayVideo.this, "POST", REST_PATH, (Object)content, Campaign.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Create setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Assets {
            public Upload upload(Long advertiserId, CreateAssetRequest content) throws IOException {
                Upload result = new Upload(advertiserId, content);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Upload upload(Long advertiserId, CreateAssetRequest content, AbstractInputStreamContent mediaContent) throws IOException {
                Upload result = new Upload(advertiserId, content, mediaContent);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Upload
            extends DisplayVideoRequest<CreateAssetResponse> {
                private static final String REST_PATH = "v2/advertisers/{+advertiserId}/assets";
                private final Pattern ADVERTISER_ID_PATTERN;
                @Key
                private Long advertiserId;

                protected Upload(Long advertiserId, CreateAssetRequest content) {
                    super(DisplayVideo.this, "POST", REST_PATH, (Object)content, CreateAssetResponse.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                }

                protected Upload(Long advertiserId, CreateAssetRequest content, AbstractInputStreamContent mediaContent) {
                    super(DisplayVideo.this, "POST", "/upload/" + DisplayVideo.this.getServicePath() + REST_PATH, (Object)content, CreateAssetResponse.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.initializeMediaUpload(mediaContent);
                }

                public Upload set$Xgafv(String $Xgafv) {
                    return (Upload)super.set$Xgafv($Xgafv);
                }

                public Upload setAccessToken(String accessToken) {
                    return (Upload)super.setAccessToken(accessToken);
                }

                public Upload setAlt(String alt) {
                    return (Upload)super.setAlt(alt);
                }

                public Upload setCallback(String callback) {
                    return (Upload)super.setCallback(callback);
                }

                public Upload setFields(String fields) {
                    return (Upload)super.setFields(fields);
                }

                public Upload setKey(String key) {
                    return (Upload)super.setKey(key);
                }

                public Upload setOauthToken(String oauthToken) {
                    return (Upload)super.setOauthToken(oauthToken);
                }

                public Upload setPrettyPrint(Boolean prettyPrint) {
                    return (Upload)super.setPrettyPrint(prettyPrint);
                }

                public Upload setQuotaUser(String quotaUser) {
                    return (Upload)super.setQuotaUser(quotaUser);
                }

                public Upload setUploadType(String uploadType) {
                    return (Upload)super.setUploadType(uploadType);
                }

                public Upload setUploadProtocol(String uploadProtocol) {
                    return (Upload)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Upload setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                @Override
                public Upload set(String parameterName, Object value) {
                    return (Upload)super.set(parameterName, value);
                }
            }
        }

        public class Patch
        extends DisplayVideoRequest<Advertiser> {
            private static final String REST_PATH = "v2/advertisers/{+advertiserId}";
            private final Pattern ADVERTISER_ID_PATTERN;
            @Key
            private Long advertiserId;
            @Key
            private String updateMask;

            protected Patch(Long advertiserId, Advertiser content) {
                super(DisplayVideo.this, "PATCH", REST_PATH, (Object)content, Advertiser.class);
                this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public Patch setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public Patch setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class ListAssignedTargetingOptions
        extends DisplayVideoRequest<BulkListAdvertiserAssignedTargetingOptionsResponse> {
            private static final String REST_PATH = "v2/advertisers/{+advertiserId}:listAssignedTargetingOptions";
            private final Pattern ADVERTISER_ID_PATTERN;
            @Key
            private Long advertiserId;
            @Key
            private String filter;
            @Key
            private String orderBy;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected ListAssignedTargetingOptions(Long advertiserId) {
                super(DisplayVideo.this, "GET", REST_PATH, null, BulkListAdvertiserAssignedTargetingOptionsResponse.class);
                this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public ListAssignedTargetingOptions set$Xgafv(String $Xgafv) {
                return (ListAssignedTargetingOptions)super.set$Xgafv($Xgafv);
            }

            public ListAssignedTargetingOptions setAccessToken(String accessToken) {
                return (ListAssignedTargetingOptions)super.setAccessToken(accessToken);
            }

            public ListAssignedTargetingOptions setAlt(String alt) {
                return (ListAssignedTargetingOptions)super.setAlt(alt);
            }

            public ListAssignedTargetingOptions setCallback(String callback) {
                return (ListAssignedTargetingOptions)super.setCallback(callback);
            }

            public ListAssignedTargetingOptions setFields(String fields) {
                return (ListAssignedTargetingOptions)super.setFields(fields);
            }

            public ListAssignedTargetingOptions setKey(String key) {
                return (ListAssignedTargetingOptions)super.setKey(key);
            }

            public ListAssignedTargetingOptions setOauthToken(String oauthToken) {
                return (ListAssignedTargetingOptions)super.setOauthToken(oauthToken);
            }

            public ListAssignedTargetingOptions setPrettyPrint(Boolean prettyPrint) {
                return (ListAssignedTargetingOptions)super.setPrettyPrint(prettyPrint);
            }

            public ListAssignedTargetingOptions setQuotaUser(String quotaUser) {
                return (ListAssignedTargetingOptions)super.setQuotaUser(quotaUser);
            }

            public ListAssignedTargetingOptions setUploadType(String uploadType) {
                return (ListAssignedTargetingOptions)super.setUploadType(uploadType);
            }

            public ListAssignedTargetingOptions setUploadProtocol(String uploadProtocol) {
                return (ListAssignedTargetingOptions)super.setUploadProtocol(uploadProtocol);
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public ListAssignedTargetingOptions setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public ListAssignedTargetingOptions setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public ListAssignedTargetingOptions setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public ListAssignedTargetingOptions setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public ListAssignedTargetingOptions setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public ListAssignedTargetingOptions set(String parameterName, Object value) {
                return (ListAssignedTargetingOptions)super.set(parameterName, value);
            }
        }

        public class List
        extends DisplayVideoRequest<ListAdvertisersResponse> {
            private static final String REST_PATH = "v2/advertisers";
            @Key
            private String filter;
            @Key
            private String orderBy;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private Long partnerId;

            protected List() {
                super(DisplayVideo.this, "GET", REST_PATH, null, ListAdvertisersResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public List setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends DisplayVideoRequest<Advertiser> {
            private static final String REST_PATH = "v2/advertisers/{+advertiserId}";
            private final Pattern ADVERTISER_ID_PATTERN;
            @Key
            private Long advertiserId;

            protected Get(Long advertiserId) {
                super(DisplayVideo.this, "GET", REST_PATH, null, Advertiser.class);
                this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public Get setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class EditAssignedTargetingOptions
        extends DisplayVideoRequest<BulkEditAdvertiserAssignedTargetingOptionsResponse> {
            private static final String REST_PATH = "v2/advertisers/{+advertiserId}:editAssignedTargetingOptions";
            private final Pattern ADVERTISER_ID_PATTERN;
            @Key
            private Long advertiserId;

            protected EditAssignedTargetingOptions(Long advertiserId, BulkEditAdvertiserAssignedTargetingOptionsRequest content) {
                super(DisplayVideo.this, "POST", REST_PATH, (Object)content, BulkEditAdvertiserAssignedTargetingOptionsResponse.class);
                this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
            }

            public EditAssignedTargetingOptions set$Xgafv(String $Xgafv) {
                return (EditAssignedTargetingOptions)super.set$Xgafv($Xgafv);
            }

            public EditAssignedTargetingOptions setAccessToken(String accessToken) {
                return (EditAssignedTargetingOptions)super.setAccessToken(accessToken);
            }

            public EditAssignedTargetingOptions setAlt(String alt) {
                return (EditAssignedTargetingOptions)super.setAlt(alt);
            }

            public EditAssignedTargetingOptions setCallback(String callback) {
                return (EditAssignedTargetingOptions)super.setCallback(callback);
            }

            public EditAssignedTargetingOptions setFields(String fields) {
                return (EditAssignedTargetingOptions)super.setFields(fields);
            }

            public EditAssignedTargetingOptions setKey(String key) {
                return (EditAssignedTargetingOptions)super.setKey(key);
            }

            public EditAssignedTargetingOptions setOauthToken(String oauthToken) {
                return (EditAssignedTargetingOptions)super.setOauthToken(oauthToken);
            }

            public EditAssignedTargetingOptions setPrettyPrint(Boolean prettyPrint) {
                return (EditAssignedTargetingOptions)super.setPrettyPrint(prettyPrint);
            }

            public EditAssignedTargetingOptions setQuotaUser(String quotaUser) {
                return (EditAssignedTargetingOptions)super.setQuotaUser(quotaUser);
            }

            public EditAssignedTargetingOptions setUploadType(String uploadType) {
                return (EditAssignedTargetingOptions)super.setUploadType(uploadType);
            }

            public EditAssignedTargetingOptions setUploadProtocol(String uploadProtocol) {
                return (EditAssignedTargetingOptions)super.setUploadProtocol(uploadProtocol);
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public EditAssignedTargetingOptions setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            @Override
            public EditAssignedTargetingOptions set(String parameterName, Object value) {
                return (EditAssignedTargetingOptions)super.set(parameterName, value);
            }
        }

        public class Delete
        extends DisplayVideoRequest<Empty> {
            private static final String REST_PATH = "v2/advertisers/{+advertiserId}";
            private final Pattern ADVERTISER_ID_PATTERN;
            @Key
            private Long advertiserId;

            protected Delete(Long advertiserId) {
                super(DisplayVideo.this, "DELETE", REST_PATH, null, Empty.class);
                this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public Delete setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends DisplayVideoRequest<Advertiser> {
            private static final String REST_PATH = "v2/advertisers";

            protected Create(Advertiser content) {
                super(DisplayVideo.this, "POST", REST_PATH, (Object)content, Advertiser.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }

        public class Audit
        extends DisplayVideoRequest<AuditAdvertiserResponse> {
            private static final String REST_PATH = "v2/advertisers/{+advertiserId}:audit";
            private final Pattern ADVERTISER_ID_PATTERN;
            @Key
            private Long advertiserId;
            @Key
            private String readMask;

            protected Audit(Long advertiserId) {
                super(DisplayVideo.this, "GET", REST_PATH, null, AuditAdvertiserResponse.class);
                this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Audit set$Xgafv(String $Xgafv) {
                return (Audit)super.set$Xgafv($Xgafv);
            }

            public Audit setAccessToken(String accessToken) {
                return (Audit)super.setAccessToken(accessToken);
            }

            public Audit setAlt(String alt) {
                return (Audit)super.setAlt(alt);
            }

            public Audit setCallback(String callback) {
                return (Audit)super.setCallback(callback);
            }

            public Audit setFields(String fields) {
                return (Audit)super.setFields(fields);
            }

            public Audit setKey(String key) {
                return (Audit)super.setKey(key);
            }

            public Audit setOauthToken(String oauthToken) {
                return (Audit)super.setOauthToken(oauthToken);
            }

            public Audit setPrettyPrint(Boolean prettyPrint) {
                return (Audit)super.setPrettyPrint(prettyPrint);
            }

            public Audit setQuotaUser(String quotaUser) {
                return (Audit)super.setQuotaUser(quotaUser);
            }

            public Audit setUploadType(String uploadType) {
                return (Audit)super.setUploadType(uploadType);
            }

            public Audit setUploadProtocol(String uploadProtocol) {
                return (Audit)super.setUploadProtocol(uploadProtocol);
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public Audit setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public String getReadMask() {
                return this.readMask;
            }

            public Audit setReadMask(String readMask) {
                this.readMask = readMask;
                return this;
            }

            @Override
            public Audit set(String parameterName, Object value) {
                return (Audit)super.set(parameterName, value);
            }
        }
    }
}

