/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.displayvideo.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.displayvideo.v1.DisplayVideoRequest;
import com.google.api.services.displayvideo.v1.DisplayVideoRequestInitializer;
import com.google.api.services.displayvideo.v1.model.Advertiser;
import com.google.api.services.displayvideo.v1.model.AssignedTargetingOption;
import com.google.api.services.displayvideo.v1.model.BulkEditAdvertiserAssignedTargetingOptionsRequest;
import com.google.api.services.displayvideo.v1.model.BulkEditAdvertiserAssignedTargetingOptionsResponse;
import com.google.api.services.displayvideo.v1.model.BulkEditLineItemAssignedTargetingOptionsRequest;
import com.google.api.services.displayvideo.v1.model.BulkEditLineItemAssignedTargetingOptionsResponse;
import com.google.api.services.displayvideo.v1.model.BulkListAdvertiserAssignedTargetingOptionsResponse;
import com.google.api.services.displayvideo.v1.model.BulkListLineItemAssignedTargetingOptionsResponse;
import com.google.api.services.displayvideo.v1.model.Campaign;
import com.google.api.services.displayvideo.v1.model.Channel;
import com.google.api.services.displayvideo.v1.model.CombinedAudience;
import com.google.api.services.displayvideo.v1.model.CreateAssetRequest;
import com.google.api.services.displayvideo.v1.model.CreateAssetResponse;
import com.google.api.services.displayvideo.v1.model.CreateSdfDownloadTaskRequest;
import com.google.api.services.displayvideo.v1.model.Creative;
import com.google.api.services.displayvideo.v1.model.CustomList;
import com.google.api.services.displayvideo.v1.model.Empty;
import com.google.api.services.displayvideo.v1.model.FirstAndThirdPartyAudience;
import com.google.api.services.displayvideo.v1.model.FloodlightGroup;
import com.google.api.services.displayvideo.v1.model.GoogleAudience;
import com.google.api.services.displayvideo.v1.model.GoogleBytestreamMedia;
import com.google.api.services.displayvideo.v1.model.InsertionOrder;
import com.google.api.services.displayvideo.v1.model.InventorySource;
import com.google.api.services.displayvideo.v1.model.InventorySourceGroup;
import com.google.api.services.displayvideo.v1.model.LineItem;
import com.google.api.services.displayvideo.v1.model.ListAdvertiserAssignedTargetingOptionsResponse;
import com.google.api.services.displayvideo.v1.model.ListAdvertisersResponse;
import com.google.api.services.displayvideo.v1.model.ListCampaignsResponse;
import com.google.api.services.displayvideo.v1.model.ListChannelsResponse;
import com.google.api.services.displayvideo.v1.model.ListCombinedAudiencesResponse;
import com.google.api.services.displayvideo.v1.model.ListCreativesResponse;
import com.google.api.services.displayvideo.v1.model.ListCustomListsResponse;
import com.google.api.services.displayvideo.v1.model.ListFirstAndThirdPartyAudiencesResponse;
import com.google.api.services.displayvideo.v1.model.ListGoogleAudiencesResponse;
import com.google.api.services.displayvideo.v1.model.ListInsertionOrdersResponse;
import com.google.api.services.displayvideo.v1.model.ListInventorySourceGroupsResponse;
import com.google.api.services.displayvideo.v1.model.ListInventorySourcesResponse;
import com.google.api.services.displayvideo.v1.model.ListLineItemAssignedTargetingOptionsResponse;
import com.google.api.services.displayvideo.v1.model.ListLineItemsResponse;
import com.google.api.services.displayvideo.v1.model.ListLocationListsResponse;
import com.google.api.services.displayvideo.v1.model.ListNegativeKeywordListsResponse;
import com.google.api.services.displayvideo.v1.model.ListTargetingOptionsResponse;
import com.google.api.services.displayvideo.v1.model.LocationList;
import com.google.api.services.displayvideo.v1.model.NegativeKeywordList;
import com.google.api.services.displayvideo.v1.model.Operation;
import com.google.api.services.displayvideo.v1.model.TargetingOption;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Pattern;

public class DisplayVideo
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://displayvideo.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://displayvideo.googleapis.com/";

    public DisplayVideo(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    DisplayVideo(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Advertisers advertisers() {
        return new Advertisers();
    }

    public CombinedAudiences combinedAudiences() {
        return new CombinedAudiences();
    }

    public CustomLists customLists() {
        return new CustomLists();
    }

    public FirstAndThirdPartyAudiences firstAndThirdPartyAudiences() {
        return new FirstAndThirdPartyAudiences();
    }

    public FloodlightGroups floodlightGroups() {
        return new FloodlightGroups();
    }

    public GoogleAudiences googleAudiences() {
        return new GoogleAudiences();
    }

    public InventorySourceGroups inventorySourceGroups() {
        return new InventorySourceGroups();
    }

    public InventorySources inventorySources() {
        return new InventorySources();
    }

    public Media media() {
        return new Media();
    }

    public Partners partners() {
        return new Partners();
    }

    public Sdfdownloadtasks sdfdownloadtasks() {
        return new Sdfdownloadtasks();
    }

    public TargetingTypes targetingTypes() {
        return new TargetingTypes();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.30.9 of the Display & Video 360 API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, "https://displayvideo.googleapis.com/", DisplayVideo.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(DisplayVideo.DEFAULT_BATCH_PATH);
        }

        public DisplayVideo build() {
            return new DisplayVideo(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setDisplayVideoRequestInitializer(DisplayVideoRequestInitializer displayvideoRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)displayvideoRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class TargetingTypes {
        public TargetingOptions targetingOptions() {
            return new TargetingOptions();
        }

        public class TargetingOptions {
            public Get get(String targetingType, String targetingOptionId) throws IOException {
                Get result = new Get(targetingType, targetingOptionId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String targetingType) throws IOException {
                List result = new List(targetingType);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends DisplayVideoRequest<ListTargetingOptionsResponse> {
                private static final String REST_PATH = "v1/targetingTypes/{+targetingType}/targetingOptions";
                private final Pattern TARGETING_TYPE_PATTERN;
                @Key
                private String targetingType;
                @Key
                private Long advertiserId;
                @Key
                private String filter;
                @Key
                private String orderBy;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String targetingType) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, ListTargetingOptionsResponse.class);
                    this.TARGETING_TYPE_PATTERN = Pattern.compile("^[^/]+$");
                    this.targetingType = (String)Preconditions.checkNotNull((Object)targetingType, (Object)"Required parameter targetingType must be specified.");
                    if (!DisplayVideo.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getTargetingType() {
                    return this.targetingType;
                }

                public List setTargetingType(String targetingType) {
                    if (!DisplayVideo.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                    }
                    this.targetingType = targetingType;
                    return this;
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public List setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public List setOrderBy(String orderBy) {
                    this.orderBy = orderBy;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends DisplayVideoRequest<TargetingOption> {
                private static final String REST_PATH = "v1/targetingTypes/{+targetingType}/targetingOptions/{+targetingOptionId}";
                private final Pattern TARGETING_TYPE_PATTERN;
                private final Pattern TARGETING_OPTION_ID_PATTERN;
                @Key
                private String targetingType;
                @Key
                private String targetingOptionId;
                @Key
                private Long advertiserId;

                protected Get(String targetingType, String targetingOptionId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, TargetingOption.class);
                    this.TARGETING_TYPE_PATTERN = Pattern.compile("^[^/]+$");
                    this.TARGETING_OPTION_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.targetingType = (String)Preconditions.checkNotNull((Object)targetingType, (Object)"Required parameter targetingType must be specified.");
                    if (!DisplayVideo.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                    }
                    this.targetingOptionId = (String)Preconditions.checkNotNull((Object)targetingOptionId, (Object)"Required parameter targetingOptionId must be specified.");
                    if (!DisplayVideo.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.TARGETING_OPTION_ID_PATTERN.matcher(targetingOptionId).matches(), (Object)"Parameter targetingOptionId must conform to the pattern ^[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getTargetingType() {
                    return this.targetingType;
                }

                public Get setTargetingType(String targetingType) {
                    if (!DisplayVideo.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                    }
                    this.targetingType = targetingType;
                    return this;
                }

                public String getTargetingOptionId() {
                    return this.targetingOptionId;
                }

                public Get setTargetingOptionId(String targetingOptionId) {
                    if (!DisplayVideo.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.TARGETING_OPTION_ID_PATTERN.matcher(targetingOptionId).matches(), (Object)"Parameter targetingOptionId must conform to the pattern ^[^/]+$");
                    }
                    this.targetingOptionId = targetingOptionId;
                    return this;
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Get setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }
    }

    public class Sdfdownloadtasks {
        public Create create(CreateSdfDownloadTaskRequest content) throws IOException {
            Create result = new Create(content);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Operations operations() {
            return new Operations();
        }

        public class Operations {
            public Get get(String name) throws IOException {
                Get result = new Get(name);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Get
            extends DisplayVideoRequest<Operation> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, Operation.class);
                    this.NAME_PATTERN = Pattern.compile("^sdfdownloadtasks/operations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!DisplayVideo.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^sdfdownloadtasks/operations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!DisplayVideo.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^sdfdownloadtasks/operations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class Create
        extends DisplayVideoRequest<Operation> {
            private static final String REST_PATH = "v1/sdfdownloadtasks";

            protected Create(CreateSdfDownloadTaskRequest content) {
                super(DisplayVideo.this, "POST", REST_PATH, (Object)content, Operation.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class Partners {
        public Channels channels() {
            return new Channels();
        }

        public class Channels {
            public Get get(Long partnerId, Long channelId) throws IOException {
                Get result = new Get(partnerId, channelId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(Long partnerId) throws IOException {
                List result = new List(partnerId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends DisplayVideoRequest<ListChannelsResponse> {
                private static final String REST_PATH = "v1/partners/{+partnerId}/channels";
                private final Pattern PARTNER_ID_PATTERN;
                @Key
                private Long partnerId;
                @Key
                private Long advertiserId;
                @Key
                private String filter;
                @Key
                private String orderBy;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(Long partnerId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, ListChannelsResponse.class);
                    this.PARTNER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.partnerId = (Long)Preconditions.checkNotNull((Object)partnerId, (Object)"Required parameter partnerId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public Long getPartnerId() {
                    return this.partnerId;
                }

                public List setPartnerId(Long partnerId) {
                    this.partnerId = partnerId;
                    return this;
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public List setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public List setOrderBy(String orderBy) {
                    this.orderBy = orderBy;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends DisplayVideoRequest<Channel> {
                private static final String REST_PATH = "v1/partners/{+partnerId}/channels/{+channelId}";
                private final Pattern PARTNER_ID_PATTERN;
                private final Pattern CHANNEL_ID_PATTERN;
                @Key
                private Long partnerId;
                @Key
                private Long channelId;
                @Key
                private Long advertiserId;

                protected Get(Long partnerId, Long channelId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, Channel.class);
                    this.PARTNER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.CHANNEL_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.partnerId = (Long)Preconditions.checkNotNull((Object)partnerId, (Object)"Required parameter partnerId must be specified.");
                    this.channelId = (Long)Preconditions.checkNotNull((Object)channelId, (Object)"Required parameter channelId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public Long getPartnerId() {
                    return this.partnerId;
                }

                public Get setPartnerId(Long partnerId) {
                    this.partnerId = partnerId;
                    return this;
                }

                public Long getChannelId() {
                    return this.channelId;
                }

                public Get setChannelId(Long channelId) {
                    this.channelId = channelId;
                    return this;
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Get setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }
    }

    public class Media {
        public Download download(String resourceName) throws IOException {
            Download result = new Download(resourceName);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Download
        extends DisplayVideoRequest<GoogleBytestreamMedia> {
            private static final String REST_PATH = "download/{+resourceName}";
            private final Pattern RESOURCE_NAME_PATTERN;
            @Key
            private String resourceName;

            protected Download(String resourceName) {
                super(DisplayVideo.this, "GET", REST_PATH, null, GoogleBytestreamMedia.class);
                this.RESOURCE_NAME_PATTERN = Pattern.compile("^.*$");
                this.resourceName = (String)Preconditions.checkNotNull((Object)resourceName, (Object)"Required parameter resourceName must be specified.");
                if (!DisplayVideo.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(resourceName).matches(), (Object)"Parameter resourceName must conform to the pattern ^.*$");
                }
                this.initializeMediaDownload();
            }

            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Download set$Xgafv(String $Xgafv) {
                return (Download)super.set$Xgafv($Xgafv);
            }

            public Download setAccessToken(String accessToken) {
                return (Download)super.setAccessToken(accessToken);
            }

            public Download setAlt(String alt) {
                return (Download)super.setAlt(alt);
            }

            public Download setCallback(String callback) {
                return (Download)super.setCallback(callback);
            }

            public Download setFields(String fields) {
                return (Download)super.setFields(fields);
            }

            public Download setKey(String key) {
                return (Download)super.setKey(key);
            }

            public Download setOauthToken(String oauthToken) {
                return (Download)super.setOauthToken(oauthToken);
            }

            public Download setPrettyPrint(Boolean prettyPrint) {
                return (Download)super.setPrettyPrint(prettyPrint);
            }

            public Download setQuotaUser(String quotaUser) {
                return (Download)super.setQuotaUser(quotaUser);
            }

            public Download setUploadType(String uploadType) {
                return (Download)super.setUploadType(uploadType);
            }

            public Download setUploadProtocol(String uploadProtocol) {
                return (Download)super.setUploadProtocol(uploadProtocol);
            }

            public String getResourceName() {
                return this.resourceName;
            }

            public Download setResourceName(String resourceName) {
                if (!DisplayVideo.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(resourceName).matches(), (Object)"Parameter resourceName must conform to the pattern ^.*$");
                }
                this.resourceName = resourceName;
                return this;
            }

            @Override
            public Download set(String parameterName, Object value) {
                return (Download)super.set(parameterName, value);
            }
        }
    }

    public class InventorySources {
        public Get get(Long inventorySourceId) throws IOException {
            Get result = new Get(inventorySourceId);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends DisplayVideoRequest<ListInventorySourcesResponse> {
            private static final String REST_PATH = "v1/inventorySources";
            @Key
            private Long advertiserId;
            @Key
            private String filter;
            @Key
            private String orderBy;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private Long partnerId;

            protected List() {
                super(DisplayVideo.this, "GET", REST_PATH, null, ListInventorySourcesResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public List setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public List setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends DisplayVideoRequest<InventorySource> {
            private static final String REST_PATH = "v1/inventorySources/{+inventorySourceId}";
            private final Pattern INVENTORY_SOURCE_ID_PATTERN;
            @Key
            private Long inventorySourceId;
            @Key
            private Long partnerId;

            protected Get(Long inventorySourceId) {
                super(DisplayVideo.this, "GET", REST_PATH, null, InventorySource.class);
                this.INVENTORY_SOURCE_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.inventorySourceId = (Long)Preconditions.checkNotNull((Object)inventorySourceId, (Object)"Required parameter inventorySourceId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getInventorySourceId() {
                return this.inventorySourceId;
            }

            public Get setInventorySourceId(Long inventorySourceId) {
                this.inventorySourceId = inventorySourceId;
                return this;
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public Get setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class InventorySourceGroups {
        public Get get(Long inventorySourceGroupId) throws IOException {
            Get result = new Get(inventorySourceGroupId);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends DisplayVideoRequest<ListInventorySourceGroupsResponse> {
            private static final String REST_PATH = "v1/inventorySourceGroups";
            @Key
            private Long advertiserId;
            @Key
            private String filter;
            @Key
            private String orderBy;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private Long partnerId;

            protected List() {
                super(DisplayVideo.this, "GET", REST_PATH, null, ListInventorySourceGroupsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public List setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public List setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends DisplayVideoRequest<InventorySourceGroup> {
            private static final String REST_PATH = "v1/inventorySourceGroups/{+inventorySourceGroupId}";
            private final Pattern INVENTORY_SOURCE_GROUP_ID_PATTERN;
            @Key
            private Long inventorySourceGroupId;
            @Key
            private Long advertiserId;
            @Key
            private Long partnerId;

            protected Get(Long inventorySourceGroupId) {
                super(DisplayVideo.this, "GET", REST_PATH, null, InventorySourceGroup.class);
                this.INVENTORY_SOURCE_GROUP_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.inventorySourceGroupId = (Long)Preconditions.checkNotNull((Object)inventorySourceGroupId, (Object)"Required parameter inventorySourceGroupId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getInventorySourceGroupId() {
                return this.inventorySourceGroupId;
            }

            public Get setInventorySourceGroupId(Long inventorySourceGroupId) {
                this.inventorySourceGroupId = inventorySourceGroupId;
                return this;
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public Get setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public Get setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class GoogleAudiences {
        public Get get(Long googleAudienceId) throws IOException {
            Get result = new Get(googleAudienceId);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends DisplayVideoRequest<ListGoogleAudiencesResponse> {
            private static final String REST_PATH = "v1/googleAudiences";
            @Key
            private Long advertiserId;
            @Key
            private String filter;
            @Key
            private String orderBy;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private Long partnerId;

            protected List() {
                super(DisplayVideo.this, "GET", REST_PATH, null, ListGoogleAudiencesResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public List setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public List setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends DisplayVideoRequest<GoogleAudience> {
            private static final String REST_PATH = "v1/googleAudiences/{+googleAudienceId}";
            private final Pattern GOOGLE_AUDIENCE_ID_PATTERN;
            @Key
            private Long googleAudienceId;
            @Key
            private Long advertiserId;
            @Key
            private Long partnerId;

            protected Get(Long googleAudienceId) {
                super(DisplayVideo.this, "GET", REST_PATH, null, GoogleAudience.class);
                this.GOOGLE_AUDIENCE_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.googleAudienceId = (Long)Preconditions.checkNotNull((Object)googleAudienceId, (Object)"Required parameter googleAudienceId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getGoogleAudienceId() {
                return this.googleAudienceId;
            }

            public Get setGoogleAudienceId(Long googleAudienceId) {
                this.googleAudienceId = googleAudienceId;
                return this;
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public Get setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public Get setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class FloodlightGroups {
        public Get get(Long floodlightGroupId) throws IOException {
            Get result = new Get(floodlightGroupId);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(Long floodlightGroupId, FloodlightGroup content) throws IOException {
            Patch result = new Patch(floodlightGroupId, content);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Patch
        extends DisplayVideoRequest<FloodlightGroup> {
            private static final String REST_PATH = "v1/floodlightGroups/{floodlightGroupId}";
            @Key
            private Long floodlightGroupId;
            @Key
            private Long partnerId;
            @Key
            private String updateMask;

            protected Patch(Long floodlightGroupId, FloodlightGroup content) {
                super(DisplayVideo.this, "PATCH", REST_PATH, (Object)content, FloodlightGroup.class);
                this.floodlightGroupId = (Long)Preconditions.checkNotNull((Object)floodlightGroupId, (Object)"Required parameter floodlightGroupId must be specified.");
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public Long getFloodlightGroupId() {
                return this.floodlightGroupId;
            }

            public Patch setFloodlightGroupId(Long floodlightGroupId) {
                this.floodlightGroupId = floodlightGroupId;
                return this;
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public Patch setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public Patch setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class Get
        extends DisplayVideoRequest<FloodlightGroup> {
            private static final String REST_PATH = "v1/floodlightGroups/{+floodlightGroupId}";
            private final Pattern FLOODLIGHT_GROUP_ID_PATTERN;
            @Key
            private Long floodlightGroupId;
            @Key
            private Long partnerId;

            protected Get(Long floodlightGroupId) {
                super(DisplayVideo.this, "GET", REST_PATH, null, FloodlightGroup.class);
                this.FLOODLIGHT_GROUP_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.floodlightGroupId = (Long)Preconditions.checkNotNull((Object)floodlightGroupId, (Object)"Required parameter floodlightGroupId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getFloodlightGroupId() {
                return this.floodlightGroupId;
            }

            public Get setFloodlightGroupId(Long floodlightGroupId) {
                this.floodlightGroupId = floodlightGroupId;
                return this;
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public Get setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class FirstAndThirdPartyAudiences {
        public Get get(Long firstAndThirdPartyAudienceId) throws IOException {
            Get result = new Get(firstAndThirdPartyAudienceId);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends DisplayVideoRequest<ListFirstAndThirdPartyAudiencesResponse> {
            private static final String REST_PATH = "v1/firstAndThirdPartyAudiences";
            @Key
            private Long advertiserId;
            @Key
            private String filter;
            @Key
            private String orderBy;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private Long partnerId;

            protected List() {
                super(DisplayVideo.this, "GET", REST_PATH, null, ListFirstAndThirdPartyAudiencesResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public List setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public List setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends DisplayVideoRequest<FirstAndThirdPartyAudience> {
            private static final String REST_PATH = "v1/firstAndThirdPartyAudiences/{+firstAndThirdPartyAudienceId}";
            private final Pattern FIRST_AND_THIRD_PARTY_AUDIENCE_ID_PATTERN;
            @Key
            private Long firstAndThirdPartyAudienceId;
            @Key
            private Long advertiserId;
            @Key
            private Long partnerId;

            protected Get(Long firstAndThirdPartyAudienceId) {
                super(DisplayVideo.this, "GET", REST_PATH, null, FirstAndThirdPartyAudience.class);
                this.FIRST_AND_THIRD_PARTY_AUDIENCE_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.firstAndThirdPartyAudienceId = (Long)Preconditions.checkNotNull((Object)firstAndThirdPartyAudienceId, (Object)"Required parameter firstAndThirdPartyAudienceId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getFirstAndThirdPartyAudienceId() {
                return this.firstAndThirdPartyAudienceId;
            }

            public Get setFirstAndThirdPartyAudienceId(Long firstAndThirdPartyAudienceId) {
                this.firstAndThirdPartyAudienceId = firstAndThirdPartyAudienceId;
                return this;
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public Get setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public Get setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class CustomLists {
        public Get get(Long customListId) throws IOException {
            Get result = new Get(customListId);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends DisplayVideoRequest<ListCustomListsResponse> {
            private static final String REST_PATH = "v1/customLists";
            @Key
            private Long advertiserId;
            @Key
            private String filter;
            @Key
            private String orderBy;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List() {
                super(DisplayVideo.this, "GET", REST_PATH, null, ListCustomListsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public List setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends DisplayVideoRequest<CustomList> {
            private static final String REST_PATH = "v1/customLists/{+customListId}";
            private final Pattern CUSTOM_LIST_ID_PATTERN;
            @Key
            private Long customListId;
            @Key
            private Long advertiserId;

            protected Get(Long customListId) {
                super(DisplayVideo.this, "GET", REST_PATH, null, CustomList.class);
                this.CUSTOM_LIST_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.customListId = (Long)Preconditions.checkNotNull((Object)customListId, (Object)"Required parameter customListId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getCustomListId() {
                return this.customListId;
            }

            public Get setCustomListId(Long customListId) {
                this.customListId = customListId;
                return this;
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public Get setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class CombinedAudiences {
        public Get get(Long combinedAudienceId) throws IOException {
            Get result = new Get(combinedAudienceId);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends DisplayVideoRequest<ListCombinedAudiencesResponse> {
            private static final String REST_PATH = "v1/combinedAudiences";
            @Key
            private Long advertiserId;
            @Key
            private String filter;
            @Key
            private String orderBy;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private Long partnerId;

            protected List() {
                super(DisplayVideo.this, "GET", REST_PATH, null, ListCombinedAudiencesResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public List setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public List setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends DisplayVideoRequest<CombinedAudience> {
            private static final String REST_PATH = "v1/combinedAudiences/{+combinedAudienceId}";
            private final Pattern COMBINED_AUDIENCE_ID_PATTERN;
            @Key
            private Long combinedAudienceId;
            @Key
            private Long advertiserId;
            @Key
            private Long partnerId;

            protected Get(Long combinedAudienceId) {
                super(DisplayVideo.this, "GET", REST_PATH, null, CombinedAudience.class);
                this.COMBINED_AUDIENCE_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.combinedAudienceId = (Long)Preconditions.checkNotNull((Object)combinedAudienceId, (Object)"Required parameter combinedAudienceId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getCombinedAudienceId() {
                return this.combinedAudienceId;
            }

            public Get setCombinedAudienceId(Long combinedAudienceId) {
                this.combinedAudienceId = combinedAudienceId;
                return this;
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public Get setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public Get setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Advertisers {
        public BulkEditAdvertiserAssignedTargetingOptions bulkEditAdvertiserAssignedTargetingOptions(Long advertiserId, BulkEditAdvertiserAssignedTargetingOptionsRequest content) throws IOException {
            BulkEditAdvertiserAssignedTargetingOptions result = new BulkEditAdvertiserAssignedTargetingOptions(advertiserId, content);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public BulkListAdvertiserAssignedTargetingOptions bulkListAdvertiserAssignedTargetingOptions(Long advertiserId) throws IOException {
            BulkListAdvertiserAssignedTargetingOptions result = new BulkListAdvertiserAssignedTargetingOptions(advertiserId);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Create create(Advertiser content) throws IOException {
            Create result = new Create(content);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(Long advertiserId) throws IOException {
            Delete result = new Delete(advertiserId);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(Long advertiserId) throws IOException {
            Get result = new Get(advertiserId);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(Long advertiserId, Advertiser content) throws IOException {
            Patch result = new Patch(advertiserId, content);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Assets assets() {
            return new Assets();
        }

        public Campaigns campaigns() {
            return new Campaigns();
        }

        public Channels channels() {
            return new Channels();
        }

        public Creatives creatives() {
            return new Creatives();
        }

        public InsertionOrders insertionOrders() {
            return new InsertionOrders();
        }

        public LineItems lineItems() {
            return new LineItems();
        }

        public LocationLists locationLists() {
            return new LocationLists();
        }

        public NegativeKeywordLists negativeKeywordLists() {
            return new NegativeKeywordLists();
        }

        public TargetingTypes targetingTypes() {
            return new TargetingTypes();
        }

        public class TargetingTypes {
            public AssignedTargetingOptions assignedTargetingOptions() {
                return new AssignedTargetingOptions();
            }

            public class AssignedTargetingOptions {
                public Create create(Long advertiserId, String targetingType, AssignedTargetingOption content) throws IOException {
                    Create result = new Create(advertiserId, targetingType, content);
                    DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(Long advertiserId, String targetingType, String assignedTargetingOptionId) throws IOException {
                    Delete result = new Delete(advertiserId, targetingType, assignedTargetingOptionId);
                    DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(Long advertiserId, String targetingType, String assignedTargetingOptionId) throws IOException {
                    Get result = new Get(advertiserId, targetingType, assignedTargetingOptionId);
                    DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(Long advertiserId, String targetingType) throws IOException {
                    List result = new List(advertiserId, targetingType);
                    DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends DisplayVideoRequest<ListAdvertiserAssignedTargetingOptionsResponse> {
                    private static final String REST_PATH = "v1/advertisers/{+advertiserId}/targetingTypes/{+targetingType}/assignedTargetingOptions";
                    private final Pattern ADVERTISER_ID_PATTERN;
                    private final Pattern TARGETING_TYPE_PATTERN;
                    @Key
                    private Long advertiserId;
                    @Key
                    private String targetingType;
                    @Key
                    private String filter;
                    @Key
                    private String orderBy;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(Long advertiserId, String targetingType) {
                        super(DisplayVideo.this, "GET", REST_PATH, null, ListAdvertiserAssignedTargetingOptionsResponse.class);
                        this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.TARGETING_TYPE_PATTERN = Pattern.compile("^[^/]+$");
                        this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                        this.targetingType = (String)Preconditions.checkNotNull((Object)targetingType, (Object)"Required parameter targetingType must be specified.");
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public Long getAdvertiserId() {
                        return this.advertiserId;
                    }

                    public List setAdvertiserId(Long advertiserId) {
                        this.advertiserId = advertiserId;
                        return this;
                    }

                    public String getTargetingType() {
                        return this.targetingType;
                    }

                    public List setTargetingType(String targetingType) {
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                        }
                        this.targetingType = targetingType;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public String getOrderBy() {
                        return this.orderBy;
                    }

                    public List setOrderBy(String orderBy) {
                        this.orderBy = orderBy;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends DisplayVideoRequest<AssignedTargetingOption> {
                    private static final String REST_PATH = "v1/advertisers/{+advertiserId}/targetingTypes/{+targetingType}/assignedTargetingOptions/{+assignedTargetingOptionId}";
                    private final Pattern ADVERTISER_ID_PATTERN;
                    private final Pattern TARGETING_TYPE_PATTERN;
                    private final Pattern ASSIGNED_TARGETING_OPTION_ID_PATTERN;
                    @Key
                    private Long advertiserId;
                    @Key
                    private String targetingType;
                    @Key
                    private String assignedTargetingOptionId;

                    protected Get(Long advertiserId, String targetingType, String assignedTargetingOptionId) {
                        super(DisplayVideo.this, "GET", REST_PATH, null, AssignedTargetingOption.class);
                        this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.TARGETING_TYPE_PATTERN = Pattern.compile("^[^/]+$");
                        this.ASSIGNED_TARGETING_OPTION_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                        this.targetingType = (String)Preconditions.checkNotNull((Object)targetingType, (Object)"Required parameter targetingType must be specified.");
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                        }
                        this.assignedTargetingOptionId = (String)Preconditions.checkNotNull((Object)assignedTargetingOptionId, (Object)"Required parameter assignedTargetingOptionId must be specified.");
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.ASSIGNED_TARGETING_OPTION_ID_PATTERN.matcher(assignedTargetingOptionId).matches(), (Object)"Parameter assignedTargetingOptionId must conform to the pattern ^[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public Long getAdvertiserId() {
                        return this.advertiserId;
                    }

                    public Get setAdvertiserId(Long advertiserId) {
                        this.advertiserId = advertiserId;
                        return this;
                    }

                    public String getTargetingType() {
                        return this.targetingType;
                    }

                    public Get setTargetingType(String targetingType) {
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                        }
                        this.targetingType = targetingType;
                        return this;
                    }

                    public String getAssignedTargetingOptionId() {
                        return this.assignedTargetingOptionId;
                    }

                    public Get setAssignedTargetingOptionId(String assignedTargetingOptionId) {
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.ASSIGNED_TARGETING_OPTION_ID_PATTERN.matcher(assignedTargetingOptionId).matches(), (Object)"Parameter assignedTargetingOptionId must conform to the pattern ^[^/]+$");
                        }
                        this.assignedTargetingOptionId = assignedTargetingOptionId;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends DisplayVideoRequest<Empty> {
                    private static final String REST_PATH = "v1/advertisers/{+advertiserId}/targetingTypes/{+targetingType}/assignedTargetingOptions/{+assignedTargetingOptionId}";
                    private final Pattern ADVERTISER_ID_PATTERN;
                    private final Pattern TARGETING_TYPE_PATTERN;
                    private final Pattern ASSIGNED_TARGETING_OPTION_ID_PATTERN;
                    @Key
                    private Long advertiserId;
                    @Key
                    private String targetingType;
                    @Key
                    private String assignedTargetingOptionId;

                    protected Delete(Long advertiserId, String targetingType, String assignedTargetingOptionId) {
                        super(DisplayVideo.this, "DELETE", REST_PATH, null, Empty.class);
                        this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.TARGETING_TYPE_PATTERN = Pattern.compile("^[^/]+$");
                        this.ASSIGNED_TARGETING_OPTION_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                        this.targetingType = (String)Preconditions.checkNotNull((Object)targetingType, (Object)"Required parameter targetingType must be specified.");
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                        }
                        this.assignedTargetingOptionId = (String)Preconditions.checkNotNull((Object)assignedTargetingOptionId, (Object)"Required parameter assignedTargetingOptionId must be specified.");
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.ASSIGNED_TARGETING_OPTION_ID_PATTERN.matcher(assignedTargetingOptionId).matches(), (Object)"Parameter assignedTargetingOptionId must conform to the pattern ^[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public Long getAdvertiserId() {
                        return this.advertiserId;
                    }

                    public Delete setAdvertiserId(Long advertiserId) {
                        this.advertiserId = advertiserId;
                        return this;
                    }

                    public String getTargetingType() {
                        return this.targetingType;
                    }

                    public Delete setTargetingType(String targetingType) {
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                        }
                        this.targetingType = targetingType;
                        return this;
                    }

                    public String getAssignedTargetingOptionId() {
                        return this.assignedTargetingOptionId;
                    }

                    public Delete setAssignedTargetingOptionId(String assignedTargetingOptionId) {
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.ASSIGNED_TARGETING_OPTION_ID_PATTERN.matcher(assignedTargetingOptionId).matches(), (Object)"Parameter assignedTargetingOptionId must conform to the pattern ^[^/]+$");
                        }
                        this.assignedTargetingOptionId = assignedTargetingOptionId;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends DisplayVideoRequest<AssignedTargetingOption> {
                    private static final String REST_PATH = "v1/advertisers/{+advertiserId}/targetingTypes/{+targetingType}/assignedTargetingOptions";
                    private final Pattern ADVERTISER_ID_PATTERN;
                    private final Pattern TARGETING_TYPE_PATTERN;
                    @Key
                    private Long advertiserId;
                    @Key
                    private String targetingType;

                    protected Create(Long advertiserId, String targetingType, AssignedTargetingOption content) {
                        super(DisplayVideo.this, "POST", REST_PATH, (Object)content, AssignedTargetingOption.class);
                        this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                        this.TARGETING_TYPE_PATTERN = Pattern.compile("^[^/]+$");
                        this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                        this.targetingType = (String)Preconditions.checkNotNull((Object)targetingType, (Object)"Required parameter targetingType must be specified.");
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public Long getAdvertiserId() {
                        return this.advertiserId;
                    }

                    public Create setAdvertiserId(Long advertiserId) {
                        this.advertiserId = advertiserId;
                        return this;
                    }

                    public String getTargetingType() {
                        return this.targetingType;
                    }

                    public Create setTargetingType(String targetingType) {
                        if (!DisplayVideo.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                        }
                        this.targetingType = targetingType;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }
        }

        public class NegativeKeywordLists {
            public Get get(Long advertiserId, Long negativeKeywordListId) throws IOException {
                Get result = new Get(advertiserId, negativeKeywordListId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(Long advertiserId) throws IOException {
                List result = new List(advertiserId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends DisplayVideoRequest<ListNegativeKeywordListsResponse> {
                private static final String REST_PATH = "v1/advertisers/{+advertiserId}/negativeKeywordLists";
                private final Pattern ADVERTISER_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(Long advertiserId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, ListNegativeKeywordListsResponse.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public List setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends DisplayVideoRequest<NegativeKeywordList> {
                private static final String REST_PATH = "v1/advertisers/{+advertiserId}/negativeKeywordLists/{+negativeKeywordListId}";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern NEGATIVE_KEYWORD_LIST_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long negativeKeywordListId;

                protected Get(Long advertiserId, Long negativeKeywordListId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, NegativeKeywordList.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.NEGATIVE_KEYWORD_LIST_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.negativeKeywordListId = (Long)Preconditions.checkNotNull((Object)negativeKeywordListId, (Object)"Required parameter negativeKeywordListId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Get setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getNegativeKeywordListId() {
                    return this.negativeKeywordListId;
                }

                public Get setNegativeKeywordListId(Long negativeKeywordListId) {
                    this.negativeKeywordListId = negativeKeywordListId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class LocationLists {
            public Get get(Long advertiserId, Long locationListId) throws IOException {
                Get result = new Get(advertiserId, locationListId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(Long advertiserId) throws IOException {
                List result = new List(advertiserId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends DisplayVideoRequest<ListLocationListsResponse> {
                private static final String REST_PATH = "v1/advertisers/{+advertiserId}/locationLists";
                private final Pattern ADVERTISER_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private String filter;
                @Key
                private String orderBy;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(Long advertiserId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, ListLocationListsResponse.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public List setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public List setOrderBy(String orderBy) {
                    this.orderBy = orderBy;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends DisplayVideoRequest<LocationList> {
                private static final String REST_PATH = "v1/advertisers/{+advertiserId}/locationLists/{+locationListId}";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern LOCATION_LIST_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long locationListId;

                protected Get(Long advertiserId, Long locationListId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, LocationList.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.LOCATION_LIST_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.locationListId = (Long)Preconditions.checkNotNull((Object)locationListId, (Object)"Required parameter locationListId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Get setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getLocationListId() {
                    return this.locationListId;
                }

                public Get setLocationListId(Long locationListId) {
                    this.locationListId = locationListId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class LineItems {
            public BulkEditLineItemAssignedTargetingOptions bulkEditLineItemAssignedTargetingOptions(Long advertiserId, Long lineItemId, BulkEditLineItemAssignedTargetingOptionsRequest content) throws IOException {
                BulkEditLineItemAssignedTargetingOptions result = new BulkEditLineItemAssignedTargetingOptions(advertiserId, lineItemId, content);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public BulkListLineItemAssignedTargetingOptions bulkListLineItemAssignedTargetingOptions(Long advertiserId, Long lineItemId) throws IOException {
                BulkListLineItemAssignedTargetingOptions result = new BulkListLineItemAssignedTargetingOptions(advertiserId, lineItemId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Create create(Long advertiserId, LineItem content) throws IOException {
                Create result = new Create(advertiserId, content);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(Long advertiserId, Long lineItemId) throws IOException {
                Delete result = new Delete(advertiserId, lineItemId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(Long advertiserId, Long lineItemId) throws IOException {
                Get result = new Get(advertiserId, lineItemId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(Long advertiserId) throws IOException {
                List result = new List(advertiserId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(Long advertiserId, Long lineItemId, LineItem content) throws IOException {
                Patch result = new Patch(advertiserId, lineItemId, content);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public TargetingTypes targetingTypes() {
                return new TargetingTypes();
            }

            public class TargetingTypes {
                public AssignedTargetingOptions assignedTargetingOptions() {
                    return new AssignedTargetingOptions();
                }

                public class AssignedTargetingOptions {
                    public Create create(Long advertiserId, Long lineItemId, String targetingType, AssignedTargetingOption content) throws IOException {
                        Create result = new Create(advertiserId, lineItemId, targetingType, content);
                        DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Delete delete(Long advertiserId, Long lineItemId, String targetingType, String assignedTargetingOptionId) throws IOException {
                        Delete result = new Delete(advertiserId, lineItemId, targetingType, assignedTargetingOptionId);
                        DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Get get(Long advertiserId, Long lineItemId, String targetingType, String assignedTargetingOptionId) throws IOException {
                        Get result = new Get(advertiserId, lineItemId, targetingType, assignedTargetingOptionId);
                        DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public List list(Long advertiserId, Long lineItemId, String targetingType) throws IOException {
                        List result = new List(advertiserId, lineItemId, targetingType);
                        DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class List
                    extends DisplayVideoRequest<ListLineItemAssignedTargetingOptionsResponse> {
                        private static final String REST_PATH = "v1/advertisers/{+advertiserId}/lineItems/{+lineItemId}/targetingTypes/{+targetingType}/assignedTargetingOptions";
                        private final Pattern ADVERTISER_ID_PATTERN;
                        private final Pattern LINE_ITEM_ID_PATTERN;
                        private final Pattern TARGETING_TYPE_PATTERN;
                        @Key
                        private Long advertiserId;
                        @Key
                        private Long lineItemId;
                        @Key
                        private String targetingType;
                        @Key
                        private String filter;
                        @Key
                        private String orderBy;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(Long advertiserId, Long lineItemId, String targetingType) {
                            super(DisplayVideo.this, "GET", REST_PATH, null, ListLineItemAssignedTargetingOptionsResponse.class);
                            this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                            this.LINE_ITEM_ID_PATTERN = Pattern.compile("^[^/]+$");
                            this.TARGETING_TYPE_PATTERN = Pattern.compile("^[^/]+$");
                            this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                            this.lineItemId = (Long)Preconditions.checkNotNull((Object)lineItemId, (Object)"Required parameter lineItemId must be specified.");
                            this.targetingType = (String)Preconditions.checkNotNull((Object)targetingType, (Object)"Required parameter targetingType must be specified.");
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public Long getAdvertiserId() {
                            return this.advertiserId;
                        }

                        public List setAdvertiserId(Long advertiserId) {
                            this.advertiserId = advertiserId;
                            return this;
                        }

                        public Long getLineItemId() {
                            return this.lineItemId;
                        }

                        public List setLineItemId(Long lineItemId) {
                            this.lineItemId = lineItemId;
                            return this;
                        }

                        public String getTargetingType() {
                            return this.targetingType;
                        }

                        public List setTargetingType(String targetingType) {
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                            }
                            this.targetingType = targetingType;
                            return this;
                        }

                        public String getFilter() {
                            return this.filter;
                        }

                        public List setFilter(String filter) {
                            this.filter = filter;
                            return this;
                        }

                        public String getOrderBy() {
                            return this.orderBy;
                        }

                        public List setOrderBy(String orderBy) {
                            this.orderBy = orderBy;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }

                    public class Get
                    extends DisplayVideoRequest<AssignedTargetingOption> {
                        private static final String REST_PATH = "v1/advertisers/{+advertiserId}/lineItems/{+lineItemId}/targetingTypes/{+targetingType}/assignedTargetingOptions/{+assignedTargetingOptionId}";
                        private final Pattern ADVERTISER_ID_PATTERN;
                        private final Pattern LINE_ITEM_ID_PATTERN;
                        private final Pattern TARGETING_TYPE_PATTERN;
                        private final Pattern ASSIGNED_TARGETING_OPTION_ID_PATTERN;
                        @Key
                        private Long advertiserId;
                        @Key
                        private Long lineItemId;
                        @Key
                        private String targetingType;
                        @Key
                        private String assignedTargetingOptionId;

                        protected Get(Long advertiserId, Long lineItemId, String targetingType, String assignedTargetingOptionId) {
                            super(DisplayVideo.this, "GET", REST_PATH, null, AssignedTargetingOption.class);
                            this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                            this.LINE_ITEM_ID_PATTERN = Pattern.compile("^[^/]+$");
                            this.TARGETING_TYPE_PATTERN = Pattern.compile("^[^/]+$");
                            this.ASSIGNED_TARGETING_OPTION_ID_PATTERN = Pattern.compile("^[^/]+$");
                            this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                            this.lineItemId = (Long)Preconditions.checkNotNull((Object)lineItemId, (Object)"Required parameter lineItemId must be specified.");
                            this.targetingType = (String)Preconditions.checkNotNull((Object)targetingType, (Object)"Required parameter targetingType must be specified.");
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                            }
                            this.assignedTargetingOptionId = (String)Preconditions.checkNotNull((Object)assignedTargetingOptionId, (Object)"Required parameter assignedTargetingOptionId must be specified.");
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.ASSIGNED_TARGETING_OPTION_ID_PATTERN.matcher(assignedTargetingOptionId).matches(), (Object)"Parameter assignedTargetingOptionId must conform to the pattern ^[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String $Xgafv) {
                            return (Get)super.set$Xgafv($Xgafv);
                        }

                        public Get setAccessToken(String accessToken) {
                            return (Get)super.setAccessToken(accessToken);
                        }

                        public Get setAlt(String alt) {
                            return (Get)super.setAlt(alt);
                        }

                        public Get setCallback(String callback) {
                            return (Get)super.setCallback(callback);
                        }

                        public Get setFields(String fields) {
                            return (Get)super.setFields(fields);
                        }

                        public Get setKey(String key) {
                            return (Get)super.setKey(key);
                        }

                        public Get setOauthToken(String oauthToken) {
                            return (Get)super.setOauthToken(oauthToken);
                        }

                        public Get setPrettyPrint(Boolean prettyPrint) {
                            return (Get)super.setPrettyPrint(prettyPrint);
                        }

                        public Get setQuotaUser(String quotaUser) {
                            return (Get)super.setQuotaUser(quotaUser);
                        }

                        public Get setUploadType(String uploadType) {
                            return (Get)super.setUploadType(uploadType);
                        }

                        public Get setUploadProtocol(String uploadProtocol) {
                            return (Get)super.setUploadProtocol(uploadProtocol);
                        }

                        public Long getAdvertiserId() {
                            return this.advertiserId;
                        }

                        public Get setAdvertiserId(Long advertiserId) {
                            this.advertiserId = advertiserId;
                            return this;
                        }

                        public Long getLineItemId() {
                            return this.lineItemId;
                        }

                        public Get setLineItemId(Long lineItemId) {
                            this.lineItemId = lineItemId;
                            return this;
                        }

                        public String getTargetingType() {
                            return this.targetingType;
                        }

                        public Get setTargetingType(String targetingType) {
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                            }
                            this.targetingType = targetingType;
                            return this;
                        }

                        public String getAssignedTargetingOptionId() {
                            return this.assignedTargetingOptionId;
                        }

                        public Get setAssignedTargetingOptionId(String assignedTargetingOptionId) {
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.ASSIGNED_TARGETING_OPTION_ID_PATTERN.matcher(assignedTargetingOptionId).matches(), (Object)"Parameter assignedTargetingOptionId must conform to the pattern ^[^/]+$");
                            }
                            this.assignedTargetingOptionId = assignedTargetingOptionId;
                            return this;
                        }

                        @Override
                        public Get set(String parameterName, Object value) {
                            return (Get)super.set(parameterName, value);
                        }
                    }

                    public class Delete
                    extends DisplayVideoRequest<Empty> {
                        private static final String REST_PATH = "v1/advertisers/{+advertiserId}/lineItems/{+lineItemId}/targetingTypes/{+targetingType}/assignedTargetingOptions/{+assignedTargetingOptionId}";
                        private final Pattern ADVERTISER_ID_PATTERN;
                        private final Pattern LINE_ITEM_ID_PATTERN;
                        private final Pattern TARGETING_TYPE_PATTERN;
                        private final Pattern ASSIGNED_TARGETING_OPTION_ID_PATTERN;
                        @Key
                        private Long advertiserId;
                        @Key
                        private Long lineItemId;
                        @Key
                        private String targetingType;
                        @Key
                        private String assignedTargetingOptionId;

                        protected Delete(Long advertiserId, Long lineItemId, String targetingType, String assignedTargetingOptionId) {
                            super(DisplayVideo.this, "DELETE", REST_PATH, null, Empty.class);
                            this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                            this.LINE_ITEM_ID_PATTERN = Pattern.compile("^[^/]+$");
                            this.TARGETING_TYPE_PATTERN = Pattern.compile("^[^/]+$");
                            this.ASSIGNED_TARGETING_OPTION_ID_PATTERN = Pattern.compile("^[^/]+$");
                            this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                            this.lineItemId = (Long)Preconditions.checkNotNull((Object)lineItemId, (Object)"Required parameter lineItemId must be specified.");
                            this.targetingType = (String)Preconditions.checkNotNull((Object)targetingType, (Object)"Required parameter targetingType must be specified.");
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                            }
                            this.assignedTargetingOptionId = (String)Preconditions.checkNotNull((Object)assignedTargetingOptionId, (Object)"Required parameter assignedTargetingOptionId must be specified.");
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.ASSIGNED_TARGETING_OPTION_ID_PATTERN.matcher(assignedTargetingOptionId).matches(), (Object)"Parameter assignedTargetingOptionId must conform to the pattern ^[^/]+$");
                            }
                        }

                        public Delete set$Xgafv(String $Xgafv) {
                            return (Delete)super.set$Xgafv($Xgafv);
                        }

                        public Delete setAccessToken(String accessToken) {
                            return (Delete)super.setAccessToken(accessToken);
                        }

                        public Delete setAlt(String alt) {
                            return (Delete)super.setAlt(alt);
                        }

                        public Delete setCallback(String callback) {
                            return (Delete)super.setCallback(callback);
                        }

                        public Delete setFields(String fields) {
                            return (Delete)super.setFields(fields);
                        }

                        public Delete setKey(String key) {
                            return (Delete)super.setKey(key);
                        }

                        public Delete setOauthToken(String oauthToken) {
                            return (Delete)super.setOauthToken(oauthToken);
                        }

                        public Delete setPrettyPrint(Boolean prettyPrint) {
                            return (Delete)super.setPrettyPrint(prettyPrint);
                        }

                        public Delete setQuotaUser(String quotaUser) {
                            return (Delete)super.setQuotaUser(quotaUser);
                        }

                        public Delete setUploadType(String uploadType) {
                            return (Delete)super.setUploadType(uploadType);
                        }

                        public Delete setUploadProtocol(String uploadProtocol) {
                            return (Delete)super.setUploadProtocol(uploadProtocol);
                        }

                        public Long getAdvertiserId() {
                            return this.advertiserId;
                        }

                        public Delete setAdvertiserId(Long advertiserId) {
                            this.advertiserId = advertiserId;
                            return this;
                        }

                        public Long getLineItemId() {
                            return this.lineItemId;
                        }

                        public Delete setLineItemId(Long lineItemId) {
                            this.lineItemId = lineItemId;
                            return this;
                        }

                        public String getTargetingType() {
                            return this.targetingType;
                        }

                        public Delete setTargetingType(String targetingType) {
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                            }
                            this.targetingType = targetingType;
                            return this;
                        }

                        public String getAssignedTargetingOptionId() {
                            return this.assignedTargetingOptionId;
                        }

                        public Delete setAssignedTargetingOptionId(String assignedTargetingOptionId) {
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.ASSIGNED_TARGETING_OPTION_ID_PATTERN.matcher(assignedTargetingOptionId).matches(), (Object)"Parameter assignedTargetingOptionId must conform to the pattern ^[^/]+$");
                            }
                            this.assignedTargetingOptionId = assignedTargetingOptionId;
                            return this;
                        }

                        @Override
                        public Delete set(String parameterName, Object value) {
                            return (Delete)super.set(parameterName, value);
                        }
                    }

                    public class Create
                    extends DisplayVideoRequest<AssignedTargetingOption> {
                        private static final String REST_PATH = "v1/advertisers/{+advertiserId}/lineItems/{+lineItemId}/targetingTypes/{+targetingType}/assignedTargetingOptions";
                        private final Pattern ADVERTISER_ID_PATTERN;
                        private final Pattern LINE_ITEM_ID_PATTERN;
                        private final Pattern TARGETING_TYPE_PATTERN;
                        @Key
                        private Long advertiserId;
                        @Key
                        private Long lineItemId;
                        @Key
                        private String targetingType;

                        protected Create(Long advertiserId, Long lineItemId, String targetingType, AssignedTargetingOption content) {
                            super(DisplayVideo.this, "POST", REST_PATH, (Object)content, AssignedTargetingOption.class);
                            this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                            this.LINE_ITEM_ID_PATTERN = Pattern.compile("^[^/]+$");
                            this.TARGETING_TYPE_PATTERN = Pattern.compile("^[^/]+$");
                            this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                            this.lineItemId = (Long)Preconditions.checkNotNull((Object)lineItemId, (Object)"Required parameter lineItemId must be specified.");
                            this.targetingType = (String)Preconditions.checkNotNull((Object)targetingType, (Object)"Required parameter targetingType must be specified.");
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                            }
                        }

                        public Create set$Xgafv(String $Xgafv) {
                            return (Create)super.set$Xgafv($Xgafv);
                        }

                        public Create setAccessToken(String accessToken) {
                            return (Create)super.setAccessToken(accessToken);
                        }

                        public Create setAlt(String alt) {
                            return (Create)super.setAlt(alt);
                        }

                        public Create setCallback(String callback) {
                            return (Create)super.setCallback(callback);
                        }

                        public Create setFields(String fields) {
                            return (Create)super.setFields(fields);
                        }

                        public Create setKey(String key) {
                            return (Create)super.setKey(key);
                        }

                        public Create setOauthToken(String oauthToken) {
                            return (Create)super.setOauthToken(oauthToken);
                        }

                        public Create setPrettyPrint(Boolean prettyPrint) {
                            return (Create)super.setPrettyPrint(prettyPrint);
                        }

                        public Create setQuotaUser(String quotaUser) {
                            return (Create)super.setQuotaUser(quotaUser);
                        }

                        public Create setUploadType(String uploadType) {
                            return (Create)super.setUploadType(uploadType);
                        }

                        public Create setUploadProtocol(String uploadProtocol) {
                            return (Create)super.setUploadProtocol(uploadProtocol);
                        }

                        public Long getAdvertiserId() {
                            return this.advertiserId;
                        }

                        public Create setAdvertiserId(Long advertiserId) {
                            this.advertiserId = advertiserId;
                            return this;
                        }

                        public Long getLineItemId() {
                            return this.lineItemId;
                        }

                        public Create setLineItemId(Long lineItemId) {
                            this.lineItemId = lineItemId;
                            return this;
                        }

                        public String getTargetingType() {
                            return this.targetingType;
                        }

                        public Create setTargetingType(String targetingType) {
                            if (!DisplayVideo.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.TARGETING_TYPE_PATTERN.matcher(targetingType).matches(), (Object)"Parameter targetingType must conform to the pattern ^[^/]+$");
                            }
                            this.targetingType = targetingType;
                            return this;
                        }

                        @Override
                        public Create set(String parameterName, Object value) {
                            return (Create)super.set(parameterName, value);
                        }
                    }
                }
            }

            public class Patch
            extends DisplayVideoRequest<LineItem> {
                private static final String REST_PATH = "v1/advertisers/{+advertiserId}/lineItems/{+lineItemId}";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern LINE_ITEM_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long lineItemId;
                @Key
                private String updateMask;

                protected Patch(Long advertiserId, Long lineItemId, LineItem content) {
                    super(DisplayVideo.this, "PATCH", REST_PATH, (Object)content, LineItem.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.LINE_ITEM_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.lineItemId = (Long)Preconditions.checkNotNull((Object)lineItemId, (Object)"Required parameter lineItemId must be specified.");
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Patch setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getLineItemId() {
                    return this.lineItemId;
                }

                public Patch setLineItemId(Long lineItemId) {
                    this.lineItemId = lineItemId;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends DisplayVideoRequest<ListLineItemsResponse> {
                private static final String REST_PATH = "v1/advertisers/{+advertiserId}/lineItems";
                private final Pattern ADVERTISER_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private String filter;
                @Key
                private String orderBy;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(Long advertiserId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, ListLineItemsResponse.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public List setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public List setOrderBy(String orderBy) {
                    this.orderBy = orderBy;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends DisplayVideoRequest<LineItem> {
                private static final String REST_PATH = "v1/advertisers/{+advertiserId}/lineItems/{+lineItemId}";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern LINE_ITEM_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long lineItemId;

                protected Get(Long advertiserId, Long lineItemId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, LineItem.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.LINE_ITEM_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.lineItemId = (Long)Preconditions.checkNotNull((Object)lineItemId, (Object)"Required parameter lineItemId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Get setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getLineItemId() {
                    return this.lineItemId;
                }

                public Get setLineItemId(Long lineItemId) {
                    this.lineItemId = lineItemId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends DisplayVideoRequest<Empty> {
                private static final String REST_PATH = "v1/advertisers/{+advertiserId}/lineItems/{+lineItemId}";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern LINE_ITEM_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long lineItemId;

                protected Delete(Long advertiserId, Long lineItemId) {
                    super(DisplayVideo.this, "DELETE", REST_PATH, null, Empty.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.LINE_ITEM_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.lineItemId = (Long)Preconditions.checkNotNull((Object)lineItemId, (Object)"Required parameter lineItemId must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Delete setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getLineItemId() {
                    return this.lineItemId;
                }

                public Delete setLineItemId(Long lineItemId) {
                    this.lineItemId = lineItemId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends DisplayVideoRequest<LineItem> {
                private static final String REST_PATH = "v1/advertisers/{+advertiserId}/lineItems";
                private final Pattern ADVERTISER_ID_PATTERN;
                @Key
                private Long advertiserId;

                protected Create(Long advertiserId, LineItem content) {
                    super(DisplayVideo.this, "POST", REST_PATH, (Object)content, LineItem.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Create setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }

            public class BulkListLineItemAssignedTargetingOptions
            extends DisplayVideoRequest<BulkListLineItemAssignedTargetingOptionsResponse> {
                private static final String REST_PATH = "v1/advertisers/{+advertiserId}/lineItems/{+lineItemId}:bulkListLineItemAssignedTargetingOptions";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern LINE_ITEM_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long lineItemId;
                @Key
                private String filter;
                @Key
                private String orderBy;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected BulkListLineItemAssignedTargetingOptions(Long advertiserId, Long lineItemId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, BulkListLineItemAssignedTargetingOptionsResponse.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.LINE_ITEM_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.lineItemId = (Long)Preconditions.checkNotNull((Object)lineItemId, (Object)"Required parameter lineItemId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public BulkListLineItemAssignedTargetingOptions set$Xgafv(String $Xgafv) {
                    return (BulkListLineItemAssignedTargetingOptions)super.set$Xgafv($Xgafv);
                }

                public BulkListLineItemAssignedTargetingOptions setAccessToken(String accessToken) {
                    return (BulkListLineItemAssignedTargetingOptions)super.setAccessToken(accessToken);
                }

                public BulkListLineItemAssignedTargetingOptions setAlt(String alt) {
                    return (BulkListLineItemAssignedTargetingOptions)super.setAlt(alt);
                }

                public BulkListLineItemAssignedTargetingOptions setCallback(String callback) {
                    return (BulkListLineItemAssignedTargetingOptions)super.setCallback(callback);
                }

                public BulkListLineItemAssignedTargetingOptions setFields(String fields) {
                    return (BulkListLineItemAssignedTargetingOptions)super.setFields(fields);
                }

                public BulkListLineItemAssignedTargetingOptions setKey(String key) {
                    return (BulkListLineItemAssignedTargetingOptions)super.setKey(key);
                }

                public BulkListLineItemAssignedTargetingOptions setOauthToken(String oauthToken) {
                    return (BulkListLineItemAssignedTargetingOptions)super.setOauthToken(oauthToken);
                }

                public BulkListLineItemAssignedTargetingOptions setPrettyPrint(Boolean prettyPrint) {
                    return (BulkListLineItemAssignedTargetingOptions)super.setPrettyPrint(prettyPrint);
                }

                public BulkListLineItemAssignedTargetingOptions setQuotaUser(String quotaUser) {
                    return (BulkListLineItemAssignedTargetingOptions)super.setQuotaUser(quotaUser);
                }

                public BulkListLineItemAssignedTargetingOptions setUploadType(String uploadType) {
                    return (BulkListLineItemAssignedTargetingOptions)super.setUploadType(uploadType);
                }

                public BulkListLineItemAssignedTargetingOptions setUploadProtocol(String uploadProtocol) {
                    return (BulkListLineItemAssignedTargetingOptions)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public BulkListLineItemAssignedTargetingOptions setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getLineItemId() {
                    return this.lineItemId;
                }

                public BulkListLineItemAssignedTargetingOptions setLineItemId(Long lineItemId) {
                    this.lineItemId = lineItemId;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public BulkListLineItemAssignedTargetingOptions setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public BulkListLineItemAssignedTargetingOptions setOrderBy(String orderBy) {
                    this.orderBy = orderBy;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public BulkListLineItemAssignedTargetingOptions setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public BulkListLineItemAssignedTargetingOptions setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public BulkListLineItemAssignedTargetingOptions set(String parameterName, Object value) {
                    return (BulkListLineItemAssignedTargetingOptions)super.set(parameterName, value);
                }
            }

            public class BulkEditLineItemAssignedTargetingOptions
            extends DisplayVideoRequest<BulkEditLineItemAssignedTargetingOptionsResponse> {
                private static final String REST_PATH = "v1/advertisers/{+advertiserId}/lineItems/{+lineItemId}:bulkEditLineItemAssignedTargetingOptions";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern LINE_ITEM_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long lineItemId;

                protected BulkEditLineItemAssignedTargetingOptions(Long advertiserId, Long lineItemId, BulkEditLineItemAssignedTargetingOptionsRequest content) {
                    super(DisplayVideo.this, "POST", REST_PATH, (Object)content, BulkEditLineItemAssignedTargetingOptionsResponse.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.LINE_ITEM_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.lineItemId = (Long)Preconditions.checkNotNull((Object)lineItemId, (Object)"Required parameter lineItemId must be specified.");
                }

                public BulkEditLineItemAssignedTargetingOptions set$Xgafv(String $Xgafv) {
                    return (BulkEditLineItemAssignedTargetingOptions)super.set$Xgafv($Xgafv);
                }

                public BulkEditLineItemAssignedTargetingOptions setAccessToken(String accessToken) {
                    return (BulkEditLineItemAssignedTargetingOptions)super.setAccessToken(accessToken);
                }

                public BulkEditLineItemAssignedTargetingOptions setAlt(String alt) {
                    return (BulkEditLineItemAssignedTargetingOptions)super.setAlt(alt);
                }

                public BulkEditLineItemAssignedTargetingOptions setCallback(String callback) {
                    return (BulkEditLineItemAssignedTargetingOptions)super.setCallback(callback);
                }

                public BulkEditLineItemAssignedTargetingOptions setFields(String fields) {
                    return (BulkEditLineItemAssignedTargetingOptions)super.setFields(fields);
                }

                public BulkEditLineItemAssignedTargetingOptions setKey(String key) {
                    return (BulkEditLineItemAssignedTargetingOptions)super.setKey(key);
                }

                public BulkEditLineItemAssignedTargetingOptions setOauthToken(String oauthToken) {
                    return (BulkEditLineItemAssignedTargetingOptions)super.setOauthToken(oauthToken);
                }

                public BulkEditLineItemAssignedTargetingOptions setPrettyPrint(Boolean prettyPrint) {
                    return (BulkEditLineItemAssignedTargetingOptions)super.setPrettyPrint(prettyPrint);
                }

                public BulkEditLineItemAssignedTargetingOptions setQuotaUser(String quotaUser) {
                    return (BulkEditLineItemAssignedTargetingOptions)super.setQuotaUser(quotaUser);
                }

                public BulkEditLineItemAssignedTargetingOptions setUploadType(String uploadType) {
                    return (BulkEditLineItemAssignedTargetingOptions)super.setUploadType(uploadType);
                }

                public BulkEditLineItemAssignedTargetingOptions setUploadProtocol(String uploadProtocol) {
                    return (BulkEditLineItemAssignedTargetingOptions)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public BulkEditLineItemAssignedTargetingOptions setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getLineItemId() {
                    return this.lineItemId;
                }

                public BulkEditLineItemAssignedTargetingOptions setLineItemId(Long lineItemId) {
                    this.lineItemId = lineItemId;
                    return this;
                }

                @Override
                public BulkEditLineItemAssignedTargetingOptions set(String parameterName, Object value) {
                    return (BulkEditLineItemAssignedTargetingOptions)super.set(parameterName, value);
                }
            }
        }

        public class InsertionOrders {
            public Create create(Long advertiserId, InsertionOrder content) throws IOException {
                Create result = new Create(advertiserId, content);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(Long advertiserId, Long insertionOrderId) throws IOException {
                Delete result = new Delete(advertiserId, insertionOrderId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(Long advertiserId, Long insertionOrderId) throws IOException {
                Get result = new Get(advertiserId, insertionOrderId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(Long advertiserId) throws IOException {
                List result = new List(advertiserId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(Long advertiserId, Long insertionOrderId, InsertionOrder content) throws IOException {
                Patch result = new Patch(advertiserId, insertionOrderId, content);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Patch
            extends DisplayVideoRequest<InsertionOrder> {
                private static final String REST_PATH = "v1/advertisers/{+advertiserId}/insertionOrders/{+insertionOrderId}";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern INSERTION_ORDER_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long insertionOrderId;
                @Key
                private String updateMask;

                protected Patch(Long advertiserId, Long insertionOrderId, InsertionOrder content) {
                    super(DisplayVideo.this, "PATCH", REST_PATH, (Object)content, InsertionOrder.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.INSERTION_ORDER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.insertionOrderId = (Long)Preconditions.checkNotNull((Object)insertionOrderId, (Object)"Required parameter insertionOrderId must be specified.");
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Patch setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getInsertionOrderId() {
                    return this.insertionOrderId;
                }

                public Patch setInsertionOrderId(Long insertionOrderId) {
                    this.insertionOrderId = insertionOrderId;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends DisplayVideoRequest<ListInsertionOrdersResponse> {
                private static final String REST_PATH = "v1/advertisers/{+advertiserId}/insertionOrders";
                private final Pattern ADVERTISER_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private String filter;
                @Key
                private String orderBy;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(Long advertiserId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, ListInsertionOrdersResponse.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public List setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public List setOrderBy(String orderBy) {
                    this.orderBy = orderBy;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends DisplayVideoRequest<InsertionOrder> {
                private static final String REST_PATH = "v1/advertisers/{+advertiserId}/insertionOrders/{+insertionOrderId}";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern INSERTION_ORDER_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long insertionOrderId;

                protected Get(Long advertiserId, Long insertionOrderId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, InsertionOrder.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.INSERTION_ORDER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.insertionOrderId = (Long)Preconditions.checkNotNull((Object)insertionOrderId, (Object)"Required parameter insertionOrderId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Get setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getInsertionOrderId() {
                    return this.insertionOrderId;
                }

                public Get setInsertionOrderId(Long insertionOrderId) {
                    this.insertionOrderId = insertionOrderId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends DisplayVideoRequest<Empty> {
                private static final String REST_PATH = "v1/advertisers/{+advertiserId}/insertionOrders/{+insertionOrderId}";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern INSERTION_ORDER_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long insertionOrderId;

                protected Delete(Long advertiserId, Long insertionOrderId) {
                    super(DisplayVideo.this, "DELETE", REST_PATH, null, Empty.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.INSERTION_ORDER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.insertionOrderId = (Long)Preconditions.checkNotNull((Object)insertionOrderId, (Object)"Required parameter insertionOrderId must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Delete setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getInsertionOrderId() {
                    return this.insertionOrderId;
                }

                public Delete setInsertionOrderId(Long insertionOrderId) {
                    this.insertionOrderId = insertionOrderId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends DisplayVideoRequest<InsertionOrder> {
                private static final String REST_PATH = "v1/advertisers/{+advertiserId}/insertionOrders";
                private final Pattern ADVERTISER_ID_PATTERN;
                @Key
                private Long advertiserId;

                protected Create(Long advertiserId, InsertionOrder content) {
                    super(DisplayVideo.this, "POST", REST_PATH, (Object)content, InsertionOrder.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Create setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Creatives {
            public Create create(Long advertiserId, Creative content) throws IOException {
                Create result = new Create(advertiserId, content);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(Long advertiserId, Long creativeId) throws IOException {
                Delete result = new Delete(advertiserId, creativeId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(Long advertiserId, Long creativeId) throws IOException {
                Get result = new Get(advertiserId, creativeId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(Long advertiserId) throws IOException {
                List result = new List(advertiserId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(Long advertiserId, Long creativeId, Creative content) throws IOException {
                Patch result = new Patch(advertiserId, creativeId, content);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Patch
            extends DisplayVideoRequest<Creative> {
                private static final String REST_PATH = "v1/advertisers/{+advertiserId}/creatives/{+creativeId}";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern CREATIVE_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long creativeId;
                @Key
                private String updateMask;

                protected Patch(Long advertiserId, Long creativeId, Creative content) {
                    super(DisplayVideo.this, "PATCH", REST_PATH, (Object)content, Creative.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.CREATIVE_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.creativeId = (Long)Preconditions.checkNotNull((Object)creativeId, (Object)"Required parameter creativeId must be specified.");
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Patch setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getCreativeId() {
                    return this.creativeId;
                }

                public Patch setCreativeId(Long creativeId) {
                    this.creativeId = creativeId;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends DisplayVideoRequest<ListCreativesResponse> {
                private static final String REST_PATH = "v1/advertisers/{+advertiserId}/creatives";
                private final Pattern ADVERTISER_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private String filter;
                @Key
                private String orderBy;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(Long advertiserId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, ListCreativesResponse.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public List setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public List setOrderBy(String orderBy) {
                    this.orderBy = orderBy;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends DisplayVideoRequest<Creative> {
                private static final String REST_PATH = "v1/advertisers/{+advertiserId}/creatives/{+creativeId}";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern CREATIVE_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long creativeId;

                protected Get(Long advertiserId, Long creativeId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, Creative.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.CREATIVE_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.creativeId = (Long)Preconditions.checkNotNull((Object)creativeId, (Object)"Required parameter creativeId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Get setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getCreativeId() {
                    return this.creativeId;
                }

                public Get setCreativeId(Long creativeId) {
                    this.creativeId = creativeId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends DisplayVideoRequest<Empty> {
                private static final String REST_PATH = "v1/advertisers/{+advertiserId}/creatives/{+creativeId}";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern CREATIVE_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long creativeId;

                protected Delete(Long advertiserId, Long creativeId) {
                    super(DisplayVideo.this, "DELETE", REST_PATH, null, Empty.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.CREATIVE_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.creativeId = (Long)Preconditions.checkNotNull((Object)creativeId, (Object)"Required parameter creativeId must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Delete setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getCreativeId() {
                    return this.creativeId;
                }

                public Delete setCreativeId(Long creativeId) {
                    this.creativeId = creativeId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends DisplayVideoRequest<Creative> {
                private static final String REST_PATH = "v1/advertisers/{+advertiserId}/creatives";
                private final Pattern ADVERTISER_ID_PATTERN;
                @Key
                private Long advertiserId;

                protected Create(Long advertiserId, Creative content) {
                    super(DisplayVideo.this, "POST", REST_PATH, (Object)content, Creative.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Create setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Channels {
            public Get get(Long advertiserId, Long channelId) throws IOException {
                Get result = new Get(advertiserId, channelId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(Long advertiserId) throws IOException {
                List result = new List(advertiserId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends DisplayVideoRequest<ListChannelsResponse> {
                private static final String REST_PATH = "v1/advertisers/{+advertiserId}/channels";
                private final Pattern ADVERTISER_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private String filter;
                @Key
                private String orderBy;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;
                @Key
                private Long partnerId;

                protected List(Long advertiserId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, ListChannelsResponse.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public List setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public List setOrderBy(String orderBy) {
                    this.orderBy = orderBy;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public Long getPartnerId() {
                    return this.partnerId;
                }

                public List setPartnerId(Long partnerId) {
                    this.partnerId = partnerId;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends DisplayVideoRequest<Channel> {
                private static final String REST_PATH = "v1/advertisers/{+advertiserId}/channels/{+channelId}";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern CHANNEL_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long channelId;
                @Key
                private Long partnerId;

                protected Get(Long advertiserId, Long channelId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, Channel.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.CHANNEL_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.channelId = (Long)Preconditions.checkNotNull((Object)channelId, (Object)"Required parameter channelId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Get setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getChannelId() {
                    return this.channelId;
                }

                public Get setChannelId(Long channelId) {
                    this.channelId = channelId;
                    return this;
                }

                public Long getPartnerId() {
                    return this.partnerId;
                }

                public Get setPartnerId(Long partnerId) {
                    this.partnerId = partnerId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class Campaigns {
            public Create create(Long advertiserId, Campaign content) throws IOException {
                Create result = new Create(advertiserId, content);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(Long advertiserId, Long campaignId) throws IOException {
                Delete result = new Delete(advertiserId, campaignId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(Long advertiserId, Long campaignId) throws IOException {
                Get result = new Get(advertiserId, campaignId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(Long advertiserId) throws IOException {
                List result = new List(advertiserId);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(Long advertiserId, Long campaignId, Campaign content) throws IOException {
                Patch result = new Patch(advertiserId, campaignId, content);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Patch
            extends DisplayVideoRequest<Campaign> {
                private static final String REST_PATH = "v1/advertisers/{+advertiserId}/campaigns/{+campaignId}";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern CAMPAIGN_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long campaignId;
                @Key
                private String updateMask;

                protected Patch(Long advertiserId, Long campaignId, Campaign content) {
                    super(DisplayVideo.this, "PATCH", REST_PATH, (Object)content, Campaign.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.CAMPAIGN_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.campaignId = (Long)Preconditions.checkNotNull((Object)campaignId, (Object)"Required parameter campaignId must be specified.");
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Patch setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getCampaignId() {
                    return this.campaignId;
                }

                public Patch setCampaignId(Long campaignId) {
                    this.campaignId = campaignId;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends DisplayVideoRequest<ListCampaignsResponse> {
                private static final String REST_PATH = "v1/advertisers/{+advertiserId}/campaigns";
                private final Pattern ADVERTISER_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private String filter;
                @Key
                private String orderBy;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(Long advertiserId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, ListCampaignsResponse.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public List setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public List setOrderBy(String orderBy) {
                    this.orderBy = orderBy;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends DisplayVideoRequest<Campaign> {
                private static final String REST_PATH = "v1/advertisers/{+advertiserId}/campaigns/{+campaignId}";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern CAMPAIGN_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long campaignId;

                protected Get(Long advertiserId, Long campaignId) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, Campaign.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.CAMPAIGN_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.campaignId = (Long)Preconditions.checkNotNull((Object)campaignId, (Object)"Required parameter campaignId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Get setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getCampaignId() {
                    return this.campaignId;
                }

                public Get setCampaignId(Long campaignId) {
                    this.campaignId = campaignId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends DisplayVideoRequest<Empty> {
                private static final String REST_PATH = "v1/advertisers/{+advertiserId}/campaigns/{+campaignId}";
                private final Pattern ADVERTISER_ID_PATTERN;
                private final Pattern CAMPAIGN_ID_PATTERN;
                @Key
                private Long advertiserId;
                @Key
                private Long campaignId;

                protected Delete(Long advertiserId, Long campaignId) {
                    super(DisplayVideo.this, "DELETE", REST_PATH, null, Empty.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.CAMPAIGN_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.campaignId = (Long)Preconditions.checkNotNull((Object)campaignId, (Object)"Required parameter campaignId must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Delete setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                public Long getCampaignId() {
                    return this.campaignId;
                }

                public Delete setCampaignId(Long campaignId) {
                    this.campaignId = campaignId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends DisplayVideoRequest<Campaign> {
                private static final String REST_PATH = "v1/advertisers/{+advertiserId}/campaigns";
                private final Pattern ADVERTISER_ID_PATTERN;
                @Key
                private Long advertiserId;

                protected Create(Long advertiserId, Campaign content) {
                    super(DisplayVideo.this, "POST", REST_PATH, (Object)content, Campaign.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Create setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Assets {
            public Upload upload(Long advertiserId, CreateAssetRequest content) throws IOException {
                Upload result = new Upload(advertiserId, content);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Upload upload(Long advertiserId, CreateAssetRequest content, AbstractInputStreamContent mediaContent) throws IOException {
                Upload result = new Upload(advertiserId, content, mediaContent);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Upload
            extends DisplayVideoRequest<CreateAssetResponse> {
                private static final String REST_PATH = "v1/advertisers/{+advertiserId}/assets";
                private final Pattern ADVERTISER_ID_PATTERN;
                @Key
                private Long advertiserId;

                protected Upload(Long advertiserId, CreateAssetRequest content) {
                    super(DisplayVideo.this, "POST", REST_PATH, (Object)content, CreateAssetResponse.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                }

                protected Upload(Long advertiserId, CreateAssetRequest content, AbstractInputStreamContent mediaContent) {
                    super(DisplayVideo.this, "POST", "/upload/" + DisplayVideo.this.getServicePath() + REST_PATH, (Object)content, CreateAssetResponse.class);
                    this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                    this.initializeMediaUpload(mediaContent);
                }

                public Upload set$Xgafv(String $Xgafv) {
                    return (Upload)super.set$Xgafv($Xgafv);
                }

                public Upload setAccessToken(String accessToken) {
                    return (Upload)super.setAccessToken(accessToken);
                }

                public Upload setAlt(String alt) {
                    return (Upload)super.setAlt(alt);
                }

                public Upload setCallback(String callback) {
                    return (Upload)super.setCallback(callback);
                }

                public Upload setFields(String fields) {
                    return (Upload)super.setFields(fields);
                }

                public Upload setKey(String key) {
                    return (Upload)super.setKey(key);
                }

                public Upload setOauthToken(String oauthToken) {
                    return (Upload)super.setOauthToken(oauthToken);
                }

                public Upload setPrettyPrint(Boolean prettyPrint) {
                    return (Upload)super.setPrettyPrint(prettyPrint);
                }

                public Upload setQuotaUser(String quotaUser) {
                    return (Upload)super.setQuotaUser(quotaUser);
                }

                public Upload setUploadType(String uploadType) {
                    return (Upload)super.setUploadType(uploadType);
                }

                public Upload setUploadProtocol(String uploadProtocol) {
                    return (Upload)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAdvertiserId() {
                    return this.advertiserId;
                }

                public Upload setAdvertiserId(Long advertiserId) {
                    this.advertiserId = advertiserId;
                    return this;
                }

                @Override
                public Upload set(String parameterName, Object value) {
                    return (Upload)super.set(parameterName, value);
                }
            }
        }

        public class Patch
        extends DisplayVideoRequest<Advertiser> {
            private static final String REST_PATH = "v1/advertisers/{+advertiserId}";
            private final Pattern ADVERTISER_ID_PATTERN;
            @Key
            private Long advertiserId;
            @Key
            private String updateMask;

            protected Patch(Long advertiserId, Advertiser content) {
                super(DisplayVideo.this, "PATCH", REST_PATH, (Object)content, Advertiser.class);
                this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public Patch setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public Patch setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends DisplayVideoRequest<ListAdvertisersResponse> {
            private static final String REST_PATH = "v1/advertisers";
            @Key
            private String filter;
            @Key
            private String orderBy;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private Long partnerId;

            protected List() {
                super(DisplayVideo.this, "GET", REST_PATH, null, ListAdvertisersResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Long getPartnerId() {
                return this.partnerId;
            }

            public List setPartnerId(Long partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends DisplayVideoRequest<Advertiser> {
            private static final String REST_PATH = "v1/advertisers/{+advertiserId}";
            private final Pattern ADVERTISER_ID_PATTERN;
            @Key
            private Long advertiserId;

            protected Get(Long advertiserId) {
                super(DisplayVideo.this, "GET", REST_PATH, null, Advertiser.class);
                this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public Get setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends DisplayVideoRequest<Empty> {
            private static final String REST_PATH = "v1/advertisers/{+advertiserId}";
            private final Pattern ADVERTISER_ID_PATTERN;
            @Key
            private Long advertiserId;

            protected Delete(Long advertiserId) {
                super(DisplayVideo.this, "DELETE", REST_PATH, null, Empty.class);
                this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public Delete setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends DisplayVideoRequest<Advertiser> {
            private static final String REST_PATH = "v1/advertisers";

            protected Create(Advertiser content) {
                super(DisplayVideo.this, "POST", REST_PATH, (Object)content, Advertiser.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }

        public class BulkListAdvertiserAssignedTargetingOptions
        extends DisplayVideoRequest<BulkListAdvertiserAssignedTargetingOptionsResponse> {
            private static final String REST_PATH = "v1/advertisers/{+advertiserId}:bulkListAdvertiserAssignedTargetingOptions";
            private final Pattern ADVERTISER_ID_PATTERN;
            @Key
            private Long advertiserId;
            @Key
            private String filter;
            @Key
            private String orderBy;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected BulkListAdvertiserAssignedTargetingOptions(Long advertiserId) {
                super(DisplayVideo.this, "GET", REST_PATH, null, BulkListAdvertiserAssignedTargetingOptionsResponse.class);
                this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public BulkListAdvertiserAssignedTargetingOptions set$Xgafv(String $Xgafv) {
                return (BulkListAdvertiserAssignedTargetingOptions)super.set$Xgafv($Xgafv);
            }

            public BulkListAdvertiserAssignedTargetingOptions setAccessToken(String accessToken) {
                return (BulkListAdvertiserAssignedTargetingOptions)super.setAccessToken(accessToken);
            }

            public BulkListAdvertiserAssignedTargetingOptions setAlt(String alt) {
                return (BulkListAdvertiserAssignedTargetingOptions)super.setAlt(alt);
            }

            public BulkListAdvertiserAssignedTargetingOptions setCallback(String callback) {
                return (BulkListAdvertiserAssignedTargetingOptions)super.setCallback(callback);
            }

            public BulkListAdvertiserAssignedTargetingOptions setFields(String fields) {
                return (BulkListAdvertiserAssignedTargetingOptions)super.setFields(fields);
            }

            public BulkListAdvertiserAssignedTargetingOptions setKey(String key) {
                return (BulkListAdvertiserAssignedTargetingOptions)super.setKey(key);
            }

            public BulkListAdvertiserAssignedTargetingOptions setOauthToken(String oauthToken) {
                return (BulkListAdvertiserAssignedTargetingOptions)super.setOauthToken(oauthToken);
            }

            public BulkListAdvertiserAssignedTargetingOptions setPrettyPrint(Boolean prettyPrint) {
                return (BulkListAdvertiserAssignedTargetingOptions)super.setPrettyPrint(prettyPrint);
            }

            public BulkListAdvertiserAssignedTargetingOptions setQuotaUser(String quotaUser) {
                return (BulkListAdvertiserAssignedTargetingOptions)super.setQuotaUser(quotaUser);
            }

            public BulkListAdvertiserAssignedTargetingOptions setUploadType(String uploadType) {
                return (BulkListAdvertiserAssignedTargetingOptions)super.setUploadType(uploadType);
            }

            public BulkListAdvertiserAssignedTargetingOptions setUploadProtocol(String uploadProtocol) {
                return (BulkListAdvertiserAssignedTargetingOptions)super.setUploadProtocol(uploadProtocol);
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public BulkListAdvertiserAssignedTargetingOptions setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public BulkListAdvertiserAssignedTargetingOptions setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public BulkListAdvertiserAssignedTargetingOptions setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public BulkListAdvertiserAssignedTargetingOptions setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public BulkListAdvertiserAssignedTargetingOptions setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public BulkListAdvertiserAssignedTargetingOptions set(String parameterName, Object value) {
                return (BulkListAdvertiserAssignedTargetingOptions)super.set(parameterName, value);
            }
        }

        public class BulkEditAdvertiserAssignedTargetingOptions
        extends DisplayVideoRequest<BulkEditAdvertiserAssignedTargetingOptionsResponse> {
            private static final String REST_PATH = "v1/advertisers/{+advertiserId}:bulkEditAdvertiserAssignedTargetingOptions";
            private final Pattern ADVERTISER_ID_PATTERN;
            @Key
            private Long advertiserId;

            protected BulkEditAdvertiserAssignedTargetingOptions(Long advertiserId, BulkEditAdvertiserAssignedTargetingOptionsRequest content) {
                super(DisplayVideo.this, "POST", REST_PATH, (Object)content, BulkEditAdvertiserAssignedTargetingOptionsResponse.class);
                this.ADVERTISER_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
            }

            public BulkEditAdvertiserAssignedTargetingOptions set$Xgafv(String $Xgafv) {
                return (BulkEditAdvertiserAssignedTargetingOptions)super.set$Xgafv($Xgafv);
            }

            public BulkEditAdvertiserAssignedTargetingOptions setAccessToken(String accessToken) {
                return (BulkEditAdvertiserAssignedTargetingOptions)super.setAccessToken(accessToken);
            }

            public BulkEditAdvertiserAssignedTargetingOptions setAlt(String alt) {
                return (BulkEditAdvertiserAssignedTargetingOptions)super.setAlt(alt);
            }

            public BulkEditAdvertiserAssignedTargetingOptions setCallback(String callback) {
                return (BulkEditAdvertiserAssignedTargetingOptions)super.setCallback(callback);
            }

            public BulkEditAdvertiserAssignedTargetingOptions setFields(String fields) {
                return (BulkEditAdvertiserAssignedTargetingOptions)super.setFields(fields);
            }

            public BulkEditAdvertiserAssignedTargetingOptions setKey(String key) {
                return (BulkEditAdvertiserAssignedTargetingOptions)super.setKey(key);
            }

            public BulkEditAdvertiserAssignedTargetingOptions setOauthToken(String oauthToken) {
                return (BulkEditAdvertiserAssignedTargetingOptions)super.setOauthToken(oauthToken);
            }

            public BulkEditAdvertiserAssignedTargetingOptions setPrettyPrint(Boolean prettyPrint) {
                return (BulkEditAdvertiserAssignedTargetingOptions)super.setPrettyPrint(prettyPrint);
            }

            public BulkEditAdvertiserAssignedTargetingOptions setQuotaUser(String quotaUser) {
                return (BulkEditAdvertiserAssignedTargetingOptions)super.setQuotaUser(quotaUser);
            }

            public BulkEditAdvertiserAssignedTargetingOptions setUploadType(String uploadType) {
                return (BulkEditAdvertiserAssignedTargetingOptions)super.setUploadType(uploadType);
            }

            public BulkEditAdvertiserAssignedTargetingOptions setUploadProtocol(String uploadProtocol) {
                return (BulkEditAdvertiserAssignedTargetingOptions)super.setUploadProtocol(uploadProtocol);
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public BulkEditAdvertiserAssignedTargetingOptions setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            @Override
            public BulkEditAdvertiserAssignedTargetingOptions set(String parameterName, Object value) {
                return (BulkEditAdvertiserAssignedTargetingOptions)super.set(parameterName, value);
            }
        }
    }
}

