/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.dfareporting;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.dfareporting.DfareportingRequest;
import com.google.api.services.dfareporting.DfareportingRequestInitializer;
import com.google.api.services.dfareporting.model.DimensionValueList;
import com.google.api.services.dfareporting.model.DimensionValueRequest;
import com.google.api.services.dfareporting.model.File;
import com.google.api.services.dfareporting.model.FileList;
import com.google.api.services.dfareporting.model.Report;
import com.google.api.services.dfareporting.model.ReportList;
import com.google.api.services.dfareporting.model.UserProfile;
import com.google.api.services.dfareporting.model.UserProfileList;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dfareporting
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "dfareporting/v1.1/";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/dfareporting/v1.1/";

    public Dfareporting(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Dfareporting(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public DimensionValues dimensionValues() {
        return new DimensionValues();
    }

    public Files files() {
        return new Files();
    }

    public Reports reports() {
        return new Reports();
    }

    public UserProfiles userProfiles() {
        return new UserProfiles();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.21.0 of the DFA Reporting API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, Dfareporting.DEFAULT_ROOT_URL, Dfareporting.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public Dfareporting build() {
            return new Dfareporting(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setDfareportingRequestInitializer(DfareportingRequestInitializer dfareportingRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)dfareportingRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class UserProfiles {
        public Get get(Long l) throws IOException {
            Get get = new Get(l);
            Dfareporting.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list() throws IOException {
            List list = new List();
            Dfareporting.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DfareportingRequest<UserProfileList> {
            private static final String REST_PATH = "userprofiles";

            protected List() {
                super(Dfareporting.this, "GET", REST_PATH, null, UserProfileList.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DfareportingRequest<UserProfile> {
            private static final String REST_PATH = "userprofiles/{profileId}";
            @Key
            private Long profileId;

            protected Get(Long l) {
                super(Dfareporting.this, "GET", REST_PATH, null, UserProfile.class);
                this.profileId = (Long)Preconditions.checkNotNull((Object)l, (Object)"Required parameter profileId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public Long getProfileId() {
                return this.profileId;
            }

            public Get setProfileId(Long l) {
                this.profileId = l;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Reports {
        public Delete delete(Long l, Long l2) throws IOException {
            Delete delete = new Delete(l, l2);
            Dfareporting.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(Long l, Long l2) throws IOException {
            Get get = new Get(l, l2);
            Dfareporting.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(Long l, Report report) throws IOException {
            Insert insert = new Insert(l, report);
            Dfareporting.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(Long l) throws IOException {
            List list = new List(l);
            Dfareporting.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(Long l, Long l2, Report report) throws IOException {
            Patch patch = new Patch(l, l2, report);
            Dfareporting.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Run run(Long l, Long l2) throws IOException {
            Run run = new Run(l, l2);
            Dfareporting.this.initialize((AbstractGoogleClientRequest<?>)run);
            return run;
        }

        public Update update(Long l, Long l2, Report report) throws IOException {
            Update update = new Update(l, l2, report);
            Dfareporting.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        public Files files() {
            return new Files();
        }

        public class Files {
            public Get get(Long l, Long l2, Long l3) throws IOException {
                Get get = new Get(l, l2, l3);
                Dfareporting.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public List list(Long l, Long l2) throws IOException {
                List list = new List(l, l2);
                Dfareporting.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends DfareportingRequest<FileList> {
                private static final String REST_PATH = "userprofiles/{profileId}/reports/{reportId}/files";
                @Key
                private Long profileId;
                @Key
                private Long reportId;
                @Key
                private Integer maxResults;
                @Key
                private String pageToken;
                @Key
                private String sortField;
                @Key
                private String sortOrder;

                protected List(Long l, Long l2) {
                    super(Dfareporting.this, "GET", REST_PATH, null, FileList.class);
                    this.profileId = (Long)Preconditions.checkNotNull((Object)l, (Object)"Required parameter profileId must be specified.");
                    this.reportId = (Long)Preconditions.checkNotNull((Object)l2, (Object)"Required parameter reportId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public Long getProfileId() {
                    return this.profileId;
                }

                public List setProfileId(Long l) {
                    this.profileId = l;
                    return this;
                }

                public Long getReportId() {
                    return this.reportId;
                }

                public List setReportId(Long l) {
                    this.reportId = l;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public String getSortField() {
                    return this.sortField;
                }

                public List setSortField(String string) {
                    this.sortField = string;
                    return this;
                }

                public String getSortOrder() {
                    return this.sortOrder;
                }

                public List setSortOrder(String string) {
                    this.sortOrder = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends DfareportingRequest<File> {
                private static final String REST_PATH = "userprofiles/{profileId}/reports/{reportId}/files/{fileId}";
                @Key
                private Long profileId;
                @Key
                private Long reportId;
                @Key
                private Long fileId;

                protected Get(Long l, Long l2, Long l3) {
                    super(Dfareporting.this, "GET", REST_PATH, null, File.class);
                    this.profileId = (Long)Preconditions.checkNotNull((Object)l, (Object)"Required parameter profileId must be specified.");
                    this.reportId = (Long)Preconditions.checkNotNull((Object)l2, (Object)"Required parameter reportId must be specified.");
                    this.fileId = (Long)Preconditions.checkNotNull((Object)l3, (Object)"Required parameter fileId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public Long getProfileId() {
                    return this.profileId;
                }

                public Get setProfileId(Long l) {
                    this.profileId = l;
                    return this;
                }

                public Long getReportId() {
                    return this.reportId;
                }

                public Get setReportId(Long l) {
                    this.reportId = l;
                    return this;
                }

                public Long getFileId() {
                    return this.fileId;
                }

                public Get setFileId(Long l) {
                    this.fileId = l;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends DfareportingRequest<Report> {
            private static final String REST_PATH = "userprofiles/{profileId}/reports/{reportId}";
            @Key
            private Long profileId;
            @Key
            private Long reportId;

            protected Update(Long l, Long l2, Report report) {
                super(Dfareporting.this, "PUT", REST_PATH, (Object)report, Report.class);
                this.profileId = (Long)Preconditions.checkNotNull((Object)l, (Object)"Required parameter profileId must be specified.");
                this.reportId = (Long)Preconditions.checkNotNull((Object)l2, (Object)"Required parameter reportId must be specified.");
                this.checkRequiredParameter((Object)report, "content");
                this.checkRequiredParameter(report.getAccountId(), "Report.getAccountId()");
                this.checkRequiredParameter((Object)report, "content");
                this.checkRequiredParameter(report.getId(), "Report.getId()");
                this.checkRequiredParameter((Object)report, "content");
                this.checkRequiredParameter(report.getLastModifiedTime(), "Report.getLastModifiedTime()");
                this.checkRequiredParameter((Object)report, "content");
                this.checkRequiredParameter(report.getName(), "Report.getName()");
                this.checkRequiredParameter((Object)report, "content");
                this.checkRequiredParameter(report.getOwnerProfileId(), "Report.getOwnerProfileId()");
                this.checkRequiredParameter((Object)report, "content");
                this.checkRequiredParameter(report.getType(), "Report.getType()");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public Long getProfileId() {
                return this.profileId;
            }

            public Update setProfileId(Long l) {
                this.profileId = l;
                return this;
            }

            public Long getReportId() {
                return this.reportId;
            }

            public Update setReportId(Long l) {
                this.reportId = l;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Run
        extends DfareportingRequest<File> {
            private static final String REST_PATH = "userprofiles/{profileId}/reports/{reportId}/run";
            @Key
            private Long profileId;
            @Key
            private Long reportId;
            @Key
            private Boolean synchronous;

            protected Run(Long l, Long l2) {
                super(Dfareporting.this, "POST", REST_PATH, null, File.class);
                this.profileId = (Long)Preconditions.checkNotNull((Object)l, (Object)"Required parameter profileId must be specified.");
                this.reportId = (Long)Preconditions.checkNotNull((Object)l2, (Object)"Required parameter reportId must be specified.");
            }

            public Run setAlt(String string) {
                return (Run)super.setAlt(string);
            }

            public Run setFields(String string) {
                return (Run)super.setFields(string);
            }

            public Run setKey(String string) {
                return (Run)super.setKey(string);
            }

            public Run setOauthToken(String string) {
                return (Run)super.setOauthToken(string);
            }

            public Run setPrettyPrint(Boolean bl) {
                return (Run)super.setPrettyPrint(bl);
            }

            public Run setQuotaUser(String string) {
                return (Run)super.setQuotaUser(string);
            }

            public Run setUserIp(String string) {
                return (Run)super.setUserIp(string);
            }

            public Long getProfileId() {
                return this.profileId;
            }

            public Run setProfileId(Long l) {
                this.profileId = l;
                return this;
            }

            public Long getReportId() {
                return this.reportId;
            }

            public Run setReportId(Long l) {
                this.reportId = l;
                return this;
            }

            public Boolean getSynchronous() {
                return this.synchronous;
            }

            public Run setSynchronous(Boolean bl) {
                this.synchronous = bl;
                return this;
            }

            @Override
            public Run set(String string, Object object) {
                return (Run)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends DfareportingRequest<Report> {
            private static final String REST_PATH = "userprofiles/{profileId}/reports/{reportId}";
            @Key
            private Long profileId;
            @Key
            private Long reportId;

            protected Patch(Long l, Long l2, Report report) {
                super(Dfareporting.this, "PATCH", REST_PATH, (Object)report, Report.class);
                this.profileId = (Long)Preconditions.checkNotNull((Object)l, (Object)"Required parameter profileId must be specified.");
                this.reportId = (Long)Preconditions.checkNotNull((Object)l2, (Object)"Required parameter reportId must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public Long getProfileId() {
                return this.profileId;
            }

            public Patch setProfileId(Long l) {
                this.profileId = l;
                return this;
            }

            public Long getReportId() {
                return this.reportId;
            }

            public Patch setReportId(Long l) {
                this.reportId = l;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DfareportingRequest<ReportList> {
            private static final String REST_PATH = "userprofiles/{profileId}/reports";
            @Key
            private Long profileId;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;
            @Key
            private String sortField;
            @Key
            private String sortOrder;

            protected List(Long l) {
                super(Dfareporting.this, "GET", REST_PATH, null, ReportList.class);
                this.profileId = (Long)Preconditions.checkNotNull((Object)l, (Object)"Required parameter profileId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public Long getProfileId() {
                return this.profileId;
            }

            public List setProfileId(Long l) {
                this.profileId = l;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getSortField() {
                return this.sortField;
            }

            public List setSortField(String string) {
                this.sortField = string;
                return this;
            }

            public String getSortOrder() {
                return this.sortOrder;
            }

            public List setSortOrder(String string) {
                this.sortOrder = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends DfareportingRequest<Report> {
            private static final String REST_PATH = "userprofiles/{profileId}/reports";
            @Key
            private Long profileId;

            protected Insert(Long l, Report report) {
                super(Dfareporting.this, "POST", REST_PATH, (Object)report, Report.class);
                this.profileId = (Long)Preconditions.checkNotNull((Object)l, (Object)"Required parameter profileId must be specified.");
                this.checkRequiredParameter((Object)report, "content");
                this.checkRequiredParameter(report.getName(), "Report.getName()");
                this.checkRequiredParameter((Object)report, "content");
                this.checkRequiredParameter(report.getType(), "Report.getType()");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public Long getProfileId() {
                return this.profileId;
            }

            public Insert setProfileId(Long l) {
                this.profileId = l;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DfareportingRequest<Report> {
            private static final String REST_PATH = "userprofiles/{profileId}/reports/{reportId}";
            @Key
            private Long profileId;
            @Key
            private Long reportId;

            protected Get(Long l, Long l2) {
                super(Dfareporting.this, "GET", REST_PATH, null, Report.class);
                this.profileId = (Long)Preconditions.checkNotNull((Object)l, (Object)"Required parameter profileId must be specified.");
                this.reportId = (Long)Preconditions.checkNotNull((Object)l2, (Object)"Required parameter reportId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public Long getProfileId() {
                return this.profileId;
            }

            public Get setProfileId(Long l) {
                this.profileId = l;
                return this;
            }

            public Long getReportId() {
                return this.reportId;
            }

            public Get setReportId(Long l) {
                this.reportId = l;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends DfareportingRequest<Void> {
            private static final String REST_PATH = "userprofiles/{profileId}/reports/{reportId}";
            @Key
            private Long profileId;
            @Key
            private Long reportId;

            protected Delete(Long l, Long l2) {
                super(Dfareporting.this, "DELETE", REST_PATH, null, Void.class);
                this.profileId = (Long)Preconditions.checkNotNull((Object)l, (Object)"Required parameter profileId must be specified.");
                this.reportId = (Long)Preconditions.checkNotNull((Object)l2, (Object)"Required parameter reportId must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public Long getProfileId() {
                return this.profileId;
            }

            public Delete setProfileId(Long l) {
                this.profileId = l;
                return this;
            }

            public Long getReportId() {
                return this.reportId;
            }

            public Delete setReportId(Long l) {
                this.reportId = l;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Files {
        public List list(Long l) throws IOException {
            List list = new List(l);
            Dfareporting.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DfareportingRequest<FileList> {
            private static final String REST_PATH = "userprofiles/{profileId}/files";
            @Key
            private Long profileId;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;
            @Key
            private String sortField;
            @Key
            private String sortOrder;

            protected List(Long l) {
                super(Dfareporting.this, "GET", REST_PATH, null, FileList.class);
                this.profileId = (Long)Preconditions.checkNotNull((Object)l, (Object)"Required parameter profileId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public Long getProfileId() {
                return this.profileId;
            }

            public List setProfileId(Long l) {
                this.profileId = l;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getSortField() {
                return this.sortField;
            }

            public List setSortField(String string) {
                this.sortField = string;
                return this;
            }

            public String getSortOrder() {
                return this.sortOrder;
            }

            public List setSortOrder(String string) {
                this.sortOrder = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }
    }

    public class DimensionValues {
        public Query query(Long l, DimensionValueRequest dimensionValueRequest) throws IOException {
            Query query = new Query(l, dimensionValueRequest);
            Dfareporting.this.initialize((AbstractGoogleClientRequest<?>)query);
            return query;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Query
        extends DfareportingRequest<DimensionValueList> {
            private static final String REST_PATH = "userprofiles/{profileId}/dimensionvalues/query";
            @Key
            private Long profileId;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;

            protected Query(Long l, DimensionValueRequest dimensionValueRequest) {
                super(Dfareporting.this, "POST", REST_PATH, (Object)dimensionValueRequest, DimensionValueList.class);
                this.profileId = (Long)Preconditions.checkNotNull((Object)l, (Object)"Required parameter profileId must be specified.");
            }

            public Query setAlt(String string) {
                return (Query)super.setAlt(string);
            }

            public Query setFields(String string) {
                return (Query)super.setFields(string);
            }

            public Query setKey(String string) {
                return (Query)super.setKey(string);
            }

            public Query setOauthToken(String string) {
                return (Query)super.setOauthToken(string);
            }

            public Query setPrettyPrint(Boolean bl) {
                return (Query)super.setPrettyPrint(bl);
            }

            public Query setQuotaUser(String string) {
                return (Query)super.setQuotaUser(string);
            }

            public Query setUserIp(String string) {
                return (Query)super.setUserIp(string);
            }

            public Long getProfileId() {
                return this.profileId;
            }

            public Query setProfileId(Long l) {
                this.profileId = l;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public Query setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public Query setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public Query set(String string, Object object) {
                return (Query)super.set(string, object);
            }
        }
    }
}

