/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Contains per-user worker telemetry used in streaming autoscaling.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class StreamingScalingReport extends com.google.api.client.json.GenericJson {

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer activeBundleCount;

  /**
   * Current acive thread count.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer activeThreadCount;

  /**
   * Maximum bundle count.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maximumBundleCount;

  /**
   * Maximum bytes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long maximumBytes;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maximumBytesCount;

  /**
   * Maximum thread count limit.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maximumThreadCount;

  /**
   * Current outstanding bundle count.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer outstandingBundleCount;

  /**
   * Current outstanding bytes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long outstandingBytes;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer outstandingBytesCount;

  /**
   * @return value or {@code null} for none
   */
  public java.lang.Integer getActiveBundleCount() {
    return activeBundleCount;
  }

  /**
   * @param activeBundleCount activeBundleCount or {@code null} for none
   */
  public StreamingScalingReport setActiveBundleCount(java.lang.Integer activeBundleCount) {
    this.activeBundleCount = activeBundleCount;
    return this;
  }

  /**
   * Current acive thread count.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getActiveThreadCount() {
    return activeThreadCount;
  }

  /**
   * Current acive thread count.
   * @param activeThreadCount activeThreadCount or {@code null} for none
   */
  public StreamingScalingReport setActiveThreadCount(java.lang.Integer activeThreadCount) {
    this.activeThreadCount = activeThreadCount;
    return this;
  }

  /**
   * Maximum bundle count.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaximumBundleCount() {
    return maximumBundleCount;
  }

  /**
   * Maximum bundle count.
   * @param maximumBundleCount maximumBundleCount or {@code null} for none
   */
  public StreamingScalingReport setMaximumBundleCount(java.lang.Integer maximumBundleCount) {
    this.maximumBundleCount = maximumBundleCount;
    return this;
  }

  /**
   * Maximum bytes.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMaximumBytes() {
    return maximumBytes;
  }

  /**
   * Maximum bytes.
   * @param maximumBytes maximumBytes or {@code null} for none
   */
  public StreamingScalingReport setMaximumBytes(java.lang.Long maximumBytes) {
    this.maximumBytes = maximumBytes;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaximumBytesCount() {
    return maximumBytesCount;
  }

  /**
   * @param maximumBytesCount maximumBytesCount or {@code null} for none
   */
  public StreamingScalingReport setMaximumBytesCount(java.lang.Integer maximumBytesCount) {
    this.maximumBytesCount = maximumBytesCount;
    return this;
  }

  /**
   * Maximum thread count limit.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaximumThreadCount() {
    return maximumThreadCount;
  }

  /**
   * Maximum thread count limit.
   * @param maximumThreadCount maximumThreadCount or {@code null} for none
   */
  public StreamingScalingReport setMaximumThreadCount(java.lang.Integer maximumThreadCount) {
    this.maximumThreadCount = maximumThreadCount;
    return this;
  }

  /**
   * Current outstanding bundle count.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getOutstandingBundleCount() {
    return outstandingBundleCount;
  }

  /**
   * Current outstanding bundle count.
   * @param outstandingBundleCount outstandingBundleCount or {@code null} for none
   */
  public StreamingScalingReport setOutstandingBundleCount(java.lang.Integer outstandingBundleCount) {
    this.outstandingBundleCount = outstandingBundleCount;
    return this;
  }

  /**
   * Current outstanding bytes.
   * @return value or {@code null} for none
   */
  public java.lang.Long getOutstandingBytes() {
    return outstandingBytes;
  }

  /**
   * Current outstanding bytes.
   * @param outstandingBytes outstandingBytes or {@code null} for none
   */
  public StreamingScalingReport setOutstandingBytes(java.lang.Long outstandingBytes) {
    this.outstandingBytes = outstandingBytes;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.Integer getOutstandingBytesCount() {
    return outstandingBytesCount;
  }

  /**
   * @param outstandingBytesCount outstandingBytesCount or {@code null} for none
   */
  public StreamingScalingReport setOutstandingBytesCount(java.lang.Integer outstandingBytesCount) {
    this.outstandingBytesCount = outstandingBytesCount;
    return this;
  }

  @Override
  public StreamingScalingReport set(String fieldName, Object value) {
    return (StreamingScalingReport) super.set(fieldName, value);
  }

  @Override
  public StreamingScalingReport clone() {
    return (StreamingScalingReport) super.clone();
  }

}
