/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Configuration information for a single streaming computation.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class StreamingComputationConfig extends com.google.api.client.json.GenericJson {

  /**
   * Unique identifier for this computation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String computationId;

  /**
   * Instructions that comprise the computation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ParallelInstruction> instructions;

  static {
    // hack to force ProGuard to consider ParallelInstruction used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ParallelInstruction.class);
  }

  /**
   * Stage name of this computation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String stageName;

  /**
   * System defined name for this computation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String systemName;

  /**
   * Map from user name of stateful transforms in this stage to their state family.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> transformUserNameToStateFamily;

  /**
   * Unique identifier for this computation.
   * @return value or {@code null} for none
   */
  public java.lang.String getComputationId() {
    return computationId;
  }

  /**
   * Unique identifier for this computation.
   * @param computationId computationId or {@code null} for none
   */
  public StreamingComputationConfig setComputationId(java.lang.String computationId) {
    this.computationId = computationId;
    return this;
  }

  /**
   * Instructions that comprise the computation.
   * @return value or {@code null} for none
   */
  public java.util.List<ParallelInstruction> getInstructions() {
    return instructions;
  }

  /**
   * Instructions that comprise the computation.
   * @param instructions instructions or {@code null} for none
   */
  public StreamingComputationConfig setInstructions(java.util.List<ParallelInstruction> instructions) {
    this.instructions = instructions;
    return this;
  }

  /**
   * Stage name of this computation.
   * @return value or {@code null} for none
   */
  public java.lang.String getStageName() {
    return stageName;
  }

  /**
   * Stage name of this computation.
   * @param stageName stageName or {@code null} for none
   */
  public StreamingComputationConfig setStageName(java.lang.String stageName) {
    this.stageName = stageName;
    return this;
  }

  /**
   * System defined name for this computation.
   * @return value or {@code null} for none
   */
  public java.lang.String getSystemName() {
    return systemName;
  }

  /**
   * System defined name for this computation.
   * @param systemName systemName or {@code null} for none
   */
  public StreamingComputationConfig setSystemName(java.lang.String systemName) {
    this.systemName = systemName;
    return this;
  }

  /**
   * Map from user name of stateful transforms in this stage to their state family.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getTransformUserNameToStateFamily() {
    return transformUserNameToStateFamily;
  }

  /**
   * Map from user name of stateful transforms in this stage to their state family.
   * @param transformUserNameToStateFamily transformUserNameToStateFamily or {@code null} for none
   */
  public StreamingComputationConfig setTransformUserNameToStateFamily(java.util.Map<String, java.lang.String> transformUserNameToStateFamily) {
    this.transformUserNameToStateFamily = transformUserNameToStateFamily;
    return this;
  }

  @Override
  public StreamingComputationConfig set(String fieldName, Object value) {
    return (StreamingComputationConfig) super.set(fieldName, value);
  }

  @Override
  public StreamingComputationConfig clone() {
    return (StreamingComputationConfig) super.clone();
  }

}
