/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Describes a stream of data, either as input to be processed or as output of a streaming Dataflow
 * job.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class StreamLocation extends com.google.api.client.json.GenericJson {

  /**
   * The stream is a custom source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CustomSourceLocation customSourceLocation;

  /**
   * The stream is a pubsub stream.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PubsubLocation pubsubLocation;

  /**
   * The stream is a streaming side input.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private StreamingSideInputLocation sideInputLocation;

  /**
   * The stream is part of another computation within the current streaming Dataflow job.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private StreamingStageLocation streamingStageLocation;

  /**
   * The stream is a custom source.
   * @return value or {@code null} for none
   */
  public CustomSourceLocation getCustomSourceLocation() {
    return customSourceLocation;
  }

  /**
   * The stream is a custom source.
   * @param customSourceLocation customSourceLocation or {@code null} for none
   */
  public StreamLocation setCustomSourceLocation(CustomSourceLocation customSourceLocation) {
    this.customSourceLocation = customSourceLocation;
    return this;
  }

  /**
   * The stream is a pubsub stream.
   * @return value or {@code null} for none
   */
  public PubsubLocation getPubsubLocation() {
    return pubsubLocation;
  }

  /**
   * The stream is a pubsub stream.
   * @param pubsubLocation pubsubLocation or {@code null} for none
   */
  public StreamLocation setPubsubLocation(PubsubLocation pubsubLocation) {
    this.pubsubLocation = pubsubLocation;
    return this;
  }

  /**
   * The stream is a streaming side input.
   * @return value or {@code null} for none
   */
  public StreamingSideInputLocation getSideInputLocation() {
    return sideInputLocation;
  }

  /**
   * The stream is a streaming side input.
   * @param sideInputLocation sideInputLocation or {@code null} for none
   */
  public StreamLocation setSideInputLocation(StreamingSideInputLocation sideInputLocation) {
    this.sideInputLocation = sideInputLocation;
    return this;
  }

  /**
   * The stream is part of another computation within the current streaming Dataflow job.
   * @return value or {@code null} for none
   */
  public StreamingStageLocation getStreamingStageLocation() {
    return streamingStageLocation;
  }

  /**
   * The stream is part of another computation within the current streaming Dataflow job.
   * @param streamingStageLocation streamingStageLocation or {@code null} for none
   */
  public StreamLocation setStreamingStageLocation(StreamingStageLocation streamingStageLocation) {
    this.streamingStageLocation = streamingStageLocation;
    return this;
  }

  @Override
  public StreamLocation set(String fieldName, Object value) {
    return (StreamLocation) super.set(fieldName, value);
  }

  @Override
  public StreamLocation clone() {
    return (StreamLocation) super.clone();
  }

}
