/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * A representation of an int64, n, that is immune to precision loss when encoded in JSON.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SplitInt64 extends com.google.api.client.json.GenericJson {

  /**
   * The high order bits, including the sign: n >> 32.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer highBits;

  /**
   * The low order bits: n & 0xffffffff.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long lowBits;

  /**
   * The high order bits, including the sign: n >> 32.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getHighBits() {
    return highBits;
  }

  /**
   * The high order bits, including the sign: n >> 32.
   * @param highBits highBits or {@code null} for none
   */
  public SplitInt64 setHighBits(java.lang.Integer highBits) {
    this.highBits = highBits;
    return this;
  }

  /**
   * The low order bits: n & 0xffffffff.
   * @return value or {@code null} for none
   */
  public java.lang.Long getLowBits() {
    return lowBits;
  }

  /**
   * The low order bits: n & 0xffffffff.
   * @param lowBits lowBits or {@code null} for none
   */
  public SplitInt64 setLowBits(java.lang.Long lowBits) {
    this.lowBits = lowBits;
    return this;
  }

  @Override
  public SplitInt64 set(String fieldName, Object value) {
    return (SplitInt64) super.set(fieldName, value);
  }

  @Override
  public SplitInt64 clone() {
    return (SplitInt64) super.clone();
  }

}
