/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * A task which consists of a shell command for the worker to execute.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ShellTask extends com.google.api.client.json.GenericJson {

  /**
   * The shell command to run.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String command;

  /**
   * Exit code for the task.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer exitCode;

  /**
   * The shell command to run.
   * @return value or {@code null} for none
   */
  public java.lang.String getCommand() {
    return command;
  }

  /**
   * The shell command to run.
   * @param command command or {@code null} for none
   */
  public ShellTask setCommand(java.lang.String command) {
    this.command = command;
    return this;
  }

  /**
   * Exit code for the task.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getExitCode() {
    return exitCode;
  }

  /**
   * Exit code for the task.
   * @param exitCode exitCode or {@code null} for none
   */
  public ShellTask setExitCode(java.lang.Integer exitCode) {
    this.exitCode = exitCode;
    return this;
  }

  @Override
  public ShellTask set(String fieldName, Object value) {
    return (ShellTask) super.set(fieldName, value);
  }

  @Override
  public ShellTask clone() {
    return (ShellTask) super.clone();
  }

}
