/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * A position that encapsulates an inner position and an index for the inner position. A
 * ConcatPosition can be used by a reader of a source that encapsulates a set of other sources.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ConcatPosition extends com.google.api.client.json.GenericJson {

  /**
   * Index of the inner source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer index;

  /**
   * Position within the inner source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Position position;

  /**
   * Index of the inner source.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getIndex() {
    return index;
  }

  /**
   * Index of the inner source.
   * @param index index or {@code null} for none
   */
  public ConcatPosition setIndex(java.lang.Integer index) {
    this.index = index;
    return this;
  }

  /**
   * Position within the inner source.
   * @return value or {@code null} for none
   */
  public Position getPosition() {
    return position;
  }

  /**
   * Position within the inner source.
   * @param position position or {@code null} for none
   */
  public ConcatPosition setPosition(Position position) {
    this.position = position;
    return this;
  }

  @Override
  public ConcatPosition set(String fieldName, Object value) {
    return (ConcatPosition) super.set(fieldName, value);
  }

  @Override
  public ConcatPosition clone() {
    return (ConcatPosition) super.clone();
  }

}
