/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * `BucketOptions` describes the bucket boundaries used in the histogram.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BucketOptions extends com.google.api.client.json.GenericJson {

  /**
   * Bucket boundaries grow exponentially.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Base2Exponent exponential;

  /**
   * Bucket boundaries grow linearly.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Linear linear;

  /**
   * Bucket boundaries grow exponentially.
   * @return value or {@code null} for none
   */
  public Base2Exponent getExponential() {
    return exponential;
  }

  /**
   * Bucket boundaries grow exponentially.
   * @param exponential exponential or {@code null} for none
   */
  public BucketOptions setExponential(Base2Exponent exponential) {
    this.exponential = exponential;
    return this;
  }

  /**
   * Bucket boundaries grow linearly.
   * @return value or {@code null} for none
   */
  public Linear getLinear() {
    return linear;
  }

  /**
   * Bucket boundaries grow linearly.
   * @param linear linear or {@code null} for none
   */
  public BucketOptions setLinear(Linear linear) {
    this.linear = linear;
    return this;
  }

  @Override
  public BucketOptions set(String fieldName, Object value) {
    return (BucketOptions) super.set(fieldName, value);
  }

  @Override
  public BucketOptions clone() {
    return (BucketOptions) super.clone();
  }

}
