/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * A single node in a BoundedTrie.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BoundedTrieNode extends com.google.api.client.json.GenericJson {

  /**
   * Children of this node. Must be empty if truncated is true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, BoundedTrieNode> children;

  /**
   * Whether this node has been truncated. A truncated leaf represents possibly many children with
   * the same prefix.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean truncated;

  /**
   * Children of this node. Must be empty if truncated is true.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, BoundedTrieNode> getChildren() {
    return children;
  }

  /**
   * Children of this node. Must be empty if truncated is true.
   * @param children children or {@code null} for none
   */
  public BoundedTrieNode setChildren(java.util.Map<String, BoundedTrieNode> children) {
    this.children = children;
    return this;
  }

  /**
   * Whether this node has been truncated. A truncated leaf represents possibly many children with
   * the same prefix.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getTruncated() {
    return truncated;
  }

  /**
   * Whether this node has been truncated. A truncated leaf represents possibly many children with
   * the same prefix.
   * @param truncated truncated or {@code null} for none
   */
  public BoundedTrieNode setTruncated(java.lang.Boolean truncated) {
    this.truncated = truncated;
    return this;
  }

  @Override
  public BoundedTrieNode set(String fieldName, Object value) {
    return (BoundedTrieNode) super.set(fieldName, value);
  }

  @Override
  public BoundedTrieNode clone() {
    return (BoundedTrieNode) super.clone();
  }

}
