/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Exponential buckets where the growth factor between buckets is `2**(2**-scale)`. e.g. for
 * `scale=1` growth factor is `2**(2**(-1))=sqrt(2)`. `n` buckets will have the following
 * boundaries. - 0th: [0, gf) - i in [1, n-1]: [gf^(i), gf^(i+1))
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Base2Exponent extends com.google.api.client.json.GenericJson {

  /**
   * Must be greater than 0.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer numberOfBuckets;

  /**
   * Must be between -3 and 3. This forces the growth factor of the bucket boundaries to be between
   * `2^(1/8)` and `256`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer scale;

  /**
   * Must be greater than 0.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getNumberOfBuckets() {
    return numberOfBuckets;
  }

  /**
   * Must be greater than 0.
   * @param numberOfBuckets numberOfBuckets or {@code null} for none
   */
  public Base2Exponent setNumberOfBuckets(java.lang.Integer numberOfBuckets) {
    this.numberOfBuckets = numberOfBuckets;
    return this;
  }

  /**
   * Must be between -3 and 3. This forces the growth factor of the bucket boundaries to be between
   * `2^(1/8)` and `256`.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getScale() {
    return scale;
  }

  /**
   * Must be between -3 and 3. This forces the growth factor of the bucket boundaries to be between
   * `2^(1/8)` and `256`.
   * @param scale scale or {@code null} for none
   */
  public Base2Exponent setScale(java.lang.Integer scale) {
    this.scale = scale;
    return this;
  }

  @Override
  public Base2Exponent set(String fieldName, Object value) {
    return (Base2Exponent) super.set(fieldName, value);
  }

  @Override
  public Base2Exponent clone() {
    return (Base2Exponent) super.clone();
  }

}
