/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * A progress measurement of a WorkItem by a worker.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ApproximateReportedProgress extends com.google.api.client.json.GenericJson {

  /**
   * Total amount of parallelism in the portion of input of this task that has already been consumed
   * and is no longer active. In the first two examples above (see remaining_parallelism), the value
   * should be 29 or 2 respectively. The sum of remaining_parallelism and consumed_parallelism
   * should equal the total amount of parallelism in this work item. If specified, must be finite.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ReportedParallelism consumedParallelism;

  /**
   * Completion as fraction of the input consumed, from 0.0 (beginning, nothing consumed), to 1.0
   * (end of the input, entire input consumed).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double fractionConsumed;

  /**
   * A Position within the work to represent a progress.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Position position;

  /**
   * Total amount of parallelism in the input of this task that remains, (i.e. can be delegated to
   * this task and any new tasks via dynamic splitting). Always at least 1 for non-finished work
   * items and 0 for finished. "Amount of parallelism" refers to how many non-empty parts of the
   * input can be read in parallel. This does not necessarily equal number of records. An input that
   * can be read in parallel down to the individual records is called "perfectly splittable". An
   * example of non-perfectly parallelizable input is a block-compressed file format where a block
   * of records has to be read as a whole, but different blocks can be read in parallel. Examples: *
   * If we are processing record #30 (starting at 1) out of 50 in a perfectly splittable 50-record
   * input, this value should be 21 (20 remaining + 1 current). * If we are reading through block 3
   * in a block-compressed file consisting of 5 blocks, this value should be 3 (since blocks 4 and 5
   * can be processed in parallel by new tasks via dynamic splitting and the current task remains
   * processing block 3). * If we are reading through the last block in a block-compressed file, or
   * reading or processing the last record in a perfectly splittable input, this value should be 1,
   * because apart from the current task, no additional remainder can be split off.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ReportedParallelism remainingParallelism;

  /**
   * Total amount of parallelism in the portion of input of this task that has already been consumed
   * and is no longer active. In the first two examples above (see remaining_parallelism), the value
   * should be 29 or 2 respectively. The sum of remaining_parallelism and consumed_parallelism
   * should equal the total amount of parallelism in this work item. If specified, must be finite.
   * @return value or {@code null} for none
   */
  public ReportedParallelism getConsumedParallelism() {
    return consumedParallelism;
  }

  /**
   * Total amount of parallelism in the portion of input of this task that has already been consumed
   * and is no longer active. In the first two examples above (see remaining_parallelism), the value
   * should be 29 or 2 respectively. The sum of remaining_parallelism and consumed_parallelism
   * should equal the total amount of parallelism in this work item. If specified, must be finite.
   * @param consumedParallelism consumedParallelism or {@code null} for none
   */
  public ApproximateReportedProgress setConsumedParallelism(ReportedParallelism consumedParallelism) {
    this.consumedParallelism = consumedParallelism;
    return this;
  }

  /**
   * Completion as fraction of the input consumed, from 0.0 (beginning, nothing consumed), to 1.0
   * (end of the input, entire input consumed).
   * @return value or {@code null} for none
   */
  public java.lang.Double getFractionConsumed() {
    return fractionConsumed;
  }

  /**
   * Completion as fraction of the input consumed, from 0.0 (beginning, nothing consumed), to 1.0
   * (end of the input, entire input consumed).
   * @param fractionConsumed fractionConsumed or {@code null} for none
   */
  public ApproximateReportedProgress setFractionConsumed(java.lang.Double fractionConsumed) {
    this.fractionConsumed = fractionConsumed;
    return this;
  }

  /**
   * A Position within the work to represent a progress.
   * @return value or {@code null} for none
   */
  public Position getPosition() {
    return position;
  }

  /**
   * A Position within the work to represent a progress.
   * @param position position or {@code null} for none
   */
  public ApproximateReportedProgress setPosition(Position position) {
    this.position = position;
    return this;
  }

  /**
   * Total amount of parallelism in the input of this task that remains, (i.e. can be delegated to
   * this task and any new tasks via dynamic splitting). Always at least 1 for non-finished work
   * items and 0 for finished. "Amount of parallelism" refers to how many non-empty parts of the
   * input can be read in parallel. This does not necessarily equal number of records. An input that
   * can be read in parallel down to the individual records is called "perfectly splittable". An
   * example of non-perfectly parallelizable input is a block-compressed file format where a block
   * of records has to be read as a whole, but different blocks can be read in parallel. Examples: *
   * If we are processing record #30 (starting at 1) out of 50 in a perfectly splittable 50-record
   * input, this value should be 21 (20 remaining + 1 current). * If we are reading through block 3
   * in a block-compressed file consisting of 5 blocks, this value should be 3 (since blocks 4 and 5
   * can be processed in parallel by new tasks via dynamic splitting and the current task remains
   * processing block 3). * If we are reading through the last block in a block-compressed file, or
   * reading or processing the last record in a perfectly splittable input, this value should be 1,
   * because apart from the current task, no additional remainder can be split off.
   * @return value or {@code null} for none
   */
  public ReportedParallelism getRemainingParallelism() {
    return remainingParallelism;
  }

  /**
   * Total amount of parallelism in the input of this task that remains, (i.e. can be delegated to
   * this task and any new tasks via dynamic splitting). Always at least 1 for non-finished work
   * items and 0 for finished. "Amount of parallelism" refers to how many non-empty parts of the
   * input can be read in parallel. This does not necessarily equal number of records. An input that
   * can be read in parallel down to the individual records is called "perfectly splittable". An
   * example of non-perfectly parallelizable input is a block-compressed file format where a block
   * of records has to be read as a whole, but different blocks can be read in parallel. Examples: *
   * If we are processing record #30 (starting at 1) out of 50 in a perfectly splittable 50-record
   * input, this value should be 21 (20 remaining + 1 current). * If we are reading through block 3
   * in a block-compressed file consisting of 5 blocks, this value should be 3 (since blocks 4 and 5
   * can be processed in parallel by new tasks via dynamic splitting and the current task remains
   * processing block 3). * If we are reading through the last block in a block-compressed file, or
   * reading or processing the last record in a perfectly splittable input, this value should be 1,
   * because apart from the current task, no additional remainder can be split off.
   * @param remainingParallelism remainingParallelism or {@code null} for none
   */
  public ApproximateReportedProgress setRemainingParallelism(ReportedParallelism remainingParallelism) {
    this.remainingParallelism = remainingParallelism;
    return this;
  }

  @Override
  public ApproximateReportedProgress set(String fieldName, Object value) {
    return (ApproximateReportedProgress) super.set(fieldName, value);
  }

  @Override
  public ApproximateReportedProgress clone() {
    return (ApproximateReportedProgress) super.clone();
  }

}
