/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Identifies a pubsub location to use for transferring data into or out of a streaming Dataflow
 * job.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PubsubLocation extends com.google.api.client.json.GenericJson {

  /**
   * Indicates whether the pipeline allows late-arriving data.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean dropLateData;

  /**
   * If true, then this location represents dynamic topics.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean dynamicDestinations;

  /**
   * If set, contains a pubsub label from which to extract record ids. If left empty, record
   * deduplication will be strictly best effort.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String idLabel;

  /**
   * A pubsub subscription, in the form of "pubsub.googleapis.com/subscriptions//"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String subscription;

  /**
   * If set, contains a pubsub label from which to extract record timestamps. If left empty, record
   * timestamps will be generated upon arrival.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String timestampLabel;

  /**
   * A pubsub topic, in the form of "pubsub.googleapis.com/topics//"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String topic;

  /**
   * If set, specifies the pubsub subscription that will be used for tracking custom time timestamps
   * for watermark estimation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String trackingSubscription;

  /**
   * If true, then the client has requested to get pubsub attributes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean withAttributes;

  /**
   * Indicates whether the pipeline allows late-arriving data.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDropLateData() {
    return dropLateData;
  }

  /**
   * Indicates whether the pipeline allows late-arriving data.
   * @param dropLateData dropLateData or {@code null} for none
   */
  public PubsubLocation setDropLateData(java.lang.Boolean dropLateData) {
    this.dropLateData = dropLateData;
    return this;
  }

  /**
   * If true, then this location represents dynamic topics.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDynamicDestinations() {
    return dynamicDestinations;
  }

  /**
   * If true, then this location represents dynamic topics.
   * @param dynamicDestinations dynamicDestinations or {@code null} for none
   */
  public PubsubLocation setDynamicDestinations(java.lang.Boolean dynamicDestinations) {
    this.dynamicDestinations = dynamicDestinations;
    return this;
  }

  /**
   * If set, contains a pubsub label from which to extract record ids. If left empty, record
   * deduplication will be strictly best effort.
   * @return value or {@code null} for none
   */
  public java.lang.String getIdLabel() {
    return idLabel;
  }

  /**
   * If set, contains a pubsub label from which to extract record ids. If left empty, record
   * deduplication will be strictly best effort.
   * @param idLabel idLabel or {@code null} for none
   */
  public PubsubLocation setIdLabel(java.lang.String idLabel) {
    this.idLabel = idLabel;
    return this;
  }

  /**
   * A pubsub subscription, in the form of "pubsub.googleapis.com/subscriptions//"
   * @return value or {@code null} for none
   */
  public java.lang.String getSubscription() {
    return subscription;
  }

  /**
   * A pubsub subscription, in the form of "pubsub.googleapis.com/subscriptions//"
   * @param subscription subscription or {@code null} for none
   */
  public PubsubLocation setSubscription(java.lang.String subscription) {
    this.subscription = subscription;
    return this;
  }

  /**
   * If set, contains a pubsub label from which to extract record timestamps. If left empty, record
   * timestamps will be generated upon arrival.
   * @return value or {@code null} for none
   */
  public java.lang.String getTimestampLabel() {
    return timestampLabel;
  }

  /**
   * If set, contains a pubsub label from which to extract record timestamps. If left empty, record
   * timestamps will be generated upon arrival.
   * @param timestampLabel timestampLabel or {@code null} for none
   */
  public PubsubLocation setTimestampLabel(java.lang.String timestampLabel) {
    this.timestampLabel = timestampLabel;
    return this;
  }

  /**
   * A pubsub topic, in the form of "pubsub.googleapis.com/topics//"
   * @return value or {@code null} for none
   */
  public java.lang.String getTopic() {
    return topic;
  }

  /**
   * A pubsub topic, in the form of "pubsub.googleapis.com/topics//"
   * @param topic topic or {@code null} for none
   */
  public PubsubLocation setTopic(java.lang.String topic) {
    this.topic = topic;
    return this;
  }

  /**
   * If set, specifies the pubsub subscription that will be used for tracking custom time timestamps
   * for watermark estimation.
   * @return value or {@code null} for none
   */
  public java.lang.String getTrackingSubscription() {
    return trackingSubscription;
  }

  /**
   * If set, specifies the pubsub subscription that will be used for tracking custom time timestamps
   * for watermark estimation.
   * @param trackingSubscription trackingSubscription or {@code null} for none
   */
  public PubsubLocation setTrackingSubscription(java.lang.String trackingSubscription) {
    this.trackingSubscription = trackingSubscription;
    return this;
  }

  /**
   * If true, then the client has requested to get pubsub attributes.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getWithAttributes() {
    return withAttributes;
  }

  /**
   * If true, then the client has requested to get pubsub attributes.
   * @param withAttributes withAttributes or {@code null} for none
   */
  public PubsubLocation setWithAttributes(java.lang.Boolean withAttributes) {
    this.withAttributes = withAttributes;
    return this;
  }

  @Override
  public PubsubLocation set(String fieldName, Object value) {
    return (PubsubLocation) super.set(fieldName, value);
  }

  @Override
  public PubsubLocation clone() {
    return (PubsubLocation) super.clone();
  }

}
