/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Statistics for the underflow and overflow bucket.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OutlierStats extends com.google.api.client.json.GenericJson {

  /**
   * Number of values that are larger than the upper bound of the largest bucket.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long overflowCount;

  /**
   * Mean of values in the overflow bucket.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double overflowMean;

  /**
   * Number of values that are smaller than the lower bound of the smallest bucket.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long underflowCount;

  /**
   * Mean of values in the undeflow bucket.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double underflowMean;

  /**
   * Number of values that are larger than the upper bound of the largest bucket.
   * @return value or {@code null} for none
   */
  public java.lang.Long getOverflowCount() {
    return overflowCount;
  }

  /**
   * Number of values that are larger than the upper bound of the largest bucket.
   * @param overflowCount overflowCount or {@code null} for none
   */
  public OutlierStats setOverflowCount(java.lang.Long overflowCount) {
    this.overflowCount = overflowCount;
    return this;
  }

  /**
   * Mean of values in the overflow bucket.
   * @return value or {@code null} for none
   */
  public java.lang.Double getOverflowMean() {
    return overflowMean;
  }

  /**
   * Mean of values in the overflow bucket.
   * @param overflowMean overflowMean or {@code null} for none
   */
  public OutlierStats setOverflowMean(java.lang.Double overflowMean) {
    this.overflowMean = overflowMean;
    return this;
  }

  /**
   * Number of values that are smaller than the lower bound of the smallest bucket.
   * @return value or {@code null} for none
   */
  public java.lang.Long getUnderflowCount() {
    return underflowCount;
  }

  /**
   * Number of values that are smaller than the lower bound of the smallest bucket.
   * @param underflowCount underflowCount or {@code null} for none
   */
  public OutlierStats setUnderflowCount(java.lang.Long underflowCount) {
    this.underflowCount = underflowCount;
    return this;
  }

  /**
   * Mean of values in the undeflow bucket.
   * @return value or {@code null} for none
   */
  public java.lang.Double getUnderflowMean() {
    return underflowMean;
  }

  /**
   * Mean of values in the undeflow bucket.
   * @param underflowMean underflowMean or {@code null} for none
   */
  public OutlierStats setUnderflowMean(java.lang.Double underflowMean) {
    this.underflowMean = underflowMean;
    return this;
  }

  @Override
  public OutlierStats set(String fieldName, Object value) {
    return (OutlierStats) super.set(fieldName, value);
  }

  @Override
  public OutlierStats clone() {
    return (OutlierStats) super.clone();
  }

}
