/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Linear buckets with the following boundaries for indices in 0 to n-1. - i in [0, n-1]: [start +
 * (i)*width, start + (i+1)*width)
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Linear extends com.google.api.client.json.GenericJson {

  /**
   * Must be greater than 0.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer numberOfBuckets;

  /**
   * Lower bound of the first bucket.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double start;

  /**
   * Distance between bucket boundaries. Must be greater than 0.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double width;

  /**
   * Must be greater than 0.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getNumberOfBuckets() {
    return numberOfBuckets;
  }

  /**
   * Must be greater than 0.
   * @param numberOfBuckets numberOfBuckets or {@code null} for none
   */
  public Linear setNumberOfBuckets(java.lang.Integer numberOfBuckets) {
    this.numberOfBuckets = numberOfBuckets;
    return this;
  }

  /**
   * Lower bound of the first bucket.
   * @return value or {@code null} for none
   */
  public java.lang.Double getStart() {
    return start;
  }

  /**
   * Lower bound of the first bucket.
   * @param start start or {@code null} for none
   */
  public Linear setStart(java.lang.Double start) {
    this.start = start;
    return this;
  }

  /**
   * Distance between bucket boundaries. Must be greater than 0.
   * @return value or {@code null} for none
   */
  public java.lang.Double getWidth() {
    return width;
  }

  /**
   * Distance between bucket boundaries. Must be greater than 0.
   * @param width width or {@code null} for none
   */
  public Linear setWidth(java.lang.Double width) {
    this.width = width;
    return this;
  }

  @Override
  public Linear set(String fieldName, Object value) {
    return (Linear) super.set(fieldName, value);
  }

  @Override
  public Linear clone() {
    return (Linear) super.clone();
  }

}
