/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Contains information about how a particular google.dataflow.v1beta3.Step will be executed.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class JobExecutionStageInfo extends com.google.api.client.json.GenericJson {

  /**
   * The steps associated with the execution stage. Note that stages may have several steps, and
   * that a given step might be run by more than one stage.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> stepName;

  /**
   * The steps associated with the execution stage. Note that stages may have several steps, and
   * that a given step might be run by more than one stage.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getStepName() {
    return stepName;
  }

  /**
   * The steps associated with the execution stage. Note that stages may have several steps, and
   * that a given step might be run by more than one stage.
   * @param stepName stepName or {@code null} for none
   */
  public JobExecutionStageInfo setStepName(java.util.List<java.lang.String> stepName) {
    this.stepName = stepName;
    return this;
  }

  @Override
  public JobExecutionStageInfo set(String fieldName, Object value) {
    return (JobExecutionStageInfo) super.set(fieldName, value);
  }

  @Override
  public JobExecutionStageInfo clone() {
    return (JobExecutionStageInfo) super.clone();
  }

}
