/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Modeled after information exposed by /proc/stat.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CPUTime extends com.google.api.client.json.GenericJson {

  /**
   * Average CPU utilization rate (% non-idle cpu / second) since previous sample.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double rate;

  /**
   * Timestamp of the measurement.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String timestamp;

  /**
   * Total active CPU time across all cores (ie., non-idle) in milliseconds since start-up.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger totalMs;

  /**
   * Average CPU utilization rate (% non-idle cpu / second) since previous sample.
   * @return value or {@code null} for none
   */
  public java.lang.Double getRate() {
    return rate;
  }

  /**
   * Average CPU utilization rate (% non-idle cpu / second) since previous sample.
   * @param rate rate or {@code null} for none
   */
  public CPUTime setRate(java.lang.Double rate) {
    this.rate = rate;
    return this;
  }

  /**
   * Timestamp of the measurement.
   * @return value or {@code null} for none
   */
  public String getTimestamp() {
    return timestamp;
  }

  /**
   * Timestamp of the measurement.
   * @param timestamp timestamp or {@code null} for none
   */
  public CPUTime setTimestamp(String timestamp) {
    this.timestamp = timestamp;
    return this;
  }

  /**
   * Total active CPU time across all cores (ie., non-idle) in milliseconds since start-up.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getTotalMs() {
    return totalMs;
  }

  /**
   * Total active CPU time across all cores (ie., non-idle) in milliseconds since start-up.
   * @param totalMs totalMs or {@code null} for none
   */
  public CPUTime setTotalMs(java.math.BigInteger totalMs) {
    this.totalMs = totalMs;
    return this;
  }

  @Override
  public CPUTime set(String fieldName, Object value) {
    return (CPUTime) super.set(fieldName, value);
  }

  @Override
  public CPUTime clone() {
    return (CPUTime) super.clone();
  }

}
