/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Request to send encoded debug information. Next ID: 8
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SendDebugCaptureRequest extends com.google.api.client.json.GenericJson {

  /**
   * The internal component id for which debug information is sent.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String componentId;

  /**
   * The encoded debug information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String data;

  /**
   * Format for the data field above (id=5).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dataFormat;

  /**
   * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints)
   * that contains the job specified by job_id.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String location;

  /**
   * The worker id, i.e., VM hostname.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String workerId;

  /**
   * The internal component id for which debug information is sent.
   * @return value or {@code null} for none
   */
  public java.lang.String getComponentId() {
    return componentId;
  }

  /**
   * The internal component id for which debug information is sent.
   * @param componentId componentId or {@code null} for none
   */
  public SendDebugCaptureRequest setComponentId(java.lang.String componentId) {
    this.componentId = componentId;
    return this;
  }

  /**
   * The encoded debug information.
   * @return value or {@code null} for none
   */
  public java.lang.String getData() {
    return data;
  }

  /**
   * The encoded debug information.
   * @param data data or {@code null} for none
   */
  public SendDebugCaptureRequest setData(java.lang.String data) {
    this.data = data;
    return this;
  }

  /**
   * Format for the data field above (id=5).
   * @return value or {@code null} for none
   */
  public java.lang.String getDataFormat() {
    return dataFormat;
  }

  /**
   * Format for the data field above (id=5).
   * @param dataFormat dataFormat or {@code null} for none
   */
  public SendDebugCaptureRequest setDataFormat(java.lang.String dataFormat) {
    this.dataFormat = dataFormat;
    return this;
  }

  /**
   * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints)
   * that contains the job specified by job_id.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocation() {
    return location;
  }

  /**
   * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints)
   * that contains the job specified by job_id.
   * @param location location or {@code null} for none
   */
  public SendDebugCaptureRequest setLocation(java.lang.String location) {
    this.location = location;
    return this;
  }

  /**
   * The worker id, i.e., VM hostname.
   * @return value or {@code null} for none
   */
  public java.lang.String getWorkerId() {
    return workerId;
  }

  /**
   * The worker id, i.e., VM hostname.
   * @param workerId workerId or {@code null} for none
   */
  public SendDebugCaptureRequest setWorkerId(java.lang.String workerId) {
    this.workerId = workerId;
    return this;
  }

  @Override
  public SendDebugCaptureRequest set(String fieldName, Object value) {
    return (SendDebugCaptureRequest) super.set(fieldName, value);
  }

  @Override
  public SendDebugCaptureRequest clone() {
    return (SendDebugCaptureRequest) super.clone();
  }

}
