/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Information about the memory usage of a worker or a container within a worker.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MemInfo extends com.google.api.client.json.GenericJson {

  /**
   * Instantenous memory limit in bytes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger currentLimitBytes;

  /**
   * Number of Out of Memory (OOM) events recorded since the previous measurement.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long currentOoms;

  /**
   * Instantenous memory (RSS) size in bytes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger currentRssBytes;

  /**
   * Timestamp of the measurement.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String timestamp;

  /**
   * Total memory (RSS) usage since start up in GB * ms.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger totalGbMs;

  /**
   * Instantenous memory limit in bytes.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getCurrentLimitBytes() {
    return currentLimitBytes;
  }

  /**
   * Instantenous memory limit in bytes.
   * @param currentLimitBytes currentLimitBytes or {@code null} for none
   */
  public MemInfo setCurrentLimitBytes(java.math.BigInteger currentLimitBytes) {
    this.currentLimitBytes = currentLimitBytes;
    return this;
  }

  /**
   * Number of Out of Memory (OOM) events recorded since the previous measurement.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCurrentOoms() {
    return currentOoms;
  }

  /**
   * Number of Out of Memory (OOM) events recorded since the previous measurement.
   * @param currentOoms currentOoms or {@code null} for none
   */
  public MemInfo setCurrentOoms(java.lang.Long currentOoms) {
    this.currentOoms = currentOoms;
    return this;
  }

  /**
   * Instantenous memory (RSS) size in bytes.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getCurrentRssBytes() {
    return currentRssBytes;
  }

  /**
   * Instantenous memory (RSS) size in bytes.
   * @param currentRssBytes currentRssBytes or {@code null} for none
   */
  public MemInfo setCurrentRssBytes(java.math.BigInteger currentRssBytes) {
    this.currentRssBytes = currentRssBytes;
    return this;
  }

  /**
   * Timestamp of the measurement.
   * @return value or {@code null} for none
   */
  public String getTimestamp() {
    return timestamp;
  }

  /**
   * Timestamp of the measurement.
   * @param timestamp timestamp or {@code null} for none
   */
  public MemInfo setTimestamp(String timestamp) {
    this.timestamp = timestamp;
    return this;
  }

  /**
   * Total memory (RSS) usage since start up in GB * ms.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getTotalGbMs() {
    return totalGbMs;
  }

  /**
   * Total memory (RSS) usage since start up in GB * ms.
   * @param totalGbMs totalGbMs or {@code null} for none
   */
  public MemInfo setTotalGbMs(java.math.BigInteger totalGbMs) {
    this.totalGbMs = totalGbMs;
    return this;
  }

  @Override
  public MemInfo set(String fieldName, Object value) {
    return (MemInfo) super.set(fieldName, value);
  }

  @Override
  public MemInfo clone() {
    return (MemInfo) super.clone();
  }

}
