/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Response to a request to lease WorkItems.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LeaseWorkItemResponse extends com.google.api.client.json.GenericJson {

  /**
   * Untranslated bag-of-bytes WorkResponse for UnifiedWorker.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.Object> unifiedWorkerResponse;

  /**
   * A list of the leased WorkItems.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<WorkItem> workItems;

  /**
   * Untranslated bag-of-bytes WorkResponse for UnifiedWorker.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.Object> getUnifiedWorkerResponse() {
    return unifiedWorkerResponse;
  }

  /**
   * Untranslated bag-of-bytes WorkResponse for UnifiedWorker.
   * @param unifiedWorkerResponse unifiedWorkerResponse or {@code null} for none
   */
  public LeaseWorkItemResponse setUnifiedWorkerResponse(java.util.Map<String, java.lang.Object> unifiedWorkerResponse) {
    this.unifiedWorkerResponse = unifiedWorkerResponse;
    return this;
  }

  /**
   * A list of the leased WorkItems.
   * @return value or {@code null} for none
   */
  public java.util.List<WorkItem> getWorkItems() {
    return workItems;
  }

  /**
   * A list of the leased WorkItems.
   * @param workItems workItems or {@code null} for none
   */
  public LeaseWorkItemResponse setWorkItems(java.util.List<WorkItem> workItems) {
    this.workItems = workItems;
    return this;
  }

  @Override
  public LeaseWorkItemResponse set(String fieldName, Object value) {
    return (LeaseWorkItemResponse) super.set(fieldName, value);
  }

  @Override
  public LeaseWorkItemResponse clone() {
    return (LeaseWorkItemResponse) super.clone();
  }

}
