/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Parameters to provide to the template being launched. Note that the [metadata in the pipeline
 * code] (https://cloud.google.com/dataflow/docs/guides/templates/creating-templates#metadata)
 * determines which runtime parameters are valid.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LaunchTemplateParameters extends com.google.api.client.json.GenericJson {

  /**
   * The runtime environment for the job.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RuntimeEnvironment environment;

  /**
   * Required. The job name to use for the created job. The name must match the regular expression
   * `[a-z]([-a-z0-9]{0,1022}[a-z0-9])?`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String jobName;

  /**
   * The runtime parameters to pass to the job.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> parameters;

  /**
   * Only applicable when updating a pipeline. Map of transform name prefixes of the job to be
   * replaced to the corresponding name prefixes of the new job.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> transformNameMapping;

  /**
   * If set, replace the existing pipeline with the name specified by jobName with this pipeline,
   * preserving state.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean update;

  /**
   * The runtime environment for the job.
   * @return value or {@code null} for none
   */
  public RuntimeEnvironment getEnvironment() {
    return environment;
  }

  /**
   * The runtime environment for the job.
   * @param environment environment or {@code null} for none
   */
  public LaunchTemplateParameters setEnvironment(RuntimeEnvironment environment) {
    this.environment = environment;
    return this;
  }

  /**
   * Required. The job name to use for the created job. The name must match the regular expression
   * `[a-z]([-a-z0-9]{0,1022}[a-z0-9])?`
   * @return value or {@code null} for none
   */
  public java.lang.String getJobName() {
    return jobName;
  }

  /**
   * Required. The job name to use for the created job. The name must match the regular expression
   * `[a-z]([-a-z0-9]{0,1022}[a-z0-9])?`
   * @param jobName jobName or {@code null} for none
   */
  public LaunchTemplateParameters setJobName(java.lang.String jobName) {
    this.jobName = jobName;
    return this;
  }

  /**
   * The runtime parameters to pass to the job.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getParameters() {
    return parameters;
  }

  /**
   * The runtime parameters to pass to the job.
   * @param parameters parameters or {@code null} for none
   */
  public LaunchTemplateParameters setParameters(java.util.Map<String, java.lang.String> parameters) {
    this.parameters = parameters;
    return this;
  }

  /**
   * Only applicable when updating a pipeline. Map of transform name prefixes of the job to be
   * replaced to the corresponding name prefixes of the new job.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getTransformNameMapping() {
    return transformNameMapping;
  }

  /**
   * Only applicable when updating a pipeline. Map of transform name prefixes of the job to be
   * replaced to the corresponding name prefixes of the new job.
   * @param transformNameMapping transformNameMapping or {@code null} for none
   */
  public LaunchTemplateParameters setTransformNameMapping(java.util.Map<String, java.lang.String> transformNameMapping) {
    this.transformNameMapping = transformNameMapping;
    return this;
  }

  /**
   * If set, replace the existing pipeline with the name specified by jobName with this pipeline,
   * preserving state.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getUpdate() {
    return update;
  }

  /**
   * If set, replace the existing pipeline with the name specified by jobName with this pipeline,
   * preserving state.
   * @param update update or {@code null} for none
   */
  public LaunchTemplateParameters setUpdate(java.lang.Boolean update) {
    this.update = update;
    return this;
  }

  @Override
  public LaunchTemplateParameters set(String fieldName, Object value) {
    return (LaunchTemplateParameters) super.set(fieldName, value);
  }

  @Override
  public LaunchTemplateParameters clone() {
    return (LaunchTemplateParameters) super.clone();
  }

}
