/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Configuration options for sampling elements.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DataSamplingConfig extends com.google.api.client.json.GenericJson {

  /**
   * List of given sampling behaviors to enable. For example, specifying behaviors = [ALWAYS_ON]
   * samples in-flight elements but does not sample exceptions. Can be used to specify multiple
   * behaviors like, behaviors = [ALWAYS_ON, EXCEPTIONS] for specifying periodic sampling and
   * exception sampling. If DISABLED is in the list, then sampling will be disabled and ignore the
   * other given behaviors. Ordering does not matter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> behaviors;

  /**
   * List of given sampling behaviors to enable. For example, specifying behaviors = [ALWAYS_ON]
   * samples in-flight elements but does not sample exceptions. Can be used to specify multiple
   * behaviors like, behaviors = [ALWAYS_ON, EXCEPTIONS] for specifying periodic sampling and
   * exception sampling. If DISABLED is in the list, then sampling will be disabled and ignore the
   * other given behaviors. Ordering does not matter.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getBehaviors() {
    return behaviors;
  }

  /**
   * List of given sampling behaviors to enable. For example, specifying behaviors = [ALWAYS_ON]
   * samples in-flight elements but does not sample exceptions. Can be used to specify multiple
   * behaviors like, behaviors = [ALWAYS_ON, EXCEPTIONS] for specifying periodic sampling and
   * exception sampling. If DISABLED is in the list, then sampling will be disabled and ignore the
   * other given behaviors. Ordering does not matter.
   * @param behaviors behaviors or {@code null} for none
   */
  public DataSamplingConfig setBehaviors(java.util.List<java.lang.String> behaviors) {
    this.behaviors = behaviors;
    return this;
  }

  @Override
  public DataSamplingConfig set(String fieldName, Object value) {
    return (DataSamplingConfig) super.set(fieldName, value);
  }

  @Override
  public DataSamplingConfig clone() {
    return (DataSamplingConfig) super.clone();
  }

}
