/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Metadata about a Source useful for automatically optimizing and tuning the pipeline, etc.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SourceMetadata extends com.google.api.client.json.GenericJson {

  /**
   * An estimate of the total size (in bytes) of the data that would be read from this source. This
   * estimate is in terms of external storage size, before any decompression or other processing
   * done by the reader.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long estimatedSizeBytes;

  /**
   * Specifies that the size of this source is known to be infinite (this is a streaming source).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean infinite;

  /**
   * Whether this source is known to produce key/value pairs with the (encoded) keys in
   * lexicographically sorted order.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean producesSortedKeys;

  /**
   * An estimate of the total size (in bytes) of the data that would be read from this source. This
   * estimate is in terms of external storage size, before any decompression or other processing
   * done by the reader.
   * @return value or {@code null} for none
   */
  public java.lang.Long getEstimatedSizeBytes() {
    return estimatedSizeBytes;
  }

  /**
   * An estimate of the total size (in bytes) of the data that would be read from this source. This
   * estimate is in terms of external storage size, before any decompression or other processing
   * done by the reader.
   * @param estimatedSizeBytes estimatedSizeBytes or {@code null} for none
   */
  public SourceMetadata setEstimatedSizeBytes(java.lang.Long estimatedSizeBytes) {
    this.estimatedSizeBytes = estimatedSizeBytes;
    return this;
  }

  /**
   * Specifies that the size of this source is known to be infinite (this is a streaming source).
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getInfinite() {
    return infinite;
  }

  /**
   * Specifies that the size of this source is known to be infinite (this is a streaming source).
   * @param infinite infinite or {@code null} for none
   */
  public SourceMetadata setInfinite(java.lang.Boolean infinite) {
    this.infinite = infinite;
    return this;
  }

  /**
   * Whether this source is known to produce key/value pairs with the (encoded) keys in
   * lexicographically sorted order.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getProducesSortedKeys() {
    return producesSortedKeys;
  }

  /**
   * Whether this source is known to produce key/value pairs with the (encoded) keys in
   * lexicographically sorted order.
   * @param producesSortedKeys producesSortedKeys or {@code null} for none
   */
  public SourceMetadata setProducesSortedKeys(java.lang.Boolean producesSortedKeys) {
    this.producesSortedKeys = producesSortedKeys;
    return this;
  }

  @Override
  public SourceMetadata set(String fieldName, Object value) {
    return (SourceMetadata) super.set(fieldName, value);
  }

  @Override
  public SourceMetadata clone() {
    return (SourceMetadata) super.clone();
  }

}
