/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Information about a hot key.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class HotKeyInfo extends com.google.api.client.json.GenericJson {

  /**
   * The age of the hot key measured from when it was first detected.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String hotKeyAge;

  /**
   * A detected hot key that is causing limited parallelism. This field will be populated only if
   * the following flag is set to true: "--enable_hot_key_logging".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String key;

  /**
   * If true, then the above key is truncated and cannot be deserialized. This occurs if the key
   * above is populated and the key size is >5MB.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean keyTruncated;

  /**
   * The age of the hot key measured from when it was first detected.
   * @return value or {@code null} for none
   */
  public String getHotKeyAge() {
    return hotKeyAge;
  }

  /**
   * The age of the hot key measured from when it was first detected.
   * @param hotKeyAge hotKeyAge or {@code null} for none
   */
  public HotKeyInfo setHotKeyAge(String hotKeyAge) {
    this.hotKeyAge = hotKeyAge;
    return this;
  }

  /**
   * A detected hot key that is causing limited parallelism. This field will be populated only if
   * the following flag is set to true: "--enable_hot_key_logging".
   * @return value or {@code null} for none
   */
  public java.lang.String getKey() {
    return key;
  }

  /**
   * A detected hot key that is causing limited parallelism. This field will be populated only if
   * the following flag is set to true: "--enable_hot_key_logging".
   * @param key key or {@code null} for none
   */
  public HotKeyInfo setKey(java.lang.String key) {
    this.key = key;
    return this;
  }

  /**
   * If true, then the above key is truncated and cannot be deserialized. This occurs if the key
   * above is populated and the key size is >5MB.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getKeyTruncated() {
    return keyTruncated;
  }

  /**
   * If true, then the above key is truncated and cannot be deserialized. This occurs if the key
   * above is populated and the key size is >5MB.
   * @param keyTruncated keyTruncated or {@code null} for none
   */
  public HotKeyInfo setKeyTruncated(java.lang.Boolean keyTruncated) {
    this.keyTruncated = keyTruncated;
    return this;
  }

  @Override
  public HotKeyInfo set(String fieldName, Object value) {
    return (HotKeyInfo) super.set(fieldName, value);
  }

  @Override
  public HotKeyInfo clone() {
    return (HotKeyInfo) super.clone();
  }

}
