/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Proto describing a hot key detected on a given WorkItem.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class HotKeyDetection extends com.google.api.client.json.GenericJson {

  /**
   * The age of the hot key measured from when it was first detected.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String hotKeyAge;

  /**
   * System-defined name of the step containing this hot key. Unique across the workflow.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String systemName;

  /**
   * User-provided name of the step that contains this hot key.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String userStepName;

  /**
   * The age of the hot key measured from when it was first detected.
   * @return value or {@code null} for none
   */
  public String getHotKeyAge() {
    return hotKeyAge;
  }

  /**
   * The age of the hot key measured from when it was first detected.
   * @param hotKeyAge hotKeyAge or {@code null} for none
   */
  public HotKeyDetection setHotKeyAge(String hotKeyAge) {
    this.hotKeyAge = hotKeyAge;
    return this;
  }

  /**
   * System-defined name of the step containing this hot key. Unique across the workflow.
   * @return value or {@code null} for none
   */
  public java.lang.String getSystemName() {
    return systemName;
  }

  /**
   * System-defined name of the step containing this hot key. Unique across the workflow.
   * @param systemName systemName or {@code null} for none
   */
  public HotKeyDetection setSystemName(java.lang.String systemName) {
    this.systemName = systemName;
    return this;
  }

  /**
   * User-provided name of the step that contains this hot key.
   * @return value or {@code null} for none
   */
  public java.lang.String getUserStepName() {
    return userStepName;
  }

  /**
   * User-provided name of the step that contains this hot key.
   * @param userStepName userStepName or {@code null} for none
   */
  public HotKeyDetection setUserStepName(java.lang.String userStepName) {
    this.userStepName = userStepName;
    return this;
  }

  @Override
  public HotKeyDetection set(String fieldName, Object value) {
    return (HotKeyDetection) super.set(fieldName, value);
  }

  @Override
  public HotKeyDetection clone() {
    return (HotKeyDetection) super.clone();
  }

}
