/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * A single message which encapsulates structured name and metadata for a given counter.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CounterStructuredNameAndMetadata extends com.google.api.client.json.GenericJson {

  /**
   * Metadata associated with a counter
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CounterMetadata metadata;

  /**
   * Structured name of the counter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CounterStructuredName name;

  /**
   * Metadata associated with a counter
   * @return value or {@code null} for none
   */
  public CounterMetadata getMetadata() {
    return metadata;
  }

  /**
   * Metadata associated with a counter
   * @param metadata metadata or {@code null} for none
   */
  public CounterStructuredNameAndMetadata setMetadata(CounterMetadata metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * Structured name of the counter.
   * @return value or {@code null} for none
   */
  public CounterStructuredName getName() {
    return name;
  }

  /**
   * Structured name of the counter.
   * @param name name or {@code null} for none
   */
  public CounterStructuredNameAndMetadata setName(CounterStructuredName name) {
    this.name = name;
    return this;
  }

  @Override
  public CounterStructuredNameAndMetadata set(String fieldName, Object value) {
    return (CounterStructuredNameAndMetadata) super.set(fieldName, value);
  }

  @Override
  public CounterStructuredNameAndMetadata clone() {
    return (CounterStructuredNameAndMetadata) super.clone();
  }

}
