/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Metadata for a BigQuery connector used by the job.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BigQueryIODetails extends com.google.api.client.json.GenericJson {

  /**
   * Dataset accessed in the connection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dataset;

  /**
   * Project accessed in the connection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String projectId;

  /**
   * Query used to access data in the connection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String query;

  /**
   * Table accessed in the connection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String table;

  /**
   * Dataset accessed in the connection.
   * @return value or {@code null} for none
   */
  public java.lang.String getDataset() {
    return dataset;
  }

  /**
   * Dataset accessed in the connection.
   * @param dataset dataset or {@code null} for none
   */
  public BigQueryIODetails setDataset(java.lang.String dataset) {
    this.dataset = dataset;
    return this;
  }

  /**
   * Project accessed in the connection.
   * @return value or {@code null} for none
   */
  public java.lang.String getProjectId() {
    return projectId;
  }

  /**
   * Project accessed in the connection.
   * @param projectId projectId or {@code null} for none
   */
  public BigQueryIODetails setProjectId(java.lang.String projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * Query used to access data in the connection.
   * @return value or {@code null} for none
   */
  public java.lang.String getQuery() {
    return query;
  }

  /**
   * Query used to access data in the connection.
   * @param query query or {@code null} for none
   */
  public BigQueryIODetails setQuery(java.lang.String query) {
    this.query = query;
    return this;
  }

  /**
   * Table accessed in the connection.
   * @return value or {@code null} for none
   */
  public java.lang.String getTable() {
    return table;
  }

  /**
   * Table accessed in the connection.
   * @param table table or {@code null} for none
   */
  public BigQueryIODetails setTable(java.lang.String table) {
    this.table = table;
    return this;
  }

  @Override
  public BigQueryIODetails set(String fieldName, Object value) {
    return (BigQueryIODetails) super.set(fieldName, value);
  }

  @Override
  public BigQueryIODetails clone() {
    return (BigQueryIODetails) super.clone();
  }

}
