/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * A worker_message response allows the server to pass information to the sender.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class WorkerMessageResponse extends com.google.api.client.json.GenericJson {

  /**
   * The service's response to a worker's health report.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private WorkerHealthReportResponse workerHealthReportResponse;

  /**
   * Service's response to reporting worker metrics (currently empty).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ResourceUtilizationReportResponse workerMetricsResponse;

  /**
   * Service's response to shutdown notice (currently empty).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private WorkerShutdownNoticeResponse workerShutdownNoticeResponse;

  /**
   * The service's response to a worker's health report.
   * @return value or {@code null} for none
   */
  public WorkerHealthReportResponse getWorkerHealthReportResponse() {
    return workerHealthReportResponse;
  }

  /**
   * The service's response to a worker's health report.
   * @param workerHealthReportResponse workerHealthReportResponse or {@code null} for none
   */
  public WorkerMessageResponse setWorkerHealthReportResponse(WorkerHealthReportResponse workerHealthReportResponse) {
    this.workerHealthReportResponse = workerHealthReportResponse;
    return this;
  }

  /**
   * Service's response to reporting worker metrics (currently empty).
   * @return value or {@code null} for none
   */
  public ResourceUtilizationReportResponse getWorkerMetricsResponse() {
    return workerMetricsResponse;
  }

  /**
   * Service's response to reporting worker metrics (currently empty).
   * @param workerMetricsResponse workerMetricsResponse or {@code null} for none
   */
  public WorkerMessageResponse setWorkerMetricsResponse(ResourceUtilizationReportResponse workerMetricsResponse) {
    this.workerMetricsResponse = workerMetricsResponse;
    return this;
  }

  /**
   * Service's response to shutdown notice (currently empty).
   * @return value or {@code null} for none
   */
  public WorkerShutdownNoticeResponse getWorkerShutdownNoticeResponse() {
    return workerShutdownNoticeResponse;
  }

  /**
   * Service's response to shutdown notice (currently empty).
   * @param workerShutdownNoticeResponse workerShutdownNoticeResponse or {@code null} for none
   */
  public WorkerMessageResponse setWorkerShutdownNoticeResponse(WorkerShutdownNoticeResponse workerShutdownNoticeResponse) {
    this.workerShutdownNoticeResponse = workerShutdownNoticeResponse;
    return this;
  }

  @Override
  public WorkerMessageResponse set(String fieldName, Object value) {
    return (WorkerMessageResponse) super.set(fieldName, value);
  }

  @Override
  public WorkerMessageResponse clone() {
    return (WorkerMessageResponse) super.clone();
  }

}
