/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Identifies the location of a streaming side input.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class StreamingSideInputLocation extends com.google.api.client.json.GenericJson {

  /**
   * Identifies the state family where this side input is stored.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String stateFamily;

  /**
   * Identifies the particular side input within the streaming Dataflow job.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String tag;

  /**
   * Identifies the state family where this side input is stored.
   * @return value or {@code null} for none
   */
  public java.lang.String getStateFamily() {
    return stateFamily;
  }

  /**
   * Identifies the state family where this side input is stored.
   * @param stateFamily stateFamily or {@code null} for none
   */
  public StreamingSideInputLocation setStateFamily(java.lang.String stateFamily) {
    this.stateFamily = stateFamily;
    return this;
  }

  /**
   * Identifies the particular side input within the streaming Dataflow job.
   * @return value or {@code null} for none
   */
  public java.lang.String getTag() {
    return tag;
  }

  /**
   * Identifies the particular side input within the streaming Dataflow job.
   * @param tag tag or {@code null} for none
   */
  public StreamingSideInputLocation setTag(java.lang.String tag) {
    this.tag = tag;
    return this;
  }

  @Override
  public StreamingSideInputLocation set(String fieldName, Object value) {
    return (StreamingSideInputLocation) super.set(fieldName, value);
  }

  @Override
  public StreamingSideInputLocation clone() {
    return (StreamingSideInputLocation) super.clone();
  }

}
