/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * A task which describes what action should be performed for the specified streaming computation
 * ranges.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class StreamingComputationTask extends com.google.api.client.json.GenericJson {

  /**
   * Contains ranges of a streaming computation this task should apply to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<StreamingComputationRanges> computationRanges;

  static {
    // hack to force ProGuard to consider StreamingComputationRanges used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(StreamingComputationRanges.class);
  }

  /**
   * Describes the set of data disks this task should apply to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MountedDataDisk> dataDisks;

  static {
    // hack to force ProGuard to consider MountedDataDisk used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(MountedDataDisk.class);
  }

  /**
   * A type of streaming computation task.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String taskType;

  /**
   * Contains ranges of a streaming computation this task should apply to.
   * @return value or {@code null} for none
   */
  public java.util.List<StreamingComputationRanges> getComputationRanges() {
    return computationRanges;
  }

  /**
   * Contains ranges of a streaming computation this task should apply to.
   * @param computationRanges computationRanges or {@code null} for none
   */
  public StreamingComputationTask setComputationRanges(java.util.List<StreamingComputationRanges> computationRanges) {
    this.computationRanges = computationRanges;
    return this;
  }

  /**
   * Describes the set of data disks this task should apply to.
   * @return value or {@code null} for none
   */
  public java.util.List<MountedDataDisk> getDataDisks() {
    return dataDisks;
  }

  /**
   * Describes the set of data disks this task should apply to.
   * @param dataDisks dataDisks or {@code null} for none
   */
  public StreamingComputationTask setDataDisks(java.util.List<MountedDataDisk> dataDisks) {
    this.dataDisks = dataDisks;
    return this;
  }

  /**
   * A type of streaming computation task.
   * @return value or {@code null} for none
   */
  public java.lang.String getTaskType() {
    return taskType;
  }

  /**
   * A type of streaming computation task.
   * @param taskType taskType or {@code null} for none
   */
  public StreamingComputationTask setTaskType(java.lang.String taskType) {
    this.taskType = taskType;
    return this;
  }

  @Override
  public StreamingComputationTask set(String fieldName, Object value) {
    return (StreamingComputationTask) super.set(fieldName, value);
  }

  @Override
  public StreamingComputationTask clone() {
    return (StreamingComputationTask) super.clone();
  }

}
