/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Represents the operation to split a high-level Source specification into bundles (parts for
 * parallel processing). At a high level, splitting of a source into bundles happens as follows:
 * SourceSplitRequest is applied to the source. If it returns SOURCE_SPLIT_OUTCOME_USE_CURRENT, no
 * further splitting happens and the source is used "as is". Otherwise, splitting is applied
 * recursively to each produced DerivedSource. As an optimization, for any Source, if its
 * does_not_need_splitting is true, the framework assumes that splitting this source would return
 * SOURCE_SPLIT_OUTCOME_USE_CURRENT, and doesn't initiate a SourceSplitRequest. This applies both to
 * the initial source being split and to bundles produced from it.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SourceSplitRequest extends com.google.api.client.json.GenericJson {

  /**
   * Hints for tuning the splitting process.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SourceSplitOptions options;

  /**
   * Specification of the source to be split.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Source source;

  /**
   * Hints for tuning the splitting process.
   * @return value or {@code null} for none
   */
  public SourceSplitOptions getOptions() {
    return options;
  }

  /**
   * Hints for tuning the splitting process.
   * @param options options or {@code null} for none
   */
  public SourceSplitRequest setOptions(SourceSplitOptions options) {
    this.options = options;
    return this;
  }

  /**
   * Specification of the source to be split.
   * @return value or {@code null} for none
   */
  public Source getSource() {
    return source;
  }

  /**
   * Specification of the source to be split.
   * @param source source or {@code null} for none
   */
  public SourceSplitRequest setSource(Source source) {
    this.source = source;
    return this;
  }

  @Override
  public SourceSplitRequest set(String fieldName, Object value) {
    return (SourceSplitRequest) super.set(fieldName, value);
  }

  @Override
  public SourceSplitRequest clone() {
    return (SourceSplitRequest) super.clone();
  }

}
