/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Request to create a snapshot of a job.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SnapshotJobRequest extends com.google.api.client.json.GenericJson {

  /**
   * User specified description of the snapshot. Maybe empty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * The location that contains this job.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String location;

  /**
   * If true, perform snapshots for sources which support this.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean snapshotSources;

  /**
   * TTL for the snapshot.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String ttl;

  /**
   * User specified description of the snapshot. Maybe empty.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * User specified description of the snapshot. Maybe empty.
   * @param description description or {@code null} for none
   */
  public SnapshotJobRequest setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * The location that contains this job.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocation() {
    return location;
  }

  /**
   * The location that contains this job.
   * @param location location or {@code null} for none
   */
  public SnapshotJobRequest setLocation(java.lang.String location) {
    this.location = location;
    return this;
  }

  /**
   * If true, perform snapshots for sources which support this.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSnapshotSources() {
    return snapshotSources;
  }

  /**
   * If true, perform snapshots for sources which support this.
   * @param snapshotSources snapshotSources or {@code null} for none
   */
  public SnapshotJobRequest setSnapshotSources(java.lang.Boolean snapshotSources) {
    this.snapshotSources = snapshotSources;
    return this;
  }

  /**
   * TTL for the snapshot.
   * @return value or {@code null} for none
   */
  public String getTtl() {
    return ttl;
  }

  /**
   * TTL for the snapshot.
   * @param ttl ttl or {@code null} for none
   */
  public SnapshotJobRequest setTtl(String ttl) {
    this.ttl = ttl;
    return this;
  }

  @Override
  public SnapshotJobRequest set(String fieldName, Object value) {
    return (SnapshotJobRequest) super.set(fieldName, value);
  }

  @Override
  public SnapshotJobRequest clone() {
    return (SnapshotJobRequest) super.clone();
  }

}
