/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Request to report the status of WorkItems.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReportWorkItemStatusRequest extends com.google.api.client.json.GenericJson {

  /**
   * The current timestamp at the worker.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String currentWorkerTime;

  /**
   * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints)
   * that contains the WorkItem's job.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String location;

  /**
   * Untranslated bag-of-bytes WorkProgressUpdateRequest from UnifiedWorker.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.Object> unifiedWorkerRequest;

  /**
   * The order is unimportant, except that the order of the WorkItemServiceState messages in the
   * ReportWorkItemStatusResponse corresponds to the order of WorkItemStatus messages here.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<WorkItemStatus> workItemStatuses;

  /**
   * The ID of the worker reporting the WorkItem status. If this does not match the ID of the worker
   * which the Dataflow service believes currently has the lease on the WorkItem, the report will be
   * dropped (with an error response).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String workerId;

  /**
   * The current timestamp at the worker.
   * @return value or {@code null} for none
   */
  public String getCurrentWorkerTime() {
    return currentWorkerTime;
  }

  /**
   * The current timestamp at the worker.
   * @param currentWorkerTime currentWorkerTime or {@code null} for none
   */
  public ReportWorkItemStatusRequest setCurrentWorkerTime(String currentWorkerTime) {
    this.currentWorkerTime = currentWorkerTime;
    return this;
  }

  /**
   * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints)
   * that contains the WorkItem's job.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocation() {
    return location;
  }

  /**
   * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints)
   * that contains the WorkItem's job.
   * @param location location or {@code null} for none
   */
  public ReportWorkItemStatusRequest setLocation(java.lang.String location) {
    this.location = location;
    return this;
  }

  /**
   * Untranslated bag-of-bytes WorkProgressUpdateRequest from UnifiedWorker.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.Object> getUnifiedWorkerRequest() {
    return unifiedWorkerRequest;
  }

  /**
   * Untranslated bag-of-bytes WorkProgressUpdateRequest from UnifiedWorker.
   * @param unifiedWorkerRequest unifiedWorkerRequest or {@code null} for none
   */
  public ReportWorkItemStatusRequest setUnifiedWorkerRequest(java.util.Map<String, java.lang.Object> unifiedWorkerRequest) {
    this.unifiedWorkerRequest = unifiedWorkerRequest;
    return this;
  }

  /**
   * The order is unimportant, except that the order of the WorkItemServiceState messages in the
   * ReportWorkItemStatusResponse corresponds to the order of WorkItemStatus messages here.
   * @return value or {@code null} for none
   */
  public java.util.List<WorkItemStatus> getWorkItemStatuses() {
    return workItemStatuses;
  }

  /**
   * The order is unimportant, except that the order of the WorkItemServiceState messages in the
   * ReportWorkItemStatusResponse corresponds to the order of WorkItemStatus messages here.
   * @param workItemStatuses workItemStatuses or {@code null} for none
   */
  public ReportWorkItemStatusRequest setWorkItemStatuses(java.util.List<WorkItemStatus> workItemStatuses) {
    this.workItemStatuses = workItemStatuses;
    return this;
  }

  /**
   * The ID of the worker reporting the WorkItem status. If this does not match the ID of the worker
   * which the Dataflow service believes currently has the lease on the WorkItem, the report will be
   * dropped (with an error response).
   * @return value or {@code null} for none
   */
  public java.lang.String getWorkerId() {
    return workerId;
  }

  /**
   * The ID of the worker reporting the WorkItem status. If this does not match the ID of the worker
   * which the Dataflow service believes currently has the lease on the WorkItem, the report will be
   * dropped (with an error response).
   * @param workerId workerId or {@code null} for none
   */
  public ReportWorkItemStatusRequest setWorkerId(java.lang.String workerId) {
    this.workerId = workerId;
    return this;
  }

  @Override
  public ReportWorkItemStatusRequest set(String fieldName, Object value) {
    return (ReportWorkItemStatusRequest) super.set(fieldName, value);
  }

  @Override
  public ReportWorkItemStatusRequest clone() {
    return (ReportWorkItemStatusRequest) super.clone();
  }

}
