/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * A point in the timeseries.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Point extends com.google.api.client.json.GenericJson {

  /**
   * The timestamp of the point.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String time;

  /**
   * The value of the point.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double value;

  /**
   * The timestamp of the point.
   * @return value or {@code null} for none
   */
  public String getTime() {
    return time;
  }

  /**
   * The timestamp of the point.
   * @param time time or {@code null} for none
   */
  public Point setTime(String time) {
    this.time = time;
    return this;
  }

  /**
   * The value of the point.
   * @return value or {@code null} for none
   */
  public java.lang.Double getValue() {
    return value;
  }

  /**
   * The value of the point.
   * @param value value or {@code null} for none
   */
  public Point setValue(java.lang.Double value) {
    this.value = value;
    return this;
  }

  @Override
  public Point set(String fieldName, Object value) {
    return (Point) super.set(fieldName, value);
  }

  @Override
  public Point clone() {
    return (Point) super.clone();
  }

}
