/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * An output of an instruction.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstructionOutput extends com.google.api.client.json.GenericJson {

  /**
   * The codec to use to encode data being written via this output.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.Object> codec;

  /**
   * The user-provided name of this output.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * For system-generated byte and mean byte metrics, certain instructions should only report the
   * key size.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean onlyCountKeyBytes;

  /**
   * For system-generated byte and mean byte metrics, certain instructions should only report the
   * value size.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean onlyCountValueBytes;

  /**
   * System-defined name for this output in the original workflow graph. Outputs that do not
   * contribute to an original instruction do not set this.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String originalName;

  /**
   * System-defined name of this output. Unique across the workflow.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String systemName;

  /**
   * The codec to use to encode data being written via this output.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.Object> getCodec() {
    return codec;
  }

  /**
   * The codec to use to encode data being written via this output.
   * @param codec codec or {@code null} for none
   */
  public InstructionOutput setCodec(java.util.Map<String, java.lang.Object> codec) {
    this.codec = codec;
    return this;
  }

  /**
   * The user-provided name of this output.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The user-provided name of this output.
   * @param name name or {@code null} for none
   */
  public InstructionOutput setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * For system-generated byte and mean byte metrics, certain instructions should only report the
   * key size.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getOnlyCountKeyBytes() {
    return onlyCountKeyBytes;
  }

  /**
   * For system-generated byte and mean byte metrics, certain instructions should only report the
   * key size.
   * @param onlyCountKeyBytes onlyCountKeyBytes or {@code null} for none
   */
  public InstructionOutput setOnlyCountKeyBytes(java.lang.Boolean onlyCountKeyBytes) {
    this.onlyCountKeyBytes = onlyCountKeyBytes;
    return this;
  }

  /**
   * For system-generated byte and mean byte metrics, certain instructions should only report the
   * value size.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getOnlyCountValueBytes() {
    return onlyCountValueBytes;
  }

  /**
   * For system-generated byte and mean byte metrics, certain instructions should only report the
   * value size.
   * @param onlyCountValueBytes onlyCountValueBytes or {@code null} for none
   */
  public InstructionOutput setOnlyCountValueBytes(java.lang.Boolean onlyCountValueBytes) {
    this.onlyCountValueBytes = onlyCountValueBytes;
    return this;
  }

  /**
   * System-defined name for this output in the original workflow graph. Outputs that do not
   * contribute to an original instruction do not set this.
   * @return value or {@code null} for none
   */
  public java.lang.String getOriginalName() {
    return originalName;
  }

  /**
   * System-defined name for this output in the original workflow graph. Outputs that do not
   * contribute to an original instruction do not set this.
   * @param originalName originalName or {@code null} for none
   */
  public InstructionOutput setOriginalName(java.lang.String originalName) {
    this.originalName = originalName;
    return this;
  }

  /**
   * System-defined name of this output. Unique across the workflow.
   * @return value or {@code null} for none
   */
  public java.lang.String getSystemName() {
    return systemName;
  }

  /**
   * System-defined name of this output. Unique across the workflow.
   * @param systemName systemName or {@code null} for none
   */
  public InstructionOutput setSystemName(java.lang.String systemName) {
    this.systemName = systemName;
    return this;
  }

  @Override
  public InstructionOutput set(String fieldName, Object value) {
    return (InstructionOutput) super.set(fieldName, value);
  }

  @Override
  public InstructionOutput clone() {
    return (InstructionOutput) super.clone();
  }

}
