/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-04-18 at 11:23:07 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.customsearch.v1;

/**
 * Service definition for Customsearch (v1).
 *
 * <p>
 * Searches over a website or collection of websites
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/custom-search/v1/introduction" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link CustomsearchRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Customsearch extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.25.0 of the Custom Search API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://customsearch.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Customsearch(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Customsearch(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Cse collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Customsearch customsearch = new Customsearch(...);}
   *   {@code Customsearch.Cse.List request = customsearch.cse().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Cse cse() {
    return new Cse();
  }

  /**
   * The "cse" collection of methods.
   */
  public class Cse {

    /**
     * Returns metadata about the search performed, metadata about the custom search engine used for the
     * search, and the search results.
     *
     * Create a request for the method "cse.list".
     *
     * This request holds the parameters needed by the customsearch server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends CustomsearchRequest<com.google.api.services.customsearch.v1.model.Search> {

      private static final String REST_PATH = "customsearch/v1";

      /**
       * Returns metadata about the search performed, metadata about the custom search engine used for
       * the search, and the search results.
       *
       * Create a request for the method "cse.list".
       *
       * This request holds the parameters needed by the the customsearch server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Customsearch.this, "GET", REST_PATH, null, com.google.api.services.customsearch.v1.model.Search.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Provides additional search terms to check for in a document, where each document in the
       * search results must contain at least one of the additional search terms.
       */
      @com.google.api.client.util.Key
      private java.lang.String orTerms;

      /** Provides additional search terms to check for in a document, where each document in the search
     results must contain at least one of the additional search terms.
       */
      public java.lang.String getOrTerms() {
        return orTerms;
      }

      /**
       * Provides additional search terms to check for in a document, where each document in the
       * search results must contain at least one of the additional search terms.
       */
      public List setOrTerms(java.lang.String orTerms) {
        this.orTerms = orTerms;
        return this;
      }

      /**
       * Specifies a given site which should always be included or excluded from results (see
       * `siteSearchFilter` parameter, below).
       */
      @com.google.api.client.util.Key
      private java.lang.String siteSearch;

      /** Specifies a given site which should always be included or excluded from results (see
     `siteSearchFilter` parameter, below).
       */
      public java.lang.String getSiteSearch() {
        return siteSearch;
      }

      /**
       * Specifies a given site which should always be included or excluded from results (see
       * `siteSearchFilter` parameter, below).
       */
      public List setSiteSearch(java.lang.String siteSearch) {
        this.siteSearch = siteSearch;
        return this;
      }

      /**
       * Specifies that all search results should contain a link to a particular URL.
       */
      @com.google.api.client.util.Key
      private java.lang.String linkSite;

      /** Specifies that all search results should contain a link to a particular URL.
       */
      public java.lang.String getLinkSite() {
        return linkSite;
      }

      /**
       * Specifies that all search results should contain a link to a particular URL.
       */
      public List setLinkSite(java.lang.String linkSite) {
        this.linkSite = linkSite;
        return this;
      }

      /** Query */
      @com.google.api.client.util.Key
      private java.lang.String q;

      /** Query
       */
      public java.lang.String getQ() {
        return q;
      }

      /** Query */
      public List setQ(java.lang.String q) {
        this.q = q;
        return this;
      }

      /**
       * Sets the user interface language.
       *
       * * Explicitly setting this parameter improves the performance and the quality of your search
       * results.
       *
       * * See the [Interface Languages](https://developers.google.com/custom-
       * search/docs/xml_results#wsInterfaceLanguages) section of [Internationalizing Queries and
       * Results Presentation](https://developers.google.com/custom-
       * search/docs/xml_results#wsInternationalizing) for more information, and (Supported
       * Interface Languages)[https://developers.google.com/custom-
       * search/docs/xml_results_appendices#interfaceLanguages] for a list of supported languages.
       */
      @com.google.api.client.util.Key
      private java.lang.String hl;

      /** Sets the user interface language.

     * Explicitly setting this parameter improves the performance and the quality of your search
     results.

     * See the [Interface Languages](https://developers.google.com/custom-
     search/docs/xml_results#wsInterfaceLanguages) section of [Internationalizing Queries and Results
     Presentation](https://developers.google.com/custom-search/docs/xml_results#wsInternationalizing)
     for more information, and (Supported Interface Languages)[https://developers.google.com/custom-
     search/docs/xml_results_appendices#interfaceLanguages] for a list of supported languages.
       */
      public java.lang.String getHl() {
        return hl;
      }

      /**
       * Sets the user interface language.
       *
       * * Explicitly setting this parameter improves the performance and the quality of your search
       * results.
       *
       * * See the [Interface Languages](https://developers.google.com/custom-
       * search/docs/xml_results#wsInterfaceLanguages) section of [Internationalizing Queries and
       * Results Presentation](https://developers.google.com/custom-
       * search/docs/xml_results#wsInternationalizing) for more information, and (Supported
       * Interface Languages)[https://developers.google.com/custom-
       * search/docs/xml_results_appendices#interfaceLanguages] for a list of supported languages.
       */
      public List setHl(java.lang.String hl) {
        this.hl = hl;
        return this;
      }

      /**
       * Enables or disables [Simplified and Traditional Chinese
       * Search](https://developers.google.com/custom-search/docs/xml_results#chineseSearch).
       *
       * The default value for this parameter is 0 (zero), meaning that the feature is enabled.
       * Supported values are:
       *
       * * `1`: Disabled
       *
       * * `0`: Enabled (default)
       */
      @com.google.api.client.util.Key
      private java.lang.String c2coff;

      /** Enables or disables [Simplified and Traditional Chinese Search](https://developers.google.com
     /custom-search/docs/xml_results#chineseSearch).

     The default value for this parameter is 0 (zero), meaning that the feature is enabled. Supported
     values are:

     * `1`: Disabled

     * `0`: Enabled (default)
       */
      public java.lang.String getC2coff() {
        return c2coff;
      }

      /**
       * Enables or disables [Simplified and Traditional Chinese
       * Search](https://developers.google.com/custom-search/docs/xml_results#chineseSearch).
       *
       * The default value for this parameter is 0 (zero), meaning that the feature is enabled.
       * Supported values are:
       *
       * * `1`: Disabled
       *
       * * `0`: Enabled (default)
       */
      public List setC2coff(java.lang.String c2coff) {
        this.c2coff = c2coff;
        return this;
      }

      /**
       * Controls turning on or off the duplicate content filter.
       *
       * * See [Automatic Filtering](https://developers.google.com/custom-
       * search/docs/xml_results#automaticFiltering) for more information about Google's search
       * results filters. Note that host crowding filtering applies only to multi-site searches.
       *
       * * By default, Google applies filtering to all search results to improve the quality of
       * those results.
       *
       * Acceptable values are:
       *
       * * `0`: Turns off duplicate content filter.
       *
       * * `1`: Turns on duplicate content filter.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Controls turning on or off the duplicate content filter.

     * See [Automatic Filtering](https://developers.google.com/custom-
     search/docs/xml_results#automaticFiltering) for more information about Google's search results
     filters. Note that host crowding filtering applies only to multi-site searches.

     * By default, Google applies filtering to all search results to improve the quality of those
     results.

     Acceptable values are:

     * `0`: Turns off duplicate content filter.

     * `1`: Turns on duplicate content filter.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * Controls turning on or off the duplicate content filter.
       *
       * * See [Automatic Filtering](https://developers.google.com/custom-
       * search/docs/xml_results#automaticFiltering) for more information about Google's search
       * results filters. Note that host crowding filtering applies only to multi-site searches.
       *
       * * By default, Google applies filtering to all search results to improve the quality of
       * those results.
       *
       * Acceptable values are:
       *
       * * `0`: Turns off duplicate content filter.
       *
       * * `1`: Turns on duplicate content filter.
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Geolocation of end user.
       *
       * * The `gl` parameter value is a two-letter country code. The `gl` parameter boosts search
       * results whose country of origin matches the parameter value. See the [Country
       * Codes](https://developers.google.com/custom-
       * search/docs/xml_results_appendices#countryCodes) page for a list of valid values.
       *
       * * Specifying a `gl` parameter value should lead to more relevant results. This is
       * particularly true for international customers and, even more specifically, for customers in
       * English- speaking countries other than the United States.
       */
      @com.google.api.client.util.Key
      private java.lang.String gl;

      /** Geolocation of end user.

     * The `gl` parameter value is a two-letter country code. The `gl` parameter boosts search results
     whose country of origin matches the parameter value. See the [Country
     Codes](https://developers.google.com/custom-search/docs/xml_results_appendices#countryCodes) page
     for a list of valid values.

     * Specifying a `gl` parameter value should lead to more relevant results. This is particularly true
     for international customers and, even more specifically, for customers in English- speaking
     countries other than the United States.
       */
      public java.lang.String getGl() {
        return gl;
      }

      /**
       * Geolocation of end user.
       *
       * * The `gl` parameter value is a two-letter country code. The `gl` parameter boosts search
       * results whose country of origin matches the parameter value. See the [Country
       * Codes](https://developers.google.com/custom-
       * search/docs/xml_results_appendices#countryCodes) page for a list of valid values.
       *
       * * Specifying a `gl` parameter value should lead to more relevant results. This is
       * particularly true for international customers and, even more specifically, for customers in
       * English- speaking countries other than the United States.
       */
      public List setGl(java.lang.String gl) {
        this.gl = gl;
        return this;
      }

      /**
       * Restricts results to URLs based on date. Supported values include:
       *
       * * `d[number]`: requests results from the specified number of past days.
       *
       * * `w[number]`: requests results from the specified number of past weeks.
       *
       * * `m[number]`: requests results from the specified number of past months.
       *
       * * `y[number]`: requests results from the specified number of past years.
       */
      @com.google.api.client.util.Key
      private java.lang.String dateRestrict;

      /** Restricts results to URLs based on date. Supported values include:

     * `d[number]`: requests results from the specified number of past days.

     * `w[number]`: requests results from the specified number of past weeks.

     * `m[number]`: requests results from the specified number of past months.

     * `y[number]`: requests results from the specified number of past years.
       */
      public java.lang.String getDateRestrict() {
        return dateRestrict;
      }

      /**
       * Restricts results to URLs based on date. Supported values include:
       *
       * * `d[number]`: requests results from the specified number of past days.
       *
       * * `w[number]`: requests results from the specified number of past weeks.
       *
       * * `m[number]`: requests results from the specified number of past months.
       *
       * * `y[number]`: requests results from the specified number of past years.
       */
      public List setDateRestrict(java.lang.String dateRestrict) {
        this.dateRestrict = dateRestrict;
        return this;
      }

      /**
       * Returns images of a specific dominant color. Acceptable values are:
       *
       * * `"black"`
       *
       * * `"blue"`
       *
       * * `"brown"`
       *
       * * `"gray"`
       *
       * * `"green"`
       *
       * * `"orange"`
       *
       * * `"pink"`
       *
       * * `"purple"`
       *
       * * `"red"`
       *
       * * `"teal"`
       *
       * * `"white"`
       *
       * * `"yellow"`
       */
      @com.google.api.client.util.Key
      private java.lang.String imgDominantColor;

      /** Returns images of a specific dominant color. Acceptable values are:

     * `"black"`

     * `"blue"`

     * `"brown"`

     * `"gray"`

     * `"green"`

     * `"orange"`

     * `"pink"`

     * `"purple"`

     * `"red"`

     * `"teal"`

     * `"white"`

     * `"yellow"`
       */
      public java.lang.String getImgDominantColor() {
        return imgDominantColor;
      }

      /**
       * Returns images of a specific dominant color. Acceptable values are:
       *
       * * `"black"`
       *
       * * `"blue"`
       *
       * * `"brown"`
       *
       * * `"gray"`
       *
       * * `"green"`
       *
       * * `"orange"`
       *
       * * `"pink"`
       *
       * * `"purple"`
       *
       * * `"red"`
       *
       * * `"teal"`
       *
       * * `"white"`
       *
       * * `"yellow"`
       */
      public List setImgDominantColor(java.lang.String imgDominantColor) {
        this.imgDominantColor = imgDominantColor;
        return this;
      }

      /**
       * Filters based on licensing. Supported values include: `cc_publicdomain`, `cc_attribute`,
       * `cc_sharealike`, `cc_noncommercial`, `cc_nonderived` and combinations of these. See
       * [typical combinations](https://wiki.creativecommons.org/wiki/CC_Search_integration).
       */
      @com.google.api.client.util.Key
      private java.lang.String rights;

      /** Filters based on licensing. Supported values include: `cc_publicdomain`, `cc_attribute`,
     `cc_sharealike`, `cc_noncommercial`, `cc_nonderived` and combinations of these. See [typical
     combinations](https://wiki.creativecommons.org/wiki/CC_Search_integration).
       */
      public java.lang.String getRights() {
        return rights;
      }

      /**
       * Filters based on licensing. Supported values include: `cc_publicdomain`, `cc_attribute`,
       * `cc_sharealike`, `cc_noncommercial`, `cc_nonderived` and combinations of these. See
       * [typical combinations](https://wiki.creativecommons.org/wiki/CC_Search_integration).
       */
      public List setRights(java.lang.String rights) {
        this.rights = rights;
        return this;
      }

      /**
       * Returns images of a specified size. Acceptable values are:
       *
       * * `"huge"`
       *
       * * `"icon"`
       *
       * * `"large"`
       *
       * * `"medium"`
       *
       * * `"small"`
       *
       * * `"xlarge"`
       *
       * * `"xxlarge"`
       */
      @com.google.api.client.util.Key
      private java.lang.String imgSize;

      /** Returns images of a specified size. Acceptable values are:

     * `"huge"`

     * `"icon"`

     * `"large"`

     * `"medium"`

     * `"small"`

     * `"xlarge"`

     * `"xxlarge"`
       */
      public java.lang.String getImgSize() {
        return imgSize;
      }

      /**
       * Returns images of a specified size. Acceptable values are:
       *
       * * `"huge"`
       *
       * * `"icon"`
       *
       * * `"large"`
       *
       * * `"medium"`
       *
       * * `"small"`
       *
       * * `"xlarge"`
       *
       * * `"xxlarge"`
       */
      public List setImgSize(java.lang.String imgSize) {
        this.imgSize = imgSize;
        return this;
      }

      /**
       * Returns images of a type. Acceptable values are:
       *
       * * `"clipart"`
       *
       * * `"face"`
       *
       * * `"lineart"`
       *
       * * `"stock"`
       *
       * * `"photo"`
       *
       * * `"animated"`
       */
      @com.google.api.client.util.Key
      private java.lang.String imgType;

      /** Returns images of a type. Acceptable values are:

     * `"clipart"`

     * `"face"`

     * `"lineart"`

     * `"stock"`

     * `"photo"`

     * `"animated"`
       */
      public java.lang.String getImgType() {
        return imgType;
      }

      /**
       * Returns images of a type. Acceptable values are:
       *
       * * `"clipart"`
       *
       * * `"face"`
       *
       * * `"lineart"`
       *
       * * `"stock"`
       *
       * * `"photo"`
       *
       * * `"animated"`
       */
      public List setImgType(java.lang.String imgType) {
        this.imgType = imgType;
        return this;
      }

      /**
       * **Deprecated**. Use the `gl` parameter for a similar effect.
       *
       * The local Google domain (for example, google.com, google.de, or google.fr) to use to
       * perform the search.
       */
      @com.google.api.client.util.Key
      private java.lang.String googlehost;

      /**** Deprecated**. Use the `gl` parameter for a similar effect.
    **
    ** The local Google domain (for example, google.com, google.de, or google.fr) to use to perform the
    ** search.
    **

       */
      public java.lang.String getGooglehost() {
        return googlehost;
      }

      /**
       * **Deprecated**. Use the `gl` parameter for a similar effect.
       *
       * The local Google domain (for example, google.com, google.de, or google.fr) to use to
       * perform the search.
       */
      public List setGooglehost(java.lang.String googlehost) {
        this.googlehost = googlehost;
        return this;
      }

      /**
       * Number of search results to return.
       *
       * * Valid values are integers between 1 and 10, inclusive.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer num;

      /** Number of search results to return.

     * Valid values are integers between 1 and 10, inclusive.
       */
      public java.lang.Integer getNum() {
        return num;
      }

      /**
       * Number of search results to return.
       *
       * * Valid values are integers between 1 and 10, inclusive.
       */
      public List setNum(java.lang.Integer num) {
        this.num = num;
        return this;
      }

      /**
       * Specifies the ending value for a search range.
       *
       * * Use `lowRange` and `highRange` to append an inclusive search range of
       * `lowRange...highRange` to the query.
       */
      @com.google.api.client.util.Key
      private java.lang.String highRange;

      /** Specifies the ending value for a search range.

     * Use `lowRange` and `highRange` to append an inclusive search range of `lowRange...highRange` to
     the query.
       */
      public java.lang.String getHighRange() {
        return highRange;
      }

      /**
       * Specifies the ending value for a search range.
       *
       * * Use `lowRange` and `highRange` to append an inclusive search range of
       * `lowRange...highRange` to the query.
       */
      public List setHighRange(java.lang.String highRange) {
        this.highRange = highRange;
        return this;
      }

      /** Identifies a phrase that all documents in the search results must contain. */
      @com.google.api.client.util.Key
      private java.lang.String exactTerms;

      /** Identifies a phrase that all documents in the search results must contain.
       */
      public java.lang.String getExactTerms() {
        return exactTerms;
      }

      /** Identifies a phrase that all documents in the search results must contain. */
      public List setExactTerms(java.lang.String exactTerms) {
        this.exactTerms = exactTerms;
        return this;
      }

      /**
       * Specifies the search type: `image`. If unspecified, results are limited to webpages.
       *
       * Acceptable values are:
       *
       * * `"image"`: custom image search.
       */
      @com.google.api.client.util.Key
      private java.lang.String searchType;

      /** Specifies the search type: `image`. If unspecified, results are limited to webpages.

     Acceptable values are:

     * `"image"`: custom image search.
       */
      public java.lang.String getSearchType() {
        return searchType;
      }

      /**
       * Specifies the search type: `image`. If unspecified, results are limited to webpages.
       *
       * Acceptable values are:
       *
       * * `"image"`: custom image search.
       */
      public List setSearchType(java.lang.String searchType) {
        this.searchType = searchType;
        return this;
      }

      /**
       * Appends the specified query terms to the query, as if they were combined with a logical AND
       * operator.
       */
      @com.google.api.client.util.Key
      private java.lang.String hq;

      /** Appends the specified query terms to the query, as if they were combined with a logical AND
     operator.
       */
      public java.lang.String getHq() {
        return hq;
      }

      /**
       * Appends the specified query terms to the query, as if they were combined with a logical AND
       * operator.
       */
      public List setHq(java.lang.String hq) {
        this.hq = hq;
        return this;
      }

      /**
       * Specifies that all search results should be pages that are related to the specified URL.
       */
      @com.google.api.client.util.Key
      private java.lang.String relatedSite;

      /** Specifies that all search results should be pages that are related to the specified URL.
       */
      public java.lang.String getRelatedSite() {
        return relatedSite;
      }

      /**
       * Specifies that all search results should be pages that are related to the specified URL.
       */
      public List setRelatedSite(java.lang.String relatedSite) {
        this.relatedSite = relatedSite;
        return this;
      }

      /**
       * Restricts the search to documents written in a particular language (e.g., `lr=lang_ja`).
       *
       * Acceptable values are:
       *
       * * `"lang_ar"`: Arabic
       *
       * * `"lang_bg"`: Bulgarian
       *
       * * `"lang_ca"`: Catalan
       *
       * * `"lang_cs"`: Czech
       *
       * * `"lang_da"`: Danish
       *
       * * `"lang_de"`: German
       *
       * * `"lang_el"`: Greek
       *
       * * `"lang_en"`: English
       *
       * * `"lang_es"`: Spanish
       *
       * * `"lang_et"`: Estonian
       *
       * * `"lang_fi"`: Finnish
       *
       * * `"lang_fr"`: French
       *
       * * `"lang_hr"`: Croatian
       *
       * * `"lang_hu"`: Hungarian
       *
       * * `"lang_id"`: Indonesian
       *
       * * `"lang_is"`: Icelandic
       *
       * * `"lang_it"`: Italian
       *
       * * `"lang_iw"`: Hebrew
       *
       * * `"lang_ja"`: Japanese
       *
       * * `"lang_ko"`: Korean
       *
       * * `"lang_lt"`: Lithuanian
       *
       * * `"lang_lv"`: Latvian
       *
       * * `"lang_nl"`: Dutch
       *
       * * `"lang_no"`: Norwegian
       *
       * * `"lang_pl"`: Polish
       *
       * * `"lang_pt"`: Portuguese
       *
       * * `"lang_ro"`: Romanian
       *
       * * `"lang_ru"`: Russian
       *
       * * `"lang_sk"`: Slovak
       *
       * * `"lang_sl"`: Slovenian
       *
       * * `"lang_sr"`: Serbian
       *
       * * `"lang_sv"`: Swedish
       *
       * * `"lang_tr"`: Turkish
       *
       * * `"lang_zh-CN"`: Chinese (Simplified)
       *
       * * `"lang_zh-TW"`: Chinese (Traditional)
       */
      @com.google.api.client.util.Key
      private java.lang.String lr;

      /** Restricts the search to documents written in a particular language (e.g., `lr=lang_ja`).

     Acceptable values are:

     * `"lang_ar"`: Arabic

     * `"lang_bg"`: Bulgarian

     * `"lang_ca"`: Catalan

     * `"lang_cs"`: Czech

     * `"lang_da"`: Danish

     * `"lang_de"`: German

     * `"lang_el"`: Greek

     * `"lang_en"`: English

     * `"lang_es"`: Spanish

     * `"lang_et"`: Estonian

     * `"lang_fi"`: Finnish

     * `"lang_fr"`: French

     * `"lang_hr"`: Croatian

     * `"lang_hu"`: Hungarian

     * `"lang_id"`: Indonesian

     * `"lang_is"`: Icelandic

     * `"lang_it"`: Italian

     * `"lang_iw"`: Hebrew

     * `"lang_ja"`: Japanese

     * `"lang_ko"`: Korean

     * `"lang_lt"`: Lithuanian

     * `"lang_lv"`: Latvian

     * `"lang_nl"`: Dutch

     * `"lang_no"`: Norwegian

     * `"lang_pl"`: Polish

     * `"lang_pt"`: Portuguese

     * `"lang_ro"`: Romanian

     * `"lang_ru"`: Russian

     * `"lang_sk"`: Slovak

     * `"lang_sl"`: Slovenian

     * `"lang_sr"`: Serbian

     * `"lang_sv"`: Swedish

     * `"lang_tr"`: Turkish

     * `"lang_zh-CN"`: Chinese (Simplified)

     * `"lang_zh-TW"`: Chinese (Traditional)
       */
      public java.lang.String getLr() {
        return lr;
      }

      /**
       * Restricts the search to documents written in a particular language (e.g., `lr=lang_ja`).
       *
       * Acceptable values are:
       *
       * * `"lang_ar"`: Arabic
       *
       * * `"lang_bg"`: Bulgarian
       *
       * * `"lang_ca"`: Catalan
       *
       * * `"lang_cs"`: Czech
       *
       * * `"lang_da"`: Danish
       *
       * * `"lang_de"`: German
       *
       * * `"lang_el"`: Greek
       *
       * * `"lang_en"`: English
       *
       * * `"lang_es"`: Spanish
       *
       * * `"lang_et"`: Estonian
       *
       * * `"lang_fi"`: Finnish
       *
       * * `"lang_fr"`: French
       *
       * * `"lang_hr"`: Croatian
       *
       * * `"lang_hu"`: Hungarian
       *
       * * `"lang_id"`: Indonesian
       *
       * * `"lang_is"`: Icelandic
       *
       * * `"lang_it"`: Italian
       *
       * * `"lang_iw"`: Hebrew
       *
       * * `"lang_ja"`: Japanese
       *
       * * `"lang_ko"`: Korean
       *
       * * `"lang_lt"`: Lithuanian
       *
       * * `"lang_lv"`: Latvian
       *
       * * `"lang_nl"`: Dutch
       *
       * * `"lang_no"`: Norwegian
       *
       * * `"lang_pl"`: Polish
       *
       * * `"lang_pt"`: Portuguese
       *
       * * `"lang_ro"`: Romanian
       *
       * * `"lang_ru"`: Russian
       *
       * * `"lang_sk"`: Slovak
       *
       * * `"lang_sl"`: Slovenian
       *
       * * `"lang_sr"`: Serbian
       *
       * * `"lang_sv"`: Swedish
       *
       * * `"lang_tr"`: Turkish
       *
       * * `"lang_zh-CN"`: Chinese (Simplified)
       *
       * * `"lang_zh-TW"`: Chinese (Traditional)
       */
      public List setLr(java.lang.String lr) {
        this.lr = lr;
        return this;
      }

      /** The sort expression to apply to the results. */
      @com.google.api.client.util.Key
      private java.lang.String sort;

      /** The sort expression to apply to the results.
       */
      public java.lang.String getSort() {
        return sort;
      }

      /** The sort expression to apply to the results. */
      public List setSort(java.lang.String sort) {
        this.sort = sort;
        return this;
      }

      /**
       * Controls whether to include or exclude results from the site named in the `siteSearch`
       * parameter.
       *
       * Acceptable values are:
       *
       * * `"e"`: exclude
       *
       * * `"i"`: include
       */
      @com.google.api.client.util.Key
      private java.lang.String siteSearchFilter;

      /** Controls whether to include or exclude results from the site named in the `siteSearch` parameter.

     Acceptable values are:

     * `"e"`: exclude

     * `"i"`: include
       */
      public java.lang.String getSiteSearchFilter() {
        return siteSearchFilter;
      }

      /**
       * Controls whether to include or exclude results from the site named in the `siteSearch`
       * parameter.
       *
       * Acceptable values are:
       *
       * * `"e"`: exclude
       *
       * * `"i"`: include
       */
      public List setSiteSearchFilter(java.lang.String siteSearchFilter) {
        this.siteSearchFilter = siteSearchFilter;
        return this;
      }

      /**
       * Specifies the starting value for a search range. Use `lowRange` and `highRange` to append
       * an inclusive search range of `lowRange...highRange` to the query.
       */
      @com.google.api.client.util.Key
      private java.lang.String lowRange;

      /** Specifies the starting value for a search range. Use `lowRange` and `highRange` to append an
     inclusive search range of `lowRange...highRange` to the query.
       */
      public java.lang.String getLowRange() {
        return lowRange;
      }

      /**
       * Specifies the starting value for a search range. Use `lowRange` and `highRange` to append
       * an inclusive search range of `lowRange...highRange` to the query.
       */
      public List setLowRange(java.lang.String lowRange) {
        this.lowRange = lowRange;
        return this;
      }

      /** The custom search engine ID to use for this request. */
      @com.google.api.client.util.Key
      private java.lang.String cx;

      /** The custom search engine ID to use for this request.
       */
      public java.lang.String getCx() {
        return cx;
      }

      /** The custom search engine ID to use for this request. */
      public List setCx(java.lang.String cx) {
        this.cx = cx;
        return this;
      }

      /**
       * The index of the first result to return. The default number of results per page is 10, so
       * `=11` would start at the top of the second page of results. **Note**: The JSON API will
       * never return more than 100 results, even if more than 100 documents match the query, so
       * setting the sum of `start + num` to a number greater than 100 will produce an error. Also
       * note that the maximum value for `num` is 10.
       */
      @com.google.api.client.util.Key
      private java.lang.Long start;

      /** The index of the first result to return. The default number of results per page is 10, so `=11`
     would start at the top of the second page of results. **Note**: The JSON API will never return more
     than 100 results, even if more than 100 documents match the query, so setting the sum of `start +
     num` to a number greater than 100 will produce an error. Also note that the maximum value for `num`
     is 10.
       */
      public java.lang.Long getStart() {
        return start;
      }

      /**
       * The index of the first result to return. The default number of results per page is 10, so
       * `=11` would start at the top of the second page of results. **Note**: The JSON API will
       * never return more than 100 results, even if more than 100 documents match the query, so
       * setting the sum of `start + num` to a number greater than 100 will produce an error. Also
       * note that the maximum value for `num` is 10.
       */
      public List setStart(java.lang.Long start) {
        this.start = start;
        return this;
      }

      /**
       * Returns black and white, grayscale, transparent, or color images. Acceptable values are:
       *
       * * `"color"`
       *
       * * `"gray"`
       *
       * * `"mono"`: black and white
       *
       * * `"trans"`: transparent background
       */
      @com.google.api.client.util.Key
      private java.lang.String imgColorType;

      /** Returns black and white, grayscale, transparent, or color images. Acceptable values are:

     * `"color"`

     * `"gray"`

     * `"mono"`: black and white

     * `"trans"`: transparent background
       */
      public java.lang.String getImgColorType() {
        return imgColorType;
      }

      /**
       * Returns black and white, grayscale, transparent, or color images. Acceptable values are:
       *
       * * `"color"`
       *
       * * `"gray"`
       *
       * * `"mono"`: black and white
       *
       * * `"trans"`: transparent background
       */
      public List setImgColorType(java.lang.String imgColorType) {
        this.imgColorType = imgColorType;
        return this;
      }

      /**
       * Restricts results to files of a specified extension. A list of file types indexable by
       * Google can be found in Search Console [Help
       * Center](https://support.google.com/webmasters/answer/35287).
       */
      @com.google.api.client.util.Key
      private java.lang.String fileType;

      /** Restricts results to files of a specified extension. A list of file types indexable by Google can
     be found in Search Console [Help Center](https://support.google.com/webmasters/answer/35287).
       */
      public java.lang.String getFileType() {
        return fileType;
      }

      /**
       * Restricts results to files of a specified extension. A list of file types indexable by
       * Google can be found in Search Console [Help
       * Center](https://support.google.com/webmasters/answer/35287).
       */
      public List setFileType(java.lang.String fileType) {
        this.fileType = fileType;
        return this;
      }

      /**
       * Restricts search results to documents originating in a particular country. You may use
       * [Boolean operators](https://developers.google.com/custom-
       * search/docs/xml_results_appendices#booleanOperators) in the cr parameter's value.
       *
       * Google Search determines the country of a document by analyzing:
       *
       * * the top-level domain (TLD) of the document's URL
       *
       * * the geographic location of the Web server's IP address
       *
       * See the [Country Parameter Values](https://developers.google.com/custom-
       * search/docs/xml_results_appendices#countryCollections) page for a list of valid values for
       * this parameter.
       */
      @com.google.api.client.util.Key
      private java.lang.String cr;

      /** Restricts search results to documents originating in a particular country. You may use [Boolean
     operators](https://developers.google.com/custom-
     search/docs/xml_results_appendices#booleanOperators) in the cr parameter's value.

     Google Search determines the country of a document by analyzing:

     * the top-level domain (TLD) of the document's URL

     * the geographic location of the Web server's IP address

     See the [Country Parameter Values](https://developers.google.com/custom-
     search/docs/xml_results_appendices#countryCollections) page for a list of valid values for this
     parameter.
       */
      public java.lang.String getCr() {
        return cr;
      }

      /**
       * Restricts search results to documents originating in a particular country. You may use
       * [Boolean operators](https://developers.google.com/custom-
       * search/docs/xml_results_appendices#booleanOperators) in the cr parameter's value.
       *
       * Google Search determines the country of a document by analyzing:
       *
       * * the top-level domain (TLD) of the document's URL
       *
       * * the geographic location of the Web server's IP address
       *
       * See the [Country Parameter Values](https://developers.google.com/custom-
       * search/docs/xml_results_appendices#countryCollections) page for a list of valid values for
       * this parameter.
       */
      public List setCr(java.lang.String cr) {
        this.cr = cr;
        return this;
      }

      /**
       * Search safety level. Acceptable values are:
       *
       * * `"active"`: Enables SafeSearch filtering.
       *
       * * `"off"`: Disables SafeSearch filtering. (default)
       */
      @com.google.api.client.util.Key
      private java.lang.String safe;

      /** Search safety level. Acceptable values are:

     * `"active"`: Enables SafeSearch filtering.

     * `"off"`: Disables SafeSearch filtering. (default)
       */
      public java.lang.String getSafe() {
        return safe;
      }

      /**
       * Search safety level. Acceptable values are:
       *
       * * `"active"`: Enables SafeSearch filtering.
       *
       * * `"off"`: Disables SafeSearch filtering. (default)
       */
      public List setSafe(java.lang.String safe) {
        this.safe = safe;
        return this;
      }

      /**
       * Identifies a word or phrase that should not appear in any documents in the search results.
       */
      @com.google.api.client.util.Key
      private java.lang.String excludeTerms;

      /** Identifies a word or phrase that should not appear in any documents in the search results.
       */
      public java.lang.String getExcludeTerms() {
        return excludeTerms;
      }

      /**
       * Identifies a word or phrase that should not appear in any documents in the search results.
       */
      public List setExcludeTerms(java.lang.String excludeTerms) {
        this.excludeTerms = excludeTerms;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Siterestrict collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Customsearch customsearch = new Customsearch(...);}
   *   {@code Customsearch.Siterestrict.List request = customsearch.siterestrict().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Siterestrict siterestrict() {
    return new Siterestrict();
  }

  /**
   * The "siterestrict" collection of methods.
   */
  public class Siterestrict {

    /**
     * Returns metadata about the search performed, metadata about the custom search engine used for the
     * search, and the search results. Uses a small set of url patterns.
     *
     * Create a request for the method "siterestrict.list".
     *
     * This request holds the parameters needed by the customsearch server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends CustomsearchRequest<com.google.api.services.customsearch.v1.model.Search> {

      private static final String REST_PATH = "customsearch/v1/siterestrict";

      /**
       * Returns metadata about the search performed, metadata about the custom search engine used for
       * the search, and the search results. Uses a small set of url patterns.
       *
       * Create a request for the method "siterestrict.list".
       *
       * This request holds the parameters needed by the the customsearch server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Customsearch.this, "GET", REST_PATH, null, com.google.api.services.customsearch.v1.model.Search.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Specifies that all search results should contain a link to a particular URL.
       */
      @com.google.api.client.util.Key
      private java.lang.String linkSite;

      /** Specifies that all search results should contain a link to a particular URL.
       */
      public java.lang.String getLinkSite() {
        return linkSite;
      }

      /**
       * Specifies that all search results should contain a link to a particular URL.
       */
      public List setLinkSite(java.lang.String linkSite) {
        this.linkSite = linkSite;
        return this;
      }

      /**
       * Sets the user interface language.
       *
       * * Explicitly setting this parameter improves the performance and the quality of your search
       * results.
       *
       * * See the [Interface Languages](https://developers.google.com/custom-
       * search/docs/xml_results#wsInterfaceLanguages) section of [Internationalizing Queries and
       * Results Presentation](https://developers.google.com/custom-
       * search/docs/xml_results#wsInternationalizing) for more information, and (Supported
       * Interface Languages)[https://developers.google.com/custom-
       * search/docs/xml_results_appendices#interfaceLanguages] for a list of supported languages.
       */
      @com.google.api.client.util.Key
      private java.lang.String hl;

      /** Sets the user interface language.

     * Explicitly setting this parameter improves the performance and the quality of your search
     results.

     * See the [Interface Languages](https://developers.google.com/custom-
     search/docs/xml_results#wsInterfaceLanguages) section of [Internationalizing Queries and Results
     Presentation](https://developers.google.com/custom-search/docs/xml_results#wsInternationalizing)
     for more information, and (Supported Interface Languages)[https://developers.google.com/custom-
     search/docs/xml_results_appendices#interfaceLanguages] for a list of supported languages.
       */
      public java.lang.String getHl() {
        return hl;
      }

      /**
       * Sets the user interface language.
       *
       * * Explicitly setting this parameter improves the performance and the quality of your search
       * results.
       *
       * * See the [Interface Languages](https://developers.google.com/custom-
       * search/docs/xml_results#wsInterfaceLanguages) section of [Internationalizing Queries and
       * Results Presentation](https://developers.google.com/custom-
       * search/docs/xml_results#wsInternationalizing) for more information, and (Supported
       * Interface Languages)[https://developers.google.com/custom-
       * search/docs/xml_results_appendices#interfaceLanguages] for a list of supported languages.
       */
      public List setHl(java.lang.String hl) {
        this.hl = hl;
        return this;
      }

      /** Query */
      @com.google.api.client.util.Key
      private java.lang.String q;

      /** Query
       */
      public java.lang.String getQ() {
        return q;
      }

      /** Query */
      public List setQ(java.lang.String q) {
        this.q = q;
        return this;
      }

      /**
       * Enables or disables [Simplified and Traditional Chinese
       * Search](https://developers.google.com/custom-search/docs/xml_results#chineseSearch).
       *
       * The default value for this parameter is 0 (zero), meaning that the feature is enabled.
       * Supported values are:
       *
       * * `1`: Disabled
       *
       * * `0`: Enabled (default)
       */
      @com.google.api.client.util.Key
      private java.lang.String c2coff;

      /** Enables or disables [Simplified and Traditional Chinese Search](https://developers.google.com
     /custom-search/docs/xml_results#chineseSearch).

     The default value for this parameter is 0 (zero), meaning that the feature is enabled. Supported
     values are:

     * `1`: Disabled

     * `0`: Enabled (default)
       */
      public java.lang.String getC2coff() {
        return c2coff;
      }

      /**
       * Enables or disables [Simplified and Traditional Chinese
       * Search](https://developers.google.com/custom-search/docs/xml_results#chineseSearch).
       *
       * The default value for this parameter is 0 (zero), meaning that the feature is enabled.
       * Supported values are:
       *
       * * `1`: Disabled
       *
       * * `0`: Enabled (default)
       */
      public List setC2coff(java.lang.String c2coff) {
        this.c2coff = c2coff;
        return this;
      }

      /**
       * Controls turning on or off the duplicate content filter.
       *
       * * See [Automatic Filtering](https://developers.google.com/custom-
       * search/docs/xml_results#automaticFiltering) for more information about Google's search
       * results filters. Note that host crowding filtering applies only to multi-site searches.
       *
       * * By default, Google applies filtering to all search results to improve the quality of
       * those results.
       *
       * Acceptable values are:
       *
       * * `0`: Turns off duplicate content filter.
       *
       * * `1`: Turns on duplicate content filter.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Controls turning on or off the duplicate content filter.

     * See [Automatic Filtering](https://developers.google.com/custom-
     search/docs/xml_results#automaticFiltering) for more information about Google's search results
     filters. Note that host crowding filtering applies only to multi-site searches.

     * By default, Google applies filtering to all search results to improve the quality of those
     results.

     Acceptable values are:

     * `0`: Turns off duplicate content filter.

     * `1`: Turns on duplicate content filter.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * Controls turning on or off the duplicate content filter.
       *
       * * See [Automatic Filtering](https://developers.google.com/custom-
       * search/docs/xml_results#automaticFiltering) for more information about Google's search
       * results filters. Note that host crowding filtering applies only to multi-site searches.
       *
       * * By default, Google applies filtering to all search results to improve the quality of
       * those results.
       *
       * Acceptable values are:
       *
       * * `0`: Turns off duplicate content filter.
       *
       * * `1`: Turns on duplicate content filter.
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Geolocation of end user.
       *
       * * The `gl` parameter value is a two-letter country code. The `gl` parameter boosts search
       * results whose country of origin matches the parameter value. See the [Country
       * Codes](https://developers.google.com/custom-
       * search/docs/xml_results_appendices#countryCodes) page for a list of valid values.
       *
       * * Specifying a `gl` parameter value should lead to more relevant results. This is
       * particularly true for international customers and, even more specifically, for customers in
       * English- speaking countries other than the United States.
       */
      @com.google.api.client.util.Key
      private java.lang.String gl;

      /** Geolocation of end user.

     * The `gl` parameter value is a two-letter country code. The `gl` parameter boosts search results
     whose country of origin matches the parameter value. See the [Country
     Codes](https://developers.google.com/custom-search/docs/xml_results_appendices#countryCodes) page
     for a list of valid values.

     * Specifying a `gl` parameter value should lead to more relevant results. This is particularly true
     for international customers and, even more specifically, for customers in English- speaking
     countries other than the United States.
       */
      public java.lang.String getGl() {
        return gl;
      }

      /**
       * Geolocation of end user.
       *
       * * The `gl` parameter value is a two-letter country code. The `gl` parameter boosts search
       * results whose country of origin matches the parameter value. See the [Country
       * Codes](https://developers.google.com/custom-
       * search/docs/xml_results_appendices#countryCodes) page for a list of valid values.
       *
       * * Specifying a `gl` parameter value should lead to more relevant results. This is
       * particularly true for international customers and, even more specifically, for customers in
       * English- speaking countries other than the United States.
       */
      public List setGl(java.lang.String gl) {
        this.gl = gl;
        return this;
      }

      /**
       * Restricts results to URLs based on date. Supported values include:
       *
       * * `d[number]`: requests results from the specified number of past days.
       *
       * * `w[number]`: requests results from the specified number of past weeks.
       *
       * * `m[number]`: requests results from the specified number of past months.
       *
       * * `y[number]`: requests results from the specified number of past years.
       */
      @com.google.api.client.util.Key
      private java.lang.String dateRestrict;

      /** Restricts results to URLs based on date. Supported values include:

     * `d[number]`: requests results from the specified number of past days.

     * `w[number]`: requests results from the specified number of past weeks.

     * `m[number]`: requests results from the specified number of past months.

     * `y[number]`: requests results from the specified number of past years.
       */
      public java.lang.String getDateRestrict() {
        return dateRestrict;
      }

      /**
       * Restricts results to URLs based on date. Supported values include:
       *
       * * `d[number]`: requests results from the specified number of past days.
       *
       * * `w[number]`: requests results from the specified number of past weeks.
       *
       * * `m[number]`: requests results from the specified number of past months.
       *
       * * `y[number]`: requests results from the specified number of past years.
       */
      public List setDateRestrict(java.lang.String dateRestrict) {
        this.dateRestrict = dateRestrict;
        return this;
      }

      /**
       * Returns images of a specific dominant color. Acceptable values are:
       *
       * * `"black"`
       *
       * * `"blue"`
       *
       * * `"brown"`
       *
       * * `"gray"`
       *
       * * `"green"`
       *
       * * `"orange"`
       *
       * * `"pink"`
       *
       * * `"purple"`
       *
       * * `"red"`
       *
       * * `"teal"`
       *
       * * `"white"`
       *
       * * `"yellow"`
       */
      @com.google.api.client.util.Key
      private java.lang.String imgDominantColor;

      /** Returns images of a specific dominant color. Acceptable values are:

     * `"black"`

     * `"blue"`

     * `"brown"`

     * `"gray"`

     * `"green"`

     * `"orange"`

     * `"pink"`

     * `"purple"`

     * `"red"`

     * `"teal"`

     * `"white"`

     * `"yellow"`
       */
      public java.lang.String getImgDominantColor() {
        return imgDominantColor;
      }

      /**
       * Returns images of a specific dominant color. Acceptable values are:
       *
       * * `"black"`
       *
       * * `"blue"`
       *
       * * `"brown"`
       *
       * * `"gray"`
       *
       * * `"green"`
       *
       * * `"orange"`
       *
       * * `"pink"`
       *
       * * `"purple"`
       *
       * * `"red"`
       *
       * * `"teal"`
       *
       * * `"white"`
       *
       * * `"yellow"`
       */
      public List setImgDominantColor(java.lang.String imgDominantColor) {
        this.imgDominantColor = imgDominantColor;
        return this;
      }

      /**
       * Filters based on licensing. Supported values include: `cc_publicdomain`, `cc_attribute`,
       * `cc_sharealike`, `cc_noncommercial`, `cc_nonderived` and combinations of these. See
       * [typical combinations](https://wiki.creativecommons.org/wiki/CC_Search_integration).
       */
      @com.google.api.client.util.Key
      private java.lang.String rights;

      /** Filters based on licensing. Supported values include: `cc_publicdomain`, `cc_attribute`,
     `cc_sharealike`, `cc_noncommercial`, `cc_nonderived` and combinations of these. See [typical
     combinations](https://wiki.creativecommons.org/wiki/CC_Search_integration).
       */
      public java.lang.String getRights() {
        return rights;
      }

      /**
       * Filters based on licensing. Supported values include: `cc_publicdomain`, `cc_attribute`,
       * `cc_sharealike`, `cc_noncommercial`, `cc_nonderived` and combinations of these. See
       * [typical combinations](https://wiki.creativecommons.org/wiki/CC_Search_integration).
       */
      public List setRights(java.lang.String rights) {
        this.rights = rights;
        return this;
      }

      /**
       * Returns images of a type. Acceptable values are:
       *
       * * `"clipart"`
       *
       * * `"face"`
       *
       * * `"lineart"`
       *
       * * `"stock"`
       *
       * * `"photo"`
       *
       * * `"animated"`
       */
      @com.google.api.client.util.Key
      private java.lang.String imgType;

      /** Returns images of a type. Acceptable values are:

     * `"clipart"`

     * `"face"`

     * `"lineart"`

     * `"stock"`

     * `"photo"`

     * `"animated"`
       */
      public java.lang.String getImgType() {
        return imgType;
      }

      /**
       * Returns images of a type. Acceptable values are:
       *
       * * `"clipart"`
       *
       * * `"face"`
       *
       * * `"lineart"`
       *
       * * `"stock"`
       *
       * * `"photo"`
       *
       * * `"animated"`
       */
      public List setImgType(java.lang.String imgType) {
        this.imgType = imgType;
        return this;
      }

      /**
       * Returns images of a specified size. Acceptable values are:
       *
       * * `"huge"`
       *
       * * `"icon"`
       *
       * * `"large"`
       *
       * * `"medium"`
       *
       * * `"small"`
       *
       * * `"xlarge"`
       *
       * * `"xxlarge"`
       */
      @com.google.api.client.util.Key
      private java.lang.String imgSize;

      /** Returns images of a specified size. Acceptable values are:

     * `"huge"`

     * `"icon"`

     * `"large"`

     * `"medium"`

     * `"small"`

     * `"xlarge"`

     * `"xxlarge"`
       */
      public java.lang.String getImgSize() {
        return imgSize;
      }

      /**
       * Returns images of a specified size. Acceptable values are:
       *
       * * `"huge"`
       *
       * * `"icon"`
       *
       * * `"large"`
       *
       * * `"medium"`
       *
       * * `"small"`
       *
       * * `"xlarge"`
       *
       * * `"xxlarge"`
       */
      public List setImgSize(java.lang.String imgSize) {
        this.imgSize = imgSize;
        return this;
      }

      /**
       * **Deprecated**. Use the `gl` parameter for a similar effect.
       *
       * The local Google domain (for example, google.com, google.de, or google.fr) to use to
       * perform the search.
       */
      @com.google.api.client.util.Key
      private java.lang.String googlehost;

      /**** Deprecated**. Use the `gl` parameter for a similar effect.
    **
    ** The local Google domain (for example, google.com, google.de, or google.fr) to use to perform the
    ** search.
    **

       */
      public java.lang.String getGooglehost() {
        return googlehost;
      }

      /**
       * **Deprecated**. Use the `gl` parameter for a similar effect.
       *
       * The local Google domain (for example, google.com, google.de, or google.fr) to use to
       * perform the search.
       */
      public List setGooglehost(java.lang.String googlehost) {
        this.googlehost = googlehost;
        return this;
      }

      /**
       * Number of search results to return.
       *
       * * Valid values are integers between 1 and 10, inclusive.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer num;

      /** Number of search results to return.

     * Valid values are integers between 1 and 10, inclusive.
       */
      public java.lang.Integer getNum() {
        return num;
      }

      /**
       * Number of search results to return.
       *
       * * Valid values are integers between 1 and 10, inclusive.
       */
      public List setNum(java.lang.Integer num) {
        this.num = num;
        return this;
      }

      /**
       * Specifies the ending value for a search range.
       *
       * * Use `lowRange` and `highRange` to append an inclusive search range of
       * `lowRange...highRange` to the query.
       */
      @com.google.api.client.util.Key
      private java.lang.String highRange;

      /** Specifies the ending value for a search range.

     * Use `lowRange` and `highRange` to append an inclusive search range of `lowRange...highRange` to
     the query.
       */
      public java.lang.String getHighRange() {
        return highRange;
      }

      /**
       * Specifies the ending value for a search range.
       *
       * * Use `lowRange` and `highRange` to append an inclusive search range of
       * `lowRange...highRange` to the query.
       */
      public List setHighRange(java.lang.String highRange) {
        this.highRange = highRange;
        return this;
      }

      /** Identifies a phrase that all documents in the search results must contain. */
      @com.google.api.client.util.Key
      private java.lang.String exactTerms;

      /** Identifies a phrase that all documents in the search results must contain.
       */
      public java.lang.String getExactTerms() {
        return exactTerms;
      }

      /** Identifies a phrase that all documents in the search results must contain. */
      public List setExactTerms(java.lang.String exactTerms) {
        this.exactTerms = exactTerms;
        return this;
      }

      /**
       * Specifies the search type: `image`. If unspecified, results are limited to webpages.
       *
       * Acceptable values are:
       *
       * * `"image"`: custom image search.
       */
      @com.google.api.client.util.Key
      private java.lang.String searchType;

      /** Specifies the search type: `image`. If unspecified, results are limited to webpages.

     Acceptable values are:

     * `"image"`: custom image search.
       */
      public java.lang.String getSearchType() {
        return searchType;
      }

      /**
       * Specifies the search type: `image`. If unspecified, results are limited to webpages.
       *
       * Acceptable values are:
       *
       * * `"image"`: custom image search.
       */
      public List setSearchType(java.lang.String searchType) {
        this.searchType = searchType;
        return this;
      }

      /**
       * Appends the specified query terms to the query, as if they were combined with a logical AND
       * operator.
       */
      @com.google.api.client.util.Key
      private java.lang.String hq;

      /** Appends the specified query terms to the query, as if they were combined with a logical AND
     operator.
       */
      public java.lang.String getHq() {
        return hq;
      }

      /**
       * Appends the specified query terms to the query, as if they were combined with a logical AND
       * operator.
       */
      public List setHq(java.lang.String hq) {
        this.hq = hq;
        return this;
      }

      /**
       * Specifies that all search results should be pages that are related to the specified URL.
       */
      @com.google.api.client.util.Key
      private java.lang.String relatedSite;

      /** Specifies that all search results should be pages that are related to the specified URL.
       */
      public java.lang.String getRelatedSite() {
        return relatedSite;
      }

      /**
       * Specifies that all search results should be pages that are related to the specified URL.
       */
      public List setRelatedSite(java.lang.String relatedSite) {
        this.relatedSite = relatedSite;
        return this;
      }

      /**
       * Restricts the search to documents written in a particular language (e.g., `lr=lang_ja`).
       *
       * Acceptable values are:
       *
       * * `"lang_ar"`: Arabic
       *
       * * `"lang_bg"`: Bulgarian
       *
       * * `"lang_ca"`: Catalan
       *
       * * `"lang_cs"`: Czech
       *
       * * `"lang_da"`: Danish
       *
       * * `"lang_de"`: German
       *
       * * `"lang_el"`: Greek
       *
       * * `"lang_en"`: English
       *
       * * `"lang_es"`: Spanish
       *
       * * `"lang_et"`: Estonian
       *
       * * `"lang_fi"`: Finnish
       *
       * * `"lang_fr"`: French
       *
       * * `"lang_hr"`: Croatian
       *
       * * `"lang_hu"`: Hungarian
       *
       * * `"lang_id"`: Indonesian
       *
       * * `"lang_is"`: Icelandic
       *
       * * `"lang_it"`: Italian
       *
       * * `"lang_iw"`: Hebrew
       *
       * * `"lang_ja"`: Japanese
       *
       * * `"lang_ko"`: Korean
       *
       * * `"lang_lt"`: Lithuanian
       *
       * * `"lang_lv"`: Latvian
       *
       * * `"lang_nl"`: Dutch
       *
       * * `"lang_no"`: Norwegian
       *
       * * `"lang_pl"`: Polish
       *
       * * `"lang_pt"`: Portuguese
       *
       * * `"lang_ro"`: Romanian
       *
       * * `"lang_ru"`: Russian
       *
       * * `"lang_sk"`: Slovak
       *
       * * `"lang_sl"`: Slovenian
       *
       * * `"lang_sr"`: Serbian
       *
       * * `"lang_sv"`: Swedish
       *
       * * `"lang_tr"`: Turkish
       *
       * * `"lang_zh-CN"`: Chinese (Simplified)
       *
       * * `"lang_zh-TW"`: Chinese (Traditional)
       */
      @com.google.api.client.util.Key
      private java.lang.String lr;

      /** Restricts the search to documents written in a particular language (e.g., `lr=lang_ja`).

     Acceptable values are:

     * `"lang_ar"`: Arabic

     * `"lang_bg"`: Bulgarian

     * `"lang_ca"`: Catalan

     * `"lang_cs"`: Czech

     * `"lang_da"`: Danish

     * `"lang_de"`: German

     * `"lang_el"`: Greek

     * `"lang_en"`: English

     * `"lang_es"`: Spanish

     * `"lang_et"`: Estonian

     * `"lang_fi"`: Finnish

     * `"lang_fr"`: French

     * `"lang_hr"`: Croatian

     * `"lang_hu"`: Hungarian

     * `"lang_id"`: Indonesian

     * `"lang_is"`: Icelandic

     * `"lang_it"`: Italian

     * `"lang_iw"`: Hebrew

     * `"lang_ja"`: Japanese

     * `"lang_ko"`: Korean

     * `"lang_lt"`: Lithuanian

     * `"lang_lv"`: Latvian

     * `"lang_nl"`: Dutch

     * `"lang_no"`: Norwegian

     * `"lang_pl"`: Polish

     * `"lang_pt"`: Portuguese

     * `"lang_ro"`: Romanian

     * `"lang_ru"`: Russian

     * `"lang_sk"`: Slovak

     * `"lang_sl"`: Slovenian

     * `"lang_sr"`: Serbian

     * `"lang_sv"`: Swedish

     * `"lang_tr"`: Turkish

     * `"lang_zh-CN"`: Chinese (Simplified)

     * `"lang_zh-TW"`: Chinese (Traditional)
       */
      public java.lang.String getLr() {
        return lr;
      }

      /**
       * Restricts the search to documents written in a particular language (e.g., `lr=lang_ja`).
       *
       * Acceptable values are:
       *
       * * `"lang_ar"`: Arabic
       *
       * * `"lang_bg"`: Bulgarian
       *
       * * `"lang_ca"`: Catalan
       *
       * * `"lang_cs"`: Czech
       *
       * * `"lang_da"`: Danish
       *
       * * `"lang_de"`: German
       *
       * * `"lang_el"`: Greek
       *
       * * `"lang_en"`: English
       *
       * * `"lang_es"`: Spanish
       *
       * * `"lang_et"`: Estonian
       *
       * * `"lang_fi"`: Finnish
       *
       * * `"lang_fr"`: French
       *
       * * `"lang_hr"`: Croatian
       *
       * * `"lang_hu"`: Hungarian
       *
       * * `"lang_id"`: Indonesian
       *
       * * `"lang_is"`: Icelandic
       *
       * * `"lang_it"`: Italian
       *
       * * `"lang_iw"`: Hebrew
       *
       * * `"lang_ja"`: Japanese
       *
       * * `"lang_ko"`: Korean
       *
       * * `"lang_lt"`: Lithuanian
       *
       * * `"lang_lv"`: Latvian
       *
       * * `"lang_nl"`: Dutch
       *
       * * `"lang_no"`: Norwegian
       *
       * * `"lang_pl"`: Polish
       *
       * * `"lang_pt"`: Portuguese
       *
       * * `"lang_ro"`: Romanian
       *
       * * `"lang_ru"`: Russian
       *
       * * `"lang_sk"`: Slovak
       *
       * * `"lang_sl"`: Slovenian
       *
       * * `"lang_sr"`: Serbian
       *
       * * `"lang_sv"`: Swedish
       *
       * * `"lang_tr"`: Turkish
       *
       * * `"lang_zh-CN"`: Chinese (Simplified)
       *
       * * `"lang_zh-TW"`: Chinese (Traditional)
       */
      public List setLr(java.lang.String lr) {
        this.lr = lr;
        return this;
      }

      /** The sort expression to apply to the results. */
      @com.google.api.client.util.Key
      private java.lang.String sort;

      /** The sort expression to apply to the results.
       */
      public java.lang.String getSort() {
        return sort;
      }

      /** The sort expression to apply to the results. */
      public List setSort(java.lang.String sort) {
        this.sort = sort;
        return this;
      }

      /**
       * Controls whether to include or exclude results from the site named in the `siteSearch`
       * parameter.
       *
       * Acceptable values are:
       *
       * * `"e"`: exclude
       *
       * * `"i"`: include
       */
      @com.google.api.client.util.Key
      private java.lang.String siteSearchFilter;

      /** Controls whether to include or exclude results from the site named in the `siteSearch` parameter.

     Acceptable values are:

     * `"e"`: exclude

     * `"i"`: include
       */
      public java.lang.String getSiteSearchFilter() {
        return siteSearchFilter;
      }

      /**
       * Controls whether to include or exclude results from the site named in the `siteSearch`
       * parameter.
       *
       * Acceptable values are:
       *
       * * `"e"`: exclude
       *
       * * `"i"`: include
       */
      public List setSiteSearchFilter(java.lang.String siteSearchFilter) {
        this.siteSearchFilter = siteSearchFilter;
        return this;
      }

      /**
       * Specifies the starting value for a search range. Use `lowRange` and `highRange` to append
       * an inclusive search range of `lowRange...highRange` to the query.
       */
      @com.google.api.client.util.Key
      private java.lang.String lowRange;

      /** Specifies the starting value for a search range. Use `lowRange` and `highRange` to append an
     inclusive search range of `lowRange...highRange` to the query.
       */
      public java.lang.String getLowRange() {
        return lowRange;
      }

      /**
       * Specifies the starting value for a search range. Use `lowRange` and `highRange` to append
       * an inclusive search range of `lowRange...highRange` to the query.
       */
      public List setLowRange(java.lang.String lowRange) {
        this.lowRange = lowRange;
        return this;
      }

      /**
       * The index of the first result to return. The default number of results per page is 10, so
       * `=11` would start at the top of the second page of results. **Note**: The JSON API will
       * never return more than 100 results, even if more than 100 documents match the query, so
       * setting the sum of `start + num` to a number greater than 100 will produce an error. Also
       * note that the maximum value for `num` is 10.
       */
      @com.google.api.client.util.Key
      private java.lang.Long start;

      /** The index of the first result to return. The default number of results per page is 10, so `=11`
     would start at the top of the second page of results. **Note**: The JSON API will never return more
     than 100 results, even if more than 100 documents match the query, so setting the sum of `start +
     num` to a number greater than 100 will produce an error. Also note that the maximum value for `num`
     is 10.
       */
      public java.lang.Long getStart() {
        return start;
      }

      /**
       * The index of the first result to return. The default number of results per page is 10, so
       * `=11` would start at the top of the second page of results. **Note**: The JSON API will
       * never return more than 100 results, even if more than 100 documents match the query, so
       * setting the sum of `start + num` to a number greater than 100 will produce an error. Also
       * note that the maximum value for `num` is 10.
       */
      public List setStart(java.lang.Long start) {
        this.start = start;
        return this;
      }

      /** The custom search engine ID to use for this request. */
      @com.google.api.client.util.Key
      private java.lang.String cx;

      /** The custom search engine ID to use for this request.
       */
      public java.lang.String getCx() {
        return cx;
      }

      /** The custom search engine ID to use for this request. */
      public List setCx(java.lang.String cx) {
        this.cx = cx;
        return this;
      }

      /**
       * Returns black and white, grayscale, transparent, or color images. Acceptable values are:
       *
       * * `"color"`
       *
       * * `"gray"`
       *
       * * `"mono"`: black and white
       *
       * * `"trans"`: transparent background
       */
      @com.google.api.client.util.Key
      private java.lang.String imgColorType;

      /** Returns black and white, grayscale, transparent, or color images. Acceptable values are:

     * `"color"`

     * `"gray"`

     * `"mono"`: black and white

     * `"trans"`: transparent background
       */
      public java.lang.String getImgColorType() {
        return imgColorType;
      }

      /**
       * Returns black and white, grayscale, transparent, or color images. Acceptable values are:
       *
       * * `"color"`
       *
       * * `"gray"`
       *
       * * `"mono"`: black and white
       *
       * * `"trans"`: transparent background
       */
      public List setImgColorType(java.lang.String imgColorType) {
        this.imgColorType = imgColorType;
        return this;
      }

      /**
       * Restricts results to files of a specified extension. A list of file types indexable by
       * Google can be found in Search Console [Help
       * Center](https://support.google.com/webmasters/answer/35287).
       */
      @com.google.api.client.util.Key
      private java.lang.String fileType;

      /** Restricts results to files of a specified extension. A list of file types indexable by Google can
     be found in Search Console [Help Center](https://support.google.com/webmasters/answer/35287).
       */
      public java.lang.String getFileType() {
        return fileType;
      }

      /**
       * Restricts results to files of a specified extension. A list of file types indexable by
       * Google can be found in Search Console [Help
       * Center](https://support.google.com/webmasters/answer/35287).
       */
      public List setFileType(java.lang.String fileType) {
        this.fileType = fileType;
        return this;
      }

      /**
       * Restricts search results to documents originating in a particular country. You may use
       * [Boolean operators](https://developers.google.com/custom-
       * search/docs/xml_results_appendices#booleanOperators) in the cr parameter's value.
       *
       * Google Search determines the country of a document by analyzing:
       *
       * * the top-level domain (TLD) of the document's URL
       *
       * * the geographic location of the Web server's IP address
       *
       * See the [Country Parameter Values](https://developers.google.com/custom-
       * search/docs/xml_results_appendices#countryCollections) page for a list of valid values for
       * this parameter.
       */
      @com.google.api.client.util.Key
      private java.lang.String cr;

      /** Restricts search results to documents originating in a particular country. You may use [Boolean
     operators](https://developers.google.com/custom-
     search/docs/xml_results_appendices#booleanOperators) in the cr parameter's value.

     Google Search determines the country of a document by analyzing:

     * the top-level domain (TLD) of the document's URL

     * the geographic location of the Web server's IP address

     See the [Country Parameter Values](https://developers.google.com/custom-
     search/docs/xml_results_appendices#countryCollections) page for a list of valid values for this
     parameter.
       */
      public java.lang.String getCr() {
        return cr;
      }

      /**
       * Restricts search results to documents originating in a particular country. You may use
       * [Boolean operators](https://developers.google.com/custom-
       * search/docs/xml_results_appendices#booleanOperators) in the cr parameter's value.
       *
       * Google Search determines the country of a document by analyzing:
       *
       * * the top-level domain (TLD) of the document's URL
       *
       * * the geographic location of the Web server's IP address
       *
       * See the [Country Parameter Values](https://developers.google.com/custom-
       * search/docs/xml_results_appendices#countryCollections) page for a list of valid values for
       * this parameter.
       */
      public List setCr(java.lang.String cr) {
        this.cr = cr;
        return this;
      }

      /**
       * Search safety level. Acceptable values are:
       *
       * * `"active"`: Enables SafeSearch filtering.
       *
       * * `"off"`: Disables SafeSearch filtering. (default)
       */
      @com.google.api.client.util.Key
      private java.lang.String safe;

      /** Search safety level. Acceptable values are:

     * `"active"`: Enables SafeSearch filtering.

     * `"off"`: Disables SafeSearch filtering. (default)
       */
      public java.lang.String getSafe() {
        return safe;
      }

      /**
       * Search safety level. Acceptable values are:
       *
       * * `"active"`: Enables SafeSearch filtering.
       *
       * * `"off"`: Disables SafeSearch filtering. (default)
       */
      public List setSafe(java.lang.String safe) {
        this.safe = safe;
        return this;
      }

      /**
       * Identifies a word or phrase that should not appear in any documents in the search results.
       */
      @com.google.api.client.util.Key
      private java.lang.String excludeTerms;

      /** Identifies a word or phrase that should not appear in any documents in the search results.
       */
      public java.lang.String getExcludeTerms() {
        return excludeTerms;
      }

      /**
       * Identifies a word or phrase that should not appear in any documents in the search results.
       */
      public List setExcludeTerms(java.lang.String excludeTerms) {
        this.excludeTerms = excludeTerms;
        return this;
      }

      /**
       * Provides additional search terms to check for in a document, where each document in the
       * search results must contain at least one of the additional search terms.
       */
      @com.google.api.client.util.Key
      private java.lang.String orTerms;

      /** Provides additional search terms to check for in a document, where each document in the search
     results must contain at least one of the additional search terms.
       */
      public java.lang.String getOrTerms() {
        return orTerms;
      }

      /**
       * Provides additional search terms to check for in a document, where each document in the
       * search results must contain at least one of the additional search terms.
       */
      public List setOrTerms(java.lang.String orTerms) {
        this.orTerms = orTerms;
        return this;
      }

      /**
       * Specifies a given site which should always be included or excluded from results (see
       * `siteSearchFilter` parameter, below).
       */
      @com.google.api.client.util.Key
      private java.lang.String siteSearch;

      /** Specifies a given site which should always be included or excluded from results (see
     `siteSearchFilter` parameter, below).
       */
      public java.lang.String getSiteSearch() {
        return siteSearch;
      }

      /**
       * Specifies a given site which should always be included or excluded from results (see
       * `siteSearchFilter` parameter, below).
       */
      public List setSiteSearch(java.lang.String siteSearch) {
        this.siteSearch = siteSearch;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link Customsearch}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link Customsearch}. */
    @Override
    public Customsearch build() {
      return new Customsearch(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link CustomsearchRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setCustomsearchRequestInitializer(
        CustomsearchRequestInitializer customsearchRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(customsearchRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
