/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-21 at 23:43:10 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Settings controlling the volume of connections to a backend service.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CircuitBreakers extends com.google.api.client.json.GenericJson {

  /**
   * The maximum number of connections to the backend service. If not specified, there is no limit.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxConnections;

  /**
   * The maximum number of pending requests allowed to the backend service. If not specified, there
   * is no limit.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxPendingRequests;

  /**
   * The maximum number of parallel requests that allowed to the backend service. If not specified,
   * there is no limit.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxRequests;

  /**
   * Maximum requests for a single connection to the backend service. This parameter is respected by
   * both the HTTP/1.1 and HTTP/2 implementations. If not specified, there is no limit. Setting this
   * parameter to 1 will effectively disable keep alive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxRequestsPerConnection;

  /**
   * The maximum number of parallel retries allowed to the backend cluster. If not specified, the
   * default is 1.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxRetries;

  /**
   * The maximum number of connections to the backend service. If not specified, there is no limit.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxConnections() {
    return maxConnections;
  }

  /**
   * The maximum number of connections to the backend service. If not specified, there is no limit.
   * @param maxConnections maxConnections or {@code null} for none
   */
  public CircuitBreakers setMaxConnections(java.lang.Integer maxConnections) {
    this.maxConnections = maxConnections;
    return this;
  }

  /**
   * The maximum number of pending requests allowed to the backend service. If not specified, there
   * is no limit.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxPendingRequests() {
    return maxPendingRequests;
  }

  /**
   * The maximum number of pending requests allowed to the backend service. If not specified, there
   * is no limit.
   * @param maxPendingRequests maxPendingRequests or {@code null} for none
   */
  public CircuitBreakers setMaxPendingRequests(java.lang.Integer maxPendingRequests) {
    this.maxPendingRequests = maxPendingRequests;
    return this;
  }

  /**
   * The maximum number of parallel requests that allowed to the backend service. If not specified,
   * there is no limit.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxRequests() {
    return maxRequests;
  }

  /**
   * The maximum number of parallel requests that allowed to the backend service. If not specified,
   * there is no limit.
   * @param maxRequests maxRequests or {@code null} for none
   */
  public CircuitBreakers setMaxRequests(java.lang.Integer maxRequests) {
    this.maxRequests = maxRequests;
    return this;
  }

  /**
   * Maximum requests for a single connection to the backend service. This parameter is respected by
   * both the HTTP/1.1 and HTTP/2 implementations. If not specified, there is no limit. Setting this
   * parameter to 1 will effectively disable keep alive.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxRequestsPerConnection() {
    return maxRequestsPerConnection;
  }

  /**
   * Maximum requests for a single connection to the backend service. This parameter is respected by
   * both the HTTP/1.1 and HTTP/2 implementations. If not specified, there is no limit. Setting this
   * parameter to 1 will effectively disable keep alive.
   * @param maxRequestsPerConnection maxRequestsPerConnection or {@code null} for none
   */
  public CircuitBreakers setMaxRequestsPerConnection(java.lang.Integer maxRequestsPerConnection) {
    this.maxRequestsPerConnection = maxRequestsPerConnection;
    return this;
  }

  /**
   * The maximum number of parallel retries allowed to the backend cluster. If not specified, the
   * default is 1.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxRetries() {
    return maxRetries;
  }

  /**
   * The maximum number of parallel retries allowed to the backend cluster. If not specified, the
   * default is 1.
   * @param maxRetries maxRetries or {@code null} for none
   */
  public CircuitBreakers setMaxRetries(java.lang.Integer maxRetries) {
    this.maxRetries = maxRetries;
    return this;
  }

  @Override
  public CircuitBreakers set(String fieldName, Object value) {
    return (CircuitBreakers) super.set(fieldName, value);
  }

  @Override
  public CircuitBreakers clone() {
    return (CircuitBreakers) super.clone();
  }

}
