/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-05-08 at 15:25:17 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.cloudkms.v1.model;

/**
 * A CryptoKey represents a logical key that can be used for cryptographic operations.
 *
 * A CryptoKey is made up of one or more versions, which represent the actual key material used in
 * cryptographic operations.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud Key Management Service (KMS) API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CryptoKey extends com.google.api.client.json.GenericJson {

  /**
   * Output only. The time at which this CryptoKey was created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * Output only. The resource name for this CryptoKey in the format
   * `projects/locations/keyRings/cryptoKeys`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * At next_rotation_time, the Key Management Service will automatically:
   *
   * 1. Create a new version of this CryptoKey. 2. Mark the new version as primary.
   *
   * Key rotations performed manually via CreateCryptoKeyVersion and UpdateCryptoKeyPrimaryVersion
   * do not affect next_rotation_time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String nextRotationTime;

  /**
   * Output only. A copy of the "primary" CryptoKeyVersion that will be used by Encrypt when this
   * CryptoKey is given in EncryptRequest.name.
   *
   * The CryptoKey's primary version can be updated via UpdateCryptoKeyPrimaryVersion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CryptoKeyVersion primary;

  /**
   * The immutable purpose of this CryptoKey. Currently, the only acceptable purpose is
   * ENCRYPT_DECRYPT.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String purpose;

  /**
   * next_rotation_time will be advanced by this period when the service automatically rotates a
   * key. Must be at least one day.
   *
   * If rotation_period is set, next_rotation_time must also be set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String rotationPeriod;

  /**
   * Output only. The time at which this CryptoKey was created.
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * Output only. The time at which this CryptoKey was created.
   * @param createTime createTime or {@code null} for none
   */
  public CryptoKey setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * Output only. The resource name for this CryptoKey in the format
   * `projects/locations/keyRings/cryptoKeys`.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Output only. The resource name for this CryptoKey in the format
   * `projects/locations/keyRings/cryptoKeys`.
   * @param name name or {@code null} for none
   */
  public CryptoKey setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * At next_rotation_time, the Key Management Service will automatically:
   *
   * 1. Create a new version of this CryptoKey. 2. Mark the new version as primary.
   *
   * Key rotations performed manually via CreateCryptoKeyVersion and UpdateCryptoKeyPrimaryVersion
   * do not affect next_rotation_time.
   * @return value or {@code null} for none
   */
  public String getNextRotationTime() {
    return nextRotationTime;
  }

  /**
   * At next_rotation_time, the Key Management Service will automatically:
   *
   * 1. Create a new version of this CryptoKey. 2. Mark the new version as primary.
   *
   * Key rotations performed manually via CreateCryptoKeyVersion and UpdateCryptoKeyPrimaryVersion
   * do not affect next_rotation_time.
   * @param nextRotationTime nextRotationTime or {@code null} for none
   */
  public CryptoKey setNextRotationTime(String nextRotationTime) {
    this.nextRotationTime = nextRotationTime;
    return this;
  }

  /**
   * Output only. A copy of the "primary" CryptoKeyVersion that will be used by Encrypt when this
   * CryptoKey is given in EncryptRequest.name.
   *
   * The CryptoKey's primary version can be updated via UpdateCryptoKeyPrimaryVersion.
   * @return value or {@code null} for none
   */
  public CryptoKeyVersion getPrimary() {
    return primary;
  }

  /**
   * Output only. A copy of the "primary" CryptoKeyVersion that will be used by Encrypt when this
   * CryptoKey is given in EncryptRequest.name.
   *
   * The CryptoKey's primary version can be updated via UpdateCryptoKeyPrimaryVersion.
   * @param primary primary or {@code null} for none
   */
  public CryptoKey setPrimary(CryptoKeyVersion primary) {
    this.primary = primary;
    return this;
  }

  /**
   * The immutable purpose of this CryptoKey. Currently, the only acceptable purpose is
   * ENCRYPT_DECRYPT.
   * @return value or {@code null} for none
   */
  public java.lang.String getPurpose() {
    return purpose;
  }

  /**
   * The immutable purpose of this CryptoKey. Currently, the only acceptable purpose is
   * ENCRYPT_DECRYPT.
   * @param purpose purpose or {@code null} for none
   */
  public CryptoKey setPurpose(java.lang.String purpose) {
    this.purpose = purpose;
    return this;
  }

  /**
   * next_rotation_time will be advanced by this period when the service automatically rotates a
   * key. Must be at least one day.
   *
   * If rotation_period is set, next_rotation_time must also be set.
   * @return value or {@code null} for none
   */
  public String getRotationPeriod() {
    return rotationPeriod;
  }

  /**
   * next_rotation_time will be advanced by this period when the service automatically rotates a
   * key. Must be at least one day.
   *
   * If rotation_period is set, next_rotation_time must also be set.
   * @param rotationPeriod rotationPeriod or {@code null} for none
   */
  public CryptoKey setRotationPeriod(String rotationPeriod) {
    this.rotationPeriod = rotationPeriod;
    return this;
  }

  @Override
  public CryptoKey set(String fieldName, Object value) {
    return (CryptoKey) super.set(fieldName, value);
  }

  @Override
  public CryptoKey clone() {
    return (CryptoKey) super.clone();
  }

}
