/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.calendar;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.DateTime;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.calendar.CalendarRequest;
import com.google.api.services.calendar.CalendarRequestInitializer;
import com.google.api.services.calendar.model.AclRule;
import com.google.api.services.calendar.model.CalendarListEntry;
import com.google.api.services.calendar.model.Channel;
import com.google.api.services.calendar.model.Event;
import com.google.api.services.calendar.model.FreeBusyRequest;
import com.google.api.services.calendar.model.FreeBusyResponse;
import com.google.api.services.calendar.model.Setting;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Calendar
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "calendar/v3/";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/calendar/v3/";

    public Calendar(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Calendar(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Acl acl() {
        return new Acl();
    }

    public CalendarList calendarList() {
        return new CalendarList();
    }

    public Calendars calendars() {
        return new Calendars();
    }

    public Channels channels() {
        return new Channels();
    }

    public Colors colors() {
        return new Colors();
    }

    public Events events() {
        return new Events();
    }

    public Freebusy freebusy() {
        return new Freebusy();
    }

    public Settings settings() {
        return new Settings();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.17.0-rc of the Calendar API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, Calendar.DEFAULT_ROOT_URL, Calendar.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public Calendar build() {
            return new Calendar(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setCalendarRequestInitializer(CalendarRequestInitializer calendarRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)calendarRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Settings {
        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list() throws IOException {
            List list = new List();
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends CalendarRequest<com.google.api.services.calendar.model.Settings> {
            private static final String REST_PATH = "users/me/settings";

            protected List() {
                super(Calendar.this, "GET", REST_PATH, null, com.google.api.services.calendar.model.Settings.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends CalendarRequest<Setting> {
            private static final String REST_PATH = "users/me/settings/{setting}";
            @Key
            private String setting;

            protected Get(String string) {
                super(Calendar.this, "GET", REST_PATH, null, Setting.class);
                this.setting = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter setting must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getSetting() {
                return this.setting;
            }

            public Get setSetting(String string) {
                this.setting = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Freebusy {
        public Query query(FreeBusyRequest freeBusyRequest) throws IOException {
            Query query = new Query(freeBusyRequest);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)query);
            return query;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Query
        extends CalendarRequest<FreeBusyResponse> {
            private static final String REST_PATH = "freeBusy";

            protected Query(FreeBusyRequest freeBusyRequest) {
                super(Calendar.this, "POST", REST_PATH, (Object)freeBusyRequest, FreeBusyResponse.class);
            }

            public Query setAlt(String string) {
                return (Query)super.setAlt(string);
            }

            public Query setFields(String string) {
                return (Query)super.setFields(string);
            }

            public Query setKey(String string) {
                return (Query)super.setKey(string);
            }

            public Query setOauthToken(String string) {
                return (Query)super.setOauthToken(string);
            }

            public Query setPrettyPrint(Boolean bl) {
                return (Query)super.setPrettyPrint(bl);
            }

            public Query setQuotaUser(String string) {
                return (Query)super.setQuotaUser(string);
            }

            public Query setUserIp(String string) {
                return (Query)super.setUserIp(string);
            }

            @Override
            public Query set(String string, Object object) {
                return (Query)super.set(string, object);
            }
        }
    }

    public class Events {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public CalendarImport calendarImport(String string, Event event) throws IOException {
            CalendarImport calendarImport = new CalendarImport(string, event);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)calendarImport);
            return calendarImport;
        }

        public Insert insert(String string, Event event) throws IOException {
            Insert insert = new Insert(string, event);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public Instances instances(String string, String string2) throws IOException {
            Instances instances = new Instances(string, string2);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)instances);
            return instances;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Move move(String string, String string2, String string3) throws IOException {
            Move move = new Move(string, string2, string3);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)move);
            return move;
        }

        public Patch patch(String string, String string2, Event event) throws IOException {
            Patch patch = new Patch(string, string2, event);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public QuickAdd quickAdd(String string, String string2) throws IOException {
            QuickAdd quickAdd = new QuickAdd(string, string2);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)quickAdd);
            return quickAdd;
        }

        public Update update(String string, String string2, Event event) throws IOException {
            Update update = new Update(string, string2, event);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        public Watch watch(String string, Channel channel) throws IOException {
            Watch watch = new Watch(string, channel);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)watch);
            return watch;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Watch
        extends CalendarRequest<Channel> {
            private static final String REST_PATH = "calendars/{calendarId}/events/watch";
            @Key
            private String calendarId;
            @Key
            private String orderBy;
            @Key
            private Boolean showHiddenInvitations;
            @Key
            private Boolean showDeleted;
            @Key
            private String iCalUID;
            @Key
            private DateTime updatedMin;
            @Key
            private Boolean singleEvents;
            @Key
            private DateTime timeMax;
            @Key
            private Boolean alwaysIncludeEmail;
            @Key
            private Integer maxResults;
            @Key
            private String q;
            @Key
            private String pageToken;
            @Key
            private DateTime timeMin;
            @Key
            private String timeZone;
            @Key
            private java.util.List<String> privateExtendedProperty;
            @Key
            private java.util.List<String> sharedExtendedProperty;
            @Key
            private Integer maxAttendees;

            protected Watch(String string, Channel channel) {
                super(Calendar.this, "POST", REST_PATH, (Object)channel, Channel.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter calendarId must be specified.");
            }

            public Watch setAlt(String string) {
                return (Watch)super.setAlt(string);
            }

            public Watch setFields(String string) {
                return (Watch)super.setFields(string);
            }

            public Watch setKey(String string) {
                return (Watch)super.setKey(string);
            }

            public Watch setOauthToken(String string) {
                return (Watch)super.setOauthToken(string);
            }

            public Watch setPrettyPrint(Boolean bl) {
                return (Watch)super.setPrettyPrint(bl);
            }

            public Watch setQuotaUser(String string) {
                return (Watch)super.setQuotaUser(string);
            }

            public Watch setUserIp(String string) {
                return (Watch)super.setUserIp(string);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Watch setCalendarId(String string) {
                this.calendarId = string;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public Watch setOrderBy(String string) {
                this.orderBy = string;
                return this;
            }

            public Boolean getShowHiddenInvitations() {
                return this.showHiddenInvitations;
            }

            public Watch setShowHiddenInvitations(Boolean bl) {
                this.showHiddenInvitations = bl;
                return this;
            }

            public Boolean getShowDeleted() {
                return this.showDeleted;
            }

            public Watch setShowDeleted(Boolean bl) {
                this.showDeleted = bl;
                return this;
            }

            public String getICalUID() {
                return this.iCalUID;
            }

            public Watch setICalUID(String string) {
                this.iCalUID = string;
                return this;
            }

            public DateTime getUpdatedMin() {
                return this.updatedMin;
            }

            public Watch setUpdatedMin(DateTime dateTime) {
                this.updatedMin = dateTime;
                return this;
            }

            public Boolean getSingleEvents() {
                return this.singleEvents;
            }

            public Watch setSingleEvents(Boolean bl) {
                this.singleEvents = bl;
                return this;
            }

            public DateTime getTimeMax() {
                return this.timeMax;
            }

            public Watch setTimeMax(DateTime dateTime) {
                this.timeMax = dateTime;
                return this;
            }

            public Boolean getAlwaysIncludeEmail() {
                return this.alwaysIncludeEmail;
            }

            public Watch setAlwaysIncludeEmail(Boolean bl) {
                this.alwaysIncludeEmail = bl;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public Watch setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getQ() {
                return this.q;
            }

            public Watch setQ(String string) {
                this.q = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public Watch setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public DateTime getTimeMin() {
                return this.timeMin;
            }

            public Watch setTimeMin(DateTime dateTime) {
                this.timeMin = dateTime;
                return this;
            }

            public String getTimeZone() {
                return this.timeZone;
            }

            public Watch setTimeZone(String string) {
                this.timeZone = string;
                return this;
            }

            public java.util.List<String> getPrivateExtendedProperty() {
                return this.privateExtendedProperty;
            }

            public Watch setPrivateExtendedProperty(java.util.List<String> list) {
                this.privateExtendedProperty = list;
                return this;
            }

            public java.util.List<String> getSharedExtendedProperty() {
                return this.sharedExtendedProperty;
            }

            public Watch setSharedExtendedProperty(java.util.List<String> list) {
                this.sharedExtendedProperty = list;
                return this;
            }

            public Integer getMaxAttendees() {
                return this.maxAttendees;
            }

            public Watch setMaxAttendees(Integer n) {
                this.maxAttendees = n;
                return this;
            }

            @Override
            public Watch set(String string, Object object) {
                return (Watch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends CalendarRequest<Event> {
            private static final String REST_PATH = "calendars/{calendarId}/events/{eventId}";
            @Key
            private String calendarId;
            @Key
            private String eventId;
            @Key
            private Boolean sendNotifications;
            @Key
            private Boolean alwaysIncludeEmail;
            @Key
            private Integer maxAttendees;

            protected Update(String string, String string2, Event event) {
                super(Calendar.this, "PUT", REST_PATH, (Object)event, Event.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter calendarId must be specified.");
                this.eventId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter eventId must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Update setCalendarId(String string) {
                this.calendarId = string;
                return this;
            }

            public String getEventId() {
                return this.eventId;
            }

            public Update setEventId(String string) {
                this.eventId = string;
                return this;
            }

            public Boolean getSendNotifications() {
                return this.sendNotifications;
            }

            public Update setSendNotifications(Boolean bl) {
                this.sendNotifications = bl;
                return this;
            }

            public Boolean getAlwaysIncludeEmail() {
                return this.alwaysIncludeEmail;
            }

            public Update setAlwaysIncludeEmail(Boolean bl) {
                this.alwaysIncludeEmail = bl;
                return this;
            }

            public Integer getMaxAttendees() {
                return this.maxAttendees;
            }

            public Update setMaxAttendees(Integer n) {
                this.maxAttendees = n;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class QuickAdd
        extends CalendarRequest<Event> {
            private static final String REST_PATH = "calendars/{calendarId}/events/quickAdd";
            @Key
            private String calendarId;
            @Key
            private String text;
            @Key
            private Boolean sendNotifications;

            protected QuickAdd(String string, String string2) {
                super(Calendar.this, "POST", REST_PATH, null, Event.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter calendarId must be specified.");
                this.text = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter text must be specified.");
            }

            public QuickAdd setAlt(String string) {
                return (QuickAdd)super.setAlt(string);
            }

            public QuickAdd setFields(String string) {
                return (QuickAdd)super.setFields(string);
            }

            public QuickAdd setKey(String string) {
                return (QuickAdd)super.setKey(string);
            }

            public QuickAdd setOauthToken(String string) {
                return (QuickAdd)super.setOauthToken(string);
            }

            public QuickAdd setPrettyPrint(Boolean bl) {
                return (QuickAdd)super.setPrettyPrint(bl);
            }

            public QuickAdd setQuotaUser(String string) {
                return (QuickAdd)super.setQuotaUser(string);
            }

            public QuickAdd setUserIp(String string) {
                return (QuickAdd)super.setUserIp(string);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public QuickAdd setCalendarId(String string) {
                this.calendarId = string;
                return this;
            }

            public String getText() {
                return this.text;
            }

            public QuickAdd setText(String string) {
                this.text = string;
                return this;
            }

            public Boolean getSendNotifications() {
                return this.sendNotifications;
            }

            public QuickAdd setSendNotifications(Boolean bl) {
                this.sendNotifications = bl;
                return this;
            }

            @Override
            public QuickAdd set(String string, Object object) {
                return (QuickAdd)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends CalendarRequest<Event> {
            private static final String REST_PATH = "calendars/{calendarId}/events/{eventId}";
            @Key
            private String calendarId;
            @Key
            private String eventId;
            @Key
            private Boolean sendNotifications;
            @Key
            private Boolean alwaysIncludeEmail;
            @Key
            private Integer maxAttendees;

            protected Patch(String string, String string2, Event event) {
                super(Calendar.this, "PATCH", REST_PATH, (Object)event, Event.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter calendarId must be specified.");
                this.eventId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter eventId must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Patch setCalendarId(String string) {
                this.calendarId = string;
                return this;
            }

            public String getEventId() {
                return this.eventId;
            }

            public Patch setEventId(String string) {
                this.eventId = string;
                return this;
            }

            public Boolean getSendNotifications() {
                return this.sendNotifications;
            }

            public Patch setSendNotifications(Boolean bl) {
                this.sendNotifications = bl;
                return this;
            }

            public Boolean getAlwaysIncludeEmail() {
                return this.alwaysIncludeEmail;
            }

            public Patch setAlwaysIncludeEmail(Boolean bl) {
                this.alwaysIncludeEmail = bl;
                return this;
            }

            public Integer getMaxAttendees() {
                return this.maxAttendees;
            }

            public Patch setMaxAttendees(Integer n) {
                this.maxAttendees = n;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Move
        extends CalendarRequest<Event> {
            private static final String REST_PATH = "calendars/{calendarId}/events/{eventId}/move";
            @Key
            private String calendarId;
            @Key
            private String eventId;
            @Key
            private String destination;
            @Key
            private Boolean sendNotifications;

            protected Move(String string, String string2, String string3) {
                super(Calendar.this, "POST", REST_PATH, null, Event.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter calendarId must be specified.");
                this.eventId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter eventId must be specified.");
                this.destination = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter destination must be specified.");
            }

            public Move setAlt(String string) {
                return (Move)super.setAlt(string);
            }

            public Move setFields(String string) {
                return (Move)super.setFields(string);
            }

            public Move setKey(String string) {
                return (Move)super.setKey(string);
            }

            public Move setOauthToken(String string) {
                return (Move)super.setOauthToken(string);
            }

            public Move setPrettyPrint(Boolean bl) {
                return (Move)super.setPrettyPrint(bl);
            }

            public Move setQuotaUser(String string) {
                return (Move)super.setQuotaUser(string);
            }

            public Move setUserIp(String string) {
                return (Move)super.setUserIp(string);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Move setCalendarId(String string) {
                this.calendarId = string;
                return this;
            }

            public String getEventId() {
                return this.eventId;
            }

            public Move setEventId(String string) {
                this.eventId = string;
                return this;
            }

            public String getDestination() {
                return this.destination;
            }

            public Move setDestination(String string) {
                this.destination = string;
                return this;
            }

            public Boolean getSendNotifications() {
                return this.sendNotifications;
            }

            public Move setSendNotifications(Boolean bl) {
                this.sendNotifications = bl;
                return this;
            }

            @Override
            public Move set(String string, Object object) {
                return (Move)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends CalendarRequest<com.google.api.services.calendar.model.Events> {
            private static final String REST_PATH = "calendars/{calendarId}/events";
            @Key
            private String calendarId;
            @Key
            private String orderBy;
            @Key
            private Boolean showHiddenInvitations;
            @Key
            private Boolean showDeleted;
            @Key
            private String iCalUID;
            @Key
            private DateTime updatedMin;
            @Key
            private Boolean singleEvents;
            @Key
            private DateTime timeMax;
            @Key
            private Boolean alwaysIncludeEmail;
            @Key
            private Integer maxResults;
            @Key
            private String q;
            @Key
            private String pageToken;
            @Key
            private DateTime timeMin;
            @Key
            private String timeZone;
            @Key
            private java.util.List<String> privateExtendedProperty;
            @Key
            private java.util.List<String> sharedExtendedProperty;
            @Key
            private Integer maxAttendees;

            protected List(String string) {
                super(Calendar.this, "GET", REST_PATH, null, com.google.api.services.calendar.model.Events.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter calendarId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public List setCalendarId(String string) {
                this.calendarId = string;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String string) {
                this.orderBy = string;
                return this;
            }

            public Boolean getShowHiddenInvitations() {
                return this.showHiddenInvitations;
            }

            public List setShowHiddenInvitations(Boolean bl) {
                this.showHiddenInvitations = bl;
                return this;
            }

            public Boolean getShowDeleted() {
                return this.showDeleted;
            }

            public List setShowDeleted(Boolean bl) {
                this.showDeleted = bl;
                return this;
            }

            public String getICalUID() {
                return this.iCalUID;
            }

            public List setICalUID(String string) {
                this.iCalUID = string;
                return this;
            }

            public DateTime getUpdatedMin() {
                return this.updatedMin;
            }

            public List setUpdatedMin(DateTime dateTime) {
                this.updatedMin = dateTime;
                return this;
            }

            public Boolean getSingleEvents() {
                return this.singleEvents;
            }

            public List setSingleEvents(Boolean bl) {
                this.singleEvents = bl;
                return this;
            }

            public DateTime getTimeMax() {
                return this.timeMax;
            }

            public List setTimeMax(DateTime dateTime) {
                this.timeMax = dateTime;
                return this;
            }

            public Boolean getAlwaysIncludeEmail() {
                return this.alwaysIncludeEmail;
            }

            public List setAlwaysIncludeEmail(Boolean bl) {
                this.alwaysIncludeEmail = bl;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getQ() {
                return this.q;
            }

            public List setQ(String string) {
                this.q = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public DateTime getTimeMin() {
                return this.timeMin;
            }

            public List setTimeMin(DateTime dateTime) {
                this.timeMin = dateTime;
                return this;
            }

            public String getTimeZone() {
                return this.timeZone;
            }

            public List setTimeZone(String string) {
                this.timeZone = string;
                return this;
            }

            public java.util.List<String> getPrivateExtendedProperty() {
                return this.privateExtendedProperty;
            }

            public List setPrivateExtendedProperty(java.util.List<String> list) {
                this.privateExtendedProperty = list;
                return this;
            }

            public java.util.List<String> getSharedExtendedProperty() {
                return this.sharedExtendedProperty;
            }

            public List setSharedExtendedProperty(java.util.List<String> list) {
                this.sharedExtendedProperty = list;
                return this;
            }

            public Integer getMaxAttendees() {
                return this.maxAttendees;
            }

            public List setMaxAttendees(Integer n) {
                this.maxAttendees = n;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Instances
        extends CalendarRequest<com.google.api.services.calendar.model.Events> {
            private static final String REST_PATH = "calendars/{calendarId}/events/{eventId}/instances";
            @Key
            private String calendarId;
            @Key
            private String eventId;
            @Key
            private Boolean showDeleted;
            @Key
            private DateTime timeMax;
            @Key
            private Boolean alwaysIncludeEmail;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;
            @Key
            private DateTime timeMin;
            @Key
            private String timeZone;
            @Key
            private String originalStart;
            @Key
            private Integer maxAttendees;

            protected Instances(String string, String string2) {
                super(Calendar.this, "GET", REST_PATH, null, com.google.api.services.calendar.model.Events.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter calendarId must be specified.");
                this.eventId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter eventId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Instances setAlt(String string) {
                return (Instances)super.setAlt(string);
            }

            public Instances setFields(String string) {
                return (Instances)super.setFields(string);
            }

            public Instances setKey(String string) {
                return (Instances)super.setKey(string);
            }

            public Instances setOauthToken(String string) {
                return (Instances)super.setOauthToken(string);
            }

            public Instances setPrettyPrint(Boolean bl) {
                return (Instances)super.setPrettyPrint(bl);
            }

            public Instances setQuotaUser(String string) {
                return (Instances)super.setQuotaUser(string);
            }

            public Instances setUserIp(String string) {
                return (Instances)super.setUserIp(string);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Instances setCalendarId(String string) {
                this.calendarId = string;
                return this;
            }

            public String getEventId() {
                return this.eventId;
            }

            public Instances setEventId(String string) {
                this.eventId = string;
                return this;
            }

            public Boolean getShowDeleted() {
                return this.showDeleted;
            }

            public Instances setShowDeleted(Boolean bl) {
                this.showDeleted = bl;
                return this;
            }

            public DateTime getTimeMax() {
                return this.timeMax;
            }

            public Instances setTimeMax(DateTime dateTime) {
                this.timeMax = dateTime;
                return this;
            }

            public Boolean getAlwaysIncludeEmail() {
                return this.alwaysIncludeEmail;
            }

            public Instances setAlwaysIncludeEmail(Boolean bl) {
                this.alwaysIncludeEmail = bl;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public Instances setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public Instances setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public DateTime getTimeMin() {
                return this.timeMin;
            }

            public Instances setTimeMin(DateTime dateTime) {
                this.timeMin = dateTime;
                return this;
            }

            public String getTimeZone() {
                return this.timeZone;
            }

            public Instances setTimeZone(String string) {
                this.timeZone = string;
                return this;
            }

            public String getOriginalStart() {
                return this.originalStart;
            }

            public Instances setOriginalStart(String string) {
                this.originalStart = string;
                return this;
            }

            public Integer getMaxAttendees() {
                return this.maxAttendees;
            }

            public Instances setMaxAttendees(Integer n) {
                this.maxAttendees = n;
                return this;
            }

            @Override
            public Instances set(String string, Object object) {
                return (Instances)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends CalendarRequest<Event> {
            private static final String REST_PATH = "calendars/{calendarId}/events";
            @Key
            private String calendarId;
            @Key
            private Boolean sendNotifications;
            @Key
            private Integer maxAttendees;

            protected Insert(String string, Event event) {
                super(Calendar.this, "POST", REST_PATH, (Object)event, Event.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter calendarId must be specified.");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Insert setCalendarId(String string) {
                this.calendarId = string;
                return this;
            }

            public Boolean getSendNotifications() {
                return this.sendNotifications;
            }

            public Insert setSendNotifications(Boolean bl) {
                this.sendNotifications = bl;
                return this;
            }

            public Integer getMaxAttendees() {
                return this.maxAttendees;
            }

            public Insert setMaxAttendees(Integer n) {
                this.maxAttendees = n;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class CalendarImport
        extends CalendarRequest<Event> {
            private static final String REST_PATH = "calendars/{calendarId}/events/import";
            @Key
            private String calendarId;

            protected CalendarImport(String string, Event event) {
                super(Calendar.this, "POST", REST_PATH, (Object)event, Event.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter calendarId must be specified.");
                this.checkRequiredParameter((Object)event, "content");
                this.checkRequiredParameter(event.getICalUID(), "Event.getICalUID()");
            }

            public CalendarImport setAlt(String string) {
                return (CalendarImport)super.setAlt(string);
            }

            public CalendarImport setFields(String string) {
                return (CalendarImport)super.setFields(string);
            }

            public CalendarImport setKey(String string) {
                return (CalendarImport)super.setKey(string);
            }

            public CalendarImport setOauthToken(String string) {
                return (CalendarImport)super.setOauthToken(string);
            }

            public CalendarImport setPrettyPrint(Boolean bl) {
                return (CalendarImport)super.setPrettyPrint(bl);
            }

            public CalendarImport setQuotaUser(String string) {
                return (CalendarImport)super.setQuotaUser(string);
            }

            public CalendarImport setUserIp(String string) {
                return (CalendarImport)super.setUserIp(string);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public CalendarImport setCalendarId(String string) {
                this.calendarId = string;
                return this;
            }

            @Override
            public CalendarImport set(String string, Object object) {
                return (CalendarImport)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends CalendarRequest<Event> {
            private static final String REST_PATH = "calendars/{calendarId}/events/{eventId}";
            @Key
            private String calendarId;
            @Key
            private String eventId;
            @Key
            private String timeZone;
            @Key
            private Boolean alwaysIncludeEmail;
            @Key
            private Integer maxAttendees;

            protected Get(String string, String string2) {
                super(Calendar.this, "GET", REST_PATH, null, Event.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter calendarId must be specified.");
                this.eventId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter eventId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Get setCalendarId(String string) {
                this.calendarId = string;
                return this;
            }

            public String getEventId() {
                return this.eventId;
            }

            public Get setEventId(String string) {
                this.eventId = string;
                return this;
            }

            public String getTimeZone() {
                return this.timeZone;
            }

            public Get setTimeZone(String string) {
                this.timeZone = string;
                return this;
            }

            public Boolean getAlwaysIncludeEmail() {
                return this.alwaysIncludeEmail;
            }

            public Get setAlwaysIncludeEmail(Boolean bl) {
                this.alwaysIncludeEmail = bl;
                return this;
            }

            public Integer getMaxAttendees() {
                return this.maxAttendees;
            }

            public Get setMaxAttendees(Integer n) {
                this.maxAttendees = n;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends CalendarRequest<Void> {
            private static final String REST_PATH = "calendars/{calendarId}/events/{eventId}";
            @Key
            private String calendarId;
            @Key
            private String eventId;
            @Key
            private Boolean sendNotifications;

            protected Delete(String string, String string2) {
                super(Calendar.this, "DELETE", REST_PATH, null, Void.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter calendarId must be specified.");
                this.eventId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter eventId must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Delete setCalendarId(String string) {
                this.calendarId = string;
                return this;
            }

            public String getEventId() {
                return this.eventId;
            }

            public Delete setEventId(String string) {
                this.eventId = string;
                return this;
            }

            public Boolean getSendNotifications() {
                return this.sendNotifications;
            }

            public Delete setSendNotifications(Boolean bl) {
                this.sendNotifications = bl;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Colors {
        public Get get() throws IOException {
            Get get = new Get();
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends CalendarRequest<com.google.api.services.calendar.model.Colors> {
            private static final String REST_PATH = "colors";

            protected Get() {
                super(Calendar.this, "GET", REST_PATH, null, com.google.api.services.calendar.model.Colors.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Channels {
        public Stop stop(Channel channel) throws IOException {
            Stop stop = new Stop(channel);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)stop);
            return stop;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Stop
        extends CalendarRequest<Void> {
            private static final String REST_PATH = "channels/stop";

            protected Stop(Channel channel) {
                super(Calendar.this, "POST", REST_PATH, (Object)channel, Void.class);
            }

            public Stop setAlt(String string) {
                return (Stop)super.setAlt(string);
            }

            public Stop setFields(String string) {
                return (Stop)super.setFields(string);
            }

            public Stop setKey(String string) {
                return (Stop)super.setKey(string);
            }

            public Stop setOauthToken(String string) {
                return (Stop)super.setOauthToken(string);
            }

            public Stop setPrettyPrint(Boolean bl) {
                return (Stop)super.setPrettyPrint(bl);
            }

            public Stop setQuotaUser(String string) {
                return (Stop)super.setQuotaUser(string);
            }

            public Stop setUserIp(String string) {
                return (Stop)super.setUserIp(string);
            }

            @Override
            public Stop set(String string, Object object) {
                return (Stop)super.set(string, object);
            }
        }
    }

    public class Calendars {
        public Clear clear(String string) throws IOException {
            Clear clear = new Clear(string);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)clear);
            return clear;
        }

        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(com.google.api.services.calendar.model.Calendar calendar) throws IOException {
            Insert insert = new Insert(calendar);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public Patch patch(String string, com.google.api.services.calendar.model.Calendar calendar) throws IOException {
            Patch patch = new Patch(string, calendar);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, com.google.api.services.calendar.model.Calendar calendar) throws IOException {
            Update update = new Update(string, calendar);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends CalendarRequest<com.google.api.services.calendar.model.Calendar> {
            private static final String REST_PATH = "calendars/{calendarId}";
            @Key
            private String calendarId;

            protected Update(String string, com.google.api.services.calendar.model.Calendar calendar) {
                super(Calendar.this, "PUT", REST_PATH, (Object)calendar, com.google.api.services.calendar.model.Calendar.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter calendarId must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Update setCalendarId(String string) {
                this.calendarId = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends CalendarRequest<com.google.api.services.calendar.model.Calendar> {
            private static final String REST_PATH = "calendars/{calendarId}";
            @Key
            private String calendarId;

            protected Patch(String string, com.google.api.services.calendar.model.Calendar calendar) {
                super(Calendar.this, "PATCH", REST_PATH, (Object)calendar, com.google.api.services.calendar.model.Calendar.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter calendarId must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Patch setCalendarId(String string) {
                this.calendarId = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends CalendarRequest<com.google.api.services.calendar.model.Calendar> {
            private static final String REST_PATH = "calendars";

            protected Insert(com.google.api.services.calendar.model.Calendar calendar) {
                super(Calendar.this, "POST", REST_PATH, (Object)calendar, com.google.api.services.calendar.model.Calendar.class);
                this.checkRequiredParameter((Object)calendar, "content");
                this.checkRequiredParameter(calendar.getSummary(), "Calendar.getSummary()");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends CalendarRequest<com.google.api.services.calendar.model.Calendar> {
            private static final String REST_PATH = "calendars/{calendarId}";
            @Key
            private String calendarId;

            protected Get(String string) {
                super(Calendar.this, "GET", REST_PATH, null, com.google.api.services.calendar.model.Calendar.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter calendarId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Get setCalendarId(String string) {
                this.calendarId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends CalendarRequest<Void> {
            private static final String REST_PATH = "calendars/{calendarId}";
            @Key
            private String calendarId;

            protected Delete(String string) {
                super(Calendar.this, "DELETE", REST_PATH, null, Void.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter calendarId must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Delete setCalendarId(String string) {
                this.calendarId = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Clear
        extends CalendarRequest<Void> {
            private static final String REST_PATH = "calendars/{calendarId}/clear";
            @Key
            private String calendarId;

            protected Clear(String string) {
                super(Calendar.this, "POST", REST_PATH, null, Void.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter calendarId must be specified.");
            }

            public Clear setAlt(String string) {
                return (Clear)super.setAlt(string);
            }

            public Clear setFields(String string) {
                return (Clear)super.setFields(string);
            }

            public Clear setKey(String string) {
                return (Clear)super.setKey(string);
            }

            public Clear setOauthToken(String string) {
                return (Clear)super.setOauthToken(string);
            }

            public Clear setPrettyPrint(Boolean bl) {
                return (Clear)super.setPrettyPrint(bl);
            }

            public Clear setQuotaUser(String string) {
                return (Clear)super.setQuotaUser(string);
            }

            public Clear setUserIp(String string) {
                return (Clear)super.setUserIp(string);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Clear setCalendarId(String string) {
                this.calendarId = string;
                return this;
            }

            @Override
            public Clear set(String string, Object object) {
                return (Clear)super.set(string, object);
            }
        }
    }

    public class CalendarList {
        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(CalendarListEntry calendarListEntry) throws IOException {
            Insert insert = new Insert(calendarListEntry);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list() throws IOException {
            List list = new List();
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, CalendarListEntry calendarListEntry) throws IOException {
            Patch patch = new Patch(string, calendarListEntry);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, CalendarListEntry calendarListEntry) throws IOException {
            Update update = new Update(string, calendarListEntry);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends CalendarRequest<CalendarListEntry> {
            private static final String REST_PATH = "users/me/calendarList/{calendarId}";
            @Key
            private String calendarId;
            @Key
            private Boolean colorRgbFormat;

            protected Update(String string, CalendarListEntry calendarListEntry) {
                super(Calendar.this, "PUT", REST_PATH, (Object)calendarListEntry, CalendarListEntry.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter calendarId must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Update setCalendarId(String string) {
                this.calendarId = string;
                return this;
            }

            public Boolean getColorRgbFormat() {
                return this.colorRgbFormat;
            }

            public Update setColorRgbFormat(Boolean bl) {
                this.colorRgbFormat = bl;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends CalendarRequest<CalendarListEntry> {
            private static final String REST_PATH = "users/me/calendarList/{calendarId}";
            @Key
            private String calendarId;
            @Key
            private Boolean colorRgbFormat;

            protected Patch(String string, CalendarListEntry calendarListEntry) {
                super(Calendar.this, "PATCH", REST_PATH, (Object)calendarListEntry, CalendarListEntry.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter calendarId must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Patch setCalendarId(String string) {
                this.calendarId = string;
                return this;
            }

            public Boolean getColorRgbFormat() {
                return this.colorRgbFormat;
            }

            public Patch setColorRgbFormat(Boolean bl) {
                this.colorRgbFormat = bl;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends CalendarRequest<com.google.api.services.calendar.model.CalendarList> {
            private static final String REST_PATH = "users/me/calendarList";
            @Key
            private String pageToken;
            @Key
            private Boolean showHidden;
            @Key
            private Integer maxResults;
            @Key
            private String minAccessRole;

            protected List() {
                super(Calendar.this, "GET", REST_PATH, null, com.google.api.services.calendar.model.CalendarList.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Boolean getShowHidden() {
                return this.showHidden;
            }

            public List setShowHidden(Boolean bl) {
                this.showHidden = bl;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getMinAccessRole() {
                return this.minAccessRole;
            }

            public List setMinAccessRole(String string) {
                this.minAccessRole = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends CalendarRequest<CalendarListEntry> {
            private static final String REST_PATH = "users/me/calendarList";
            @Key
            private Boolean colorRgbFormat;

            protected Insert(CalendarListEntry calendarListEntry) {
                super(Calendar.this, "POST", REST_PATH, (Object)calendarListEntry, CalendarListEntry.class);
                this.checkRequiredParameter((Object)calendarListEntry, "content");
                this.checkRequiredParameter(calendarListEntry.getId(), "CalendarListEntry.getId()");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public Boolean getColorRgbFormat() {
                return this.colorRgbFormat;
            }

            public Insert setColorRgbFormat(Boolean bl) {
                this.colorRgbFormat = bl;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends CalendarRequest<CalendarListEntry> {
            private static final String REST_PATH = "users/me/calendarList/{calendarId}";
            @Key
            private String calendarId;

            protected Get(String string) {
                super(Calendar.this, "GET", REST_PATH, null, CalendarListEntry.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter calendarId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Get setCalendarId(String string) {
                this.calendarId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends CalendarRequest<Void> {
            private static final String REST_PATH = "users/me/calendarList/{calendarId}";
            @Key
            private String calendarId;

            protected Delete(String string) {
                super(Calendar.this, "DELETE", REST_PATH, null, Void.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter calendarId must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Delete setCalendarId(String string) {
                this.calendarId = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Acl {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, AclRule aclRule) throws IOException {
            Insert insert = new Insert(string, aclRule);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, String string2, AclRule aclRule) throws IOException {
            Patch patch = new Patch(string, string2, aclRule);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, String string2, AclRule aclRule) throws IOException {
            Update update = new Update(string, string2, aclRule);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends CalendarRequest<AclRule> {
            private static final String REST_PATH = "calendars/{calendarId}/acl/{ruleId}";
            @Key
            private String calendarId;
            @Key
            private String ruleId;

            protected Update(String string, String string2, AclRule aclRule) {
                super(Calendar.this, "PUT", REST_PATH, (Object)aclRule, AclRule.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter calendarId must be specified.");
                this.ruleId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter ruleId must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Update setCalendarId(String string) {
                this.calendarId = string;
                return this;
            }

            public String getRuleId() {
                return this.ruleId;
            }

            public Update setRuleId(String string) {
                this.ruleId = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends CalendarRequest<AclRule> {
            private static final String REST_PATH = "calendars/{calendarId}/acl/{ruleId}";
            @Key
            private String calendarId;
            @Key
            private String ruleId;

            protected Patch(String string, String string2, AclRule aclRule) {
                super(Calendar.this, "PATCH", REST_PATH, (Object)aclRule, AclRule.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter calendarId must be specified.");
                this.ruleId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter ruleId must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Patch setCalendarId(String string) {
                this.calendarId = string;
                return this;
            }

            public String getRuleId() {
                return this.ruleId;
            }

            public Patch setRuleId(String string) {
                this.ruleId = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends CalendarRequest<com.google.api.services.calendar.model.Acl> {
            private static final String REST_PATH = "calendars/{calendarId}/acl";
            @Key
            private String calendarId;

            protected List(String string) {
                super(Calendar.this, "GET", REST_PATH, null, com.google.api.services.calendar.model.Acl.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter calendarId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public List setCalendarId(String string) {
                this.calendarId = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends CalendarRequest<AclRule> {
            private static final String REST_PATH = "calendars/{calendarId}/acl";
            @Key
            private String calendarId;

            protected Insert(String string, AclRule aclRule) {
                super(Calendar.this, "POST", REST_PATH, (Object)aclRule, AclRule.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter calendarId must be specified.");
                this.checkRequiredParameter((Object)aclRule, "content");
                this.checkRequiredParameter(aclRule.getRole(), "AclRule.getRole()");
                this.checkRequiredParameter((Object)aclRule, "content");
                this.checkRequiredParameter((Object)aclRule.getScope(), "AclRule.getScope()");
                this.checkRequiredParameter((Object)aclRule, "content");
                this.checkRequiredParameter(aclRule.getScope().getType(), "AclRule.getScope().getType()");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Insert setCalendarId(String string) {
                this.calendarId = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends CalendarRequest<AclRule> {
            private static final String REST_PATH = "calendars/{calendarId}/acl/{ruleId}";
            @Key
            private String calendarId;
            @Key
            private String ruleId;

            protected Get(String string, String string2) {
                super(Calendar.this, "GET", REST_PATH, null, AclRule.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter calendarId must be specified.");
                this.ruleId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter ruleId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Get setCalendarId(String string) {
                this.calendarId = string;
                return this;
            }

            public String getRuleId() {
                return this.ruleId;
            }

            public Get setRuleId(String string) {
                this.ruleId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends CalendarRequest<Void> {
            private static final String REST_PATH = "calendars/{calendarId}/acl/{ruleId}";
            @Key
            private String calendarId;
            @Key
            private String ruleId;

            protected Delete(String string, String string2) {
                super(Calendar.this, "DELETE", REST_PATH, null, Void.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter calendarId must be specified.");
                this.ruleId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter ruleId must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Delete setCalendarId(String string) {
                this.calendarId = string;
                return this;
            }

            public String getRuleId() {
                return this.ruleId;
            }

            public Delete setRuleId(String string) {
                this.ruleId = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }
}

