/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.calendar.model;

/**
 * Model definition for EventBirthdayProperties.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Calendar API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class EventBirthdayProperties extends com.google.api.client.json.GenericJson {

  /**
   * Resource name of the contact this birthday event is linked to. This can be used to fetch
   * contact details from People API. Format: "people/c12345". Read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String contact;

  /**
   * Custom type label specified for this event. This is populated if birthdayProperties.type is set
   * to "custom". Read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String customTypeName;

  /**
   * Type of birthday or special event. Possible values are: - "anniversary" - An anniversary other
   * than birthday. Always has a contact.  - "birthday" - A birthday event. This is the default
   * value.  - "custom" - A special date whose label is further specified in the customTypeName
   * field. Always has a contact.  - "other" - A special date which does not fall into the other
   * categories, and does not have a custom label. Always has a contact.  - "self" - Calendar
   * owner's own birthday. Cannot have a contact.  The Calendar API only supports creating events
   * with the type "birthday". The type cannot be changed after the event is created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Resource name of the contact this birthday event is linked to. This can be used to fetch
   * contact details from People API. Format: "people/c12345". Read-only.
   * @return value or {@code null} for none
   */
  public java.lang.String getContact() {
    return contact;
  }

  /**
   * Resource name of the contact this birthday event is linked to. This can be used to fetch
   * contact details from People API. Format: "people/c12345". Read-only.
   * @param contact contact or {@code null} for none
   */
  public EventBirthdayProperties setContact(java.lang.String contact) {
    this.contact = contact;
    return this;
  }

  /**
   * Custom type label specified for this event. This is populated if birthdayProperties.type is set
   * to "custom". Read-only.
   * @return value or {@code null} for none
   */
  public java.lang.String getCustomTypeName() {
    return customTypeName;
  }

  /**
   * Custom type label specified for this event. This is populated if birthdayProperties.type is set
   * to "custom". Read-only.
   * @param customTypeName customTypeName or {@code null} for none
   */
  public EventBirthdayProperties setCustomTypeName(java.lang.String customTypeName) {
    this.customTypeName = customTypeName;
    return this;
  }

  /**
   * Type of birthday or special event. Possible values are: - "anniversary" - An anniversary other
   * than birthday. Always has a contact.  - "birthday" - A birthday event. This is the default
   * value.  - "custom" - A special date whose label is further specified in the customTypeName
   * field. Always has a contact.  - "other" - A special date which does not fall into the other
   * categories, and does not have a custom label. Always has a contact.  - "self" - Calendar
   * owner's own birthday. Cannot have a contact.  The Calendar API only supports creating events
   * with the type "birthday". The type cannot be changed after the event is created.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Type of birthday or special event. Possible values are: - "anniversary" - An anniversary other
   * than birthday. Always has a contact.  - "birthday" - A birthday event. This is the default
   * value.  - "custom" - A special date whose label is further specified in the customTypeName
   * field. Always has a contact.  - "other" - A special date which does not fall into the other
   * categories, and does not have a custom label. Always has a contact.  - "self" - Calendar
   * owner's own birthday. Cannot have a contact.  The Calendar API only supports creating events
   * with the type "birthday". The type cannot be changed after the event is created.
   * @param type type or {@code null} for none
   */
  public EventBirthdayProperties setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public EventBirthdayProperties set(String fieldName, Object value) {
    return (EventBirthdayProperties) super.set(fieldName, value);
  }

  @Override
  public EventBirthdayProperties clone() {
    return (EventBirthdayProperties) super.clone();
  }

}
