/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Statistics for a LOAD query.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LoadQueryStatistics extends com.google.api.client.json.GenericJson {

  /**
   * Output only. The number of bad records encountered while processing a LOAD query. Note that if
   * the job has failed because of more bad records encountered than the maximum allowed in the load
   * job configuration, then this number can be less than the total number of bad records present in
   * the input data.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long badRecords;

  /**
   * Output only. This field is deprecated. The number of bytes of source data copied over the
   * network for a `LOAD` query. `transferred_bytes` has the canonical value for physical
   * transferred bytes, which is used for BigQuery Omni billing.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long bytesTransferred;

  /**
   * Output only. Number of bytes of source data in a LOAD query.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long inputFileBytes;

  /**
   * Output only. Number of source files in a LOAD query.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long inputFiles;

  /**
   * Output only. Size of the loaded data in bytes. Note that while a LOAD query is in the running
   * state, this value may change.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long outputBytes;

  /**
   * Output only. Number of rows imported in a LOAD query. Note that while a LOAD query is in the
   * running state, this value may change.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long outputRows;

  /**
   * Output only. The number of bad records encountered while processing a LOAD query. Note that if
   * the job has failed because of more bad records encountered than the maximum allowed in the load
   * job configuration, then this number can be less than the total number of bad records present in
   * the input data.
   * @return value or {@code null} for none
   */
  public java.lang.Long getBadRecords() {
    return badRecords;
  }

  /**
   * Output only. The number of bad records encountered while processing a LOAD query. Note that if
   * the job has failed because of more bad records encountered than the maximum allowed in the load
   * job configuration, then this number can be less than the total number of bad records present in
   * the input data.
   * @param badRecords badRecords or {@code null} for none
   */
  public LoadQueryStatistics setBadRecords(java.lang.Long badRecords) {
    this.badRecords = badRecords;
    return this;
  }

  /**
   * Output only. This field is deprecated. The number of bytes of source data copied over the
   * network for a `LOAD` query. `transferred_bytes` has the canonical value for physical
   * transferred bytes, which is used for BigQuery Omni billing.
   * @return value or {@code null} for none
   */
  public java.lang.Long getBytesTransferred() {
    return bytesTransferred;
  }

  /**
   * Output only. This field is deprecated. The number of bytes of source data copied over the
   * network for a `LOAD` query. `transferred_bytes` has the canonical value for physical
   * transferred bytes, which is used for BigQuery Omni billing.
   * @param bytesTransferred bytesTransferred or {@code null} for none
   */
  public LoadQueryStatistics setBytesTransferred(java.lang.Long bytesTransferred) {
    this.bytesTransferred = bytesTransferred;
    return this;
  }

  /**
   * Output only. Number of bytes of source data in a LOAD query.
   * @return value or {@code null} for none
   */
  public java.lang.Long getInputFileBytes() {
    return inputFileBytes;
  }

  /**
   * Output only. Number of bytes of source data in a LOAD query.
   * @param inputFileBytes inputFileBytes or {@code null} for none
   */
  public LoadQueryStatistics setInputFileBytes(java.lang.Long inputFileBytes) {
    this.inputFileBytes = inputFileBytes;
    return this;
  }

  /**
   * Output only. Number of source files in a LOAD query.
   * @return value or {@code null} for none
   */
  public java.lang.Long getInputFiles() {
    return inputFiles;
  }

  /**
   * Output only. Number of source files in a LOAD query.
   * @param inputFiles inputFiles or {@code null} for none
   */
  public LoadQueryStatistics setInputFiles(java.lang.Long inputFiles) {
    this.inputFiles = inputFiles;
    return this;
  }

  /**
   * Output only. Size of the loaded data in bytes. Note that while a LOAD query is in the running
   * state, this value may change.
   * @return value or {@code null} for none
   */
  public java.lang.Long getOutputBytes() {
    return outputBytes;
  }

  /**
   * Output only. Size of the loaded data in bytes. Note that while a LOAD query is in the running
   * state, this value may change.
   * @param outputBytes outputBytes or {@code null} for none
   */
  public LoadQueryStatistics setOutputBytes(java.lang.Long outputBytes) {
    this.outputBytes = outputBytes;
    return this;
  }

  /**
   * Output only. Number of rows imported in a LOAD query. Note that while a LOAD query is in the
   * running state, this value may change.
   * @return value or {@code null} for none
   */
  public java.lang.Long getOutputRows() {
    return outputRows;
  }

  /**
   * Output only. Number of rows imported in a LOAD query. Note that while a LOAD query is in the
   * running state, this value may change.
   * @param outputRows outputRows or {@code null} for none
   */
  public LoadQueryStatistics setOutputRows(java.lang.Long outputRows) {
    this.outputRows = outputRows;
    return this;
  }

  @Override
  public LoadQueryStatistics set(String fieldName, Object value) {
    return (LoadQueryStatistics) super.set(fieldName, value);
  }

  @Override
  public LoadQueryStatistics clone() {
    return (LoadQueryStatistics) super.clone();
  }

}
