/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Reason about why no search index was used in the search query (or sub-query).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class IndexUnusedReason extends com.google.api.client.json.GenericJson {

  /**
   * Specifies the base table involved in the reason that no search index was used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TableReference baseTable;

  /**
   * Specifies the high-level reason for the scenario when no search index was used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String code;

  /**
   * Specifies the name of the unused search index, if available.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String indexName;

  /**
   * Free form human-readable reason for the scenario when no search index was used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String message;

  /**
   * Specifies the base table involved in the reason that no search index was used.
   * @return value or {@code null} for none
   */
  public TableReference getBaseTable() {
    return baseTable;
  }

  /**
   * Specifies the base table involved in the reason that no search index was used.
   * @param baseTable baseTable or {@code null} for none
   */
  public IndexUnusedReason setBaseTable(TableReference baseTable) {
    this.baseTable = baseTable;
    return this;
  }

  /**
   * Specifies the high-level reason for the scenario when no search index was used.
   * @return value or {@code null} for none
   */
  public java.lang.String getCode() {
    return code;
  }

  /**
   * Specifies the high-level reason for the scenario when no search index was used.
   * @param code code or {@code null} for none
   */
  public IndexUnusedReason setCode(java.lang.String code) {
    this.code = code;
    return this;
  }

  /**
   * Specifies the name of the unused search index, if available.
   * @return value or {@code null} for none
   */
  public java.lang.String getIndexName() {
    return indexName;
  }

  /**
   * Specifies the name of the unused search index, if available.
   * @param indexName indexName or {@code null} for none
   */
  public IndexUnusedReason setIndexName(java.lang.String indexName) {
    this.indexName = indexName;
    return this;
  }

  /**
   * Free form human-readable reason for the scenario when no search index was used.
   * @return value or {@code null} for none
   */
  public java.lang.String getMessage() {
    return message;
  }

  /**
   * Free form human-readable reason for the scenario when no search index was used.
   * @param message message or {@code null} for none
   */
  public IndexUnusedReason setMessage(java.lang.String message) {
    this.message = message;
    return this;
  }

  @Override
  public IndexUnusedReason set(String fieldName, Object value) {
    return (IndexUnusedReason) super.set(fieldName, value);
  }

  @Override
  public IndexUnusedReason clone() {
    return (IndexUnusedReason) super.clone();
  }

}
