/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Request message for the BatchDeleteRowAccessPoliciesRequest method.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BatchDeleteRowAccessPoliciesRequest extends com.google.api.client.json.GenericJson {

  /**
   * If set to true, it deletes the row access policy even if it's the last row access policy on the
   * table and the deletion will widen the access rather narrowing it.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean force;

  /**
   * Required. Policy IDs of the row access policies.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> policyIds;

  /**
   * If set to true, it deletes the row access policy even if it's the last row access policy on the
   * table and the deletion will widen the access rather narrowing it.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getForce() {
    return force;
  }

  /**
   * If set to true, it deletes the row access policy even if it's the last row access policy on the
   * table and the deletion will widen the access rather narrowing it.
   * @param force force or {@code null} for none
   */
  public BatchDeleteRowAccessPoliciesRequest setForce(java.lang.Boolean force) {
    this.force = force;
    return this;
  }

  /**
   * Required. Policy IDs of the row access policies.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getPolicyIds() {
    return policyIds;
  }

  /**
   * Required. Policy IDs of the row access policies.
   * @param policyIds policyIds or {@code null} for none
   */
  public BatchDeleteRowAccessPoliciesRequest setPolicyIds(java.util.List<java.lang.String> policyIds) {
    this.policyIds = policyIds;
    return this;
  }

  @Override
  public BatchDeleteRowAccessPoliciesRequest set(String fieldName, Object value) {
    return (BatchDeleteRowAccessPoliciesRequest) super.set(fieldName, value);
  }

  @Override
  public BatchDeleteRowAccessPoliciesRequest clone() {
    return (BatchDeleteRowAccessPoliciesRequest) super.clone();
  }

}
