/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Represents privacy policy associated with "aggregation threshold" method.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AggregationThresholdPolicy extends com.google.api.client.json.GenericJson {

  /**
   * Optional. The privacy unit column(s) associated with this policy. For now, only one column per
   * data source object (table, view) is allowed as a privacy unit column. Representing as a
   * repeated field in metadata for extensibility to multiple columns in future. Duplicates and
   * Repeated struct fields are not allowed. For nested fields, use dot notation ("outer.inner")
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> privacyUnitColumns;

  /**
   * Optional. The threshold for the "aggregation threshold" policy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long threshold;

  /**
   * Optional. The privacy unit column(s) associated with this policy. For now, only one column per
   * data source object (table, view) is allowed as a privacy unit column. Representing as a
   * repeated field in metadata for extensibility to multiple columns in future. Duplicates and
   * Repeated struct fields are not allowed. For nested fields, use dot notation ("outer.inner")
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getPrivacyUnitColumns() {
    return privacyUnitColumns;
  }

  /**
   * Optional. The privacy unit column(s) associated with this policy. For now, only one column per
   * data source object (table, view) is allowed as a privacy unit column. Representing as a
   * repeated field in metadata for extensibility to multiple columns in future. Duplicates and
   * Repeated struct fields are not allowed. For nested fields, use dot notation ("outer.inner")
   * @param privacyUnitColumns privacyUnitColumns or {@code null} for none
   */
  public AggregationThresholdPolicy setPrivacyUnitColumns(java.util.List<java.lang.String> privacyUnitColumns) {
    this.privacyUnitColumns = privacyUnitColumns;
    return this;
  }

  /**
   * Optional. The threshold for the "aggregation threshold" policy.
   * @return value or {@code null} for none
   */
  public java.lang.Long getThreshold() {
    return threshold;
  }

  /**
   * Optional. The threshold for the "aggregation threshold" policy.
   * @param threshold threshold or {@code null} for none
   */
  public AggregationThresholdPolicy setThreshold(java.lang.Long threshold) {
    this.threshold = threshold;
    return this;
  }

  @Override
  public AggregationThresholdPolicy set(String fieldName, Object value) {
    return (AggregationThresholdPolicy) super.set(fieldName, value);
  }

  @Override
  public AggregationThresholdPolicy clone() {
    return (AggregationThresholdPolicy) super.clone();
  }

}
