/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.bigquery;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.bigquery.BigqueryRequest;
import com.google.api.services.bigquery.BigqueryRequestInitializer;
import com.google.api.services.bigquery.model.BatchDeleteRowAccessPoliciesRequest;
import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.DatasetList;
import com.google.api.services.bigquery.model.GetIamPolicyRequest;
import com.google.api.services.bigquery.model.GetQueryResultsResponse;
import com.google.api.services.bigquery.model.GetServiceAccountResponse;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobCancelResponse;
import com.google.api.services.bigquery.model.JobList;
import com.google.api.services.bigquery.model.ListModelsResponse;
import com.google.api.services.bigquery.model.ListRoutinesResponse;
import com.google.api.services.bigquery.model.ListRowAccessPoliciesResponse;
import com.google.api.services.bigquery.model.Model;
import com.google.api.services.bigquery.model.Policy;
import com.google.api.services.bigquery.model.ProjectList;
import com.google.api.services.bigquery.model.QueryRequest;
import com.google.api.services.bigquery.model.QueryResponse;
import com.google.api.services.bigquery.model.Routine;
import com.google.api.services.bigquery.model.RowAccessPolicy;
import com.google.api.services.bigquery.model.SetIamPolicyRequest;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableDataInsertAllRequest;
import com.google.api.services.bigquery.model.TableDataInsertAllResponse;
import com.google.api.services.bigquery.model.TableDataList;
import com.google.api.services.bigquery.model.TableList;
import com.google.api.services.bigquery.model.TestIamPermissionsRequest;
import com.google.api.services.bigquery.model.TestIamPermissionsResponse;
import com.google.api.services.bigquery.model.UndeleteDatasetRequest;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.regex.Pattern;

public class Bigquery
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://bigquery.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://bigquery.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "bigquery/v2/";
    public static final String DEFAULT_BATCH_PATH = "batch/bigquery/v2";
    public static final String DEFAULT_BASE_URL = "https://bigquery.googleapis.com/bigquery/v2/";

    public Bigquery(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Bigquery(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Datasets datasets() {
        return new Datasets();
    }

    public Jobs jobs() {
        return new Jobs();
    }

    public Models models() {
        return new Models();
    }

    public Projects projects() {
        return new Projects();
    }

    public Routines routines() {
        return new Routines();
    }

    public RowAccessPolicies rowAccessPolicies() {
        return new RowAccessPolicies();
    }

    public Tabledata tabledata() {
        return new Tabledata();
    }

    public Tables tables() {
        return new Tables();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the BigQuery API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return Bigquery.DEFAULT_MTLS_ROOT_URL;
            }
            return Bigquery.DEFAULT_ROOT_URL;
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), Bigquery.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Bigquery.DEFAULT_BATCH_PATH);
        }

        public Bigquery build() {
            return new Bigquery(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setBigqueryRequestInitializer(BigqueryRequestInitializer bigqueryRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)bigqueryRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }

        public Builder setUniverseDomain(String universeDomain) {
            return (Builder)super.setUniverseDomain(universeDomain);
        }
    }

    public class Tables {
        public Delete delete(String projectId, String datasetId, String tableId) throws IOException {
            Delete result = new Delete(projectId, datasetId, tableId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String projectId, String datasetId, String tableId) throws IOException {
            Get result = new Get(projectId, datasetId, tableId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetIamPolicy getIamPolicy(String resource, GetIamPolicyRequest content) throws IOException {
            GetIamPolicy result = new GetIamPolicy(resource, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String projectId, String datasetId, Table content) throws IOException {
            Insert result = new Insert(projectId, datasetId, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String projectId, String datasetId) throws IOException {
            List result = new List(projectId, datasetId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String projectId, String datasetId, String tableId, Table content) throws IOException {
            Patch result = new Patch(projectId, datasetId, tableId, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetIamPolicy setIamPolicy(String resource, SetIamPolicyRequest content) throws IOException {
            SetIamPolicy result = new SetIamPolicy(resource, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public TestIamPermissions testIamPermissions(String resource, TestIamPermissionsRequest content) throws IOException {
            TestIamPermissions result = new TestIamPermissions(resource, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String projectId, String datasetId, String tableId, Table content) throws IOException {
            Update result = new Update(projectId, datasetId, tableId, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends BigqueryRequest<Table> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/tables/{+tableId}";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            private final Pattern TABLE_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String tableId;
            @Key(value="autodetect_schema")
            private Boolean autodetectSchema;

            protected Update(String projectId, String datasetId, String tableId, Table content) {
                super(Bigquery.this, "PUT", REST_PATH, (Object)content, Table.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.TABLE_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.tableId = (String)Preconditions.checkNotNull((Object)tableId, (Object)"Required parameter tableId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TABLE_ID_PATTERN.matcher(tableId).matches(), (Object)"Parameter tableId must conform to the pattern ^[^/]+$");
                }
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Update setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Update setDatasetId(String datasetId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = datasetId;
                return this;
            }

            public String getTableId() {
                return this.tableId;
            }

            public Update setTableId(String tableId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TABLE_ID_PATTERN.matcher(tableId).matches(), (Object)"Parameter tableId must conform to the pattern ^[^/]+$");
                }
                this.tableId = tableId;
                return this;
            }

            public Boolean getAutodetectSchema() {
                return this.autodetectSchema;
            }

            public Update setAutodetectSchema(Boolean autodetectSchema) {
                this.autodetectSchema = autodetectSchema;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class TestIamPermissions
        extends BigqueryRequest<TestIamPermissionsResponse> {
            private static final String REST_PATH = "{+resource}:testIamPermissions";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected TestIamPermissions(String resource, TestIamPermissionsRequest content) {
                super(Bigquery.this, "POST", REST_PATH, (Object)content, TestIamPermissionsResponse.class);
                this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/datasets/[^/]+/tables/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/datasets/[^/]+/tables/[^/]+$");
                }
            }

            public TestIamPermissions set$Xgafv(String $Xgafv) {
                return (TestIamPermissions)super.set$Xgafv($Xgafv);
            }

            public TestIamPermissions setAccessToken(String accessToken) {
                return (TestIamPermissions)super.setAccessToken(accessToken);
            }

            public TestIamPermissions setAlt(String alt) {
                return (TestIamPermissions)super.setAlt(alt);
            }

            public TestIamPermissions setCallback(String callback) {
                return (TestIamPermissions)super.setCallback(callback);
            }

            public TestIamPermissions setFields(String fields) {
                return (TestIamPermissions)super.setFields(fields);
            }

            public TestIamPermissions setKey(String key) {
                return (TestIamPermissions)super.setKey(key);
            }

            public TestIamPermissions setOauthToken(String oauthToken) {
                return (TestIamPermissions)super.setOauthToken(oauthToken);
            }

            public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
            }

            public TestIamPermissions setQuotaUser(String quotaUser) {
                return (TestIamPermissions)super.setQuotaUser(quotaUser);
            }

            public TestIamPermissions setUploadType(String uploadType) {
                return (TestIamPermissions)super.setUploadType(uploadType);
            }

            public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public TestIamPermissions setResource(String resource) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/datasets/[^/]+/tables/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public TestIamPermissions set(String parameterName, Object value) {
                return (TestIamPermissions)super.set(parameterName, value);
            }
        }

        public class SetIamPolicy
        extends BigqueryRequest<Policy> {
            private static final String REST_PATH = "{+resource}:setIamPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected SetIamPolicy(String resource, SetIamPolicyRequest content) {
                super(Bigquery.this, "POST", REST_PATH, (Object)content, Policy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/datasets/[^/]+/tables/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/datasets/[^/]+/tables/[^/]+$");
                }
            }

            public SetIamPolicy set$Xgafv(String $Xgafv) {
                return (SetIamPolicy)super.set$Xgafv($Xgafv);
            }

            public SetIamPolicy setAccessToken(String accessToken) {
                return (SetIamPolicy)super.setAccessToken(accessToken);
            }

            public SetIamPolicy setAlt(String alt) {
                return (SetIamPolicy)super.setAlt(alt);
            }

            public SetIamPolicy setCallback(String callback) {
                return (SetIamPolicy)super.setCallback(callback);
            }

            public SetIamPolicy setFields(String fields) {
                return (SetIamPolicy)super.setFields(fields);
            }

            public SetIamPolicy setKey(String key) {
                return (SetIamPolicy)super.setKey(key);
            }

            public SetIamPolicy setOauthToken(String oauthToken) {
                return (SetIamPolicy)super.setOauthToken(oauthToken);
            }

            public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
            }

            public SetIamPolicy setQuotaUser(String quotaUser) {
                return (SetIamPolicy)super.setQuotaUser(quotaUser);
            }

            public SetIamPolicy setUploadType(String uploadType) {
                return (SetIamPolicy)super.setUploadType(uploadType);
            }

            public SetIamPolicy setUploadProtocol(String uploadProtocol) {
                return (SetIamPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public SetIamPolicy setResource(String resource) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/datasets/[^/]+/tables/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public SetIamPolicy set(String parameterName, Object value) {
                return (SetIamPolicy)super.set(parameterName, value);
            }
        }

        public class Patch
        extends BigqueryRequest<Table> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/tables/{+tableId}";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            private final Pattern TABLE_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String tableId;
            @Key(value="autodetect_schema")
            private Boolean autodetectSchema;

            protected Patch(String projectId, String datasetId, String tableId, Table content) {
                super(Bigquery.this, "PATCH", REST_PATH, (Object)content, Table.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.TABLE_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.tableId = (String)Preconditions.checkNotNull((Object)tableId, (Object)"Required parameter tableId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TABLE_ID_PATTERN.matcher(tableId).matches(), (Object)"Parameter tableId must conform to the pattern ^[^/]+$");
                }
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Patch setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Patch setDatasetId(String datasetId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = datasetId;
                return this;
            }

            public String getTableId() {
                return this.tableId;
            }

            public Patch setTableId(String tableId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TABLE_ID_PATTERN.matcher(tableId).matches(), (Object)"Parameter tableId must conform to the pattern ^[^/]+$");
                }
                this.tableId = tableId;
                return this;
            }

            public Boolean getAutodetectSchema() {
                return this.autodetectSchema;
            }

            public Patch setAutodetectSchema(Boolean autodetectSchema) {
                this.autodetectSchema = autodetectSchema;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends BigqueryRequest<TableList> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/tables";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String projectId, String datasetId) {
                super(Bigquery.this, "GET", REST_PATH, null, TableList.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public List setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public List setDatasetId(String datasetId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = datasetId;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends BigqueryRequest<Table> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/tables";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;

            protected Insert(String projectId, String datasetId, Table content) {
                super(Bigquery.this, "POST", REST_PATH, (Object)content, Table.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Insert setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Insert setDatasetId(String datasetId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = datasetId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class GetIamPolicy
        extends BigqueryRequest<Policy> {
            private static final String REST_PATH = "{+resource}:getIamPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected GetIamPolicy(String resource, GetIamPolicyRequest content) {
                super(Bigquery.this, "POST", REST_PATH, (Object)content, Policy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/datasets/[^/]+/tables/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/datasets/[^/]+/tables/[^/]+$");
                }
            }

            public GetIamPolicy set$Xgafv(String $Xgafv) {
                return (GetIamPolicy)super.set$Xgafv($Xgafv);
            }

            public GetIamPolicy setAccessToken(String accessToken) {
                return (GetIamPolicy)super.setAccessToken(accessToken);
            }

            public GetIamPolicy setAlt(String alt) {
                return (GetIamPolicy)super.setAlt(alt);
            }

            public GetIamPolicy setCallback(String callback) {
                return (GetIamPolicy)super.setCallback(callback);
            }

            public GetIamPolicy setFields(String fields) {
                return (GetIamPolicy)super.setFields(fields);
            }

            public GetIamPolicy setKey(String key) {
                return (GetIamPolicy)super.setKey(key);
            }

            public GetIamPolicy setOauthToken(String oauthToken) {
                return (GetIamPolicy)super.setOauthToken(oauthToken);
            }

            public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
            }

            public GetIamPolicy setQuotaUser(String quotaUser) {
                return (GetIamPolicy)super.setQuotaUser(quotaUser);
            }

            public GetIamPolicy setUploadType(String uploadType) {
                return (GetIamPolicy)super.setUploadType(uploadType);
            }

            public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public GetIamPolicy setResource(String resource) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/datasets/[^/]+/tables/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public GetIamPolicy set(String parameterName, Object value) {
                return (GetIamPolicy)super.set(parameterName, value);
            }
        }

        public class Get
        extends BigqueryRequest<Table> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/tables/{+tableId}";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            private final Pattern TABLE_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String tableId;
            @Key
            private String selectedFields;
            @Key
            private String view;

            protected Get(String projectId, String datasetId, String tableId) {
                super(Bigquery.this, "GET", REST_PATH, null, Table.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.TABLE_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.tableId = (String)Preconditions.checkNotNull((Object)tableId, (Object)"Required parameter tableId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TABLE_ID_PATTERN.matcher(tableId).matches(), (Object)"Parameter tableId must conform to the pattern ^[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Get setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Get setDatasetId(String datasetId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = datasetId;
                return this;
            }

            public String getTableId() {
                return this.tableId;
            }

            public Get setTableId(String tableId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TABLE_ID_PATTERN.matcher(tableId).matches(), (Object)"Parameter tableId must conform to the pattern ^[^/]+$");
                }
                this.tableId = tableId;
                return this;
            }

            public String getSelectedFields() {
                return this.selectedFields;
            }

            public Get setSelectedFields(String selectedFields) {
                this.selectedFields = selectedFields;
                return this;
            }

            public String getView() {
                return this.view;
            }

            public Get setView(String view) {
                this.view = view;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends BigqueryRequest<Void> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/tables/{+tableId}";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            private final Pattern TABLE_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String tableId;

            protected Delete(String projectId, String datasetId, String tableId) {
                super(Bigquery.this, "DELETE", REST_PATH, null, Void.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.TABLE_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.tableId = (String)Preconditions.checkNotNull((Object)tableId, (Object)"Required parameter tableId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TABLE_ID_PATTERN.matcher(tableId).matches(), (Object)"Parameter tableId must conform to the pattern ^[^/]+$");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Delete setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Delete setDatasetId(String datasetId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = datasetId;
                return this;
            }

            public String getTableId() {
                return this.tableId;
            }

            public Delete setTableId(String tableId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TABLE_ID_PATTERN.matcher(tableId).matches(), (Object)"Parameter tableId must conform to the pattern ^[^/]+$");
                }
                this.tableId = tableId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class Tabledata {
        public InsertAll insertAll(String projectId, String datasetId, String tableId, TableDataInsertAllRequest content) throws IOException {
            InsertAll result = new InsertAll(projectId, datasetId, tableId, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String projectId, String datasetId, String tableId) throws IOException {
            List result = new List(projectId, datasetId, tableId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends BigqueryRequest<TableDataList> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/tables/{+tableId}/data";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            private final Pattern TABLE_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String tableId;
            @Key(value="formatOptions.useInt64Timestamp")
            private Boolean formatOptionsUseInt64Timestamp;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String selectedFields;
            @Key
            private BigInteger startIndex;

            protected List(String projectId, String datasetId, String tableId) {
                super(Bigquery.this, "GET", REST_PATH, null, TableDataList.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.TABLE_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.tableId = (String)Preconditions.checkNotNull((Object)tableId, (Object)"Required parameter tableId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TABLE_ID_PATTERN.matcher(tableId).matches(), (Object)"Parameter tableId must conform to the pattern ^[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public List setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public List setDatasetId(String datasetId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = datasetId;
                return this;
            }

            public String getTableId() {
                return this.tableId;
            }

            public List setTableId(String tableId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TABLE_ID_PATTERN.matcher(tableId).matches(), (Object)"Parameter tableId must conform to the pattern ^[^/]+$");
                }
                this.tableId = tableId;
                return this;
            }

            public Boolean getFormatOptionsUseInt64Timestamp() {
                return this.formatOptionsUseInt64Timestamp;
            }

            public List setFormatOptionsUseInt64Timestamp(Boolean formatOptionsUseInt64Timestamp) {
                this.formatOptionsUseInt64Timestamp = formatOptionsUseInt64Timestamp;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getSelectedFields() {
                return this.selectedFields;
            }

            public List setSelectedFields(String selectedFields) {
                this.selectedFields = selectedFields;
                return this;
            }

            public BigInteger getStartIndex() {
                return this.startIndex;
            }

            public List setStartIndex(BigInteger startIndex) {
                this.startIndex = startIndex;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class InsertAll
        extends BigqueryRequest<TableDataInsertAllResponse> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/tables/{+tableId}/insertAll";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            private final Pattern TABLE_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String tableId;

            protected InsertAll(String projectId, String datasetId, String tableId, TableDataInsertAllRequest content) {
                super(Bigquery.this, "POST", REST_PATH, (Object)content, TableDataInsertAllResponse.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.TABLE_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.tableId = (String)Preconditions.checkNotNull((Object)tableId, (Object)"Required parameter tableId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TABLE_ID_PATTERN.matcher(tableId).matches(), (Object)"Parameter tableId must conform to the pattern ^[^/]+$");
                }
            }

            public InsertAll set$Xgafv(String $Xgafv) {
                return (InsertAll)super.set$Xgafv($Xgafv);
            }

            public InsertAll setAccessToken(String accessToken) {
                return (InsertAll)super.setAccessToken(accessToken);
            }

            public InsertAll setAlt(String alt) {
                return (InsertAll)super.setAlt(alt);
            }

            public InsertAll setCallback(String callback) {
                return (InsertAll)super.setCallback(callback);
            }

            public InsertAll setFields(String fields) {
                return (InsertAll)super.setFields(fields);
            }

            public InsertAll setKey(String key) {
                return (InsertAll)super.setKey(key);
            }

            public InsertAll setOauthToken(String oauthToken) {
                return (InsertAll)super.setOauthToken(oauthToken);
            }

            public InsertAll setPrettyPrint(Boolean prettyPrint) {
                return (InsertAll)super.setPrettyPrint(prettyPrint);
            }

            public InsertAll setQuotaUser(String quotaUser) {
                return (InsertAll)super.setQuotaUser(quotaUser);
            }

            public InsertAll setUploadType(String uploadType) {
                return (InsertAll)super.setUploadType(uploadType);
            }

            public InsertAll setUploadProtocol(String uploadProtocol) {
                return (InsertAll)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public InsertAll setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public InsertAll setDatasetId(String datasetId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = datasetId;
                return this;
            }

            public String getTableId() {
                return this.tableId;
            }

            public InsertAll setTableId(String tableId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TABLE_ID_PATTERN.matcher(tableId).matches(), (Object)"Parameter tableId must conform to the pattern ^[^/]+$");
                }
                this.tableId = tableId;
                return this;
            }

            @Override
            public InsertAll set(String parameterName, Object value) {
                return (InsertAll)super.set(parameterName, value);
            }
        }
    }

    public class RowAccessPolicies {
        public BatchDelete batchDelete(String projectId, String datasetId, String tableId, BatchDeleteRowAccessPoliciesRequest content) throws IOException {
            BatchDelete result = new BatchDelete(projectId, datasetId, tableId, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String projectId, String datasetId, String tableId, String policyId) throws IOException {
            Delete result = new Delete(projectId, datasetId, tableId, policyId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String projectId, String datasetId, String tableId, String policyId) throws IOException {
            Get result = new Get(projectId, datasetId, tableId, policyId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetIamPolicy getIamPolicy(String resource, GetIamPolicyRequest content) throws IOException {
            GetIamPolicy result = new GetIamPolicy(resource, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String projectId, String datasetId, String tableId, RowAccessPolicy content) throws IOException {
            Insert result = new Insert(projectId, datasetId, tableId, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String projectId, String datasetId, String tableId) throws IOException {
            List result = new List(projectId, datasetId, tableId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public TestIamPermissions testIamPermissions(String resource, TestIamPermissionsRequest content) throws IOException {
            TestIamPermissions result = new TestIamPermissions(resource, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String projectId, String datasetId, String tableId, String policyId, RowAccessPolicy content) throws IOException {
            Update result = new Update(projectId, datasetId, tableId, policyId, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends BigqueryRequest<RowAccessPolicy> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/tables/{+tableId}/rowAccessPolicies/{+policyId}";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            private final Pattern TABLE_ID_PATTERN;
            private final Pattern POLICY_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String tableId;
            @Key
            private String policyId;

            protected Update(String projectId, String datasetId, String tableId, String policyId, RowAccessPolicy content) {
                super(Bigquery.this, "PUT", REST_PATH, (Object)content, RowAccessPolicy.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.TABLE_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.POLICY_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.tableId = (String)Preconditions.checkNotNull((Object)tableId, (Object)"Required parameter tableId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TABLE_ID_PATTERN.matcher(tableId).matches(), (Object)"Parameter tableId must conform to the pattern ^[^/]+$");
                }
                this.policyId = (String)Preconditions.checkNotNull((Object)policyId, (Object)"Required parameter policyId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.POLICY_ID_PATTERN.matcher(policyId).matches(), (Object)"Parameter policyId must conform to the pattern ^[^/]+$");
                }
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Update setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Update setDatasetId(String datasetId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = datasetId;
                return this;
            }

            public String getTableId() {
                return this.tableId;
            }

            public Update setTableId(String tableId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TABLE_ID_PATTERN.matcher(tableId).matches(), (Object)"Parameter tableId must conform to the pattern ^[^/]+$");
                }
                this.tableId = tableId;
                return this;
            }

            public String getPolicyId() {
                return this.policyId;
            }

            public Update setPolicyId(String policyId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.POLICY_ID_PATTERN.matcher(policyId).matches(), (Object)"Parameter policyId must conform to the pattern ^[^/]+$");
                }
                this.policyId = policyId;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class TestIamPermissions
        extends BigqueryRequest<TestIamPermissionsResponse> {
            private static final String REST_PATH = "{+resource}:testIamPermissions";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected TestIamPermissions(String resource, TestIamPermissionsRequest content) {
                super(Bigquery.this, "POST", REST_PATH, (Object)content, TestIamPermissionsResponse.class);
                this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/datasets/[^/]+/tables/[^/]+/rowAccessPolicies/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/datasets/[^/]+/tables/[^/]+/rowAccessPolicies/[^/]+$");
                }
            }

            public TestIamPermissions set$Xgafv(String $Xgafv) {
                return (TestIamPermissions)super.set$Xgafv($Xgafv);
            }

            public TestIamPermissions setAccessToken(String accessToken) {
                return (TestIamPermissions)super.setAccessToken(accessToken);
            }

            public TestIamPermissions setAlt(String alt) {
                return (TestIamPermissions)super.setAlt(alt);
            }

            public TestIamPermissions setCallback(String callback) {
                return (TestIamPermissions)super.setCallback(callback);
            }

            public TestIamPermissions setFields(String fields) {
                return (TestIamPermissions)super.setFields(fields);
            }

            public TestIamPermissions setKey(String key) {
                return (TestIamPermissions)super.setKey(key);
            }

            public TestIamPermissions setOauthToken(String oauthToken) {
                return (TestIamPermissions)super.setOauthToken(oauthToken);
            }

            public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
            }

            public TestIamPermissions setQuotaUser(String quotaUser) {
                return (TestIamPermissions)super.setQuotaUser(quotaUser);
            }

            public TestIamPermissions setUploadType(String uploadType) {
                return (TestIamPermissions)super.setUploadType(uploadType);
            }

            public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public TestIamPermissions setResource(String resource) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/datasets/[^/]+/tables/[^/]+/rowAccessPolicies/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public TestIamPermissions set(String parameterName, Object value) {
                return (TestIamPermissions)super.set(parameterName, value);
            }
        }

        public class List
        extends BigqueryRequest<ListRowAccessPoliciesResponse> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/tables/{+tableId}/rowAccessPolicies";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            private final Pattern TABLE_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String tableId;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List(String projectId, String datasetId, String tableId) {
                super(Bigquery.this, "GET", REST_PATH, null, ListRowAccessPoliciesResponse.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.TABLE_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.tableId = (String)Preconditions.checkNotNull((Object)tableId, (Object)"Required parameter tableId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TABLE_ID_PATTERN.matcher(tableId).matches(), (Object)"Parameter tableId must conform to the pattern ^[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public List setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public List setDatasetId(String datasetId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = datasetId;
                return this;
            }

            public String getTableId() {
                return this.tableId;
            }

            public List setTableId(String tableId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TABLE_ID_PATTERN.matcher(tableId).matches(), (Object)"Parameter tableId must conform to the pattern ^[^/]+$");
                }
                this.tableId = tableId;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends BigqueryRequest<RowAccessPolicy> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/tables/{+tableId}/rowAccessPolicies";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            private final Pattern TABLE_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String tableId;

            protected Insert(String projectId, String datasetId, String tableId, RowAccessPolicy content) {
                super(Bigquery.this, "POST", REST_PATH, (Object)content, RowAccessPolicy.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.TABLE_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.tableId = (String)Preconditions.checkNotNull((Object)tableId, (Object)"Required parameter tableId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TABLE_ID_PATTERN.matcher(tableId).matches(), (Object)"Parameter tableId must conform to the pattern ^[^/]+$");
                }
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Insert setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Insert setDatasetId(String datasetId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = datasetId;
                return this;
            }

            public String getTableId() {
                return this.tableId;
            }

            public Insert setTableId(String tableId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TABLE_ID_PATTERN.matcher(tableId).matches(), (Object)"Parameter tableId must conform to the pattern ^[^/]+$");
                }
                this.tableId = tableId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class GetIamPolicy
        extends BigqueryRequest<Policy> {
            private static final String REST_PATH = "{+resource}:getIamPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected GetIamPolicy(String resource, GetIamPolicyRequest content) {
                super(Bigquery.this, "POST", REST_PATH, (Object)content, Policy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/datasets/[^/]+/tables/[^/]+/rowAccessPolicies/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/datasets/[^/]+/tables/[^/]+/rowAccessPolicies/[^/]+$");
                }
            }

            public GetIamPolicy set$Xgafv(String $Xgafv) {
                return (GetIamPolicy)super.set$Xgafv($Xgafv);
            }

            public GetIamPolicy setAccessToken(String accessToken) {
                return (GetIamPolicy)super.setAccessToken(accessToken);
            }

            public GetIamPolicy setAlt(String alt) {
                return (GetIamPolicy)super.setAlt(alt);
            }

            public GetIamPolicy setCallback(String callback) {
                return (GetIamPolicy)super.setCallback(callback);
            }

            public GetIamPolicy setFields(String fields) {
                return (GetIamPolicy)super.setFields(fields);
            }

            public GetIamPolicy setKey(String key) {
                return (GetIamPolicy)super.setKey(key);
            }

            public GetIamPolicy setOauthToken(String oauthToken) {
                return (GetIamPolicy)super.setOauthToken(oauthToken);
            }

            public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
            }

            public GetIamPolicy setQuotaUser(String quotaUser) {
                return (GetIamPolicy)super.setQuotaUser(quotaUser);
            }

            public GetIamPolicy setUploadType(String uploadType) {
                return (GetIamPolicy)super.setUploadType(uploadType);
            }

            public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public GetIamPolicy setResource(String resource) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/datasets/[^/]+/tables/[^/]+/rowAccessPolicies/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public GetIamPolicy set(String parameterName, Object value) {
                return (GetIamPolicy)super.set(parameterName, value);
            }
        }

        public class Get
        extends BigqueryRequest<RowAccessPolicy> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/tables/{+tableId}/rowAccessPolicies/{+policyId}";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            private final Pattern TABLE_ID_PATTERN;
            private final Pattern POLICY_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String tableId;
            @Key
            private String policyId;

            protected Get(String projectId, String datasetId, String tableId, String policyId) {
                super(Bigquery.this, "GET", REST_PATH, null, RowAccessPolicy.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.TABLE_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.POLICY_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.tableId = (String)Preconditions.checkNotNull((Object)tableId, (Object)"Required parameter tableId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TABLE_ID_PATTERN.matcher(tableId).matches(), (Object)"Parameter tableId must conform to the pattern ^[^/]+$");
                }
                this.policyId = (String)Preconditions.checkNotNull((Object)policyId, (Object)"Required parameter policyId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.POLICY_ID_PATTERN.matcher(policyId).matches(), (Object)"Parameter policyId must conform to the pattern ^[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Get setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Get setDatasetId(String datasetId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = datasetId;
                return this;
            }

            public String getTableId() {
                return this.tableId;
            }

            public Get setTableId(String tableId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TABLE_ID_PATTERN.matcher(tableId).matches(), (Object)"Parameter tableId must conform to the pattern ^[^/]+$");
                }
                this.tableId = tableId;
                return this;
            }

            public String getPolicyId() {
                return this.policyId;
            }

            public Get setPolicyId(String policyId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.POLICY_ID_PATTERN.matcher(policyId).matches(), (Object)"Parameter policyId must conform to the pattern ^[^/]+$");
                }
                this.policyId = policyId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends BigqueryRequest<Void> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/tables/{+tableId}/rowAccessPolicies/{+policyId}";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            private final Pattern TABLE_ID_PATTERN;
            private final Pattern POLICY_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String tableId;
            @Key
            private String policyId;
            @Key
            private Boolean force;

            protected Delete(String projectId, String datasetId, String tableId, String policyId) {
                super(Bigquery.this, "DELETE", REST_PATH, null, Void.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.TABLE_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.POLICY_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.tableId = (String)Preconditions.checkNotNull((Object)tableId, (Object)"Required parameter tableId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TABLE_ID_PATTERN.matcher(tableId).matches(), (Object)"Parameter tableId must conform to the pattern ^[^/]+$");
                }
                this.policyId = (String)Preconditions.checkNotNull((Object)policyId, (Object)"Required parameter policyId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.POLICY_ID_PATTERN.matcher(policyId).matches(), (Object)"Parameter policyId must conform to the pattern ^[^/]+$");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Delete setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Delete setDatasetId(String datasetId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = datasetId;
                return this;
            }

            public String getTableId() {
                return this.tableId;
            }

            public Delete setTableId(String tableId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TABLE_ID_PATTERN.matcher(tableId).matches(), (Object)"Parameter tableId must conform to the pattern ^[^/]+$");
                }
                this.tableId = tableId;
                return this;
            }

            public String getPolicyId() {
                return this.policyId;
            }

            public Delete setPolicyId(String policyId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.POLICY_ID_PATTERN.matcher(policyId).matches(), (Object)"Parameter policyId must conform to the pattern ^[^/]+$");
                }
                this.policyId = policyId;
                return this;
            }

            public Boolean getForce() {
                return this.force;
            }

            public Delete setForce(Boolean force) {
                this.force = force;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class BatchDelete
        extends BigqueryRequest<Void> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/tables/{+tableId}/rowAccessPolicies:batchDelete";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            private final Pattern TABLE_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String tableId;

            protected BatchDelete(String projectId, String datasetId, String tableId, BatchDeleteRowAccessPoliciesRequest content) {
                super(Bigquery.this, "POST", REST_PATH, (Object)content, Void.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.TABLE_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.tableId = (String)Preconditions.checkNotNull((Object)tableId, (Object)"Required parameter tableId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TABLE_ID_PATTERN.matcher(tableId).matches(), (Object)"Parameter tableId must conform to the pattern ^[^/]+$");
                }
            }

            public BatchDelete set$Xgafv(String $Xgafv) {
                return (BatchDelete)super.set$Xgafv($Xgafv);
            }

            public BatchDelete setAccessToken(String accessToken) {
                return (BatchDelete)super.setAccessToken(accessToken);
            }

            public BatchDelete setAlt(String alt) {
                return (BatchDelete)super.setAlt(alt);
            }

            public BatchDelete setCallback(String callback) {
                return (BatchDelete)super.setCallback(callback);
            }

            public BatchDelete setFields(String fields) {
                return (BatchDelete)super.setFields(fields);
            }

            public BatchDelete setKey(String key) {
                return (BatchDelete)super.setKey(key);
            }

            public BatchDelete setOauthToken(String oauthToken) {
                return (BatchDelete)super.setOauthToken(oauthToken);
            }

            public BatchDelete setPrettyPrint(Boolean prettyPrint) {
                return (BatchDelete)super.setPrettyPrint(prettyPrint);
            }

            public BatchDelete setQuotaUser(String quotaUser) {
                return (BatchDelete)super.setQuotaUser(quotaUser);
            }

            public BatchDelete setUploadType(String uploadType) {
                return (BatchDelete)super.setUploadType(uploadType);
            }

            public BatchDelete setUploadProtocol(String uploadProtocol) {
                return (BatchDelete)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public BatchDelete setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public BatchDelete setDatasetId(String datasetId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = datasetId;
                return this;
            }

            public String getTableId() {
                return this.tableId;
            }

            public BatchDelete setTableId(String tableId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TABLE_ID_PATTERN.matcher(tableId).matches(), (Object)"Parameter tableId must conform to the pattern ^[^/]+$");
                }
                this.tableId = tableId;
                return this;
            }

            @Override
            public BatchDelete set(String parameterName, Object value) {
                return (BatchDelete)super.set(parameterName, value);
            }
        }
    }

    public class Routines {
        public Delete delete(String projectId, String datasetId, String routineId) throws IOException {
            Delete result = new Delete(projectId, datasetId, routineId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String projectId, String datasetId, String routineId) throws IOException {
            Get result = new Get(projectId, datasetId, routineId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetIamPolicy getIamPolicy(String resource, GetIamPolicyRequest content) throws IOException {
            GetIamPolicy result = new GetIamPolicy(resource, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String projectId, String datasetId, Routine content) throws IOException {
            Insert result = new Insert(projectId, datasetId, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String projectId, String datasetId) throws IOException {
            List result = new List(projectId, datasetId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetIamPolicy setIamPolicy(String resource, SetIamPolicyRequest content) throws IOException {
            SetIamPolicy result = new SetIamPolicy(resource, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String projectId, String datasetId, String routineId, Routine content) throws IOException {
            Update result = new Update(projectId, datasetId, routineId, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends BigqueryRequest<Routine> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/routines/{+routineId}";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            private final Pattern ROUTINE_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String routineId;

            protected Update(String projectId, String datasetId, String routineId, Routine content) {
                super(Bigquery.this, "PUT", REST_PATH, (Object)content, Routine.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.ROUTINE_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.routineId = (String)Preconditions.checkNotNull((Object)routineId, (Object)"Required parameter routineId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ROUTINE_ID_PATTERN.matcher(routineId).matches(), (Object)"Parameter routineId must conform to the pattern ^[^/]+$");
                }
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Update setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Update setDatasetId(String datasetId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = datasetId;
                return this;
            }

            public String getRoutineId() {
                return this.routineId;
            }

            public Update setRoutineId(String routineId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ROUTINE_ID_PATTERN.matcher(routineId).matches(), (Object)"Parameter routineId must conform to the pattern ^[^/]+$");
                }
                this.routineId = routineId;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class SetIamPolicy
        extends BigqueryRequest<Policy> {
            private static final String REST_PATH = "{+resource}:setIamPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected SetIamPolicy(String resource, SetIamPolicyRequest content) {
                super(Bigquery.this, "POST", REST_PATH, (Object)content, Policy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/datasets/[^/]+/routines/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/datasets/[^/]+/routines/[^/]+$");
                }
            }

            public SetIamPolicy set$Xgafv(String $Xgafv) {
                return (SetIamPolicy)super.set$Xgafv($Xgafv);
            }

            public SetIamPolicy setAccessToken(String accessToken) {
                return (SetIamPolicy)super.setAccessToken(accessToken);
            }

            public SetIamPolicy setAlt(String alt) {
                return (SetIamPolicy)super.setAlt(alt);
            }

            public SetIamPolicy setCallback(String callback) {
                return (SetIamPolicy)super.setCallback(callback);
            }

            public SetIamPolicy setFields(String fields) {
                return (SetIamPolicy)super.setFields(fields);
            }

            public SetIamPolicy setKey(String key) {
                return (SetIamPolicy)super.setKey(key);
            }

            public SetIamPolicy setOauthToken(String oauthToken) {
                return (SetIamPolicy)super.setOauthToken(oauthToken);
            }

            public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
            }

            public SetIamPolicy setQuotaUser(String quotaUser) {
                return (SetIamPolicy)super.setQuotaUser(quotaUser);
            }

            public SetIamPolicy setUploadType(String uploadType) {
                return (SetIamPolicy)super.setUploadType(uploadType);
            }

            public SetIamPolicy setUploadProtocol(String uploadProtocol) {
                return (SetIamPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public SetIamPolicy setResource(String resource) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/datasets/[^/]+/routines/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public SetIamPolicy set(String parameterName, Object value) {
                return (SetIamPolicy)super.set(parameterName, value);
            }
        }

        public class List
        extends BigqueryRequest<ListRoutinesResponse> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/routines";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String readMask;

            protected List(String projectId, String datasetId) {
                super(Bigquery.this, "GET", REST_PATH, null, ListRoutinesResponse.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public List setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public List setDatasetId(String datasetId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = datasetId;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getReadMask() {
                return this.readMask;
            }

            public List setReadMask(String readMask) {
                this.readMask = readMask;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends BigqueryRequest<Routine> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/routines";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;

            protected Insert(String projectId, String datasetId, Routine content) {
                super(Bigquery.this, "POST", REST_PATH, (Object)content, Routine.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Insert setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Insert setDatasetId(String datasetId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = datasetId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class GetIamPolicy
        extends BigqueryRequest<Policy> {
            private static final String REST_PATH = "{+resource}:getIamPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected GetIamPolicy(String resource, GetIamPolicyRequest content) {
                super(Bigquery.this, "POST", REST_PATH, (Object)content, Policy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/datasets/[^/]+/routines/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/datasets/[^/]+/routines/[^/]+$");
                }
            }

            public GetIamPolicy set$Xgafv(String $Xgafv) {
                return (GetIamPolicy)super.set$Xgafv($Xgafv);
            }

            public GetIamPolicy setAccessToken(String accessToken) {
                return (GetIamPolicy)super.setAccessToken(accessToken);
            }

            public GetIamPolicy setAlt(String alt) {
                return (GetIamPolicy)super.setAlt(alt);
            }

            public GetIamPolicy setCallback(String callback) {
                return (GetIamPolicy)super.setCallback(callback);
            }

            public GetIamPolicy setFields(String fields) {
                return (GetIamPolicy)super.setFields(fields);
            }

            public GetIamPolicy setKey(String key) {
                return (GetIamPolicy)super.setKey(key);
            }

            public GetIamPolicy setOauthToken(String oauthToken) {
                return (GetIamPolicy)super.setOauthToken(oauthToken);
            }

            public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
            }

            public GetIamPolicy setQuotaUser(String quotaUser) {
                return (GetIamPolicy)super.setQuotaUser(quotaUser);
            }

            public GetIamPolicy setUploadType(String uploadType) {
                return (GetIamPolicy)super.setUploadType(uploadType);
            }

            public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public GetIamPolicy setResource(String resource) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/datasets/[^/]+/routines/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public GetIamPolicy set(String parameterName, Object value) {
                return (GetIamPolicy)super.set(parameterName, value);
            }
        }

        public class Get
        extends BigqueryRequest<Routine> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/routines/{+routineId}";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            private final Pattern ROUTINE_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String routineId;
            @Key
            private String readMask;

            protected Get(String projectId, String datasetId, String routineId) {
                super(Bigquery.this, "GET", REST_PATH, null, Routine.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.ROUTINE_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.routineId = (String)Preconditions.checkNotNull((Object)routineId, (Object)"Required parameter routineId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ROUTINE_ID_PATTERN.matcher(routineId).matches(), (Object)"Parameter routineId must conform to the pattern ^[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Get setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Get setDatasetId(String datasetId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = datasetId;
                return this;
            }

            public String getRoutineId() {
                return this.routineId;
            }

            public Get setRoutineId(String routineId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ROUTINE_ID_PATTERN.matcher(routineId).matches(), (Object)"Parameter routineId must conform to the pattern ^[^/]+$");
                }
                this.routineId = routineId;
                return this;
            }

            public String getReadMask() {
                return this.readMask;
            }

            public Get setReadMask(String readMask) {
                this.readMask = readMask;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends BigqueryRequest<Void> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/routines/{+routineId}";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            private final Pattern ROUTINE_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String routineId;

            protected Delete(String projectId, String datasetId, String routineId) {
                super(Bigquery.this, "DELETE", REST_PATH, null, Void.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.ROUTINE_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.routineId = (String)Preconditions.checkNotNull((Object)routineId, (Object)"Required parameter routineId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ROUTINE_ID_PATTERN.matcher(routineId).matches(), (Object)"Parameter routineId must conform to the pattern ^[^/]+$");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Delete setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Delete setDatasetId(String datasetId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = datasetId;
                return this;
            }

            public String getRoutineId() {
                return this.routineId;
            }

            public Delete setRoutineId(String routineId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ROUTINE_ID_PATTERN.matcher(routineId).matches(), (Object)"Parameter routineId must conform to the pattern ^[^/]+$");
                }
                this.routineId = routineId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class Projects {
        public GetServiceAccount getServiceAccount(String projectId) throws IOException {
            GetServiceAccount result = new GetServiceAccount(projectId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends BigqueryRequest<ProjectList> {
            private static final String REST_PATH = "projects";
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List() {
                super(Bigquery.this, "GET", REST_PATH, null, ProjectList.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class GetServiceAccount
        extends BigqueryRequest<GetServiceAccountResponse> {
            private static final String REST_PATH = "projects/{+projectId}/serviceAccount";
            private final Pattern PROJECT_ID_PATTERN;
            @Key
            private String projectId;

            protected GetServiceAccount(String projectId) {
                super(Bigquery.this, "GET", REST_PATH, null, GetServiceAccountResponse.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetServiceAccount set$Xgafv(String $Xgafv) {
                return (GetServiceAccount)super.set$Xgafv($Xgafv);
            }

            public GetServiceAccount setAccessToken(String accessToken) {
                return (GetServiceAccount)super.setAccessToken(accessToken);
            }

            public GetServiceAccount setAlt(String alt) {
                return (GetServiceAccount)super.setAlt(alt);
            }

            public GetServiceAccount setCallback(String callback) {
                return (GetServiceAccount)super.setCallback(callback);
            }

            public GetServiceAccount setFields(String fields) {
                return (GetServiceAccount)super.setFields(fields);
            }

            public GetServiceAccount setKey(String key) {
                return (GetServiceAccount)super.setKey(key);
            }

            public GetServiceAccount setOauthToken(String oauthToken) {
                return (GetServiceAccount)super.setOauthToken(oauthToken);
            }

            public GetServiceAccount setPrettyPrint(Boolean prettyPrint) {
                return (GetServiceAccount)super.setPrettyPrint(prettyPrint);
            }

            public GetServiceAccount setQuotaUser(String quotaUser) {
                return (GetServiceAccount)super.setQuotaUser(quotaUser);
            }

            public GetServiceAccount setUploadType(String uploadType) {
                return (GetServiceAccount)super.setUploadType(uploadType);
            }

            public GetServiceAccount setUploadProtocol(String uploadProtocol) {
                return (GetServiceAccount)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public GetServiceAccount setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            @Override
            public GetServiceAccount set(String parameterName, Object value) {
                return (GetServiceAccount)super.set(parameterName, value);
            }
        }
    }

    public class Models {
        public Delete delete(String projectId, String datasetId, String modelId) throws IOException {
            Delete result = new Delete(projectId, datasetId, modelId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String projectId, String datasetId, String modelId) throws IOException {
            Get result = new Get(projectId, datasetId, modelId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String projectId, String datasetId) throws IOException {
            List result = new List(projectId, datasetId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String projectId, String datasetId, String modelId, Model content) throws IOException {
            Patch result = new Patch(projectId, datasetId, modelId, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Patch
        extends BigqueryRequest<Model> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/models/{+modelId}";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            private final Pattern MODEL_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String modelId;

            protected Patch(String projectId, String datasetId, String modelId, Model content) {
                super(Bigquery.this, "PATCH", REST_PATH, (Object)content, Model.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.MODEL_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.modelId = (String)Preconditions.checkNotNull((Object)modelId, (Object)"Required parameter modelId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.MODEL_ID_PATTERN.matcher(modelId).matches(), (Object)"Parameter modelId must conform to the pattern ^[^/]+$");
                }
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Patch setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Patch setDatasetId(String datasetId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = datasetId;
                return this;
            }

            public String getModelId() {
                return this.modelId;
            }

            public Patch setModelId(String modelId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.MODEL_ID_PATTERN.matcher(modelId).matches(), (Object)"Parameter modelId must conform to the pattern ^[^/]+$");
                }
                this.modelId = modelId;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends BigqueryRequest<ListModelsResponse> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/models";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String projectId, String datasetId) {
                super(Bigquery.this, "GET", REST_PATH, null, ListModelsResponse.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public List setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public List setDatasetId(String datasetId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = datasetId;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends BigqueryRequest<Model> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/models/{+modelId}";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            private final Pattern MODEL_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String modelId;

            protected Get(String projectId, String datasetId, String modelId) {
                super(Bigquery.this, "GET", REST_PATH, null, Model.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.MODEL_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.modelId = (String)Preconditions.checkNotNull((Object)modelId, (Object)"Required parameter modelId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.MODEL_ID_PATTERN.matcher(modelId).matches(), (Object)"Parameter modelId must conform to the pattern ^[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Get setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Get setDatasetId(String datasetId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = datasetId;
                return this;
            }

            public String getModelId() {
                return this.modelId;
            }

            public Get setModelId(String modelId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.MODEL_ID_PATTERN.matcher(modelId).matches(), (Object)"Parameter modelId must conform to the pattern ^[^/]+$");
                }
                this.modelId = modelId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends BigqueryRequest<Void> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/models/{+modelId}";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            private final Pattern MODEL_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String modelId;

            protected Delete(String projectId, String datasetId, String modelId) {
                super(Bigquery.this, "DELETE", REST_PATH, null, Void.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.MODEL_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.modelId = (String)Preconditions.checkNotNull((Object)modelId, (Object)"Required parameter modelId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.MODEL_ID_PATTERN.matcher(modelId).matches(), (Object)"Parameter modelId must conform to the pattern ^[^/]+$");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Delete setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Delete setDatasetId(String datasetId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = datasetId;
                return this;
            }

            public String getModelId() {
                return this.modelId;
            }

            public Delete setModelId(String modelId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.MODEL_ID_PATTERN.matcher(modelId).matches(), (Object)"Parameter modelId must conform to the pattern ^[^/]+$");
                }
                this.modelId = modelId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class Jobs {
        public Cancel cancel(String projectId, String jobId) throws IOException {
            Cancel result = new Cancel(projectId, jobId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String projectId, String jobId) throws IOException {
            Delete result = new Delete(projectId, jobId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String projectId, String jobId) throws IOException {
            Get result = new Get(projectId, jobId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetQueryResults getQueryResults(String projectId, String jobId) throws IOException {
            GetQueryResults result = new GetQueryResults(projectId, jobId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String projectId, Job content) throws IOException {
            Insert result = new Insert(projectId, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String projectId, Job content, AbstractInputStreamContent mediaContent) throws IOException {
            Insert result = new Insert(projectId, content, mediaContent);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String projectId) throws IOException {
            List result = new List(projectId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Query query(String projectId, QueryRequest content) throws IOException {
            Query result = new Query(projectId, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Query
        extends BigqueryRequest<QueryResponse> {
            private static final String REST_PATH = "projects/{+projectId}/queries";
            private final Pattern PROJECT_ID_PATTERN;
            @Key
            private String projectId;

            protected Query(String projectId, QueryRequest content) {
                super(Bigquery.this, "POST", REST_PATH, (Object)content, QueryResponse.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
            }

            public Query set$Xgafv(String $Xgafv) {
                return (Query)super.set$Xgafv($Xgafv);
            }

            public Query setAccessToken(String accessToken) {
                return (Query)super.setAccessToken(accessToken);
            }

            public Query setAlt(String alt) {
                return (Query)super.setAlt(alt);
            }

            public Query setCallback(String callback) {
                return (Query)super.setCallback(callback);
            }

            public Query setFields(String fields) {
                return (Query)super.setFields(fields);
            }

            public Query setKey(String key) {
                return (Query)super.setKey(key);
            }

            public Query setOauthToken(String oauthToken) {
                return (Query)super.setOauthToken(oauthToken);
            }

            public Query setPrettyPrint(Boolean prettyPrint) {
                return (Query)super.setPrettyPrint(prettyPrint);
            }

            public Query setQuotaUser(String quotaUser) {
                return (Query)super.setQuotaUser(quotaUser);
            }

            public Query setUploadType(String uploadType) {
                return (Query)super.setUploadType(uploadType);
            }

            public Query setUploadProtocol(String uploadProtocol) {
                return (Query)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Query setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            @Override
            public Query set(String parameterName, Object value) {
                return (Query)super.set(parameterName, value);
            }
        }

        public class List
        extends BigqueryRequest<JobList> {
            private static final String REST_PATH = "projects/{+projectId}/jobs";
            private final Pattern PROJECT_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private Boolean allUsers;
            @Key
            private BigInteger maxCreationTime;
            @Key
            private Long maxResults;
            @Key
            private BigInteger minCreationTime;
            @Key
            private String pageToken;
            @Key
            private String parentJobId;
            @Key
            private String projection;
            @Key
            private java.util.List<String> stateFilter;

            protected List(String projectId) {
                super(Bigquery.this, "GET", REST_PATH, null, JobList.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public List setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public Boolean getAllUsers() {
                return this.allUsers;
            }

            public List setAllUsers(Boolean allUsers) {
                this.allUsers = allUsers;
                return this;
            }

            public BigInteger getMaxCreationTime() {
                return this.maxCreationTime;
            }

            public List setMaxCreationTime(BigInteger maxCreationTime) {
                this.maxCreationTime = maxCreationTime;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public BigInteger getMinCreationTime() {
                return this.minCreationTime;
            }

            public List setMinCreationTime(BigInteger minCreationTime) {
                this.minCreationTime = minCreationTime;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getParentJobId() {
                return this.parentJobId;
            }

            public List setParentJobId(String parentJobId) {
                this.parentJobId = parentJobId;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public List setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            public java.util.List<String> getStateFilter() {
                return this.stateFilter;
            }

            public List setStateFilter(java.util.List<String> stateFilter) {
                this.stateFilter = stateFilter;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends BigqueryRequest<Job> {
            private static final String REST_PATH = "projects/{+projectId}/jobs";
            private final Pattern PROJECT_ID_PATTERN;
            @Key
            private String projectId;

            protected Insert(String projectId, Job content) {
                super(Bigquery.this, "POST", REST_PATH, (Object)content, Job.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
            }

            protected Insert(String projectId, Job content, AbstractInputStreamContent mediaContent) {
                super(Bigquery.this, "POST", "/upload/" + Bigquery.this.getServicePath() + REST_PATH, (Object)content, Job.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                Preconditions.checkNotNull((Object)mediaContent, (Object)"Required parameter mediaContent must be specified.");
                this.initializeMediaUpload(mediaContent);
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Insert setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class GetQueryResults
        extends BigqueryRequest<GetQueryResultsResponse> {
            private static final String REST_PATH = "projects/{+projectId}/queries/{+jobId}";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern JOB_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String jobId;
            @Key(value="formatOptions.useInt64Timestamp")
            private Boolean formatOptionsUseInt64Timestamp;
            @Key
            private String location;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private BigInteger startIndex;
            @Key
            private Long timeoutMs;

            protected GetQueryResults(String projectId, String jobId) {
                super(Bigquery.this, "GET", REST_PATH, null, GetQueryResultsResponse.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.JOB_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.jobId = (String)Preconditions.checkNotNull((Object)jobId, (Object)"Required parameter jobId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.JOB_ID_PATTERN.matcher(jobId).matches(), (Object)"Parameter jobId must conform to the pattern ^[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetQueryResults set$Xgafv(String $Xgafv) {
                return (GetQueryResults)super.set$Xgafv($Xgafv);
            }

            public GetQueryResults setAccessToken(String accessToken) {
                return (GetQueryResults)super.setAccessToken(accessToken);
            }

            public GetQueryResults setAlt(String alt) {
                return (GetQueryResults)super.setAlt(alt);
            }

            public GetQueryResults setCallback(String callback) {
                return (GetQueryResults)super.setCallback(callback);
            }

            public GetQueryResults setFields(String fields) {
                return (GetQueryResults)super.setFields(fields);
            }

            public GetQueryResults setKey(String key) {
                return (GetQueryResults)super.setKey(key);
            }

            public GetQueryResults setOauthToken(String oauthToken) {
                return (GetQueryResults)super.setOauthToken(oauthToken);
            }

            public GetQueryResults setPrettyPrint(Boolean prettyPrint) {
                return (GetQueryResults)super.setPrettyPrint(prettyPrint);
            }

            public GetQueryResults setQuotaUser(String quotaUser) {
                return (GetQueryResults)super.setQuotaUser(quotaUser);
            }

            public GetQueryResults setUploadType(String uploadType) {
                return (GetQueryResults)super.setUploadType(uploadType);
            }

            public GetQueryResults setUploadProtocol(String uploadProtocol) {
                return (GetQueryResults)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public GetQueryResults setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getJobId() {
                return this.jobId;
            }

            public GetQueryResults setJobId(String jobId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.JOB_ID_PATTERN.matcher(jobId).matches(), (Object)"Parameter jobId must conform to the pattern ^[^/]+$");
                }
                this.jobId = jobId;
                return this;
            }

            public Boolean getFormatOptionsUseInt64Timestamp() {
                return this.formatOptionsUseInt64Timestamp;
            }

            public GetQueryResults setFormatOptionsUseInt64Timestamp(Boolean formatOptionsUseInt64Timestamp) {
                this.formatOptionsUseInt64Timestamp = formatOptionsUseInt64Timestamp;
                return this;
            }

            public String getLocation() {
                return this.location;
            }

            public GetQueryResults setLocation(String location) {
                this.location = location;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public GetQueryResults setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public GetQueryResults setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public BigInteger getStartIndex() {
                return this.startIndex;
            }

            public GetQueryResults setStartIndex(BigInteger startIndex) {
                this.startIndex = startIndex;
                return this;
            }

            public Long getTimeoutMs() {
                return this.timeoutMs;
            }

            public GetQueryResults setTimeoutMs(Long timeoutMs) {
                this.timeoutMs = timeoutMs;
                return this;
            }

            @Override
            public GetQueryResults set(String parameterName, Object value) {
                return (GetQueryResults)super.set(parameterName, value);
            }
        }

        public class Get
        extends BigqueryRequest<Job> {
            private static final String REST_PATH = "projects/{+projectId}/jobs/{+jobId}";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern JOB_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String jobId;
            @Key
            private String location;

            protected Get(String projectId, String jobId) {
                super(Bigquery.this, "GET", REST_PATH, null, Job.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.JOB_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.jobId = (String)Preconditions.checkNotNull((Object)jobId, (Object)"Required parameter jobId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.JOB_ID_PATTERN.matcher(jobId).matches(), (Object)"Parameter jobId must conform to the pattern ^[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Get setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getJobId() {
                return this.jobId;
            }

            public Get setJobId(String jobId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.JOB_ID_PATTERN.matcher(jobId).matches(), (Object)"Parameter jobId must conform to the pattern ^[^/]+$");
                }
                this.jobId = jobId;
                return this;
            }

            public String getLocation() {
                return this.location;
            }

            public Get setLocation(String location) {
                this.location = location;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends BigqueryRequest<Void> {
            private static final String REST_PATH = "projects/{+projectId}/jobs/{+jobId}/delete";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern JOB_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String jobId;
            @Key
            private String location;

            protected Delete(String projectId, String jobId) {
                super(Bigquery.this, "DELETE", REST_PATH, null, Void.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.JOB_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.jobId = (String)Preconditions.checkNotNull((Object)jobId, (Object)"Required parameter jobId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.JOB_ID_PATTERN.matcher(jobId).matches(), (Object)"Parameter jobId must conform to the pattern ^[^/]+$");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Delete setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getJobId() {
                return this.jobId;
            }

            public Delete setJobId(String jobId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.JOB_ID_PATTERN.matcher(jobId).matches(), (Object)"Parameter jobId must conform to the pattern ^[^/]+$");
                }
                this.jobId = jobId;
                return this;
            }

            public String getLocation() {
                return this.location;
            }

            public Delete setLocation(String location) {
                this.location = location;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Cancel
        extends BigqueryRequest<JobCancelResponse> {
            private static final String REST_PATH = "projects/{+projectId}/jobs/{+jobId}/cancel";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern JOB_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String jobId;
            @Key
            private String location;

            protected Cancel(String projectId, String jobId) {
                super(Bigquery.this, "POST", REST_PATH, null, JobCancelResponse.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.JOB_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.jobId = (String)Preconditions.checkNotNull((Object)jobId, (Object)"Required parameter jobId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.JOB_ID_PATTERN.matcher(jobId).matches(), (Object)"Parameter jobId must conform to the pattern ^[^/]+$");
                }
            }

            public Cancel set$Xgafv(String $Xgafv) {
                return (Cancel)super.set$Xgafv($Xgafv);
            }

            public Cancel setAccessToken(String accessToken) {
                return (Cancel)super.setAccessToken(accessToken);
            }

            public Cancel setAlt(String alt) {
                return (Cancel)super.setAlt(alt);
            }

            public Cancel setCallback(String callback) {
                return (Cancel)super.setCallback(callback);
            }

            public Cancel setFields(String fields) {
                return (Cancel)super.setFields(fields);
            }

            public Cancel setKey(String key) {
                return (Cancel)super.setKey(key);
            }

            public Cancel setOauthToken(String oauthToken) {
                return (Cancel)super.setOauthToken(oauthToken);
            }

            public Cancel setPrettyPrint(Boolean prettyPrint) {
                return (Cancel)super.setPrettyPrint(prettyPrint);
            }

            public Cancel setQuotaUser(String quotaUser) {
                return (Cancel)super.setQuotaUser(quotaUser);
            }

            public Cancel setUploadType(String uploadType) {
                return (Cancel)super.setUploadType(uploadType);
            }

            public Cancel setUploadProtocol(String uploadProtocol) {
                return (Cancel)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Cancel setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getJobId() {
                return this.jobId;
            }

            public Cancel setJobId(String jobId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.JOB_ID_PATTERN.matcher(jobId).matches(), (Object)"Parameter jobId must conform to the pattern ^[^/]+$");
                }
                this.jobId = jobId;
                return this;
            }

            public String getLocation() {
                return this.location;
            }

            public Cancel setLocation(String location) {
                this.location = location;
                return this;
            }

            @Override
            public Cancel set(String parameterName, Object value) {
                return (Cancel)super.set(parameterName, value);
            }
        }
    }

    public class Datasets {
        public Delete delete(String projectId, String datasetId) throws IOException {
            Delete result = new Delete(projectId, datasetId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String projectId, String datasetId) throws IOException {
            Get result = new Get(projectId, datasetId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String projectId, Dataset content) throws IOException {
            Insert result = new Insert(projectId, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String projectId) throws IOException {
            List result = new List(projectId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String projectId, String datasetId, Dataset content) throws IOException {
            Patch result = new Patch(projectId, datasetId, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Undelete undelete(String projectId, String datasetId, UndeleteDatasetRequest content) throws IOException {
            Undelete result = new Undelete(projectId, datasetId, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String projectId, String datasetId, Dataset content) throws IOException {
            Update result = new Update(projectId, datasetId, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends BigqueryRequest<Dataset> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private Integer accessPolicyVersion;

            protected Update(String projectId, String datasetId, Dataset content) {
                super(Bigquery.this, "PUT", REST_PATH, (Object)content, Dataset.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Update setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Update setDatasetId(String datasetId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = datasetId;
                return this;
            }

            public Integer getAccessPolicyVersion() {
                return this.accessPolicyVersion;
            }

            public Update setAccessPolicyVersion(Integer accessPolicyVersion) {
                this.accessPolicyVersion = accessPolicyVersion;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Undelete
        extends BigqueryRequest<Dataset> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}:undelete";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;

            protected Undelete(String projectId, String datasetId, UndeleteDatasetRequest content) {
                super(Bigquery.this, "POST", REST_PATH, (Object)content, Dataset.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
            }

            public Undelete set$Xgafv(String $Xgafv) {
                return (Undelete)super.set$Xgafv($Xgafv);
            }

            public Undelete setAccessToken(String accessToken) {
                return (Undelete)super.setAccessToken(accessToken);
            }

            public Undelete setAlt(String alt) {
                return (Undelete)super.setAlt(alt);
            }

            public Undelete setCallback(String callback) {
                return (Undelete)super.setCallback(callback);
            }

            public Undelete setFields(String fields) {
                return (Undelete)super.setFields(fields);
            }

            public Undelete setKey(String key) {
                return (Undelete)super.setKey(key);
            }

            public Undelete setOauthToken(String oauthToken) {
                return (Undelete)super.setOauthToken(oauthToken);
            }

            public Undelete setPrettyPrint(Boolean prettyPrint) {
                return (Undelete)super.setPrettyPrint(prettyPrint);
            }

            public Undelete setQuotaUser(String quotaUser) {
                return (Undelete)super.setQuotaUser(quotaUser);
            }

            public Undelete setUploadType(String uploadType) {
                return (Undelete)super.setUploadType(uploadType);
            }

            public Undelete setUploadProtocol(String uploadProtocol) {
                return (Undelete)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Undelete setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Undelete setDatasetId(String datasetId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = datasetId;
                return this;
            }

            @Override
            public Undelete set(String parameterName, Object value) {
                return (Undelete)super.set(parameterName, value);
            }
        }

        public class Patch
        extends BigqueryRequest<Dataset> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private Integer accessPolicyVersion;

            protected Patch(String projectId, String datasetId, Dataset content) {
                super(Bigquery.this, "PATCH", REST_PATH, (Object)content, Dataset.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Patch setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Patch setDatasetId(String datasetId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = datasetId;
                return this;
            }

            public Integer getAccessPolicyVersion() {
                return this.accessPolicyVersion;
            }

            public Patch setAccessPolicyVersion(Integer accessPolicyVersion) {
                this.accessPolicyVersion = accessPolicyVersion;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends BigqueryRequest<DatasetList> {
            private static final String REST_PATH = "projects/{+projectId}/datasets";
            private final Pattern PROJECT_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private Boolean all;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String projectId) {
                super(Bigquery.this, "GET", REST_PATH, null, DatasetList.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public List setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public Boolean getAll() {
                return this.all;
            }

            public List setAll(Boolean all) {
                this.all = all;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends BigqueryRequest<Dataset> {
            private static final String REST_PATH = "projects/{+projectId}/datasets";
            private final Pattern PROJECT_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private Integer accessPolicyVersion;

            protected Insert(String projectId, Dataset content) {
                super(Bigquery.this, "POST", REST_PATH, (Object)content, Dataset.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Insert setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public Integer getAccessPolicyVersion() {
                return this.accessPolicyVersion;
            }

            public Insert setAccessPolicyVersion(Integer accessPolicyVersion) {
                this.accessPolicyVersion = accessPolicyVersion;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends BigqueryRequest<Dataset> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private Integer accessPolicyVersion;
            @Key
            private String datasetView;

            protected Get(String projectId, String datasetId) {
                super(Bigquery.this, "GET", REST_PATH, null, Dataset.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Get setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Get setDatasetId(String datasetId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = datasetId;
                return this;
            }

            public Integer getAccessPolicyVersion() {
                return this.accessPolicyVersion;
            }

            public Get setAccessPolicyVersion(Integer accessPolicyVersion) {
                this.accessPolicyVersion = accessPolicyVersion;
                return this;
            }

            public String getDatasetView() {
                return this.datasetView;
            }

            public Get setDatasetView(String datasetView) {
                this.datasetView = datasetView;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends BigqueryRequest<Void> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private Boolean deleteContents;

            protected Delete(String projectId, String datasetId) {
                super(Bigquery.this, "DELETE", REST_PATH, null, Void.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Delete setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Delete setDatasetId(String datasetId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = datasetId;
                return this;
            }

            public Boolean getDeleteContents() {
                return this.deleteContents;
            }

            public Delete setDeleteContents(Boolean deleteContents) {
                this.deleteContents = deleteContents;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }
}

