/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Standalone performance insights for a specific stage.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class StagePerformanceStandaloneInsight extends com.google.api.client.json.GenericJson {

  /**
   * Output only. If present, the stage had the following reasons for being disqualified from BI
   * Engine execution.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<BiEngineReason> biEngineReasons;

  static {
    // hack to force ProGuard to consider BiEngineReason used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(BiEngineReason.class);
  }

  /**
   * Output only. High cardinality joins in the stage.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<HighCardinalityJoin> highCardinalityJoins;

  static {
    // hack to force ProGuard to consider HighCardinalityJoin used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(HighCardinalityJoin.class);
  }

  /**
   * Output only. True if the stage has insufficient shuffle quota.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean insufficientShuffleQuota;

  /**
   * Output only. Partition skew in the stage.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PartitionSkew partitionSkew;

  /**
   * Output only. True if the stage has a slot contention issue.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean slotContention;

  /**
   * Output only. The stage id that the insight mapped to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long stageId;

  /**
   * Output only. If present, the stage had the following reasons for being disqualified from BI
   * Engine execution.
   * @return value or {@code null} for none
   */
  public java.util.List<BiEngineReason> getBiEngineReasons() {
    return biEngineReasons;
  }

  /**
   * Output only. If present, the stage had the following reasons for being disqualified from BI
   * Engine execution.
   * @param biEngineReasons biEngineReasons or {@code null} for none
   */
  public StagePerformanceStandaloneInsight setBiEngineReasons(java.util.List<BiEngineReason> biEngineReasons) {
    this.biEngineReasons = biEngineReasons;
    return this;
  }

  /**
   * Output only. High cardinality joins in the stage.
   * @return value or {@code null} for none
   */
  public java.util.List<HighCardinalityJoin> getHighCardinalityJoins() {
    return highCardinalityJoins;
  }

  /**
   * Output only. High cardinality joins in the stage.
   * @param highCardinalityJoins highCardinalityJoins or {@code null} for none
   */
  public StagePerformanceStandaloneInsight setHighCardinalityJoins(java.util.List<HighCardinalityJoin> highCardinalityJoins) {
    this.highCardinalityJoins = highCardinalityJoins;
    return this;
  }

  /**
   * Output only. True if the stage has insufficient shuffle quota.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getInsufficientShuffleQuota() {
    return insufficientShuffleQuota;
  }

  /**
   * Output only. True if the stage has insufficient shuffle quota.
   * @param insufficientShuffleQuota insufficientShuffleQuota or {@code null} for none
   */
  public StagePerformanceStandaloneInsight setInsufficientShuffleQuota(java.lang.Boolean insufficientShuffleQuota) {
    this.insufficientShuffleQuota = insufficientShuffleQuota;
    return this;
  }

  /**
   * Output only. Partition skew in the stage.
   * @return value or {@code null} for none
   */
  public PartitionSkew getPartitionSkew() {
    return partitionSkew;
  }

  /**
   * Output only. Partition skew in the stage.
   * @param partitionSkew partitionSkew or {@code null} for none
   */
  public StagePerformanceStandaloneInsight setPartitionSkew(PartitionSkew partitionSkew) {
    this.partitionSkew = partitionSkew;
    return this;
  }

  /**
   * Output only. True if the stage has a slot contention issue.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSlotContention() {
    return slotContention;
  }

  /**
   * Output only. True if the stage has a slot contention issue.
   * @param slotContention slotContention or {@code null} for none
   */
  public StagePerformanceStandaloneInsight setSlotContention(java.lang.Boolean slotContention) {
    this.slotContention = slotContention;
    return this;
  }

  /**
   * Output only. The stage id that the insight mapped to.
   * @return value or {@code null} for none
   */
  public java.lang.Long getStageId() {
    return stageId;
  }

  /**
   * Output only. The stage id that the insight mapped to.
   * @param stageId stageId or {@code null} for none
   */
  public StagePerformanceStandaloneInsight setStageId(java.lang.Long stageId) {
    this.stageId = stageId;
    return this;
  }

  @Override
  public StagePerformanceStandaloneInsight set(String fieldName, Object value) {
    return (StagePerformanceStandaloneInsight) super.set(fieldName, value);
  }

  @Override
  public StagePerformanceStandaloneInsight clone() {
    return (StagePerformanceStandaloneInsight) super.clone();
  }

}
