/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * A materialized view considered for a query job.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MaterializedView extends com.google.api.client.json.GenericJson {

  /**
   * Whether the materialized view is chosen for the query. A materialized view can be chosen to
   * rewrite multiple parts of the same query. If a materialized view is chosen to rewrite any part
   * of the query, then this field is true, even if the materialized view was not chosen to rewrite
   * others parts.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean chosen;

  /**
   * If present, specifies a best-effort estimation of the bytes saved by using the materialized
   * view rather than its base tables.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long estimatedBytesSaved;

  /**
   * If present, specifies the reason why the materialized view was not chosen for the query.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String rejectedReason;

  /**
   * The candidate materialized view.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TableReference tableReference;

  /**
   * Whether the materialized view is chosen for the query. A materialized view can be chosen to
   * rewrite multiple parts of the same query. If a materialized view is chosen to rewrite any part
   * of the query, then this field is true, even if the materialized view was not chosen to rewrite
   * others parts.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getChosen() {
    return chosen;
  }

  /**
   * Whether the materialized view is chosen for the query. A materialized view can be chosen to
   * rewrite multiple parts of the same query. If a materialized view is chosen to rewrite any part
   * of the query, then this field is true, even if the materialized view was not chosen to rewrite
   * others parts.
   * @param chosen chosen or {@code null} for none
   */
  public MaterializedView setChosen(java.lang.Boolean chosen) {
    this.chosen = chosen;
    return this;
  }

  /**
   * If present, specifies a best-effort estimation of the bytes saved by using the materialized
   * view rather than its base tables.
   * @return value or {@code null} for none
   */
  public java.lang.Long getEstimatedBytesSaved() {
    return estimatedBytesSaved;
  }

  /**
   * If present, specifies a best-effort estimation of the bytes saved by using the materialized
   * view rather than its base tables.
   * @param estimatedBytesSaved estimatedBytesSaved or {@code null} for none
   */
  public MaterializedView setEstimatedBytesSaved(java.lang.Long estimatedBytesSaved) {
    this.estimatedBytesSaved = estimatedBytesSaved;
    return this;
  }

  /**
   * If present, specifies the reason why the materialized view was not chosen for the query.
   * @return value or {@code null} for none
   */
  public java.lang.String getRejectedReason() {
    return rejectedReason;
  }

  /**
   * If present, specifies the reason why the materialized view was not chosen for the query.
   * @param rejectedReason rejectedReason or {@code null} for none
   */
  public MaterializedView setRejectedReason(java.lang.String rejectedReason) {
    this.rejectedReason = rejectedReason;
    return this;
  }

  /**
   * The candidate materialized view.
   * @return value or {@code null} for none
   */
  public TableReference getTableReference() {
    return tableReference;
  }

  /**
   * The candidate materialized view.
   * @param tableReference tableReference or {@code null} for none
   */
  public MaterializedView setTableReference(TableReference tableReference) {
    this.tableReference = tableReference;
    return this;
  }

  @Override
  public MaterializedView set(String fieldName, Object value) {
    return (MaterializedView) super.set(fieldName, value);
  }

  @Override
  public MaterializedView clone() {
    return (MaterializedView) super.clone();
  }

}
